/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.internal.dataset.conv;

import java.io.IOException;
import java.util.HashMap;
import java.util.Optional;
import java.util.StringTokenizer;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.Array;
import ucar.ma2.ArrayObject;
import ucar.ma2.DataType;
import ucar.ma2.InvalidRangeException;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.constants.AxisType;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.ProjectionCT;
import ucar.nc2.dataset.VariableDS;
import ucar.nc2.dataset.conv.DefaultConvention;
import ucar.nc2.dataset.spi.CoordSystemBuilderFactory;
import ucar.nc2.internal.dataset.CoordSystemBuilder;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.units.SimpleUnit;
import ucar.nc2.util.CancelTask;
import ucar.unidata.geoloc.ProjectionImpl;
import ucar.unidata.geoloc.projection.LambertConformal;
import ucar.unidata.geoloc.projection.Stereographic;
import ucar.unidata.geoloc.projection.TransverseMercator;

public class DefaultConventions
extends CoordSystemBuilder {
    private static final Logger logger = LoggerFactory.getLogger(DefaultConvention.class);
    protected ProjectionCT projCT;

    private DefaultConventions(NetcdfDataset.Builder datasetBuilder) {
        super(datasetBuilder);
        this.conventionName = "Default";
    }

    @Override
    public void augmentDataset(CancelTask cancelTask) {
        this.projCT = this.makeProjectionCT();
        if (this.projCT != null) {
            VariableDS.Builder vb = this.makeCoordinateTransformVariable(this.projCT);
            this.rootGroup.addVariable(vb);
            String xname = this.findCoordinateName(AxisType.GeoX);
            String yname = this.findCoordinateName(AxisType.GeoY);
            if (xname != null && yname != null) {
                vb.addAttribute(new Attribute("_CoordinateAxes", xname + " " + yname));
            }
        }
    }

    @Override
    protected void identifyCoordinateAxes() {
        AxisType atype;
        for (CoordSystemBuilder.VarProcess vp : this.varList) {
            String dimName;
            if (vp.isCoordinateVariable || (dimName = this.findAlias(vp.vb)).isEmpty()) continue;
            Optional<Dimension> dimOpt = this.rootGroup.findDimension(dimName);
            dimOpt.ifPresent(dime -> {
                vp.isCoordinateAxis = true;
                this.parseInfo.format(" Coordinate Axis added (alias) = %s for dimension %s%n", vp, dimName);
            });
        }
        for (CoordSystemBuilder.VarProcess vp : this.varList) {
            String coordsString;
            if (vp.coordinateAxes != null || (coordsString = vp.vb.getAttributeContainer().findAttributeString("coordinates", null)) == null) continue;
            vp.coordinates = coordsString;
        }
        super.identifyCoordinateAxes();
        HashMap<AxisType, CoordSystemBuilder.VarProcess> map = new HashMap<AxisType, CoordSystemBuilder.VarProcess>();
        for (CoordSystemBuilder.VarProcess vp : this.varList) {
            if (!vp.isCoordinateAxis || (atype = this.getAxisType(vp.vb)) == null) continue;
            map.put(atype, vp);
        }
        if (map.get((Object)AxisType.Time) == null) {
            for (CoordSystemBuilder.VarProcess vp : this.varList) {
                String unit = vp.vb.getUnits();
                if (unit == null || !SimpleUnit.isDateUnit(unit)) continue;
                vp.isCoordinateAxis = true;
                map.put(AxisType.Time, vp);
                this.parseInfo.format(" Time Coordinate Axis added (unit) = %s from unit %s%n", vp.vb.getFullName(), unit);
            }
        }
        for (CoordSystemBuilder.VarProcess vp : this.varList) {
            if (vp.isCoordinateVariable || (atype = this.getAxisType(vp.vb)) == null || map.get((Object)atype) != null) continue;
            vp.isCoordinateAxis = true;
            this.parseInfo.format(" Coordinate Axis added (Default forced) = %s for axis %s%n", new Object[]{vp.vb.getFullName(), atype});
            map.put(atype, vp);
        }
    }

    @Nullable
    private String findCoordinateName(AxisType axisType) {
        for (Variable.Builder<?> vb : this.rootGroup.vbuilders) {
            VariableDS.Builder vds;
            if (!(vb instanceof VariableDS.Builder) || axisType != this.getAxisType(vds = (VariableDS.Builder)vb)) continue;
            return vds.getFullName();
        }
        return null;
    }

    @Override
    @Nullable
    protected AxisType getAxisType(VariableDS.Builder vb) {
        String desc;
        AxisType result = this.getAxisTypeCoards(vb);
        if (result != null) {
            return result;
        }
        String vname = vb.shortName;
        if (vname == null) {
            return null;
        }
        String unit = vb.getUnits();
        if (unit == null) {
            unit = "";
        }
        if ((desc = vb.getDescription()) == null) {
            desc = "";
        }
        if (vname.equalsIgnoreCase("x") || this.findAlias(vb).equalsIgnoreCase("x")) {
            return AxisType.GeoX;
        }
        if (vname.equalsIgnoreCase("lon") || vname.equalsIgnoreCase("longitude") || this.findAlias(vb).equalsIgnoreCase("lon")) {
            return AxisType.Lon;
        }
        if (vname.equalsIgnoreCase("y") || this.findAlias(vb).equalsIgnoreCase("y")) {
            return AxisType.GeoY;
        }
        if (vname.equalsIgnoreCase("lat") || vname.equalsIgnoreCase("latitude") || this.findAlias(vb).equalsIgnoreCase("lat")) {
            return AxisType.Lat;
        }
        if (vname.equalsIgnoreCase("lev") || this.findAlias(vb).equalsIgnoreCase("lev") || vname.equalsIgnoreCase("level") || this.findAlias(vb).equalsIgnoreCase("level")) {
            return AxisType.GeoZ;
        }
        if ((vname.equalsIgnoreCase("z") || this.findAlias(vb).equalsIgnoreCase("z") || vname.equalsIgnoreCase("altitude") || desc.contains("altitude") || vname.equalsIgnoreCase("depth") || vname.equalsIgnoreCase("elev") || vname.equalsIgnoreCase("elevation")) && SimpleUnit.isCompatible("m", unit)) {
            return AxisType.Height;
        }
        if ((vname.equalsIgnoreCase("time") || this.findAlias(vb).equalsIgnoreCase("time")) && SimpleUnit.isDateUnit(unit)) {
            return AxisType.Time;
        }
        if (vname.equalsIgnoreCase("time") && vb.dataType == DataType.STRING && vb.orgVar != null) {
            try {
                ArrayObject.D1 sarry;
                String firstStringValue;
                Array firstValue = vb.orgVar.read("0");
                if (firstValue instanceof ArrayObject.D1 && CalendarDate.parseISOformat(null, firstStringValue = (String)(sarry = (ArrayObject.D1)firstValue).get(0)) != null) {
                    return AxisType.Time;
                }
            }
            catch (IOException | InvalidRangeException e) {
                logger.warn("time string error", (Throwable)e);
            }
        }
        return null;
    }

    private String findAlias(VariableDS.Builder vb) {
        String alias = vb.getAttributeContainer().findAttributeString("coord_axis", null);
        if (alias == null) {
            alias = vb.getAttributeContainer().findAttributeString("coord_alias", "");
        }
        if (alias == null) {
            alias = "";
        }
        return alias;
    }

    @Nullable
    private AxisType getAxisTypeCoards(VariableDS.Builder vb) {
        String unit = vb.getUnits();
        if (unit == null) {
            return null;
        }
        if (unit.equalsIgnoreCase("degrees_east") || unit.equalsIgnoreCase("degrees_E") || unit.equalsIgnoreCase("degreesE") || unit.equalsIgnoreCase("degree_east") || unit.equalsIgnoreCase("degree_E") || unit.equalsIgnoreCase("degreeE")) {
            return AxisType.Lon;
        }
        if (unit.equalsIgnoreCase("degrees_north") || unit.equalsIgnoreCase("degrees_N") || unit.equalsIgnoreCase("degreesN") || unit.equalsIgnoreCase("degree_north") || unit.equalsIgnoreCase("degree_N") || unit.equalsIgnoreCase("degreeN")) {
            return AxisType.Lat;
        }
        if (SimpleUnit.isDateUnit(unit)) {
            return AxisType.Time;
        }
        if (SimpleUnit.isCompatible("mbar", unit)) {
            return AxisType.Pressure;
        }
        if (unit.equalsIgnoreCase("level") || unit.equalsIgnoreCase("layer") || unit.equalsIgnoreCase("sigma_level")) {
            return AxisType.GeoZ;
        }
        String positive = vb.getAttributeContainer().findAttributeString("positive", null);
        if (positive != null) {
            if (SimpleUnit.isCompatible("m", unit)) {
                return AxisType.Height;
            }
            return AxisType.GeoZ;
        }
        return null;
    }

    private ProjectionCT makeProjectionCT() {
        ProjectionImpl proj;
        String projection = this.rootGroup.getAttributeContainer().findAttributeString("projection", null);
        if (null == projection) {
            this.parseInfo.format("Default Conventions error: NO projection name found %n", new Object[0]);
            return null;
        }
        String params = this.rootGroup.getAttributeContainer().findAttributeString("projection_params", null);
        if (null == params) {
            params = this.rootGroup.getAttributeContainer().findAttributeString("proj_params", null);
        }
        if (null == params) {
            this.parseInfo.format("Default Conventions error: NO projection parameters found %n", new Object[0]);
            return null;
        }
        int count = 0;
        double[] p = new double[4];
        try {
            StringTokenizer stoke = new StringTokenizer(params, " ,");
            while (stoke.hasMoreTokens() && count < 4) {
                p[count++] = Double.parseDouble(stoke.nextToken());
            }
        }
        catch (NumberFormatException e) {
            StringTokenizer stoke = new StringTokenizer(params, " ,");
            while (stoke.hasMoreTokens() && count < 4) {
                stoke.nextToken();
                p[count++] = Double.parseDouble(stoke.nextToken());
            }
        }
        this.parseInfo.format("Default Conventions projection %s params = %f %f %f %f%n", projection, p[0], p[1], p[2], p[3]);
        if (projection.equalsIgnoreCase("LambertConformal")) {
            proj = new LambertConformal(p[0], p[1], p[2], p[3]);
        } else if (projection.equalsIgnoreCase("TransverseMercator")) {
            proj = new TransverseMercator(p[0], p[1], p[2]);
        } else if (projection.equalsIgnoreCase("Stereographic") || projection.equalsIgnoreCase("Oblique_Stereographic")) {
            proj = new Stereographic(p[0], p[1], p[2]);
        } else {
            this.parseInfo.format("Default Conventions error: Unknown projection %s%n", projection);
            return null;
        }
        return new ProjectionCT(proj.getClassName(), "FGDC", proj);
    }

    public static class Factory
    implements CoordSystemBuilderFactory {
        @Override
        @Nullable
        public String getConventionName() {
            return null;
        }

        @Override
        public boolean isMine(NetcdfFile ncfile) {
            return false;
        }

        @Override
        public CoordSystemBuilder open(NetcdfDataset.Builder datasetBuilder) {
            return new DefaultConventions(datasetBuilder);
        }
    }
}

