/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dataset;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Formatter;
import java.util.List;
import java.util.ServiceLoader;
import java.util.Set;
import javax.annotation.Nullable;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.IndexIterator;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Section;
import ucar.nc2.Attribute;
import ucar.nc2.Group;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.dataset.CoordinateSystem;
import ucar.nc2.dataset.EnhanceScaleMissingUnsigned;
import ucar.nc2.dataset.EnhancementsImpl;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.VariableEnhanced;
import ucar.nc2.filter.ConvertMissing;
import ucar.nc2.filter.Enhancement;
import ucar.nc2.filter.EnhancementProvider;
import ucar.nc2.filter.ScaleOffset;
import ucar.nc2.filter.UnsignedConversion;
import ucar.nc2.internal.dataset.CoordinatesHelper;
import ucar.nc2.util.CancelTask;
import ucar.nc2.util.Misc;

public class VariableDS
extends Variable
implements VariableEnhanced,
EnhanceScaleMissingUnsigned {
    static final ServiceLoader<EnhancementProvider> ENHANCEMENT_PROVIDERS = ServiceLoader.load(EnhancementProvider.class);
    private EnhancementsImpl enhanceProxy;
    private List<String> coordSysNames;
    private UnsignedConversion unsignedConversion;
    private ScaleOffset scaleOffset;
    private List<Enhancement> loadedEnhancements = new ArrayList<Enhancement>();
    private ConvertMissing convertMissing;
    private Set<NetcdfDataset.Enhance> enhanceMode = EnumSet.noneOf(NetcdfDataset.Enhance.class);
    protected Variable orgVar;
    protected DataType orgDataType;
    protected String orgName;
    String orgFileTypeId;
    private boolean hasFillValue = false;
    private double fillValue = Double.MAX_VALUE;

    @Deprecated
    public VariableDS(NetcdfDataset ds, Group group, Structure parentStructure, String shortName, DataType dataType, String dims, String units, String desc) {
        super(ds, group, parentStructure, shortName);
        this.setDataType(dataType);
        this.setDimensions(dims);
        this.orgDataType = dataType;
        if (dataType == DataType.STRUCTURE) {
            throw new IllegalArgumentException("VariableDS must not wrap a Structure; name=" + shortName);
        }
        if (units != null) {
            this.addAttribute(new Attribute("units", units.trim()));
        }
        if (desc != null) {
            this.addAttribute(new Attribute("long_name", desc));
        }
        this.enhanceProxy = new EnhancementsImpl(this, units, desc);
    }

    @Deprecated
    public VariableDS(Group group, Structure parent, String shortName, Variable orgVar) {
        super(null, group, parent, shortName);
        this.setDimensions(this.getDimensionsString());
        if (orgVar instanceof Structure) {
            throw new IllegalArgumentException("VariableDS must not wrap a Structure; name=" + orgVar.getFullName());
        }
        this.ncfile = null;
        this.spiObject = null;
        this.createNewCache();
        this.orgVar = orgVar;
        this.orgDataType = orgVar.getDataType();
        this.enhanceProxy = new EnhancementsImpl(this);
    }

    @Deprecated
    public VariableDS(Group g, Variable orgVar, boolean enhance) {
        super(orgVar);
        String units;
        if (g != null) {
            this.setParentGroup(g);
        }
        this.setDimensions(this.getDimensionsString());
        if (orgVar instanceof Structure) {
            throw new IllegalArgumentException("VariableDS must not wrap a Structure; name=" + orgVar.getFullName());
        }
        this.ncfile = null;
        this.spiObject = null;
        this.createNewCache();
        this.orgVar = orgVar;
        this.orgDataType = orgVar.getDataType();
        this.orgFileTypeId = orgVar.getFileTypeId();
        this.enhanceProxy = new EnhancementsImpl(this);
        if (enhance) {
            this.enhance(NetcdfDataset.getDefaultEnhanceMode());
        }
        if ((units = orgVar.getUnitsString()) != null) {
            this.setUnitsString(units.trim());
        }
    }

    @Deprecated
    protected VariableDS(VariableDS vds, boolean isCopy) {
        super(vds);
        this.orgVar = vds;
        this.orgDataType = vds.orgDataType;
        this.orgName = vds.orgName;
        this.enhanceMode = vds.enhanceMode;
        this.enhanceProxy = new EnhancementsImpl(this);
        this.unsignedConversion = vds.unsignedConversion;
        this.scaleOffset = vds.scaleOffset;
        this.convertMissing = vds.convertMissing;
        this.fillValue = vds.getFillValue();
        this.hasFillValue = vds.hasFillValue();
        String units = vds.getUnitsString();
        if (units != null) {
            this.setUnitsString(units.trim());
        }
        if (!isCopy) {
            this.createNewCache();
        }
    }

    @Override
    public NetcdfFile getNetcdfFile() {
        return this.group == null ? null : this.group.getNetcdfFile();
    }

    @Override
    @Deprecated
    protected VariableDS copy() {
        return new VariableDS(this, true);
    }

    @Override
    @Deprecated
    public void clearCoordinateSystems() {
        this.enhanceProxy = new EnhancementsImpl(this, this.getUnitsString(), this.getDescription());
    }

    @Override
    @Deprecated
    public void enhance(Set<NetcdfDataset.Enhance> enhancements) {
        this.enhanceMode = EnumSet.copyOf(enhancements);
        if (this.orgVar instanceof VariableDS) {
            for (NetcdfDataset.Enhance orgVarEnhancement : ((VariableDS)this.orgVar).getEnhanceMode()) {
                this.enhanceMode.remove((Object)orgVarEnhancement);
            }
        }
        if (this.orgDataType != null) {
            this.setDataType(this.orgDataType);
        }
        this.createEnhancements();
        if (this.convertMissing != null) {
            this.fillValue = this.unpackVal(this.convertMissing.getFillValue());
            this.hasFillValue = true;
        } else {
            this.fillValue = ConvertMissing.getFillValueOrDefault(this);
            this.hasFillValue = !Double.isNaN(this.fillValue);
        }
    }

    boolean needConvert() {
        Set<NetcdfDataset.Enhance> enhancements = this.getEnhanceMode();
        return enhancements.contains((Object)NetcdfDataset.Enhance.ConvertEnums) || enhancements.contains((Object)NetcdfDataset.Enhance.ConvertUnsigned) || enhancements.contains((Object)NetcdfDataset.Enhance.ApplyScaleOffset) || enhancements.contains((Object)NetcdfDataset.Enhance.ConvertMissing);
    }

    Array convert(Array data) {
        return this.convert(data, this.enhanceMode);
    }

    Array convert(Array data, Set<NetcdfDataset.Enhance> enhancements) {
        if (enhancements.contains((Object)NetcdfDataset.Enhance.ConvertEnums) && (this.dataType.isEnum() || this.orgDataType != null && this.orgDataType.isEnum())) {
            return this.convertEnums(data);
        }
        if (this.isVariableLength) {
            return data;
        }
        if (!this.dataType.isNumeric()) {
            return data;
        }
        DataType convertedType = data.getDataType();
        ArrayList<Enhancement> toApply = new ArrayList<Enhancement>();
        if (enhancements.contains((Object)NetcdfDataset.Enhance.ConvertUnsigned) && this.unsignedConversion != null) {
            toApply.add(this.unsignedConversion);
            convertedType = this.unsignedConversion.getOutType();
        }
        if (enhancements.contains((Object)NetcdfDataset.Enhance.ConvertMissing) && this.convertMissing != null && (this.dataType == DataType.FLOAT || this.dataType == DataType.DOUBLE)) {
            toApply.add(this.convertMissing);
        }
        if (enhancements.contains((Object)NetcdfDataset.Enhance.ApplyScaleOffset) && this.scaleOffset != null) {
            toApply.add(this.scaleOffset);
            convertedType = this.scaleOffset.getScaledOffsetType();
        }
        toApply.addAll(this.loadedEnhancements);
        double[] dataArray = (double[])data.get1DJavaArray(DataType.DOUBLE);
        dataArray = Arrays.stream(dataArray).parallel().map(num -> {
            for (Enhancement e : toApply) {
                num = e.convert(num);
            }
            return num;
        }).toArray();
        Array out = Array.factory(convertedType, data.getShape());
        IndexIterator iterOut = out.getIndexIterator();
        int i = 0;
        while ((long)i < data.getSize()) {
            iterOut.setObjectNext(dataArray[i]);
            ++i;
        }
        return out;
    }

    private Array convertEnums(Array values) {
        if (!values.getDataType().isIntegral()) {
            return values;
        }
        Array result = Array.factory(DataType.STRING, values.getShape());
        IndexIterator ii = result.getIndexIterator();
        values.resetLocalIterator();
        while (values.hasNext()) {
            String sval = this.lookupEnumString(values.nextInt());
            ii.setObjectNext(sval);
        }
        return result;
    }

    public Set<NetcdfDataset.Enhance> getEnhanceMode() {
        if (!(this.orgVar instanceof VariableDS)) {
            return Collections.unmodifiableSet(this.enhanceMode);
        }
        VariableDS orgVarDS = (VariableDS)this.orgVar;
        return Sets.union(this.enhanceMode, orgVarDS.getEnhanceMode());
    }

    @Deprecated
    public boolean addEnhancement(NetcdfDataset.Enhance enhancement) {
        if (this.enhanceMode.add(enhancement)) {
            this.enhance(this.enhanceMode);
            return true;
        }
        return false;
    }

    @Deprecated
    public boolean removeEnhancement(NetcdfDataset.Enhance enhancement) {
        if (this.enhanceMode.remove((Object)enhancement)) {
            this.enhance(this.enhanceMode);
            return true;
        }
        return false;
    }

    @Override
    public Variable getOriginalVariable() {
        return this.orgVar;
    }

    @Override
    @Deprecated
    public void setOriginalVariable(Variable orgVar) {
        if (orgVar instanceof Structure) {
            throw new IllegalArgumentException("VariableDS must not wrap a Structure; name=" + orgVar.getFullName());
        }
        this.orgVar = orgVar;
    }

    public DataType getOriginalDataType() {
        return this.orgDataType != null ? this.orgDataType : this.getDataType();
    }

    @Override
    public String getOriginalName() {
        return this.orgName;
    }

    @Override
    public String lookupEnumString(int val) {
        if (this.dataType.isEnum()) {
            return super.lookupEnumString(val);
        }
        return this.orgVar.lookupEnumString(val);
    }

    @Override
    @Deprecated
    public String setName(String newName) {
        this.orgName = this.getShortName();
        super.setShortName(newName);
        return newName;
    }

    @Override
    public String toStringDebug() {
        return this.orgVar != null ? this.orgVar.toStringDebug() : "";
    }

    @Override
    public String getDatasetLocation() {
        String result = super.getDatasetLocation();
        if (result != null) {
            return result;
        }
        if (this.orgVar != null) {
            return this.orgVar.getDatasetLocation();
        }
        return null;
    }

    @Deprecated
    public boolean hasCachedDataRecurse() {
        return super.hasCachedData() || this.orgVar != null && this.orgVar.hasCachedData();
    }

    @Override
    @Deprecated
    public void setCaching(boolean caching) {
        if (caching && this.orgVar != null) {
            this.orgVar.setCaching(true);
        }
    }

    @Override
    protected Array _read() throws IOException {
        Array result = this.hasCachedData() ? super._read() : this.proxyReader.reallyRead(this, null);
        return this.convert(result);
    }

    @Override
    protected Array _read(Section section) throws IOException, InvalidRangeException {
        if (null == section || section.computeSize() == this.getSize()) {
            return this._read();
        }
        Array result = this.hasCachedData() ? super._read(section) : this.proxyReader.reallyRead(this, section, null);
        return this.convert(result);
    }

    @Override
    public Array reallyRead(Variable client, CancelTask cancelTask) throws IOException {
        if (this.orgVar == null) {
            return this.getMissingDataArray(this.shape);
        }
        return this.orgVar.read();
    }

    @Override
    public Array reallyRead(Variable client, Section section, CancelTask cancelTask) throws IOException, InvalidRangeException {
        if (null == section || section.computeSize() == this.getSize()) {
            return this.reallyRead(client, cancelTask);
        }
        if (this.orgVar == null) {
            return this.getMissingDataArray(section.getShape());
        }
        return this.orgVar.read(section);
    }

    @Override
    public long readToStream(Section section, OutputStream out) throws IOException, InvalidRangeException {
        if (this.orgVar == null) {
            return super.readToStream(section, out);
        }
        return this.orgVar.readToStream(section, out);
    }

    public Array getMissingDataArray(int[] shape) {
        Object[] storage;
        switch (this.getDataType()) {
            case BOOLEAN: {
                storage = new boolean[1];
                break;
            }
            case BYTE: 
            case UBYTE: 
            case ENUM1: {
                storage = new byte[1];
                break;
            }
            case CHAR: {
                storage = new char[1];
                break;
            }
            case SHORT: 
            case USHORT: 
            case ENUM2: {
                storage = new short[1];
                break;
            }
            case INT: 
            case UINT: 
            case ENUM4: {
                storage = new int[1];
                break;
            }
            case LONG: 
            case ULONG: {
                storage = new long[1];
                break;
            }
            case FLOAT: {
                storage = new float[1];
                break;
            }
            case DOUBLE: {
                storage = new double[1];
                break;
            }
            default: {
                storage = new Object[1];
            }
        }
        Array array = Array.factoryConstant(this.getDataType(), shape, storage);
        if (this.hasFillValue) {
            array.setObject(0, (Object)this.fillValue);
        }
        return array;
    }

    public void showScaleMissingProxy(Formatter f) {
        f.format("has missing = %s%n", this.convertMissing != null);
        if (this.convertMissing != null) {
            if (this.convertMissing.hasMissing()) {
                if (this.convertMissing.hasMissingValue()) {
                    f.format("   missing value(s) = ", new Object[0]);
                    for (double d : this.convertMissing.getMissingValues()) {
                        f.format(" %f", d);
                    }
                    f.format("%n", new Object[0]);
                }
                if (this.convertMissing.hasFillValue()) {
                    f.format("   fillValue = %f%n", this.convertMissing.getFillValue());
                }
                if (this.convertMissing.hasValidData()) {
                    f.format("   valid min/max = [%f,%f]%n", this.convertMissing.getValidMin(), this.convertMissing.getValidMax());
                }
            }
            f.format("FillValue or default = %s%n", this.convertMissing.getFillValue());
        }
        f.format("%nhas scale/offset = %s%n", this.scaleOffset != null);
        if (this.scaleOffset != null) {
            double offset = this.scaleOffset.applyScaleOffset(0.0);
            double scale = this.scaleOffset.applyScaleOffset(1.0) - offset;
            f.format("   scale_factor = %f add_offset = %f%n", scale, offset);
        }
        f.format("original data type = %s%n", new Object[]{this.orgDataType});
        f.format("converted data type = %s%n", new Object[]{this.getDataType()});
    }

    @Override
    public String getDescription() {
        return this.enhanceProxy.getDescription();
    }

    @Override
    public String getUnitsString() {
        return this.enhanceProxy.getUnitsString();
    }

    @Override
    @Deprecated
    public void setUnitsString(String units) {
        this.enhanceProxy.setUnitsString(units);
    }

    public ImmutableList<CoordinateSystem> getCoordinateSystems() {
        return this.enhanceProxy.getCoordinateSystems();
    }

    @Override
    @Deprecated
    public void addCoordinateSystem(CoordinateSystem cs) {
        this.enhanceProxy.addCoordinateSystem(cs);
    }

    @Override
    @Deprecated
    public void removeCoordinateSystem(CoordinateSystem cs) {
        this.enhanceProxy.removeCoordinateSystem(cs);
    }

    @Override
    public boolean hasScaleOffset() {
        return this.scaleOffset != null;
    }

    @Override
    public double getScaleFactor() {
        return this.scaleOffset != null ? this.scaleOffset.getScaleFactor() : 1.0;
    }

    @Override
    public double getOffset() {
        return this.scaleOffset != null ? this.scaleOffset.getOffset() : 0.0;
    }

    @Override
    public boolean hasMissing() {
        return this.convertMissing != null && this.convertMissing.hasMissing();
    }

    @Override
    public boolean isMissing(double val) {
        if (Double.isNaN(val)) {
            return true;
        }
        return this.convertMissing != null && this.convertMissing.isMissing(this.packVal(val));
    }

    @Override
    public boolean hasValidData() {
        return this.convertMissing != null && this.convertMissing.hasMissingValue();
    }

    @Override
    public double getValidMin() {
        if (this.convertMissing == null) {
            return -1.7976931348623157E308;
        }
        if (this.scaleOffset == null) {
            return this.convertMissing.getValidMin();
        }
        return this.scaleOffset.getScaleFactor() < 0.0 ? this.unpackVal(this.convertMissing.getValidMax()) : this.unpackVal(this.convertMissing.getValidMin());
    }

    @Override
    public double getValidMax() {
        if (this.convertMissing == null) {
            return Double.MAX_VALUE;
        }
        if (this.scaleOffset == null) {
            return this.convertMissing.getValidMax();
        }
        return this.scaleOffset.getScaleFactor() < 0.0 ? this.unpackVal(this.convertMissing.getValidMin()) : this.unpackVal(this.convertMissing.getValidMax());
    }

    @Override
    public boolean isInvalidData(double val) {
        return this.convertMissing != null && this.convertMissing.isInvalidData(this.packVal(val));
    }

    @Override
    public boolean hasFillValue() {
        return this.hasFillValue;
    }

    @Override
    public double getFillValue() {
        return this.fillValue;
    }

    @Override
    public boolean isFillValue(double val) {
        return this.hasFillValue && Misc.nearlyEquals(val, this.fillValue, (double)1.0E-5f);
    }

    @Override
    public boolean hasMissingValue() {
        return this.convertMissing != null && this.convertMissing.hasMissingValue();
    }

    @Override
    public double[] getMissingValues() {
        if (this.convertMissing == null) {
            return new double[]{0.0};
        }
        double[] missingVals = this.convertMissing.getMissingValues();
        double[] vals = new double[missingVals.length];
        for (int i = 0; i < missingVals.length; ++i) {
            vals[i] = this.unpackVal(missingVals[i]);
        }
        return vals;
    }

    @Override
    public boolean isMissingValue(double val) {
        return this.convertMissing != null && this.convertMissing.isMissingValue(this.packVal(val));
    }

    private double unpackVal(double val) {
        return this.scaleOffset != null && !Double.isNaN(val) ? this.scaleOffset.convert(val) : val;
    }

    private double packVal(double val) {
        return this.scaleOffset != null && !Double.isNaN(val) ? this.scaleOffset.applyScaleOffset(val) : val;
    }

    @Override
    @Deprecated
    public void setFillValueIsMissing(boolean b) {
        if (this.convertMissing != null) {
            this.convertMissing.setFillValueIsMissing(b);
        }
    }

    @Override
    @Deprecated
    public void setInvalidDataIsMissing(boolean b) {
        if (this.convertMissing != null) {
            this.convertMissing.setInvalidDataIsMissing(b);
        }
    }

    public boolean missingDataIsMissing() {
        return ((Builder)VariableDS.builder()).missingDataIsMissing;
    }

    public boolean fillValueIsMissing() {
        return ((Builder)VariableDS.builder()).fillValueIsMissing;
    }

    public boolean invalidDataIsMissing() {
        return ((Builder)VariableDS.builder()).invalidDataIsMissing;
    }

    @Override
    @Deprecated
    public void setMissingDataIsMissing(boolean b) {
        if (this.convertMissing != null) {
            this.convertMissing.setMissingDataIsMissing(b);
        }
    }

    @Override
    @Nullable
    public DataType getScaledOffsetType() {
        return this.scaleOffset != null ? this.scaleOffset.getScaledOffsetType() : this.dataType;
    }

    @Override
    public DataType getUnsignedConversionType() {
        return this.unsignedConversion != null ? this.unsignedConversion.getOutType() : this.dataType;
    }

    @Override
    public DataType.Signedness getSignedness() {
        return this.unsignedConversion != null ? this.unsignedConversion.getSignedness() : this.dataType.getSignedness();
    }

    @Override
    public double applyScaleOffset(Number value) {
        return this.scaleOffset != null ? this.scaleOffset.convert(value.doubleValue()) : value.doubleValue();
    }

    @Override
    public Array applyScaleOffset(Array data) {
        return this.scaleOffset != null ? this.scaleOffset.convert(data) : data;
    }

    @Override
    public Number convertUnsigned(Number value) {
        return this.unsignedConversion != null ? (Number)this.unsignedConversion.convert(value.doubleValue()) : (Number)value;
    }

    public Number convertUnsigned(Number value, DataType dataType) {
        return this.unsignedConversion != null ? (Number)UnsignedConversion.convertUnsigned(value, dataType) : (Number)value;
    }

    @Override
    public Array convertUnsigned(Array in) {
        return this.unsignedConversion != null ? this.unsignedConversion.convertUnsigned(in) : in;
    }

    @Override
    public Number convertMissing(Number value) {
        return this.convertMissing != null ? (Number)this.convertMissing.convert(value.doubleValue()) : (Number)value;
    }

    @Override
    public Array convertMissing(Array in) {
        return this.convertMissing != null && (this.dataType == DataType.FLOAT || this.dataType == DataType.DOUBLE) ? this.convertMissing.convertMissing(in) : in;
    }

    @Override
    @Deprecated
    public Array convert(Array in, boolean convertUnsigned, boolean applyScaleOffset, boolean convertMissing) {
        return this.convertMissing(this.applyScaleOffset(this.convertUnsigned(in)));
    }

    protected VariableDS(Builder<?> builder, Group parentGroup) {
        super(builder, parentGroup);
        Attribute units;
        this.enhanceMode = builder.enhanceMode;
        this.orgVar = builder.orgVar;
        this.orgDataType = builder.orgDataType;
        this.orgName = builder.orgName;
        if (this.orgDataType == null) {
            this.orgDataType = this.dataType;
        }
        if ((units = builder.getAttributeContainer().findAttributeIgnoreCase("units")) != null && units.isString()) {
            builder.getAttributeContainer().addAttribute(Attribute.builder("units").setStringValue(units.getStringValue().trim()).build());
        }
        this.orgFileTypeId = builder.orgFileTypeId;
        this.enhanceProxy = new EnhancementsImpl(this, ((Builder)builder).units, builder.getDescription());
        this.scaleOffset = ((Builder)builder).scaleOffset;
        this.createEnhancements();
        if (this.convertMissing != null) {
            this.fillValue = this.unpackVal(this.convertMissing.getFillValue());
            this.hasFillValue = true;
        } else {
            this.fillValue = ConvertMissing.getFillValueOrDefault(this);
            this.hasFillValue = !Double.isNaN(this.fillValue);
        }
        this.coordSysNames = builder.coordSysNames;
    }

    private void createEnhancements() {
        if (this.enhanceMode.contains((Object)NetcdfDataset.Enhance.ConvertEnums) && this.dataType.isEnum()) {
            this.dataType = DataType.STRING;
        }
        if (this.enhanceMode.contains((Object)NetcdfDataset.Enhance.ConvertUnsigned)) {
            this.unsignedConversion = UnsignedConversion.createFromVar(this);
            this.dataType = this.unsignedConversion.getOutType();
        }
        if (this.enhanceMode.contains((Object)NetcdfDataset.Enhance.ConvertMissing)) {
            this.convertMissing = ConvertMissing.createFromVariable(this);
        }
        if (this.enhanceMode.contains((Object)NetcdfDataset.Enhance.ApplyScaleOffset) && (this.dataType.isNumeric() || this.dataType == DataType.CHAR)) {
            if (this.scaleOffset == null) {
                this.scaleOffset = ScaleOffset.createFromVariable(this);
            }
            DataType dataType = this.dataType = this.scaleOffset != null ? this.scaleOffset.getScaledOffsetType() : this.dataType;
        }
        if (this.enhanceMode.contains((Object)NetcdfDataset.Enhance.ApplyRuntimeLoadedEnhancements)) {
            for (EnhancementProvider service : ENHANCEMENT_PROVIDERS) {
                if (this.attributes().findAttribute(service.getAttributeName()) == null || !service.appliesTo(this.enhanceMode, this.dataType)) continue;
                this.loadedEnhancements.add(service.create(this));
            }
        }
    }

    public Builder<?> toBuilder() {
        return this.addLocalFieldsToBuilder(VariableDS.builder());
    }

    protected Builder<?> addLocalFieldsToBuilder(Builder<? extends Builder<?>> builder) {
        ((Builder)((Builder)((Builder)((Builder)((Builder)builder.setOriginalVariable(this.orgVar).setOriginalDataType(this.orgDataType)).setOriginalName(this.orgName)).setOriginalFileTypeId(this.orgFileTypeId)).setEnhanceMode(this.enhanceMode)).setUnits(this.enhanceProxy.units)).setDesc(this.enhanceProxy.desc);
        ((Builder)builder).scaleOffset = this.scaleOffset;
        if (this.coordSysNames != null) {
            this.coordSysNames.stream().forEach(s -> builder.addCoordinateSystemName((String)s));
        }
        return (Builder)super.addLocalFieldsToBuilder(builder);
    }

    @Deprecated
    void setCoordinateSystems(CoordinatesHelper coords) {
        for (String name : this.coordSysNames) {
            coords.findCoordSystem(name).ifPresent(cs -> this.enhanceProxy.addCoordinateSystem((CoordinateSystem)cs));
        }
    }

    public static Builder<?> builder() {
        return new Builder2();
    }

    public static abstract class Builder<T extends Builder<T>>
    extends Variable.Builder<T> {
        public Set<NetcdfDataset.Enhance> enhanceMode = EnumSet.noneOf(NetcdfDataset.Enhance.class);
        public Variable orgVar;
        public DataType orgDataType;
        public String orgFileTypeId;
        String orgName;
        private String units;
        private String desc;
        public List<String> coordSysNames = new ArrayList<String>();
        private boolean invalidDataIsMissing = NetcdfDataset.invalidDataIsMissing;
        private boolean fillValueIsMissing = NetcdfDataset.fillValueIsMissing;
        private boolean missingDataIsMissing = NetcdfDataset.missingDataIsMissing;
        private ScaleOffset scaleOffset;
        private boolean built;

        @Override
        protected abstract T self();

        public T setEnhanceMode(Set<NetcdfDataset.Enhance> enhanceMode) {
            this.enhanceMode = enhanceMode;
            return (T)this.self();
        }

        public T addEnhanceMode(Set<NetcdfDataset.Enhance> enhanceMode) {
            this.enhanceMode.addAll(enhanceMode);
            return (T)this.self();
        }

        public T setOriginalVariable(Variable orgVar) {
            this.orgVar = orgVar;
            return (T)this.self();
        }

        public T setOriginalDataType(DataType orgDataType) {
            this.orgDataType = orgDataType;
            return (T)this.self();
        }

        public T setOriginalName(String orgName) {
            this.orgName = orgName;
            return (T)this.self();
        }

        public T setOriginalFileTypeId(String orgFileTypeId) {
            this.orgFileTypeId = orgFileTypeId;
            return (T)this.self();
        }

        public T setUnits(String units) {
            this.units = units;
            if (units != null) {
                this.units = units.trim();
                this.addAttribute(new Attribute("units", this.units));
            }
            return (T)this.self();
        }

        public T setDesc(String desc) {
            this.desc = desc;
            if (desc != null) {
                this.addAttribute(new Attribute("long_name", desc));
            }
            return (T)this.self();
        }

        public void addCoordinateSystemName(String coordSysName) {
            this.coordSysNames.add(coordSysName);
        }

        public void setFillValueIsMissing(boolean b) {
            this.fillValueIsMissing = b;
        }

        public void setInvalidDataIsMissing(boolean b) {
            this.invalidDataIsMissing = b;
        }

        public void setMissingDataIsMissing(boolean b) {
            this.missingDataIsMissing = b;
        }

        @Override
        public Variable.Builder<?> copy() {
            return new Builder2().copyFrom(this);
        }

        @Override
        public T copyFrom(Variable orgVar) {
            super.copyFrom(orgVar);
            this.setSPobject(null);
            this.setOriginalVariable(orgVar);
            this.setOriginalDataType(orgVar.getDataType());
            this.setOriginalName(orgVar.getShortName());
            this.orgFileTypeId = orgVar.getFileTypeId();
            return (T)this.self();
        }

        @Override
        public T copyFrom(Builder<?> builder) {
            super.copyFrom(builder);
            builder.coordSysNames.forEach(name -> this.addCoordinateSystemName((String)name));
            this.setDesc(builder.desc);
            this.setEnhanceMode(builder.enhanceMode);
            this.setFillValueIsMissing(builder.fillValueIsMissing);
            this.setInvalidDataIsMissing(builder.invalidDataIsMissing);
            this.setMissingDataIsMissing(builder.missingDataIsMissing);
            this.scaleOffset = builder.scaleOffset;
            this.orgVar = builder.orgVar;
            this.orgDataType = builder.orgDataType;
            this.orgFileTypeId = builder.orgFileTypeId;
            this.orgName = builder.orgName;
            this.setUnits(builder.units);
            return (T)this.self();
        }

        public String getUnits() {
            String result = this.units;
            if (result == null) {
                result = this.getAttributeContainer().findAttributeString("units", null);
            }
            if (result == null && this.orgVar != null) {
                result = this.orgVar.attributes().findAttributeString("units", null);
            }
            return result == null ? null : result.trim();
        }

        public String getDescription() {
            String result = this.desc;
            if (result == null) {
                result = this.getAttributeContainer().findAttributeString("long_name", null);
            }
            if (result == null && this.orgVar != null) {
                result = this.orgVar.attributes().findAttributeString("long_name", null);
            }
            return result == null ? null : result.trim();
        }

        @Override
        public VariableDS build(Group parentGroup) {
            if (this.built) {
                throw new IllegalStateException("already built");
            }
            this.built = true;
            return new VariableDS(this, parentGroup);
        }
    }

    private static class Builder2
    extends Builder<Builder2> {
        private Builder2() {
        }

        @Override
        protected Builder2 self() {
            return this;
        }
    }
}

