/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft2.coverage;

import com.google.common.collect.Lists;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.List;
import javax.annotation.Nullable;
import ucar.nc2.Attribute;
import ucar.nc2.AttributeContainer;
import ucar.nc2.AttributeContainerMutable;
import ucar.nc2.NetcdfFile;
import ucar.nc2.VariableSimpleIF;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.ft.FeatureDataset;
import ucar.nc2.ft2.coverage.Coverage;
import ucar.nc2.ft2.coverage.CoverageCollection;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.time.CalendarDateRange;
import ucar.nc2.util.cache.FileCacheIF;
import ucar.unidata.geoloc.LatLonRect;

public class FeatureDatasetCoverage
implements FeatureDataset,
Closeable {
    private final String location;
    private final AttributeContainer gatts;
    private final Closeable closer;
    private final List<CoverageCollection> covCollections;
    private final FeatureType featureType;
    private final CalendarDateRange calendarDateRange;
    private FileCacheIF fileCache;

    public FeatureDatasetCoverage(String location, Closeable closer, CoverageCollection covCollection) {
        this.location = location;
        this.gatts = new AttributeContainerMutable(location, covCollection.getGlobalAttributes()).toImmutable();
        this.closer = closer;
        this.covCollections = Lists.newArrayList((Object[])new CoverageCollection[]{covCollection});
        this.featureType = covCollection.getCoverageType();
        this.calendarDateRange = covCollection.getCalendarDateRange();
    }

    public FeatureDatasetCoverage(String location, AttributeContainer gatts, Closeable closer, List<CoverageCollection> covCollections) {
        this.location = location;
        this.gatts = gatts;
        this.closer = closer;
        this.covCollections = covCollections;
        CalendarDateRange cdr = null;
        FeatureType ft = null;
        for (CoverageCollection cc : covCollections) {
            FeatureType ftCheck = cc.getCoverageType();
            if (ft == null) {
                ft = ftCheck;
            } else if (ftCheck != ft) {
                ft = FeatureType.COVERAGE;
            }
            CalendarDateRange cdrCheck = cc.getCalendarDateRange();
            if (cdr == null) {
                cdr = cdrCheck;
                continue;
            }
            if (cdrCheck == null) continue;
            cdr = cdr.extend(cdrCheck);
        }
        this.featureType = ft;
        this.calendarDateRange = cdr;
    }

    public List<CoverageCollection> getCoverageCollections() {
        return this.covCollections;
    }

    public CoverageCollection getSingleCoverageCollection() {
        if (this.covCollections.size() != 1) {
            throw new RuntimeException("multiple collection in the dataset");
        }
        return this.covCollections.get(0);
    }

    public CoverageCollection findCoverageDataset(FeatureType type) {
        for (CoverageCollection cd : this.covCollections) {
            if (cd.getCoverageType() != type) continue;
            return cd;
        }
        return null;
    }

    public CoverageCollection findCoverageDataset(String name) {
        for (CoverageCollection cd : this.covCollections) {
            if (!cd.getName().equals(name)) continue;
            return cd;
        }
        return null;
    }

    @Override
    public FeatureType getFeatureType() {
        return this.featureType;
    }

    @Override
    public String getTitle() {
        return this.location;
    }

    @Override
    public String getDescription() {
        return this.location;
    }

    @Override
    public String getLocation() {
        return this.location;
    }

    @Override
    public CalendarDateRange getCalendarDateRange() {
        return this.calendarDateRange;
    }

    @Override
    public CalendarDate getCalendarDateStart() {
        return this.calendarDateRange == null ? null : this.calendarDateRange.getStart();
    }

    @Override
    public CalendarDate getCalendarDateEnd() {
        return this.calendarDateRange == null ? null : this.calendarDateRange.getEnd();
    }

    @Override
    public LatLonRect getBoundingBox() {
        return null;
    }

    @Override
    public AttributeContainer attributes() {
        return this.gatts;
    }

    @Override
    public List<Attribute> getGlobalAttributes() {
        return this.gatts.getAttributes();
    }

    @Override
    public Attribute findGlobalAttributeIgnoreCase(String name) {
        return this.gatts.findAttributeIgnoreCase(name);
    }

    @Override
    public List<VariableSimpleIF> getDataVariables() {
        ArrayList<VariableSimpleIF> result = new ArrayList<VariableSimpleIF>();
        for (CoverageCollection cc : this.covCollections) {
            for (Coverage cov : cc.getCoverages()) {
                result.add(cov);
            }
        }
        return result;
    }

    @Override
    public VariableSimpleIF getDataVariable(String shortName) {
        for (CoverageCollection cc : this.covCollections) {
            Coverage result = cc.findCoverage(shortName);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Override
    @Nullable
    public NetcdfFile getNetcdfFile() {
        return null;
    }

    @Override
    public void getDetailInfo(Formatter sf) {
        for (CoverageCollection cc : this.covCollections) {
            cc.toString(sf);
        }
    }

    @Override
    public String getImplementationName() {
        return this.closer.getClass().getName();
    }

    @Override
    public long getLastModified() {
        return 0L;
    }

    @Override
    @Deprecated
    public synchronized void setFileCache(FileCacheIF fileCache) {
        this.fileCache = fileCache;
    }

    @Override
    @Deprecated
    public void release() {
    }

    @Override
    @Deprecated
    public void reacquire() {
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.fileCache != null && this.fileCache.release(this)) {
            return;
        }
        this.reallyClose();
    }

    private void reallyClose() throws IOException {
        try {
            this.closer.close();
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }
}

