/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.geoloc.projection.sat;

public class GEOSTransform {
    public static final String GOES = "GOES";
    public static final String GEOS = "GEOS";
    public static final String WGS84 = "WGS84";
    public static final String GRS80 = "GRS80";
    public final Geoid wgs84 = new GeoidWGS84();
    public final Geoid grs80 = new GeoidGRS80();
    private static final double DEG_TO_RAD = Math.PI / 180;
    private static final double RAD_TO_DEG = 57.29577951308232;
    private static final double h_msg = 42164.0;
    private static final double h_goesr = 42164.16;
    double r_pol = 6356.7523;
    double r_eq = 6378.137;
    private double f = 0.003352810681182319;
    private double fp = 1.0 / ((1.0 - this.f) * (1.0 - this.f));
    private double h = 42164.16;
    double d;
    double sub_lon;
    double sub_lon_degrees;
    double sat_height;
    public String scan_geom = "GEOS";

    public GEOSTransform() {
        this(0.0);
    }

    public GEOSTransform(double subLonDegrees) {
        this(subLonDegrees, GEOS);
    }

    public GEOSTransform(double subLonDegrees, String scan_geom) {
        this(subLonDegrees, scan_geom, null);
    }

    public GEOSTransform(double subLonDegrees, String scan_geom, String geoidID) {
        Geoid geoid = null;
        if (geoidID == null) {
            if (scan_geom.equals(GEOS)) {
                geoid = this.wgs84;
            } else if (scan_geom.equals(GOES)) {
                geoid = this.grs80;
            }
        } else if (geoidID.equals(WGS84)) {
            geoid = this.wgs84;
        } else if (geoidID.equals(GRS80)) {
            geoid = this.grs80;
        }
        if (geoid == null) {
            throw new IllegalArgumentException("GEOSTransform unrecognized scan_geom=" + scan_geom + " geoidID=" + geoidID);
        }
        this.init(subLonDegrees, scan_geom, geoid);
    }

    public GEOSTransform(double subLonDegrees, double perspective_point_height, double semi_minor_axis, double semi_major_axis, double inverse_flattening, String sweep_angle_axis) {
        Geoid geoid = Double.isNaN(inverse_flattening) ? new Geoid(semi_minor_axis, semi_major_axis) : new Geoid(semi_minor_axis, semi_major_axis, inverse_flattening);
        this.scan_geom = GEOSTransform.sweepAngleAxisToScanGeom(sweep_angle_axis);
        this.init(subLonDegrees, this.scan_geom, geoid, perspective_point_height);
    }

    public GEOSTransform(double subLonDegrees, double perspective_point_height, double semi_minor_axis, double semi_major_axis, String sweep_angle_axis) {
        Geoid geoid = new Geoid(semi_minor_axis, semi_major_axis);
        this.scan_geom = GEOSTransform.sweepAngleAxisToScanGeom(sweep_angle_axis);
        this.init(subLonDegrees, this.scan_geom, geoid, perspective_point_height);
    }

    private void init(double subLonDegrees, String scan_geom, Geoid geoid) {
        this.sub_lon_degrees = subLonDegrees;
        this.sub_lon = this.sub_lon_degrees * (Math.PI / 180);
        this.scan_geom = scan_geom;
        this.r_pol = geoid.r_pol;
        this.r_eq = geoid.r_eq;
        this.f = geoid.f;
        this.fp = 1.0 / ((1.0 - this.f) * (1.0 - this.f));
        if (scan_geom.equals(GEOS)) {
            this.h = 42164.0;
        } else if (scan_geom.equals(GOES)) {
            this.h = 42164.16;
        }
        this.sat_height = this.h - this.r_eq;
        this.d = this.h * this.h - this.r_eq * this.r_eq;
    }

    private void init(double subLonDegrees, String scan_geom, Geoid geoid, double perspective_point_height) {
        this.sub_lon_degrees = subLonDegrees;
        this.sub_lon = this.sub_lon_degrees * (Math.PI / 180);
        this.scan_geom = scan_geom;
        this.sat_height = perspective_point_height;
        this.r_pol = geoid.r_pol;
        this.r_eq = geoid.r_eq;
        this.f = geoid.f;
        this.fp = 1.0 / ((1.0 - this.f) * (1.0 - this.f));
        this.h = perspective_point_height + this.r_eq;
        this.d = this.h * this.h - this.r_eq * this.r_eq;
    }

    public double[] earthToSat(double geographic_lon, double geographic_lat) {
        double geocentric_lat = Math.atan(this.r_pol * this.r_pol / (this.r_eq * this.r_eq) * Math.tan(geographic_lat *= Math.PI / 180));
        double r_earth = this.r_pol / Math.sqrt(1.0 - (this.r_eq * this.r_eq - this.r_pol * this.r_pol) / (this.r_eq * this.r_eq) * Math.cos(geocentric_lat) * Math.cos(geocentric_lat));
        double r_1 = this.h - r_earth * Math.cos(geocentric_lat) * Math.cos((geographic_lon *= Math.PI / 180) - this.sub_lon);
        double r_2 = -r_earth * Math.cos(geocentric_lat) * Math.sin(geographic_lon - this.sub_lon);
        double r_3 = r_earth * Math.sin(geocentric_lat);
        if (r_1 > this.h) {
            return new double[]{Double.NaN, Double.NaN};
        }
        double lamda_sat = Double.NaN;
        double theta_sat = Double.NaN;
        if (this.scan_geom.equals(GEOS)) {
            if (this.h * (this.h - r_1) < r_3 * r_3 + this.r_eq * this.r_eq * r_2 * r_2 / (this.r_pol * this.r_pol)) {
                return new double[]{Double.NaN, Double.NaN};
            }
            lamda_sat = Math.atan(-r_2 / r_1);
            theta_sat = Math.asin(r_3 / Math.sqrt(r_1 * r_1 + r_2 * r_2 + r_3 * r_3));
        } else if (this.scan_geom.equals(GOES)) {
            if (this.h * (this.h - r_1) < r_2 * r_2 + this.r_eq * this.r_eq * r_3 * r_3 / (this.r_pol * this.r_pol)) {
                return new double[]{Double.NaN, Double.NaN};
            }
            lamda_sat = Math.asin(-r_2 / Math.sqrt(r_1 * r_1 + r_2 * r_2 + r_3 * r_3));
            theta_sat = Math.atan(r_3 / r_1);
        }
        return new double[]{lamda_sat, theta_sat};
    }

    public double[] satToEarth(double x, double y) {
        double c2;
        double c1;
        if (this.scan_geom.equals(GOES)) {
            double[] lambda_theta_geos = this.GOES_to_GEOS(x, y);
            x = lambda_theta_geos[0];
            y = lambda_theta_geos[1];
        }
        if ((c1 = this.h * Math.cos(x) * Math.cos(y) * (this.h * Math.cos(x) * Math.cos(y))) < (c2 = (Math.cos(y) * Math.cos(y) + this.fp * Math.sin(y) * Math.sin(y)) * this.d)) {
            return new double[]{Double.NaN, Double.NaN};
        }
        double s_d = Math.sqrt(c1 - c2);
        double s_n = (this.h * Math.cos(x) * Math.cos(y) - s_d) / (Math.cos(y) * Math.cos(y) + this.fp * Math.sin(y) * Math.sin(y));
        double s_1 = this.h - s_n * Math.cos(x) * Math.cos(y);
        double s_2 = s_n * Math.sin(x) * Math.cos(y);
        double s_3 = -s_n * Math.sin(y);
        double s_xy = Math.sqrt(s_1 * s_1 + s_2 * s_2);
        double geographic_lon = Math.atan(s_2 / s_1) + this.sub_lon;
        double geographic_lat = Math.atan(-this.fp * (s_3 / s_xy));
        double lonDegrees = 57.29577951308232 * geographic_lon;
        double latDegrees = 57.29577951308232 * geographic_lat;
        if (lonDegrees < -180.0) {
            lonDegrees += 360.0;
        }
        if (lonDegrees > 180.0) {
            lonDegrees -= 360.0;
        }
        return new double[]{lonDegrees, latDegrees};
    }

    public double[] GOES_to_GEOS(double lamda_goes, double theta_goes) {
        double theta_geos = Math.asin(Math.sin(theta_goes) * Math.cos(lamda_goes));
        double lamda_geos = Math.atan(Math.tan(lamda_goes) / Math.cos(theta_goes));
        return new double[]{lamda_geos, theta_geos};
    }

    public double[] FGFtoEarth(double fgf_x, double fgf_y, double scale_x, double offset_x, double scale_y, double offset_y) {
        double[] xy = this.FGFtoSat(fgf_x, fgf_y, scale_x, offset_x, scale_y, offset_y);
        return this.satToEarth(xy[0], xy[1]);
    }

    public double[] FGFtoSat(double fgf_x, double fgf_y, double scale_x, double offset_x, double scale_y, double offset_y) {
        double x = fgf_x * scale_x + offset_x;
        double y = fgf_y * scale_y + offset_y;
        return new double[]{x, y};
    }

    public double[] elemLineToEarth(int elem, int line, double scale_x, double offset_x, double scale_y, double offset_y) {
        return this.FGFtoEarth(elem, line, scale_x, offset_x, scale_y, offset_y);
    }

    public double[] earthToFGF(double geographic_lon, double geographic_lat, double scale_x, double offset_x, double scale_y, double offset_y) {
        double[] xy = this.earthToSat(geographic_lon, geographic_lat);
        return this.SatToFGF(xy[0], xy[1], scale_x, offset_x, scale_y, offset_y);
    }

    public int[] earthToElemLine(double geographic_lon, double geographic_lat, double scale_x, double offset_x, double scale_y, double offset_y) {
        double[] fgf = this.earthToFGF(geographic_lon, geographic_lat, scale_x, offset_x, scale_y, offset_y);
        int elem = (int)Math.floor(fgf[0] + 0.5);
        int line = (int)Math.floor(fgf[1] + 0.5);
        return new int[]{elem, line};
    }

    public double[] SatToFGF(double lamda, double theta, double scale_x, double offset_x, double scale_y, double offset_y) {
        double fgf_x = (lamda - offset_x) / scale_x;
        double fgf_y = (theta - offset_y) / scale_y;
        return new double[]{fgf_x, fgf_y};
    }

    public static String scanGeomToSweepAngleAxis(String scanGeometry) {
        String sweepAngleAxis = "y";
        if (scanGeometry.equals(GOES)) {
            sweepAngleAxis = "x";
        }
        return sweepAngleAxis;
    }

    public static String sweepAngleAxisToScanGeom(String sweepAngleAxis) {
        String scanGeom = GOES;
        if (sweepAngleAxis.equals("y")) {
            scanGeom = GEOS;
        }
        return scanGeom;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GEOSTransform that = (GEOSTransform)o;
        if (Double.compare(that.sub_lon, this.sub_lon) != 0) {
            return false;
        }
        return this.scan_geom.equals(that.scan_geom);
    }

    public int hashCode() {
        long temp = Double.doubleToLongBits(this.sub_lon);
        int result = (int)(temp ^ temp >>> 32);
        result = 31 * result + this.scan_geom.hashCode();
        return result;
    }

    static class GeoidGRS80
    extends Geoid {
        public GeoidGRS80() {
            this.r_pol = 6356.7523;
            this.r_eq = 6378.137;
            this.f = 0.003352810681182319;
        }
    }

    static class GeoidWGS84
    extends Geoid {
        public GeoidWGS84() {
            this.r_pol = 6356.7523;
            this.r_eq = 6378.137;
            this.f = 0.0033528106647474805;
        }
    }

    static class Geoid {
        double r_pol;
        double r_eq;
        double f;

        public Geoid() {
        }

        public Geoid(double r_pol, double r_eq, double invf) {
            this.r_pol = r_pol;
            this.r_eq = r_eq;
            this.f = 1.0 / invf;
        }

        public Geoid(double r_pol, double r_eq) {
            this.r_pol = r_pol;
            this.r_eq = r_eq;
            this.f = (r_eq - r_pol) / r_eq;
        }
    }
}

