/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.internal.ncml;

import java.io.IOException;
import java.util.List;
import java.util.Optional;
import ucar.ma2.DataType;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.Group;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.VariableDS;
import ucar.nc2.internal.ncml.AggDataset;
import ucar.nc2.internal.ncml.AggDatasetOuter;
import ucar.nc2.internal.ncml.Aggregation;
import ucar.nc2.internal.ncml.AggregationOuter;
import ucar.nc2.internal.ncml.BuilderHelper;
import ucar.nc2.util.CancelTask;

public class AggregationNew
extends AggregationOuter {
    public AggregationNew(NetcdfDataset.Builder ncd, String dimName, String recheckS) {
        super(ncd, dimName, Aggregation.Type.joinNew, recheckS);
    }

    @Override
    protected void buildNetcdfDataset(CancelTask cancelTask) throws IOException {
        this.buildCoords(cancelTask);
        AggDataset typicalDataset = this.getTypicalDataset();
        NetcdfFile typical = typicalDataset.acquireFile(null);
        BuilderHelper.transferDataset(typical, this.ncDataset, null);
        String dimName = this.getDimensionName();
        Dimension aggDim = new Dimension(dimName, this.getTotalCoords());
        Group.Builder root = this.ncDataset.rootGroup;
        root.removeDimension(dimName);
        root.addDimension(aggDim);
        this.promoteGlobalAttributes((AggDatasetOuter)typicalDataset);
        List<String> aggVarNames = this.getAggVariableNames();
        Optional<Variable.Builder<?>> joinAggCoord = root.findVariableLocal(dimName);
        if (!joinAggCoord.isPresent()) {
            DataType coordType = this.getCoordinateType();
            VariableDS.Builder joinAggCoordVar = (VariableDS.Builder)((VariableDS.Builder)((VariableDS.Builder)((VariableDS.Builder)VariableDS.builder().setName(dimName)).setDataType(coordType)).setParentGroupBuilder(root)).setDimensionsByName(dimName);
            root.addVariable(joinAggCoordVar);
            joinAggCoordVar.setProxyReader(this);
            if (this.isDate) {
                joinAggCoordVar.addAttribute(new Attribute("_CoordinateAxisType", "Time"));
                String coordUnits = ((AggDatasetOuter)typicalDataset).coordUdunit;
                if (coordUnits != null && !coordUnits.isEmpty()) {
                    joinAggCoordVar.addAttribute(new Attribute("units", coordUnits));
                }
            }
            AggregationOuter.CoordValueVar cv = new AggregationOuter.CoordValueVar(joinAggCoordVar.shortName, joinAggCoordVar.dataType, joinAggCoordVar.getUnits());
            joinAggCoordVar.setSPobject(cv);
            this.cacheList.add(cv);
        } else {
            Variable.Builder<?> joinAggCoordVar = joinAggCoord.get();
            if (joinAggCoordVar.getRank() == 0) {
                if (!aggVarNames.contains(joinAggCoordVar.shortName)) {
                    aggVarNames.add(joinAggCoordVar.shortName);
                }
            } else {
                throw new IllegalArgumentException("Variable " + dimName + " already exists, but is not a scalar (suitable for aggregating as a coordinate).");
            }
        }
        if (aggVarNames.isEmpty()) {
            for (Variable v2 : typical.getVariables()) {
                if (v2 instanceof CoordinateAxis) continue;
                aggVarNames.add(v2.getShortName());
            }
        }
        for (String varname : aggVarNames) {
            Optional<Variable.Builder<?>> aggVarOpt = root.findVariableLocal(varname);
            if (!aggVarOpt.isPresent()) {
                logger.error(this.ncDataset.location + " aggNewDimension cant find variable " + varname);
                continue;
            }
            Variable.Builder<?> aggVar = aggVarOpt.get();
            VariableDS.Builder vagg = (VariableDS.Builder)((VariableDS.Builder)((VariableDS.Builder)((VariableDS.Builder)VariableDS.builder().setName(aggVar.shortName)).setDataType(aggVar.dataType)).setParentGroupBuilder(root)).setDimensionsByName(dimName + " " + aggVar.makeDimensionsString());
            vagg.setProxyReader(this);
            BuilderHelper.transferAttributes(aggVar.getAttributeContainer(), vagg.getAttributeContainer());
            Attribute att = vagg.getAttributeContainer().findAttribute("_CoordinateAxes");
            if (att != null) {
                String axes = dimName + " " + att.getStringValue();
                vagg.addAttribute(new Attribute("_CoordinateAxes", axes));
            }
            root.replaceVariable(vagg);
            this.aggVars.add(vagg);
            if (cancelTask == null || !cancelTask.isCancel()) continue;
            return;
        }
        this.setDatasetAcquireProxy(typicalDataset, this.ncDataset);
        typicalDataset.close(typical);
        if (this.isDate && this.timeUnitsChange) {
            root.findVariableLocal(dimName).ifPresent(v -> {
                try {
                    this.readTimeCoordinates((Variable.Builder)v, cancelTask);
                }
                catch (IOException e) {
                    throw new IllegalStateException(e);
                }
            });
        }
    }

    private DataType getCoordinateType() {
        List<AggDataset> nestedDatasets = this.getDatasets();
        AggDatasetOuter first = (AggDatasetOuter)nestedDatasets.get(0);
        return first.coordDataType;
    }
}

