/*
 * Decompiled with CFR 0.152.
 */
package thredds.client.catalog;

import com.google.common.base.Preconditions;
import java.text.ParseException;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import thredds.client.catalog.TimeDuration;
import ucar.nc2.time.Calendar;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.time.CalendarDateFormatter;
import ucar.nc2.time.CalendarPeriod;
import ucar.nc2.units.TimeUnit;

@Immutable
public class DateType {
    @Nullable
    private final String format;
    @Nullable
    private final String type;
    @Nullable
    private final CalendarDate date;
    private final String text;
    private final boolean isPresent;
    private final boolean isBlank;

    public static DateType present() {
        return new DateType();
    }

    public static DateType parse(String text) throws ParseException {
        return DateType.parse(text, null, null, null);
    }

    public static DateType parse(@Nullable String text, @Nullable String format, @Nullable String type, @Nullable Calendar calendar) throws ParseException {
        String calName;
        String string = text = text == null ? "" : text.trim();
        if (text.isEmpty()) {
            return new DateType(text, format, type, null);
        }
        if (text.equalsIgnoreCase("present")) {
            return DateType.present();
        }
        if (format != null) {
            CalendarDateFormatter dateFormat = new CalendarDateFormatter(format);
            CalendarDate date = dateFormat.parse(text);
            return new DateType(text, format, type, date);
        }
        String string2 = calName = calendar == null ? null : calendar.name();
        if (text.indexOf("since") > 0) {
            CalendarDate date = CalendarDate.parseUdunits(calName, text);
            return new DateType(text, format, type, date);
        }
        CalendarDate date = CalendarDate.parseISOformat(calName, text);
        return new DateType(text, format, type, date);
    }

    private DateType() {
        this.date = null;
        this.text = "present";
        this.isPresent = true;
        this.isBlank = false;
        this.format = null;
        this.type = null;
    }

    public DateType(CalendarDate date) {
        this.date = (CalendarDate)Preconditions.checkNotNull((Object)date);
        this.text = this.toDateTimeString();
        this.isPresent = false;
        this.isBlank = false;
        this.format = null;
        this.type = null;
    }

    private DateType(String text, @Nullable String format, @Nullable String type, CalendarDate date) {
        this.text = text == null ? "" : text.trim();
        this.isBlank = this.text.isEmpty();
        this.format = format;
        this.type = type;
        this.date = (CalendarDate)Preconditions.checkNotNull((Object)date);
        this.isPresent = false;
    }

    @Nullable
    public CalendarDate getCalendarDate() {
        return this.isPresent() ? CalendarDate.present() : this.date;
    }

    public boolean isPresent() {
        return this.isPresent;
    }

    public boolean isBlank() {
        return this.isBlank;
    }

    public String getText() {
        return this.text;
    }

    @Nullable
    public String getFormat() {
        return this.format;
    }

    @Nullable
    public String getType() {
        return this.type;
    }

    public String toDateString() {
        return CalendarDateFormatter.toDateString(this.getCalendarDate());
    }

    public String toDateTimeString() {
        return CalendarDateFormatter.toDateTimeStringISO(this.getCalendarDate());
    }

    public String toString() {
        return this.getText();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DateType dateType = (DateType)o;
        return this.isPresent == dateType.isPresent && this.isBlank == dateType.isBlank && Objects.equals(this.text, dateType.text) && Objects.equals(this.format, dateType.format) && Objects.equals(this.type, dateType.type) && Objects.equals(this.date, dateType.date);
    }

    public int hashCode() {
        return Objects.hash(this.text, this.format, this.type, this.isPresent, this.isBlank, this.date);
    }

    public boolean before(DateType d) {
        if (d.isPresent()) {
            return true;
        }
        if (this.isPresent()) {
            return false;
        }
        if (this.date == null) {
            return false;
        }
        if (d.getCalendarDate() == null) {
            return false;
        }
        return this.date.isBefore(d.getCalendarDate());
    }

    public DateType add(TimeDuration d) {
        return this.add(d.getTimeUnit());
    }

    public DateType add(TimeUnit d) {
        CalendarDate useDate = this.getCalendarDate();
        CalendarDate result = useDate.add((int)d.getValueInSeconds(), CalendarPeriod.Field.Second);
        return new DateType(result);
    }

    public DateType subtract(TimeDuration d) {
        return this.subtract(d.getTimeUnit());
    }

    public DateType subtract(TimeUnit d) {
        CalendarDate useDate = this.getCalendarDate();
        CalendarDate result = useDate.add((int)(-d.getValueInSeconds()), CalendarPeriod.Field.Second);
        return new DateType(result);
    }
}

