/*
 * Decompiled with CFR 0.152.
 */
package thredds.client.catalog;

import java.text.ParseException;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import thredds.client.catalog.DateType;
import thredds.client.catalog.TimeDuration;
import ucar.nc2.time.CalendarDate;

@Immutable
public class TimeCoverage {
    private final DateType start;
    private final DateType end;
    private final TimeDuration duration;
    private final TimeDuration resolution;
    private final boolean isEmpty;
    private final boolean isMoving;
    private final boolean useStart;
    private final boolean useEnd;
    private final boolean useDuration;
    private final boolean useResolution;
    private int hashCode;

    public boolean contains(CalendarDate date) {
        if (this.isEmpty) {
            return false;
        }
        DateType datet = new DateType(date);
        if (datet.before(this.getStart())) {
            return false;
        }
        return !this.getEnd().before(datet);
    }

    public boolean intersects(CalendarDate start_want, CalendarDate end_want) {
        if (this.isEmpty) {
            return false;
        }
        DateType endWantT = new DateType(end_want);
        if (endWantT.before(this.getStart())) {
            return false;
        }
        DateType startWantT = new DateType(start_want);
        return !this.getEnd().before(startWantT);
    }

    public boolean intersects(TimeCoverage other) {
        return this.intersects(other.getStart().getCalendarDate(), other.getEnd().getCalendarDate());
    }

    public TimeCoverage intersect(TimeCoverage clip) {
        if (this.isEmpty) {
            return this;
        }
        if (clip.isEmpty) {
            return clip;
        }
        DateType ss = this.getStart();
        DateType s = ss.before(clip.getStart()) ? clip.getStart() : ss;
        DateType ee = this.getEnd();
        DateType e = ee.before(clip.getEnd()) ? ee : clip.getEnd();
        return TimeCoverage.create(s, e, null, this.resolution);
    }

    public TimeCoverage extend(TimeCoverage dr) {
        boolean localEmpty = this.isEmpty;
        DateType start = localEmpty || dr.getStart().before(this.getStart()) ? dr.getStart() : this.getStart();
        DateType end = localEmpty || this.getEnd().before(dr.getEnd()) ? dr.getEnd() : this.getEnd();
        return TimeCoverage.create(start, end, null, this.resolution);
    }

    public TimeCoverage extend(CalendarDate date) {
        DateType extended = new DateType(date);
        DateType start = extended.before(this.getStart()) ? extended : this.getStart();
        DateType end = this.getEnd().before(extended) ? extended : this.getEnd();
        return TimeCoverage.create(start, end, null, this.resolution);
    }

    public DateType getStart() {
        return this.isMoving && !this.useStart ? this.end.subtract(this.duration) : this.start;
    }

    public DateType getEnd() {
        return this.isMoving && !this.useEnd ? this.start.add(this.duration) : this.end;
    }

    public TimeDuration getDuration() {
        if (this.isMoving && !this.useDuration) {
            long min = this.start.getCalendarDate().getMillis();
            long max = this.end.getCalendarDate().getMillis();
            double secs = 0.001 * (double)(max - min);
            if (secs < 0.0) {
                secs = 0.0;
            }
            if (this.resolution == null) {
                return new TimeDuration(this.duration.getTimeUnit().newValueInSeconds(secs));
            }
            double resSecs = this.resolution.getValueInSeconds();
            double closest = Math.round(secs / resSecs);
            secs = closest * resSecs;
            return new TimeDuration(this.duration.getTimeUnit().newValueInSeconds(secs));
        }
        return this.duration;
    }

    public TimeDuration getResolution() {
        return this.resolution;
    }

    public boolean fixedStart() {
        return this.useStart;
    }

    public boolean fixedEnd() {
        return this.useEnd;
    }

    public boolean fixedDuration() {
        return this.useDuration;
    }

    public boolean fixedResolution() {
        return this.useResolution;
    }

    public boolean isPoint() {
        return !this.isEmpty && this.start.equals(this.end);
    }

    public boolean isEmpty() {
        return this.isEmpty;
    }

    public String toString() {
        return "start= " + this.start + " end= " + this.end + " duration= " + this.duration + " resolution= " + this.resolution;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TimeCoverage)) {
            return false;
        }
        TimeCoverage oo = (TimeCoverage)o;
        if (this.useStart && !this.start.equals(oo.start)) {
            return false;
        }
        if (this.useEnd && !this.end.equals(oo.end)) {
            return false;
        }
        if (this.useDuration && !this.duration.equals(oo.duration)) {
            return false;
        }
        return !this.useResolution || this.resolution.equals(oo.resolution);
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int result = 17;
            if (this.useStart) {
                result = 37 * result + this.start.hashCode();
            }
            if (this.useEnd) {
                result = 37 * result + this.end.hashCode();
            }
            if (this.useDuration) {
                result = 37 * result + this.duration.hashCode();
            }
            if (this.useResolution) {
                result = 37 * result + this.resolution.hashCode();
            }
            this.hashCode = result;
        }
        return this.hashCode;
    }

    public static TimeCoverage create(@Nullable DateType start, @Nullable DateType end, @Nullable TimeDuration duration, @Nullable TimeDuration resolution) {
        return new Builder(start, end, duration, resolution).build();
    }

    static Builder builder() {
        return new Builder();
    }

    public static Builder builder(@Nullable DateType start, @Nullable DateType end, @Nullable TimeDuration duration, @Nullable TimeDuration resolution) {
        return new Builder(start, end, duration, resolution);
    }

    private TimeCoverage(Builder builder) {
        this.start = builder.start;
        this.end = builder.end;
        this.duration = builder.duration;
        this.resolution = builder.resolution;
        this.isEmpty = builder.isEmpty;
        this.isMoving = builder.isMoving;
        this.useStart = builder.useStart;
        this.useEnd = builder.useEnd;
        this.useDuration = builder.useDuration;
        this.useResolution = builder.useResolution;
    }

    public static class Builder {
        private DateType start;
        private DateType end;
        private TimeDuration duration;
        private TimeDuration resolution;
        private boolean isEmpty;
        private boolean isMoving;
        private boolean useStart;
        private boolean useEnd;
        private boolean useDuration;
        private boolean useResolution;

        Builder() {
        }

        Builder(@Nullable DateType start, @Nullable DateType end, @Nullable TimeDuration duration, @Nullable TimeDuration resolution) {
            this.start = start;
            this.end = end;
            this.duration = duration;
            this.resolution = resolution;
            this.useStart = start != null && !start.isBlank();
            this.useEnd = end != null && !end.isBlank();
            this.useDuration = duration != null && !duration.isBlank();
            this.useResolution = resolution != null;
            boolean invalid = true;
            if (this.useStart && this.useEnd) {
                invalid = false;
                this.isMoving = this.start.isPresent() || this.end.isPresent();
                this.useDuration = false;
                this.recalcDuration();
            } else if (this.useStart && this.useDuration) {
                invalid = false;
                this.isMoving = this.start.isPresent();
                this.end = this.start.add(duration);
            } else if (this.useEnd && this.useDuration) {
                invalid = false;
                this.isMoving = this.end.isPresent();
                this.start = this.end.subtract(duration);
            }
            if (invalid) {
                throw new IllegalArgumentException("DateRange must have 2 of start, end, duration");
            }
            this.checkIfEmpty();
        }

        private void checkIfEmpty() {
            this.isEmpty = this.start.isPresent() && this.end.isPresent() ? true : (this.start.isPresent() || this.end.isPresent() ? this.duration.getValue() <= 0.0 : this.end.before(this.start));
            if (this.isEmpty) {
                this.duration = new TimeDuration(this.duration.getTimeUnit().newValue(0.0));
            }
        }

        private String chooseResolution(double time) {
            if (time < 180.0) {
                return "secs";
            }
            if ((time /= 60.0) < 180.0) {
                return "minutes";
            }
            if ((time /= 60.0) < 72.0) {
                return "hours";
            }
            if ((time /= 24.0) < 90.0) {
                return "days";
            }
            if ((time /= 30.0) < 36.0) {
                return "months";
            }
            return "years";
        }

        public void setDuration(TimeDuration duration) {
            this.duration = duration;
            this.useDuration = true;
            if (this.useStart) {
                this.isMoving = this.start.isPresent();
                this.end = this.start.add(duration);
                this.useEnd = false;
            } else {
                this.isMoving = this.end.isPresent();
                this.start = this.end.subtract(duration);
            }
            this.checkIfEmpty();
        }

        public void setEnd(DateType end) {
            this.end = end;
            this.useEnd = true;
            if (this.useStart) {
                this.isMoving = this.start.isPresent() || this.end.isPresent();
                this.useDuration = false;
                this.recalcDuration();
            } else {
                this.isMoving = this.end.isPresent();
                this.start = this.end.subtract(this.duration);
            }
            this.checkIfEmpty();
        }

        public void setResolution(TimeDuration resolution) {
            this.resolution = resolution;
            this.useResolution = true;
        }

        public void setStart(DateType start) {
            this.start = start;
            this.useStart = true;
            if (this.useEnd) {
                this.isMoving = this.start.isPresent() || this.end.isPresent();
                this.useDuration = false;
                this.recalcDuration();
            } else {
                this.isMoving = this.start.isPresent();
                this.end = this.start.add(this.duration);
            }
            this.checkIfEmpty();
        }

        private void recalcDuration() {
            long min = this.start.getCalendarDate().getMillis();
            long max = this.end.getCalendarDate().getMillis();
            double secs = 0.001 * (double)(max - min);
            if (secs < 0.0) {
                secs = 0.0;
            }
            if (this.duration == null) {
                try {
                    this.duration = TimeDuration.parse(this.chooseResolution(secs));
                }
                catch (ParseException e) {
                    throw new RuntimeException(e);
                }
            }
            if (this.resolution == null) {
                this.duration = new TimeDuration(this.duration.getTimeUnit().newValueInSeconds(secs));
            } else {
                double resSecs = this.resolution.getValueInSeconds();
                double closest = Math.round(secs / resSecs);
                secs = closest * resSecs;
                this.duration = new TimeDuration(this.duration.getTimeUnit().newValueInSeconds(secs));
            }
        }

        public TimeCoverage build() {
            return new TimeCoverage(this);
        }
    }
}

