/*
 * Decompiled with CFR 0.152.
 */
package thredds.client.catalog;

import java.text.ParseException;
import java.util.Calendar;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.Duration;
import ucar.nc2.units.TimeUnit;
import ucar.units.ConversionException;
import ucar.units.UnitException;

@Immutable
public class TimeDuration {
    private final String text;
    private final TimeUnit timeUnit;
    private final boolean isBlank;

    public static TimeDuration parse(String text) throws ParseException {
        String string = text = text == null ? "" : text.trim();
        if (text.isEmpty()) {
            try {
                TimeUnit timeUnit = new TimeUnit("1 sec");
                return new TimeDuration(text, timeUnit);
            }
            catch (Exception e) {
                throw new ParseException(e.getMessage(), 0);
            }
        }
        try {
            TimeUnit timeUnit = new TimeUnit(text);
            return new TimeDuration(text, timeUnit);
        }
        catch (Exception e) {
            try {
                return TimeDuration.parseW3CDuration(text);
            }
            catch (Exception e1) {
                throw new ParseException(e.getMessage(), 0);
            }
        }
    }

    public static TimeDuration parseW3CDuration(String text) throws ParseException {
        text = text == null ? "" : text.trim();
        try {
            DatatypeFactory factory = DatatypeFactory.newInstance();
            Duration d = factory.newDuration(text);
            Calendar c = Calendar.getInstance();
            c.set(1900, 0, 1, 0, 0, 0);
            long secs = d.getTimeInMillis(c.getTime()) / 1000L;
            TimeUnit timeUnit = new TimeUnit(secs + " secs");
            return new TimeDuration(text, timeUnit);
        }
        catch (Exception e) {
            throw new ParseException(e.getMessage(), 0);
        }
    }

    public TimeDuration(TimeUnit timeUnit) {
        this.timeUnit = timeUnit;
        this.text = timeUnit.toString();
        this.isBlank = false;
    }

    private TimeDuration(String text, TimeUnit timeUnit) {
        this.text = text.trim();
        this.isBlank = this.text.isEmpty();
        this.timeUnit = timeUnit;
    }

    public double getValue() {
        return this.timeUnit.getValue();
    }

    public double getValue(TimeUnit want) {
        try {
            return this.timeUnit.convertTo(this.timeUnit.getValue(), want);
        }
        catch (ConversionException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public double getValue(String unit) {
        try {
            TimeUnit tdayUnit = new TimeUnit(unit);
            return this.getValue(tdayUnit);
        }
        catch (UnitException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public double getValueInSeconds() {
        return this.timeUnit.getValueInSeconds();
    }

    public boolean isBlank() {
        return this.isBlank;
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    public String getText() {
        return this.text;
    }

    public String toString() {
        return this.getText();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TimeDuration that = (TimeDuration)o;
        return this.isBlank == that.isBlank && Objects.equals(this.text, that.text) && Objects.equals(this.timeUnit, that.timeUnit);
    }

    public int hashCode() {
        return Objects.hash(this.text, this.timeUnit, this.isBlank);
    }
}

