/*
 * Decompiled with CFR 0.152.
 */
package thredds.filesystem;

import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Iterator;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.filesystem.MFileOS7;
import thredds.inventory.CollectionConfig;
import thredds.inventory.MController;
import thredds.inventory.MFile;

@ThreadSafe
public class ControllerOS7
implements MController {
    private static final Logger logger = LoggerFactory.getLogger(ControllerOS7.class);

    @Override
    public Iterator<MFile> getInventoryAll(CollectionConfig mc, boolean recheck) {
        return null;
    }

    @Override
    public Iterator<MFile> getInventoryTop(CollectionConfig mc, boolean recheck) throws IOException {
        Path cd;
        String path = mc.getDirectoryName();
        if (path.startsWith("file:")) {
            path = path.substring(5);
        }
        if (!Files.exists(cd = Paths.get(path, new String[0]), new LinkOption[0])) {
            return null;
        }
        return new MFileIterator(cd, new CollectionFilter(mc));
    }

    @Override
    public Iterator<MFile> getSubdirs(CollectionConfig mc, boolean recheck) {
        return null;
    }

    @Override
    public void close() {
    }

    public static class PrintFiles
    extends SimpleFileVisitor<Path> {
        private int countFiles;
        private int countDirs;
        private int countOther;
        private int countSyms;
        long start = System.currentTimeMillis();

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attr) {
            if (attr.isSymbolicLink()) {
                ++this.countSyms;
            } else if (attr.isRegularFile()) {
                ++this.countFiles;
            } else {
                ++this.countOther;
            }
            if (this.countFiles % 10000 == 0) {
                double took = System.currentTimeMillis() - this.start;
                double rate = (double)this.countFiles / took;
                double d = (double)this.countDirs / took;
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
            ++this.countDirs;
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFileFailed(Path file, IOException exc) {
            return FileVisitResult.CONTINUE;
        }

        public String toString() {
            return "PrintFiles{countFiles=" + this.countFiles + ", countDirs=" + this.countDirs + ", countOther=" + this.countOther + ", countSyms=" + this.countSyms + '}';
        }
    }

    private static class MFileIterator
    implements Iterator<MFile> {
        Iterator<Path> dirStream;

        MFileIterator(Path dir, DirectoryStream.Filter<Path> filter) throws IOException {
            this.dirStream = filter != null ? Files.newDirectoryStream(dir, filter).iterator() : Files.newDirectoryStream(dir).iterator();
        }

        @Override
        public boolean hasNext() {
            return this.dirStream.hasNext();
        }

        @Override
        public MFile next() {
            try {
                return new MFileOS7(this.dirStream.next());
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class CollectionFilter
    implements DirectoryStream.Filter<Path> {
        CollectionConfig mc;

        private CollectionFilter(CollectionConfig mc) {
            this.mc = mc;
        }

        @Override
        public boolean accept(Path entry) {
            return !entry.endsWith(".gbx9") && !entry.endsWith(".ncx");
        }
    }
}

