/*
 * Decompiled with CFR 0.152.
 */
package thredds.inventory;

import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Stack;
import org.slf4j.Logger;
import thredds.filesystem.MFileOS7;
import thredds.inventory.CloseableIterator;
import thredds.inventory.CollectionAbstract;
import thredds.inventory.MFile;

public class CollectionGlob
extends CollectionAbstract {
    PathMatcher matcher;
    boolean debug;
    int depth;

    public CollectionGlob(String collectionName, String glob, Logger logger) {
        super(collectionName, logger);
        this.matcher = FileSystems.getDefault().getPathMatcher("glob:" + glob);
        int pos = glob.indexOf("*");
        this.root = glob.substring(0, pos - 1);
        String match = glob.substring(pos);
        pos = glob.indexOf("**");
        if (pos > 0) {
            this.depth = Integer.MAX_VALUE;
        } else {
            for (char c : match.toCharArray()) {
                if (c != '/') continue;
                ++this.depth;
            }
        }
        if (this.debug) {
            System.out.printf(" CollectionGlob.MFileIterator topPath='%s' depth=%d%n", this.root, this.depth);
        }
    }

    @Override
    public void close() {
    }

    @Override
    public Iterable<MFile> getFilesSorted() throws IOException {
        return this.makeFileListSorted();
    }

    @Override
    public CloseableIterator<MFile> getFileIterator() throws IOException {
        return new MyFileIterator(this.root);
    }

    public static DirectoryStream<Path> newDirectoryStream(Path dir, String glob) throws IOException {
        FileSystem fs = dir.getFileSystem();
        PathMatcher matcher = fs.getPathMatcher("glob:" + glob);
        DirectoryStream.Filter<Path> filter = entry -> matcher.matches(entry.getFileName());
        return fs.provider().newDirectoryStream(dir, filter);
    }

    private class MyFileIterator
    implements CloseableIterator<MFile> {
        DirectoryStream<Path> dirStream;
        Iterator<Path> dirStreamIterator;
        MFile nextMFile;
        int count;
        int total;
        Stack<Path> subdirs = new Stack();
        int currDepth;

        MyFileIterator(String topDir) throws IOException {
            Path topPath = Paths.get(topDir, new String[0]);
            this.dirStream = Files.newDirectoryStream(topPath);
            this.dirStreamIterator = this.dirStream.iterator();
        }

        @Override
        public boolean hasNext() {
            try {
                BasicFileAttributes attr;
                Path nextPath;
                while (true) {
                    if (!this.dirStreamIterator.hasNext()) {
                        this.dirStream.close();
                        if (this.subdirs.isEmpty()) {
                            this.nextMFile = null;
                            return false;
                        }
                        ++this.currDepth;
                        Path nextSubdir = this.subdirs.pop();
                        this.dirStream = Files.newDirectoryStream(nextSubdir);
                        this.dirStreamIterator = this.dirStream.iterator();
                        continue;
                    }
                    ++this.total;
                    nextPath = this.dirStreamIterator.next();
                    attr = Files.readAttributes(nextPath, BasicFileAttributes.class, new LinkOption[0]);
                    if (attr.isDirectory()) {
                        if (this.currDepth >= CollectionGlob.this.depth) continue;
                        this.subdirs.push(nextPath);
                        continue;
                    }
                    if (CollectionGlob.this.matcher.matches(nextPath)) break;
                }
                this.nextMFile = new MFileOS7(nextPath, attr);
                return true;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public MFile next() {
            if (this.nextMFile == null) {
                throw new NoSuchElementException();
            }
            ++this.count;
            return this.nextMFile;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void close() {
            if (CollectionGlob.this.debug) {
                System.out.printf("  OK=%d total=%d%n ", this.count, this.total);
            }
            try {
                this.dirStream.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

