/*
 * Decompiled with CFR 0.152.
 */
package thredds.inventory.partition;

import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.slf4j.Logger;
import thredds.featurecollection.FeatureCollectionConfig;
import thredds.inventory.CloseableIterator;
import thredds.inventory.CollectionAbstract;
import thredds.inventory.CollectionUpdateType;
import thredds.inventory.MCollection;
import thredds.inventory.MFile;
import thredds.inventory.MFileIterator;
import thredds.inventory.partition.DirectoryBuilder;
import thredds.inventory.partition.DirectoryCollection;
import thredds.inventory.partition.DirectoryCollectionFromIndex;
import thredds.inventory.partition.IndexReader;
import thredds.inventory.partition.PartitionManager;

public class DirectoryPartition
extends CollectionAbstract
implements PartitionManager {
    private final FeatureCollectionConfig config;
    private final Path collectionDir;
    private final String topCollection;
    private final boolean isTop;
    private final IndexReader indexReader;
    private final String suffix;
    private List<String> removed;

    public DirectoryPartition(FeatureCollectionConfig config, Path collectionDir, boolean isTop, IndexReader indexReader, String suffix, Logger logger) {
        super(null, logger);
        this.config = config;
        this.collectionDir = collectionDir;
        this.isTop = isTop;
        this.indexReader = indexReader;
        this.suffix = suffix;
        this.topCollection = DirectoryPartition.cleanName(config.collectionName);
        this.collectionName = isTop ? this.topCollection : DirectoryCollection.makeCollectionName(this.topCollection, collectionDir);
    }

    @Override
    public String getIndexFilename(String suffix) {
        if (this.isTop) {
            return super.getIndexFilename(suffix);
        }
        Path indexPath = DirectoryCollection.makeCollectionIndexPath(this.topCollection, this.collectionDir, suffix);
        return indexPath.toString();
    }

    @Override
    public Iterable<MCollection> makePartitions(CollectionUpdateType forceCollection) throws IOException {
        if (forceCollection == null) {
            forceCollection = CollectionUpdateType.test;
        }
        DirectoryBuilder builder = new DirectoryBuilder(this.topCollection, this.collectionDir, null, this.suffix);
        builder.constructChildren(this.indexReader, forceCollection);
        ArrayList<MCollection> result = new ArrayList<MCollection>();
        for (DirectoryBuilder child : builder.getChildren()) {
            MCollection dc = null;
            try {
                dc = DirectoryBuilder.factory(this.config, child.getDir(), false, this.indexReader, this.suffix, this.logger);
                if (!this.wasRemoved(dc)) {
                    result.add(dc);
                }
                this.lastModified = Math.max(this.lastModified, dc.getLastModified());
            }
            catch (Throwable ioe) {
                this.logger.warn("DirectoryBuilder on " + child.getDir() + " failed: skipping", ioe);
                if (dc == null) continue;
                dc.close();
            }
        }
        result.sort(Comparator.comparing(MCollection::getCollectionName));
        return result;
    }

    MCollection makeChildCollection(DirectoryBuilder dpb) throws IOException {
        boolean hasIndex = dpb.findIndex();
        CollectionAbstract result = hasIndex ? new DirectoryCollectionFromIndex(dpb, this.dateExtractor, this.indexReader, this.logger) : new DirectoryCollection(this.topCollection, dpb.getDir(), false, this.config.olderThan, this.logger);
        return result;
    }

    @Override
    public String getRoot() {
        return this.collectionDir.toString();
    }

    @Override
    public Iterable<MFile> getFilesSorted() {
        return new ArrayList<MFile>();
    }

    @Override
    public CloseableIterator<MFile> getFileIterator() {
        return new MFileIterator(this.getFilesSorted().iterator(), null);
    }

    @Override
    public void close() {
    }

    @Override
    public void removePartition(MCollection partition) {
        if (this.removed == null) {
            this.removed = new ArrayList<String>();
        }
        this.removed.add(partition.getCollectionName());
    }

    private boolean wasRemoved(MCollection partition) {
        return this.removed != null && this.removed.contains(partition.getCollectionName());
    }
}

