/*
 * Decompiled with CFR 0.152.
 */
package ucar.array;

import com.google.common.base.Objects;
import java.util.Iterator;
import javax.annotation.concurrent.Immutable;
import ucar.array.ArrayType;
import ucar.array.Index;
import ucar.array.IndexFn;
import ucar.array.Section;
import ucar.array.Storage;

@Immutable
public abstract class Array<T>
implements Iterable<T> {
    final ArrayType arrayType;
    final IndexFn indexFn;
    final int rank;

    @Override
    public abstract Iterator<T> iterator();

    abstract Iterator<T> fastIterator();

    public abstract T get(int ... var1);

    public abstract T get(Index var1);

    public T getScalar() {
        return this.get(this.getIndex());
    }

    public ArrayType getArrayType() {
        return this.arrayType;
    }

    public boolean isVlen() {
        return false;
    }

    public Index getIndex() {
        return new Index(new int[this.rank], this.indexFn);
    }

    public int getRank() {
        return this.rank;
    }

    public int[] getShape() {
        return this.indexFn.getShape();
    }

    public Section getSection() {
        return this.indexFn.getSection();
    }

    public long length() {
        return this.indexFn.length();
    }

    public String show() {
        StringBuilder sbuff = new StringBuilder();
        boolean first = true;
        for (T value : this) {
            if (!first) {
                sbuff.append(", ");
            }
            sbuff.append(value);
            first = false;
        }
        return sbuff.toString();
    }

    public String toString() {
        return "Array{arrayType=" + (Object)((Object)this.arrayType) + ", indexFn=" + this.indexFn + ", rank=" + this.rank + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Array)) {
            return false;
        }
        Array array = (Array)o;
        return this.getRank() == array.getRank() && this.getArrayType() == array.getArrayType() && Objects.equal((Object)this.indexFn, (Object)array.indexFn);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.getArrayType(), this.indexFn, this.getRank()});
    }

    Array(ArrayType arrayType, int[] shape) {
        this.arrayType = arrayType;
        this.rank = shape.length;
        this.indexFn = IndexFn.builder(shape).build();
    }

    Array(ArrayType arrayType, IndexFn indexFn) {
        this.arrayType = arrayType;
        this.rank = indexFn.getRank();
        this.indexFn = indexFn;
    }

    abstract void arraycopy(int var1, Object var2, int var3, long var4);

    abstract Storage<T> storage();

    IndexFn indexFn() {
        return this.indexFn;
    }

    abstract Array<T> createView(IndexFn var1);
}

