/*
 * Decompiled with CFR 0.152.
 */
package ucar.array;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.protobuf.ByteString;
import java.nio.ByteBuffer;
import java.util.Iterator;
import javax.annotation.concurrent.Immutable;
import ucar.array.Array;
import ucar.array.ArrayType;
import ucar.array.Arrays;
import ucar.array.Index;
import ucar.array.IndexFn;
import ucar.array.Storage;

@Immutable
final class ArrayByte
extends Array<Byte> {
    private final Storage<Byte> storage;

    ArrayByte(ArrayType dtype, int[] shape) {
        super(dtype, shape);
        this.storage = new StorageS(new byte[(byte)this.indexFn.length()]);
    }

    ArrayByte(ArrayType dtype, int[] shape, Storage<Byte> storage) {
        super(dtype, shape);
        Preconditions.checkArgument((this.indexFn.length() <= storage.length() ? 1 : 0) != 0);
        this.storage = storage;
    }

    private ArrayByte(ArrayType dtype, IndexFn indexFn, Storage<Byte> storageD) {
        super(dtype, indexFn);
        Preconditions.checkArgument((indexFn.length() <= storageD.length() ? 1 : 0) != 0);
        this.storage = storageD;
    }

    @Override
    Iterator<Byte> fastIterator() {
        return this.storage.iterator();
    }

    @Override
    public Iterator<Byte> iterator() {
        return this.indexFn.isCanonicalOrder() ? this.fastIterator() : new CanonicalIterator();
    }

    @Override
    public Byte get(int ... index) {
        return this.storage.get(this.indexFn.get(index));
    }

    @Override
    public Byte get(Index index) {
        return this.get(index.getCurrentIndex());
    }

    @Override
    void arraycopy(int srcPos, Object dest, int destPos, long length) {
        if (this.indexFn.isCanonicalOrder()) {
            this.storage.arraycopy(srcPos, dest, destPos, length);
        } else {
            byte[] ddest = (byte[])dest;
            int destIndex = destPos;
            Iterator<Integer> iter = this.indexFn.iterator(srcPos, length);
            while (iter.hasNext()) {
                ddest[destIndex++] = this.storage.get(iter.next().intValue());
            }
        }
    }

    ByteString getByteString() {
        if (this.indexFn.isCanonicalOrder()) {
            return ByteString.copyFrom((byte[])((StorageS)this.storage).storage);
        }
        byte[] raw = new byte[(int)this.length()];
        int idx = 0;
        for (byte bval : this) {
            raw[idx++] = bval;
        }
        return ByteString.copyFrom((byte[])raw);
    }

    ByteBuffer getByteBuffer() {
        if (this.indexFn.isCanonicalOrder()) {
            return ByteBuffer.wrap(((StorageS)this.storage).storage);
        }
        ByteBuffer result = ByteBuffer.allocate((int)this.length());
        for (byte bval : this) {
            result.put(bval);
        }
        return result;
    }

    String makeStringFromChar() {
        byte c;
        byte c2;
        Preconditions.checkArgument((this.getRank() < 2 ? 1 : 0) != 0);
        int count = 0;
        Iterator<Byte> iterator = this.iterator();
        while (iterator.hasNext() && (c2 = iterator.next().byteValue()) != 0) {
            ++count;
        }
        byte[] carr = new byte[count];
        int idx = 0;
        Iterator<Byte> iterator2 = this.iterator();
        while (iterator2.hasNext() && (c = iterator2.next().byteValue()) != 0) {
            carr[idx++] = c;
        }
        return new String(carr, Charsets.UTF_8);
    }

    Array<String> makeStringsFromChar() {
        if (this.getRank() < 2) {
            return Arrays.factory(ArrayType.STRING, new int[]{1}, new String[]{this.makeStringFromChar()});
        }
        int innerLength = this.indexFn.getShape(this.rank - 1);
        int outerLength = (int)this.length() / innerLength;
        int[] outerShape = new int[this.rank - 1];
        System.arraycopy(this.getShape(), 0, outerShape, 0, this.rank - 1);
        String[] result = new String[outerLength];
        byte[] carr = new byte[innerLength];
        int cidx = 0;
        int sidx = 0;
        Index index = this.getIndex();
        while (sidx < outerLength) {
            int idx = sidx * innerLength + cidx;
            byte c = this.get(index.setElem(idx));
            if (c == 0) {
                result[sidx++] = new String(carr, 0, cidx, Charsets.UTF_8);
                cidx = 0;
                continue;
            }
            carr[cidx++] = c;
            if (cidx != innerLength) continue;
            result[sidx++] = new String(carr, Charsets.UTF_8);
            cidx = 0;
        }
        return Arrays.factory(ArrayType.STRING, outerShape, result);
    }

    @Override
    Storage<Byte> storage() {
        return this.storage;
    }

    protected ArrayByte createView(IndexFn view) {
        return new ArrayByte(this.arrayType, view, this.storage);
    }

    @Immutable
    static final class StorageS
    implements Storage<Byte> {
        private final byte[] storage;

        StorageS(byte[] storage) {
            this.storage = storage;
        }

        @Override
        public long length() {
            return this.storage.length;
        }

        @Override
        public Byte get(long elem) {
            return this.storage[(int)elem];
        }

        @Override
        public void arraycopy(int srcPos, Object dest, int destPos, long length) {
            System.arraycopy(this.storage, srcPos, dest, destPos, (int)length);
        }

        @Override
        public Iterator<Byte> iterator() {
            return new StorageIter();
        }

        private final class StorageIter
        implements Iterator<Byte> {
            private int count = 0;

            private StorageIter() {
            }

            @Override
            public final boolean hasNext() {
                return this.count < StorageS.this.storage.length;
            }

            @Override
            public final Byte next() {
                return StorageS.this.storage[this.count++];
            }
        }
    }

    private class CanonicalIterator
    implements Iterator<Byte> {
        private final Iterator<Integer> iter;

        private CanonicalIterator() {
            this.iter = ArrayByte.this.indexFn.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public Byte next() {
            return (Byte)ArrayByte.this.storage.get(this.iter.next().intValue());
        }
    }
}

