/*
 * Decompiled with CFR 0.152.
 */
package ucar.array;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.annotation.concurrent.Immutable;
import ucar.array.Array;
import ucar.array.ArrayType;
import ucar.array.Index;
import ucar.array.IndexFn;
import ucar.array.Storage;

@Immutable
final class ArrayDouble
extends Array<Double> {
    private final Storage<Double> storageD;

    ArrayDouble(int[] shape) {
        super(ArrayType.DOUBLE, shape);
        this.storageD = new StorageD(new double[(int)this.indexFn.length()]);
    }

    ArrayDouble(int[] shape, Storage<Double> storageD) {
        super(ArrayType.DOUBLE, shape);
        Preconditions.checkArgument((this.indexFn.length() <= storageD.length() ? 1 : 0) != 0);
        this.storageD = storageD;
    }

    private ArrayDouble(IndexFn indexFn, Storage<Double> storageD) {
        super(ArrayType.DOUBLE, indexFn);
        Preconditions.checkArgument((indexFn.length() <= storageD.length() ? 1 : 0) != 0);
        this.storageD = storageD;
    }

    @Override
    Iterator<Double> fastIterator() {
        return this.storageD.iterator();
    }

    @Override
    public Iterator<Double> iterator() {
        return this.indexFn.isCanonicalOrder() ? this.fastIterator() : new CanonicalIterator();
    }

    @Override
    public Double get(int ... index) {
        return this.storageD.get(this.indexFn.get(index));
    }

    @Override
    public Double get(Index index) {
        return this.get(index.getCurrentIndex());
    }

    @Override
    void arraycopy(int srcPos, Object dest, int destPos, long length) {
        if (this.indexFn.isCanonicalOrder()) {
            this.storageD.arraycopy(srcPos, dest, destPos, length);
        } else {
            double[] ddest = (double[])dest;
            int destIndex = destPos;
            Iterator<Integer> iter = this.indexFn.iterator(srcPos, length);
            while (iter.hasNext()) {
                ddest[destIndex++] = this.storageD.get(iter.next().intValue());
            }
        }
    }

    @Override
    Storage<Double> storage() {
        return this.storageD;
    }

    protected ArrayDouble createView(IndexFn view) {
        return new ArrayDouble(view, this.storageD);
    }

    @Immutable
    static class StorageDM
    implements Storage<Double> {
        private final ImmutableList<Storage<Double>> dataArrays;
        private final long[] arrayEdge;
        private final long totalLength;

        StorageDM(List<Array<?>> dataArrays) {
            ImmutableList.Builder builder = ImmutableList.builder();
            ArrayList<Long> edge = new ArrayList<Long>();
            edge.add(0L);
            long total = 0L;
            for (Array<?> dataArray : dataArrays) {
                builder.add(dataArray.storage());
                edge.add(total += dataArray.length());
            }
            this.dataArrays = builder.build();
            this.arrayEdge = edge.stream().mapToLong(i -> i).toArray();
            this.totalLength = total;
        }

        @Override
        public long length() {
            return this.totalLength;
        }

        @Override
        public Double get(long elem) {
            int search = Arrays.binarySearch(this.arrayEdge, elem);
            int arrayIndex = search < 0 ? -search - 2 : search;
            Storage array = (Storage)this.dataArrays.get(arrayIndex);
            return (Double)array.get((int)(elem - this.arrayEdge[arrayIndex]));
        }

        @Override
        public void arraycopy(int srcPos, Object dest, int destPos, long length) {
            long needed = length;
            int startDst = destPos;
            int search = Arrays.binarySearch(this.arrayEdge, (long)srcPos);
            int startIndex = search < 0 ? -search - 2 : search;
            int startSrc = (int)((long)srcPos - this.arrayEdge[startIndex]);
            for (int index = startIndex; index < this.dataArrays.size(); ++index) {
                Storage storage = (Storage)this.dataArrays.get(index);
                int have = (int)Math.min(storage.length() - (long)startSrc, needed);
                storage.arraycopy(startSrc, dest, startDst, have);
                needed -= (long)have;
                startDst += have;
                startSrc = 0;
            }
        }

        @Override
        public Iterator<Double> iterator() {
            return new StorageDMIter();
        }

        private final class StorageDMIter
        implements Iterator<Double> {
            private int count = 0;
            private int arrayIndex = 0;
            private Storage<Double> array = (Storage)StorageDM.access$500(StorageDM.this).get(0);

            private StorageDMIter() {
            }

            @Override
            public final boolean hasNext() {
                return (long)this.count < StorageDM.this.totalLength;
            }

            @Override
            public final Double next() {
                if ((long)this.count >= StorageDM.this.arrayEdge[this.arrayIndex + 1]) {
                    ++this.arrayIndex;
                    this.array = (Storage)StorageDM.this.dataArrays.get(this.arrayIndex);
                }
                double val = this.array.get((int)((long)this.count - StorageDM.this.arrayEdge[this.arrayIndex]));
                ++this.count;
                return val;
            }
        }
    }

    @Immutable
    static final class StorageD
    implements Storage<Double> {
        private final double[] storage;

        StorageD(double[] storage) {
            this.storage = storage;
        }

        @Override
        public long length() {
            return this.storage.length;
        }

        @Override
        public Double get(long elem) {
            return this.storage[(int)elem];
        }

        @Override
        public void arraycopy(int srcPos, Object dest, int destPos, long length) {
            System.arraycopy(this.storage, srcPos, dest, destPos, (int)length);
        }

        @Override
        public Iterator<Double> iterator() {
            return new StorageDIter();
        }

        private final class StorageDIter
        implements Iterator<Double> {
            private int count = 0;

            private StorageDIter() {
            }

            @Override
            public final boolean hasNext() {
                return this.count < StorageD.this.storage.length;
            }

            @Override
            public final Double next() {
                return StorageD.this.storage[this.count++];
            }
        }
    }

    private class CanonicalIterator
    implements Iterator<Double> {
        private final Iterator<Integer> iter;

        private CanonicalIterator() {
            this.iter = ArrayDouble.this.indexFn.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public Double next() {
            return (Double)ArrayDouble.this.storageD.get(this.iter.next().intValue());
        }
    }
}

