/*
 * Decompiled with CFR 0.152.
 */
package ucar.array;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.annotation.concurrent.Immutable;
import ucar.array.Array;
import ucar.array.ArrayType;
import ucar.array.Index;
import ucar.array.IndexFn;
import ucar.array.Storage;

@Immutable
final class ArrayFloat
extends Array<Float> {
    private final Storage<Float> storageF;

    ArrayFloat(int[] shape) {
        super(ArrayType.FLOAT, shape);
        this.storageF = new StorageF(new float[(int)this.indexFn.length()]);
    }

    ArrayFloat(int[] shape, Storage<Float> storageF) {
        super(ArrayType.FLOAT, shape);
        Preconditions.checkArgument((this.indexFn.length() <= storageF.length() ? 1 : 0) != 0);
        this.storageF = storageF;
    }

    private ArrayFloat(IndexFn indexFn, Storage<Float> storageF) {
        super(ArrayType.FLOAT, indexFn);
        Preconditions.checkArgument((indexFn.length() <= storageF.length() ? 1 : 0) != 0);
        this.storageF = storageF;
    }

    @Override
    Iterator<Float> fastIterator() {
        return this.storageF.iterator();
    }

    @Override
    public Iterator<Float> iterator() {
        return this.indexFn.isCanonicalOrder() ? this.fastIterator() : new CanonicalIterator();
    }

    @Override
    public Float get(int ... index) {
        return this.storageF.get(this.indexFn.get(index));
    }

    @Override
    public Float get(Index index) {
        return this.get(index.getCurrentIndex());
    }

    @Override
    void arraycopy(int srcPos, Object dest, int destPos, long length) {
        if (this.indexFn.isCanonicalOrder()) {
            this.storageF.arraycopy(srcPos, dest, destPos, length);
        } else {
            float[] ddest = (float[])dest;
            int destIndex = destPos;
            Iterator<Integer> iter = this.indexFn.iterator(srcPos, length);
            while (iter.hasNext()) {
                ddest[destIndex++] = this.storageF.get(iter.next().intValue()).floatValue();
            }
        }
    }

    @Override
    Storage<Float> storage() {
        return this.storageF;
    }

    protected ArrayFloat createView(IndexFn view) {
        return new ArrayFloat(view, this.storageF);
    }

    @Immutable
    static class StorageFM
    implements Storage<Float> {
        private final ImmutableList<Storage<Float>> dataArrays;
        private final long[] arrayEdge;
        private final long totalLength;

        StorageFM(List<Array<?>> dataArrays) {
            ImmutableList.Builder builder = ImmutableList.builder();
            ArrayList<Long> edge = new ArrayList<Long>();
            edge.add(0L);
            long total = 0L;
            for (Array<?> dataArray : dataArrays) {
                builder.add(dataArray.storage());
                edge.add(total += dataArray.length());
            }
            this.dataArrays = builder.build();
            this.arrayEdge = edge.stream().mapToLong(i -> i).toArray();
            this.totalLength = total;
        }

        @Override
        public long length() {
            return this.totalLength;
        }

        @Override
        public Float get(long elem) {
            int search = Arrays.binarySearch(this.arrayEdge, elem);
            int arrayIndex = search < 0 ? -search - 2 : search;
            Storage storage = (Storage)this.dataArrays.get(arrayIndex);
            return (Float)storage.get((int)(elem - this.arrayEdge[arrayIndex]));
        }

        @Override
        public void arraycopy(int srcPos, Object dest, int destPos, long length) {
            long needed = length;
            int startDst = destPos;
            int search = Arrays.binarySearch(this.arrayEdge, (long)srcPos);
            int startIndex = search < 0 ? -search - 2 : search;
            int startSrc = (int)((long)srcPos - this.arrayEdge[startIndex]);
            for (int index = startIndex; index < this.dataArrays.size(); ++index) {
                Storage storage = (Storage)this.dataArrays.get(index);
                int have = (int)Math.min(storage.length() - (long)startSrc, needed);
                storage.arraycopy(startSrc, dest, startDst, have);
                needed -= (long)have;
                startDst += have;
                startSrc = 0;
            }
        }

        @Override
        public Iterator<Float> iterator() {
            return new StorageFMIter();
        }

        final class StorageFMIter
        implements Iterator<Float> {
            private int count = 0;
            private int arrayIndex = 0;
            Storage<Float> storage = (Storage)StorageFM.access$400(StorageFM.this).get(0);

            StorageFMIter() {
            }

            @Override
            public final boolean hasNext() {
                return (long)this.count < StorageFM.this.totalLength;
            }

            @Override
            public final Float next() {
                if ((long)this.count >= StorageFM.this.arrayEdge[this.arrayIndex + 1]) {
                    ++this.arrayIndex;
                    this.storage = (Storage)StorageFM.this.dataArrays.get(this.arrayIndex);
                }
                float val = this.storage.get((int)((long)this.count - StorageFM.this.arrayEdge[this.arrayIndex])).floatValue();
                ++this.count;
                return Float.valueOf(val);
            }
        }
    }

    @Immutable
    static final class StorageF
    implements Storage<Float> {
        private final float[] storage;

        StorageF(float[] storage) {
            this.storage = storage;
        }

        @Override
        public long length() {
            return this.storage.length;
        }

        @Override
        public Float get(long elem) {
            return Float.valueOf(this.storage[(int)elem]);
        }

        @Override
        public void arraycopy(int srcPos, Object dest, int destPos, long length) {
            System.arraycopy(this.storage, srcPos, dest, destPos, (int)length);
        }

        @Override
        public Iterator<Float> iterator() {
            return new StorageFIter();
        }

        private final class StorageFIter
        implements Iterator<Float> {
            private int count = 0;

            private StorageFIter() {
            }

            @Override
            public final boolean hasNext() {
                return this.count < StorageF.this.storage.length;
            }

            @Override
            public final Float next() {
                return Float.valueOf(StorageF.this.storage[this.count++]);
            }
        }
    }

    private class CanonicalIterator
    implements Iterator<Float> {
        private final Iterator<Integer> iter;

        private CanonicalIterator() {
            this.iter = ArrayFloat.this.indexFn.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public Float next() {
            return (Float)ArrayFloat.this.storageF.get(this.iter.next().intValue());
        }
    }
}

