/*
 * Decompiled with CFR 0.152.
 */
package ucar.array;

import com.google.common.base.Preconditions;
import java.util.Iterator;
import javax.annotation.concurrent.Immutable;
import ucar.array.Array;
import ucar.array.ArrayType;
import ucar.array.Index;
import ucar.array.IndexFn;
import ucar.array.Storage;

@Immutable
class ArrayInteger
extends Array<Integer> {
    private final Storage<Integer> storage;

    ArrayInteger(ArrayType dtype, int[] shape) {
        super(dtype, shape);
        this.storage = new StorageS(new int[(int)this.indexFn.length()]);
    }

    ArrayInteger(ArrayType dtype, int[] shape, Storage<Integer> storage) {
        super(dtype, shape);
        if (this.indexFn.length() > storage.length()) {
            throw new IllegalArgumentException(String.format("shape %d > storage %d", this.indexFn.length(), storage.length()));
        }
        this.storage = storage;
    }

    private ArrayInteger(ArrayType dtype, IndexFn indexFn, Storage<Integer> storageD) {
        super(dtype, indexFn);
        Preconditions.checkArgument((indexFn.length() <= storageD.length() ? 1 : 0) != 0);
        this.storage = storageD;
    }

    @Override
    Iterator<Integer> fastIterator() {
        return this.storage.iterator();
    }

    @Override
    public Iterator<Integer> iterator() {
        return this.indexFn.isCanonicalOrder() ? this.fastIterator() : new CanonicalIterator();
    }

    @Override
    public Integer get(int ... index) {
        return this.storage.get(this.indexFn.get(index));
    }

    @Override
    public Integer get(Index index) {
        return this.get(index.getCurrentIndex());
    }

    @Override
    void arraycopy(int srcPos, Object dest, int destPos, long length) {
        if (this.indexFn.isCanonicalOrder()) {
            this.storage.arraycopy(srcPos, dest, destPos, length);
        } else {
            int[] ddest = (int[])dest;
            int destIndex = destPos;
            Iterator<Integer> iter = this.indexFn.iterator(srcPos, length);
            while (iter.hasNext()) {
                ddest[destIndex++] = this.storage.get(iter.next().intValue());
            }
        }
    }

    @Override
    Storage<Integer> storage() {
        return this.storage;
    }

    protected ArrayInteger createView(IndexFn view) {
        return new ArrayInteger(this.arrayType, view, this.storage);
    }

    @Immutable
    static final class StorageS
    implements Storage<Integer> {
        private final int[] storage;

        StorageS(int[] storage) {
            this.storage = storage;
        }

        @Override
        public long length() {
            return this.storage.length;
        }

        @Override
        public Integer get(long elem) {
            return this.storage[(int)elem];
        }

        @Override
        public void arraycopy(int srcPos, Object dest, int destPos, long length) {
            System.arraycopy(this.storage, srcPos, dest, destPos, (int)length);
        }

        @Override
        public Iterator<Integer> iterator() {
            return new StorageIter();
        }

        private final class StorageIter
        implements Iterator<Integer> {
            private int count = 0;

            private StorageIter() {
            }

            @Override
            public final boolean hasNext() {
                return this.count < StorageS.this.storage.length;
            }

            @Override
            public final Integer next() {
                return StorageS.this.storage[this.count++];
            }
        }
    }

    private class CanonicalIterator
    implements Iterator<Integer> {
        private final Iterator<Integer> iter;

        private CanonicalIterator() {
            this.iter = ArrayInteger.this.indexFn.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public Integer next() {
            return (Integer)ArrayInteger.this.storage.get(this.iter.next().intValue());
        }
    }
}

