/*
 * Decompiled with CFR 0.152.
 */
package ucar.array;

import com.google.common.base.Preconditions;
import java.util.Iterator;
import javax.annotation.concurrent.Immutable;
import ucar.array.Array;
import ucar.array.ArrayType;
import ucar.array.Index;
import ucar.array.IndexFn;
import ucar.array.Storage;

@Immutable
final class ArrayLong
extends Array<Long> {
    private final Storage<Long> storage;

    ArrayLong(ArrayType dtype, int[] shape) {
        super(dtype, shape);
        this.storage = new StorageS(new long[(int)this.indexFn.length()]);
    }

    ArrayLong(ArrayType dtype, int[] shape, Storage<Long> storage) {
        super(dtype, shape);
        Preconditions.checkArgument((this.indexFn.length() <= storage.length() ? 1 : 0) != 0);
        this.storage = storage;
    }

    private ArrayLong(ArrayType dtype, IndexFn indexFn, Storage<Long> storageD) {
        super(dtype, indexFn);
        Preconditions.checkArgument((indexFn.length() <= storageD.length() ? 1 : 0) != 0);
        this.storage = storageD;
    }

    @Override
    Iterator<Long> fastIterator() {
        return this.storage.iterator();
    }

    @Override
    public Iterator<Long> iterator() {
        return this.indexFn.isCanonicalOrder() ? this.fastIterator() : new CanonicalIterator();
    }

    @Override
    public Long get(int ... index) {
        return this.storage.get(this.indexFn.get(index));
    }

    @Override
    public Long get(Index index) {
        return this.get(index.getCurrentIndex());
    }

    @Override
    void arraycopy(int srcPos, Object dest, int destPos, long length) {
        if (this.indexFn.isCanonicalOrder()) {
            this.storage.arraycopy(srcPos, dest, destPos, length);
        } else {
            long[] ddest = (long[])dest;
            int destIndex = destPos;
            Iterator<Integer> iter = this.indexFn.iterator(srcPos, length);
            while (iter.hasNext()) {
                ddest[destIndex++] = this.storage.get(iter.next().intValue());
            }
        }
    }

    @Override
    Storage<Long> storage() {
        return this.storage;
    }

    protected ArrayLong createView(IndexFn view) {
        return new ArrayLong(this.arrayType, view, this.storage);
    }

    @Immutable
    static final class StorageS
    implements Storage<Long> {
        private final long[] storage;

        StorageS(long[] storage) {
            this.storage = storage;
        }

        @Override
        public long length() {
            return this.storage.length;
        }

        @Override
        public Long get(long elem) {
            return this.storage[(int)elem];
        }

        @Override
        public void arraycopy(int srcPos, Object dest, int destPos, long length) {
            System.arraycopy(this.storage, srcPos, dest, destPos, (int)length);
        }

        @Override
        public Iterator<Long> iterator() {
            return new StorageIter();
        }

        private final class StorageIter
        implements Iterator<Long> {
            private int count = 0;

            private StorageIter() {
            }

            @Override
            public final boolean hasNext() {
                return this.count < StorageS.this.storage.length;
            }

            @Override
            public final Long next() {
                return StorageS.this.storage[this.count++];
            }
        }
    }

    private class CanonicalIterator
    implements Iterator<Long> {
        private final Iterator<Integer> iter;

        private CanonicalIterator() {
            this.iter = ArrayLong.this.indexFn.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public Long next() {
            return (Long)ArrayLong.this.storage.get(this.iter.next().intValue());
        }
    }
}

