/*
 * Decompiled with CFR 0.152.
 */
package ucar.array;

import com.google.common.base.Preconditions;
import java.util.Iterator;
import javax.annotation.concurrent.Immutable;
import ucar.array.Array;
import ucar.array.ArrayType;
import ucar.array.Index;
import ucar.array.IndexFn;
import ucar.array.Storage;

@Immutable
final class ArrayShort
extends Array<Short> {
    private final Storage<Short> storage;

    ArrayShort(ArrayType dtype, int[] shape) {
        super(dtype, shape);
        this.storage = new StorageS(new short[(int)this.indexFn.length()]);
    }

    ArrayShort(ArrayType dtype, int[] shape, Storage<Short> storage) {
        super(dtype, shape);
        Preconditions.checkArgument((this.indexFn.length() <= storage.length() ? 1 : 0) != 0);
        this.storage = storage;
    }

    private ArrayShort(ArrayType dtype, IndexFn indexFn, Storage<Short> storageD) {
        super(dtype, indexFn);
        Preconditions.checkArgument((indexFn.length() <= storageD.length() ? 1 : 0) != 0);
        this.storage = storageD;
    }

    @Override
    Iterator<Short> fastIterator() {
        return this.storage.iterator();
    }

    @Override
    public Iterator<Short> iterator() {
        return this.indexFn.isCanonicalOrder() ? this.fastIterator() : new CanonicalIterator();
    }

    @Override
    public Short get(int ... index) {
        return this.storage.get(this.indexFn.get(index));
    }

    @Override
    public Short get(Index index) {
        return this.get(index.getCurrentIndex());
    }

    @Override
    void arraycopy(int srcPos, Object dest, int destPos, long length) {
        if (this.indexFn.isCanonicalOrder()) {
            this.storage.arraycopy(srcPos, dest, destPos, length);
        } else {
            short[] ddest = (short[])dest;
            int destIndex = destPos;
            Iterator<Integer> iter = this.indexFn.iterator(srcPos, length);
            while (iter.hasNext()) {
                ddest[destIndex++] = this.storage.get(iter.next().intValue());
            }
        }
    }

    @Override
    Storage<Short> storage() {
        return this.storage;
    }

    protected ArrayShort createView(IndexFn view) {
        return new ArrayShort(this.arrayType, view, this.storage);
    }

    @Immutable
    static class StorageS
    implements Storage<Short> {
        private final short[] storage;

        StorageS(short[] storage) {
            this.storage = storage;
        }

        @Override
        public long length() {
            return this.storage.length;
        }

        @Override
        public Short get(long elem) {
            return this.storage[(int)elem];
        }

        @Override
        public void arraycopy(int srcPos, Object dest, int destPos, long length) {
            System.arraycopy(this.storage, srcPos, dest, destPos, (int)length);
        }

        @Override
        public Iterator<Short> iterator() {
            return new StorageIter();
        }

        private final class StorageIter
        implements Iterator<Short> {
            private int count = 0;

            private StorageIter() {
            }

            @Override
            public final boolean hasNext() {
                return this.count < StorageS.this.storage.length;
            }

            @Override
            public final Short next() {
                return StorageS.this.storage[this.count++];
            }
        }
    }

    private class CanonicalIterator
    implements Iterator<Short> {
        private final Iterator<Integer> iter;

        private CanonicalIterator() {
            this.iter = ArrayShort.this.indexFn.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public Short next() {
            return (Short)ArrayShort.this.storage.get(this.iter.next().intValue());
        }
    }
}

