/*
 * Decompiled with CFR 0.152.
 */
package ucar.array;

import com.google.common.base.Preconditions;
import java.util.Iterator;
import javax.annotation.concurrent.Immutable;
import ucar.array.Array;
import ucar.array.ArrayType;
import ucar.array.Index;
import ucar.array.IndexFn;
import ucar.array.Storage;

@Immutable
final class ArrayString
extends Array<String> {
    private final Storage<String> storage;

    ArrayString(int[] shape) {
        super(ArrayType.STRING, shape);
        this.storage = new StorageS(new String[(int)this.indexFn.length()]);
    }

    ArrayString(int[] shape, Storage<String> storage) {
        super(ArrayType.STRING, shape);
        Preconditions.checkArgument((this.indexFn.length() <= storage.length() ? 1 : 0) != 0);
        this.storage = storage;
    }

    private ArrayString(IndexFn indexFn, Storage<String> storageD) {
        super(ArrayType.STRING, indexFn);
        Preconditions.checkArgument((indexFn.length() <= storageD.length() ? 1 : 0) != 0);
        this.storage = storageD;
    }

    @Override
    Iterator<String> fastIterator() {
        return this.storage.iterator();
    }

    @Override
    public Iterator<String> iterator() {
        return this.indexFn.isCanonicalOrder() ? this.fastIterator() : new CanonicalIterator();
    }

    @Override
    public String get(int ... index) {
        return this.storage.get(this.indexFn.get(index));
    }

    @Override
    public String get(Index index) {
        return this.get(index.getCurrentIndex());
    }

    @Override
    void arraycopy(int srcPos, Object dest, int destPos, long length) {
        if (this.indexFn.isCanonicalOrder()) {
            this.storage.arraycopy(srcPos, dest, destPos, length);
        } else {
            String[] ddest = (String[])dest;
            int destIndex = destPos;
            Iterator<Integer> iter = this.indexFn.iterator(srcPos, length);
            while (iter.hasNext()) {
                ddest[destIndex++] = this.storage.get(iter.next().intValue());
            }
        }
    }

    @Override
    Storage<String> storage() {
        return this.storage;
    }

    protected ArrayString createView(IndexFn view) {
        return new ArrayString(view, this.storage);
    }

    @Immutable
    static final class StorageS
    implements Storage<String> {
        private final String[] storage;

        StorageS(String[] storage) {
            this.storage = storage;
        }

        @Override
        public long length() {
            return this.storage.length;
        }

        @Override
        public String get(long elem) {
            return this.storage[(int)elem];
        }

        @Override
        public void arraycopy(int srcPos, Object dest, int destPos, long length) {
            System.arraycopy(this.storage, srcPos, dest, destPos, (int)length);
        }

        @Override
        public Iterator<String> iterator() {
            return new StorageIter();
        }

        private final class StorageIter
        implements Iterator<String> {
            private int count = 0;

            private StorageIter() {
            }

            @Override
            public final boolean hasNext() {
                return this.count < StorageS.this.storage.length;
            }

            @Override
            public final String next() {
                return StorageS.this.storage[this.count++];
            }
        }
    }

    private class CanonicalIterator
    implements Iterator<String> {
        private final Iterator<Integer> iter;

        private CanonicalIterator() {
            this.iter = ArrayString.this.indexFn.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public String next() {
            return (String)ArrayString.this.storage.get(this.iter.next().intValue());
        }
    }
}

