/*
 * Decompiled with CFR 0.152.
 */
package ucar.array;

import java.math.BigInteger;
import javax.annotation.Nullable;
import ucar.array.Array;
import ucar.array.StructureData;
import ucar.ma2.DataType;

public enum ArrayType {
    BOOLEAN("boolean", "boolean", 1, Byte.class, false),
    BYTE("byte", "byte", 1, Byte.class, false),
    CHAR("char", "char", 1, Byte.class, false),
    SHORT("short", "short", 2, Short.class, false),
    INT("int", "int", 4, Integer.class, false),
    LONG("long", "int64", 8, Long.class, false),
    FLOAT("float", "float", 4, Float.class, false),
    DOUBLE("double", "double", 8, Double.class, false),
    UBYTE("ubyte", "ubyte", 1, Byte.class, true),
    USHORT("ushort", "ushort", 2, Short.class, true),
    UINT("uint", "uint", 4, Integer.class, true),
    ULONG("ulong", "uint64", 8, Long.class, true),
    ENUM1("enum1", "enum1", 1, Byte.TYPE, false),
    ENUM2("enum2", "enum2", 2, Short.TYPE, false),
    ENUM4("enum4", "enum4", 4, Integer.TYPE, false),
    STRING("String", "string", 4, String.class, false),
    STRUCTURE("Structure", "Structure", 0, StructureData.class, false),
    SEQUENCE("Sequence", "Sequence", 4, StructureData.class, false),
    OPAQUE("opaque", "opaque", 1, Array.class, false),
    OBJECT("object", "object", 1, Object.class, false);

    private final String name;
    private final String cdlName;
    private final int size;
    private final Class<?> primitiveClass;
    private final Signedness signedness;

    private ArrayType(String name, String cdlName, int size, Class<?> primitiveClass, boolean isUnsigned) {
        this(name, cdlName, size, primitiveClass, isUnsigned ? Signedness.UNSIGNED : Signedness.SIGNED);
    }

    private ArrayType(String name, String cdlName, int size, Class<?> primitiveClass, Signedness signedness) {
        this.name = name;
        this.cdlName = cdlName;
        this.size = size;
        this.primitiveClass = primitiveClass;
        this.signedness = signedness;
    }

    public String toString() {
        return this.name;
    }

    public String toNcml() {
        return this.name;
    }

    public String toCdl() {
        return this.cdlName;
    }

    public int getSize() {
        return this.size;
    }

    public Class<?> getPrimitiveClass() {
        return this.primitiveClass;
    }

    public Signedness getSignedness() {
        return this.signedness;
    }

    public boolean isUnsigned() {
        return this.signedness == Signedness.UNSIGNED;
    }

    public boolean isString() {
        return this == STRING || this == CHAR;
    }

    public boolean isNumeric() {
        return this == FLOAT || this == DOUBLE || this.isIntegral();
    }

    public boolean isIntegral() {
        return this == BYTE || this == INT || this == SHORT || this == LONG || this == UBYTE || this == UINT || this == USHORT || this == ULONG;
    }

    public boolean isFloatingPoint() {
        return this == FLOAT || this == DOUBLE;
    }

    public boolean isEnum() {
        return this == ENUM1 || this == ENUM2 || this == ENUM4;
    }

    public ArrayType withSignedness(Signedness signedness) {
        switch (this) {
            case BYTE: 
            case UBYTE: {
                return signedness == Signedness.UNSIGNED ? UBYTE : BYTE;
            }
            case SHORT: 
            case USHORT: {
                return signedness == Signedness.UNSIGNED ? USHORT : SHORT;
            }
            case INT: 
            case UINT: {
                return signedness == Signedness.UNSIGNED ? UINT : INT;
            }
            case LONG: 
            case ULONG: {
                return signedness == Signedness.UNSIGNED ? ULONG : LONG;
            }
        }
        return this;
    }

    @Deprecated
    public DataType getDataType() {
        return DataType.valueOf(this.name());
    }

    @Nullable
    public static ArrayType getTypeByName(String name) {
        if (name == null) {
            return null;
        }
        try {
            return ArrayType.valueOf(name.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public static ArrayType forPrimitiveClass(Class<?> c, boolean isUnsigned) {
        if (c == Float.TYPE || c == Float.class) {
            return FLOAT;
        }
        if (c == Double.TYPE || c == Double.class) {
            return DOUBLE;
        }
        if (c == Short.TYPE || c == Short.class) {
            return isUnsigned ? USHORT : SHORT;
        }
        if (c == Integer.TYPE || c == Integer.class) {
            return isUnsigned ? UINT : INT;
        }
        if (c == Byte.TYPE || c == Byte.class) {
            return isUnsigned ? UBYTE : BYTE;
        }
        if (c == Character.TYPE || c == Character.class) {
            return CHAR;
        }
        if (c == Boolean.TYPE || c == Boolean.class) {
            return BOOLEAN;
        }
        if (c == Long.TYPE || c == Long.class) {
            return isUnsigned ? ULONG : LONG;
        }
        if (c == String.class) {
            return STRING;
        }
        if (c == StructureData.class) {
            return STRUCTURE;
        }
        throw new RuntimeException("Unsupported primitive class " + c.getName());
    }

    public static Number widenNumber(Number number) {
        if (number instanceof Byte) {
            return ArrayType.unsignedByteToShort(number.byteValue());
        }
        if (number instanceof Short) {
            return ArrayType.unsignedShortToInt(number.shortValue());
        }
        if (number instanceof Integer) {
            return ArrayType.unsignedIntToLong(number.intValue());
        }
        if (number instanceof Long) {
            return ArrayType.unsignedLongToBigInt(number.longValue());
        }
        return number;
    }

    public static Number widenNumberIfNegative(Number number) {
        if (number instanceof Byte && number.byteValue() < 0) {
            return ArrayType.unsignedByteToShort(number.byteValue());
        }
        if (number instanceof Short && number.shortValue() < 0) {
            return ArrayType.unsignedShortToInt(number.shortValue());
        }
        if (number instanceof Integer && number.intValue() < 0) {
            return ArrayType.unsignedIntToLong(number.intValue());
        }
        if (number instanceof Long && number.longValue() < 0L) {
            return ArrayType.unsignedLongToBigInt(number.longValue());
        }
        return number;
    }

    public static BigInteger unsignedLongToBigInt(long l) {
        if (l >= 0L) {
            return BigInteger.valueOf(l);
        }
        int upper = (int)(l >>> 32);
        int lower = (int)l;
        return BigInteger.valueOf(Integer.toUnsignedLong(upper)).shiftLeft(32).add(BigInteger.valueOf(Integer.toUnsignedLong(lower)));
    }

    public static long unsignedIntToLong(int i) {
        return Integer.toUnsignedLong(i);
    }

    public static int unsignedShortToInt(short s) {
        return Short.toUnsignedInt(s);
    }

    public static short unsignedByteToShort(byte b) {
        return (short)Byte.toUnsignedInt(b);
    }

    public static enum Signedness {
        SIGNED,
        UNSIGNED;

    }
}

