/*
 * Decompiled with CFR 0.152.
 */
package ucar.array;

import com.google.common.base.Preconditions;
import java.util.Iterator;
import javax.annotation.concurrent.Immutable;
import ucar.array.Array;
import ucar.array.ArrayByte;
import ucar.array.ArrayDouble;
import ucar.array.ArrayFloat;
import ucar.array.ArrayInteger;
import ucar.array.ArrayLong;
import ucar.array.ArrayShort;
import ucar.array.ArrayString;
import ucar.array.ArrayType;
import ucar.array.Arrays;
import ucar.array.Index;
import ucar.array.IndexFn;
import ucar.array.Storage;
import ucar.array.StorageMutable;

public final class ArrayVlen<T>
extends Array<Array<T>> {
    private final StorageMutable<Array<T>> storage;

    public static <T> ArrayVlen<T> factory(ArrayType dataType, int[] shape) {
        return new ArrayVlen<T>(dataType, Arrays.removeVlen(shape));
    }

    public static <T> ArrayVlen<T> factory(ArrayType dataType, int[] shape, Object storage) {
        return new ArrayVlen<T>(dataType, Arrays.removeVlen(shape), storage);
    }

    public static <T> StorageMutable<Array<T>> createStorage(ArrayType dataType, int length, Object dataArray) {
        StorageMutable<Array<Double>> result;
        if (dataArray == null) {
            dataArray = ArrayVlen.createVlenArray(dataType, length);
        }
        switch (dataType) {
            case BOOLEAN: 
            case BYTE: 
            case CHAR: 
            case ENUM1: 
            case OPAQUE: 
            case UBYTE: {
                result = new StorageVByte(dataType, (byte[][])dataArray);
                break;
            }
            case DOUBLE: {
                result = new StorageVDouble((double[][])dataArray);
                break;
            }
            case FLOAT: {
                result = new StorageVFloat((float[][])dataArray);
                break;
            }
            case INT: 
            case ENUM4: 
            case UINT: {
                result = new StorageVInt(dataType, (int[][])dataArray);
                break;
            }
            case LONG: 
            case ULONG: {
                result = new StorageVLong(dataType, (long[][])dataArray);
                break;
            }
            case SHORT: 
            case ENUM2: 
            case USHORT: {
                result = new StorageVShort(dataType, (short[][])dataArray);
                break;
            }
            case STRING: {
                result = new StorageVString((String[][])dataArray);
                break;
            }
            default: {
                throw new RuntimeException("Unimplemented ArrayType " + (Object)((Object)dataType));
            }
        }
        return result;
    }

    public static Object createVlenArray(ArrayType dataType, int length) {
        switch (dataType) {
            case BOOLEAN: 
            case BYTE: 
            case CHAR: 
            case ENUM1: 
            case OPAQUE: 
            case UBYTE: {
                return new byte[length][];
            }
            case DOUBLE: {
                return new double[length][];
            }
            case FLOAT: {
                return new float[length][];
            }
            case INT: 
            case ENUM4: 
            case UINT: {
                return new int[length][];
            }
            case LONG: 
            case ULONG: {
                return new long[length][];
            }
            case SHORT: 
            case ENUM2: 
            case USHORT: {
                return new short[length][];
            }
            case STRING: {
                return new String[length][];
            }
        }
        throw new RuntimeException("Unimplemented ArrayType " + (Object)((Object)dataType));
    }

    private ArrayVlen(ArrayType dataType, int[] shape) {
        super(dataType, shape);
        this.storage = ArrayVlen.createStorage(dataType, (int)Arrays.computeSize(shape), null);
    }

    private ArrayVlen(ArrayType dataType, int[] shape, Object dataArray) {
        super(dataType, shape);
        this.storage = ArrayVlen.createStorage(dataType, (int)Arrays.computeSize(shape), dataArray);
    }

    private ArrayVlen(ArrayType dataType, IndexFn indexFn, StorageMutable<Array<T>> storage) {
        super(dataType, indexFn);
        Preconditions.checkArgument((indexFn.length() <= storage.length() ? 1 : 0) != 0);
        this.storage = storage;
    }

    @Override
    public boolean isVlen() {
        return true;
    }

    @Override
    Iterator<Array<T>> fastIterator() {
        return this.storage.iterator();
    }

    @Override
    public Iterator<Array<T>> iterator() {
        return this.indexFn.isCanonicalOrder() ? this.fastIterator() : new CanonicalIterator();
    }

    @Override
    public Array<T> get(int ... index) {
        return (Array)this.storage.get(this.indexFn.get(index));
    }

    @Override
    public Array<T> get(Index index) {
        return this.get(index.getCurrentIndex());
    }

    public void set(int index, Object value) {
        this.storage.set(index, value);
    }

    @Override
    void arraycopy(int srcPos, Object dest, int destPos, long length) {
        if (this.indexFn.isCanonicalOrder()) {
            this.storage.arraycopy(srcPos, dest, destPos, length);
        } else {
            Object[] ddest = (Object[])dest;
            int destIndex = destPos;
            Iterator<Integer> iter = this.indexFn.iterator(srcPos, length);
            while (iter.hasNext()) {
                ddest[destIndex++] = this.storage.get(iter.next().intValue());
            }
        }
    }

    @Override
    Storage<Array<T>> storage() {
        return this.storage;
    }

    @Override
    protected ArrayVlen<T> createView(IndexFn view) {
        return new ArrayVlen<T>(this.arrayType, view, this.storage);
    }

    @Immutable
    static class StorageVString
    implements StorageMutable<Array<String>> {
        private final String[][] primitiveArray;

        StorageVString(String[][] primitiveArray) {
            this.primitiveArray = primitiveArray;
        }

        @Override
        public long length() {
            return this.primitiveArray.length;
        }

        @Override
        public Array<String> get(long elem) {
            String[] p = this.primitiveArray[(int)elem];
            return Arrays.factory(ArrayType.STRING, new int[]{p.length}, p);
        }

        @Override
        public void arraycopy(int srcPos, Object dest, int destPos, long length) {
            System.arraycopy(this.primitiveArray, srcPos, dest, destPos, (int)length);
        }

        @Override
        public Iterator<Array<String>> iterator() {
            return new StorageIter();
        }

        @Override
        public void set(int index, Object value) {
            if (value instanceof ArrayString) {
                value = Arrays.copyPrimitiveArray((ArrayString)value);
            }
            this.primitiveArray[index] = (String[])value;
        }

        private final class StorageIter
        implements Iterator<Array<String>> {
            private int count = 0;

            private StorageIter() {
            }

            @Override
            public final boolean hasNext() {
                return this.count < StorageVString.this.primitiveArray.length;
            }

            @Override
            public final Array<String> next() {
                String[] p = StorageVString.this.primitiveArray[this.count++];
                return p == null ? null : Arrays.factory(ArrayType.STRING, new int[]{p.length}, p);
            }
        }
    }

    @Immutable
    static class StorageVShort
    implements StorageMutable<Array<Short>> {
        private final ArrayType primitiveArrayType;
        private final short[][] primitiveArray;

        StorageVShort(ArrayType primitiveArrayType, short[][] primitiveArray) {
            this.primitiveArrayType = primitiveArrayType;
            this.primitiveArray = primitiveArray;
        }

        @Override
        public long length() {
            return this.primitiveArray.length;
        }

        @Override
        public Array<Short> get(long elem) {
            short[] p = this.primitiveArray[(int)elem];
            return Arrays.factory(this.primitiveArrayType, new int[]{p.length}, p);
        }

        @Override
        public void arraycopy(int srcPos, Object dest, int destPos, long length) {
            System.arraycopy(this.primitiveArray, srcPos, dest, destPos, (int)length);
        }

        @Override
        public Iterator<Array<Short>> iterator() {
            return new StorageIter();
        }

        @Override
        public void set(int index, Object value) {
            if (value instanceof ArrayShort) {
                value = Arrays.copyPrimitiveArray((ArrayShort)value);
            }
            this.primitiveArray[index] = (short[])value;
        }

        private final class StorageIter
        implements Iterator<Array<Short>> {
            private int count = 0;

            private StorageIter() {
            }

            @Override
            public final boolean hasNext() {
                return this.count < StorageVShort.this.primitiveArray.length;
            }

            @Override
            public final Array<Short> next() {
                short[] p = StorageVShort.this.primitiveArray[this.count++];
                return p == null ? null : Arrays.factory(StorageVShort.this.primitiveArrayType, new int[]{p.length}, p);
            }
        }
    }

    @Immutable
    static class StorageVLong
    implements StorageMutable<Array<Long>> {
        private final ArrayType primitiveArrayType;
        private final long[][] primitiveArray;

        StorageVLong(ArrayType primitiveArrayType, long[][] primitiveArray) {
            this.primitiveArrayType = primitiveArrayType;
            this.primitiveArray = primitiveArray;
        }

        @Override
        public long length() {
            return this.primitiveArray.length;
        }

        @Override
        public Array<Long> get(long elem) {
            long[] p = this.primitiveArray[(int)elem];
            return Arrays.factory(this.primitiveArrayType, new int[]{p.length}, p);
        }

        @Override
        public void arraycopy(int srcPos, Object dest, int destPos, long length) {
            System.arraycopy(this.primitiveArray, srcPos, dest, destPos, (int)length);
        }

        @Override
        public Iterator<Array<Long>> iterator() {
            return new StorageIter();
        }

        @Override
        public void set(int index, Object value) {
            if (value instanceof ArrayLong) {
                value = Arrays.copyPrimitiveArray((ArrayLong)value);
            }
            this.primitiveArray[index] = (long[])value;
        }

        private final class StorageIter
        implements Iterator<Array<Long>> {
            private int count = 0;

            private StorageIter() {
            }

            @Override
            public final boolean hasNext() {
                return this.count < StorageVLong.this.primitiveArray.length;
            }

            @Override
            public final Array<Long> next() {
                long[] p = StorageVLong.this.primitiveArray[this.count++];
                return p == null ? null : Arrays.factory(StorageVLong.this.primitiveArrayType, new int[]{p.length}, p);
            }
        }
    }

    @Immutable
    static class StorageVInt
    implements StorageMutable<Array<Integer>> {
        private final ArrayType primitiveArrayType;
        private final int[][] primitiveArray;

        StorageVInt(ArrayType primitiveArrayType, int[][] primitiveArray) {
            this.primitiveArrayType = primitiveArrayType;
            this.primitiveArray = primitiveArray;
        }

        @Override
        public long length() {
            return this.primitiveArray.length;
        }

        @Override
        public Array<Integer> get(long elem) {
            int[] p = this.primitiveArray[(int)elem];
            return Arrays.factory(this.primitiveArrayType, new int[]{p.length}, p);
        }

        @Override
        public void arraycopy(int srcPos, Object dest, int destPos, long length) {
            System.arraycopy(this.primitiveArray, srcPos, dest, destPos, (int)length);
        }

        @Override
        public Iterator<Array<Integer>> iterator() {
            return new StorageIter();
        }

        @Override
        public void set(int index, Object value) {
            if (value instanceof ArrayInteger) {
                value = Arrays.copyPrimitiveArray((ArrayInteger)value);
            }
            this.primitiveArray[index] = (int[])value;
        }

        private final class StorageIter
        implements Iterator<Array<Integer>> {
            private int count = 0;

            private StorageIter() {
            }

            @Override
            public final boolean hasNext() {
                return this.count < StorageVInt.this.primitiveArray.length;
            }

            @Override
            public final Array<Integer> next() {
                int[] p = StorageVInt.this.primitiveArray[this.count++];
                return p == null ? null : Arrays.factory(StorageVInt.this.primitiveArrayType, new int[]{p.length}, p);
            }
        }
    }

    @Immutable
    static class StorageVFloat
    implements StorageMutable<Array<Float>> {
        private final float[][] primitiveArray;

        StorageVFloat(float[][] primitiveArray) {
            this.primitiveArray = primitiveArray;
        }

        @Override
        public long length() {
            return this.primitiveArray.length;
        }

        @Override
        public Array<Float> get(long elem) {
            float[] p = this.primitiveArray[(int)elem];
            return Arrays.factory(ArrayType.FLOAT, new int[]{p.length}, p);
        }

        @Override
        public void arraycopy(int srcPos, Object dest, int destPos, long length) {
            System.arraycopy(this.primitiveArray, srcPos, dest, destPos, (int)length);
        }

        @Override
        public Iterator<Array<Float>> iterator() {
            return new StorageIter();
        }

        @Override
        public void set(int index, Object value) {
            if (value instanceof ArrayFloat) {
                value = Arrays.copyPrimitiveArray((ArrayFloat)value);
            }
            this.primitiveArray[index] = (float[])value;
        }

        private final class StorageIter
        implements Iterator<Array<Float>> {
            private int count = 0;

            private StorageIter() {
            }

            @Override
            public final boolean hasNext() {
                return this.count < StorageVFloat.this.primitiveArray.length;
            }

            @Override
            public final Array<Float> next() {
                float[] p = StorageVFloat.this.primitiveArray[this.count++];
                return p == null ? null : Arrays.factory(ArrayType.FLOAT, new int[]{p.length}, p);
            }
        }
    }

    @Immutable
    static class StorageVDouble
    implements StorageMutable<Array<Double>> {
        private final double[][] primitiveArray;

        StorageVDouble(double[][] primitiveArray) {
            this.primitiveArray = primitiveArray;
        }

        @Override
        public long length() {
            return this.primitiveArray.length;
        }

        @Override
        public Array<Double> get(long elem) {
            double[] p = this.primitiveArray[(int)elem];
            return Arrays.factory(ArrayType.DOUBLE, new int[]{p.length}, p);
        }

        @Override
        public void arraycopy(int srcPos, Object dest, int destPos, long length) {
            System.arraycopy(this.primitiveArray, srcPos, dest, destPos, (int)length);
        }

        @Override
        public Iterator<Array<Double>> iterator() {
            return new StorageIter();
        }

        @Override
        public void set(int index, Object value) {
            if (value instanceof ArrayDouble) {
                value = Arrays.copyPrimitiveArray((ArrayDouble)value);
            }
            this.primitiveArray[index] = (double[])value;
        }

        private final class StorageIter
        implements Iterator<Array<Double>> {
            private int count = 0;

            private StorageIter() {
            }

            @Override
            public final boolean hasNext() {
                return this.count < StorageVDouble.this.primitiveArray.length;
            }

            @Override
            public final Array<Double> next() {
                double[] p = StorageVDouble.this.primitiveArray[this.count++];
                return p == null ? null : Arrays.factory(ArrayType.DOUBLE, new int[]{p.length}, p);
            }
        }
    }

    @Immutable
    static final class StorageVByte
    implements StorageMutable<Array<Byte>> {
        private final ArrayType primitiveArrayType;
        private final byte[][] primitiveArray;

        StorageVByte(ArrayType primitiveArrayType, byte[][] primitiveArray) {
            this.primitiveArrayType = primitiveArrayType;
            this.primitiveArray = primitiveArray;
        }

        @Override
        public long length() {
            return this.primitiveArray.length;
        }

        @Override
        public Array<Byte> get(long elem) {
            byte[] p = this.primitiveArray[(int)elem];
            return Arrays.factory(this.primitiveArrayType, new int[]{p.length}, p);
        }

        @Override
        public void arraycopy(int srcPos, Object dest, int destPos, long length) {
            System.arraycopy(this.primitiveArray, srcPos, dest, destPos, (int)length);
        }

        @Override
        public Iterator<Array<Byte>> iterator() {
            return new StorageIter();
        }

        @Override
        public void set(int index, Object value) {
            if (value instanceof ArrayByte) {
                value = Arrays.copyPrimitiveArray((ArrayByte)value);
            }
            this.primitiveArray[index] = (byte[])value;
        }

        private final class StorageIter
        implements Iterator<Array<Byte>> {
            private int count = 0;

            private StorageIter() {
            }

            @Override
            public final boolean hasNext() {
                return this.count < StorageVByte.this.primitiveArray.length;
            }

            @Override
            public final Array<Byte> next() {
                byte[] p = StorageVByte.this.primitiveArray[this.count++];
                return p == null ? null : Arrays.factory(StorageVByte.this.primitiveArrayType, new int[]{p.length}, p);
            }
        }
    }

    private class CanonicalIterator
    implements Iterator<Array<T>> {
        private final Iterator<Integer> iter;

        private CanonicalIterator() {
            this.iter = ArrayVlen.this.indexFn.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public Array<T> next() {
            return (Array)ArrayVlen.this.storage.get(this.iter.next().intValue());
        }
    }
}

