/*
 * Decompiled with CFR 0.152.
 */
package ucar.array;

import com.google.common.base.Preconditions;
import com.google.protobuf.ByteString;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import ucar.array.Array;
import ucar.array.ArrayByte;
import ucar.array.ArrayDouble;
import ucar.array.ArrayFloat;
import ucar.array.ArrayInteger;
import ucar.array.ArrayLong;
import ucar.array.ArrayShort;
import ucar.array.ArrayString;
import ucar.array.ArrayType;
import ucar.array.ArraysConvert;
import ucar.array.IndexFn;
import ucar.array.InvalidRangeException;
import ucar.array.IsMissingEvaluator;
import ucar.array.MinMax;
import ucar.array.Range;
import ucar.array.Section;
import ucar.array.Storage;

public class Arrays {
    private Arrays() {
    }

    public static <T> Array<T> factory(ArrayType dataType, int[] shape, Storage<T> storage) {
        switch (dataType) {
            case OPAQUE: 
            case BOOLEAN: 
            case BYTE: 
            case CHAR: 
            case ENUM1: 
            case UBYTE: {
                return new ArrayByte(dataType, shape, storage);
            }
            case DOUBLE: {
                return new ArrayDouble(shape, storage);
            }
            case FLOAT: {
                return new ArrayFloat(shape, storage);
            }
            case INT: 
            case ENUM4: 
            case UINT: {
                return new ArrayInteger(dataType, shape, storage);
            }
            case LONG: 
            case ULONG: {
                return new ArrayLong(dataType, shape, storage);
            }
            case SHORT: 
            case ENUM2: 
            case USHORT: {
                return new ArrayShort(dataType, shape, storage);
            }
            case STRING: {
                return new ArrayString(shape, storage);
            }
        }
        throw new RuntimeException("Unimplemented ArrayType " + (Object)((Object)dataType));
    }

    public static <T> Array<T> factory(ArrayType dataType, int[] shape, Object dataArray) {
        switch (dataType) {
            case CHAR: {
                if (dataArray instanceof char[]) {
                    dataArray = ArraysConvert.convertCharToByte((char[])dataArray);
                }
            }
            case OPAQUE: 
            case BOOLEAN: 
            case BYTE: 
            case ENUM1: 
            case UBYTE: {
                ArrayByte.StorageS storageS = new ArrayByte.StorageS((byte[])dataArray);
                return new ArrayByte(dataType, shape, (Storage<Byte>)storageS);
            }
            case DOUBLE: {
                ArrayDouble.StorageD storageD = new ArrayDouble.StorageD((double[])dataArray);
                return new ArrayDouble(shape, (Storage<Double>)storageD);
            }
            case FLOAT: {
                ArrayFloat.StorageF storageF = new ArrayFloat.StorageF((float[])dataArray);
                return new ArrayFloat(shape, (Storage<Float>)storageF);
            }
            case INT: 
            case ENUM4: 
            case UINT: {
                ArrayInteger.StorageS storageS = new ArrayInteger.StorageS((int[])dataArray);
                return new ArrayInteger(dataType, shape, (Storage<Integer>)storageS);
            }
            case LONG: 
            case ULONG: {
                ArrayLong.StorageS storageS = new ArrayLong.StorageS((long[])dataArray);
                return new ArrayLong(dataType, shape, (Storage<Long>)storageS);
            }
            case SHORT: 
            case ENUM2: 
            case USHORT: {
                ArrayShort.StorageS storageS = new ArrayShort.StorageS((short[])dataArray);
                return new ArrayShort(dataType, shape, (Storage<Short>)storageS);
            }
            case STRING: {
                ArrayString.StorageS storageS = new ArrayString.StorageS((String[])dataArray);
                return new ArrayString(shape, (Storage<String>)storageS);
            }
        }
        throw new RuntimeException("Unimplemented ArrayType= " + (Object)((Object)dataType));
    }

    public static <T> Array<T> factory(ArrayType dataType, int[] shape) {
        switch (dataType) {
            case BOOLEAN: 
            case BYTE: 
            case CHAR: 
            case ENUM1: 
            case UBYTE: {
                return new ArrayByte(dataType, shape);
            }
            case DOUBLE: {
                return new ArrayDouble(shape);
            }
            case FLOAT: {
                return new ArrayFloat(shape);
            }
            case INT: 
            case ENUM4: 
            case UINT: {
                return new ArrayInteger(dataType, shape);
            }
            case LONG: 
            case ULONG: {
                return new ArrayLong(dataType, shape);
            }
            case SHORT: 
            case ENUM2: 
            case USHORT: {
                return new ArrayShort(dataType, shape);
            }
            case STRING: {
                return new ArrayString(shape);
            }
        }
        throw new RuntimeException("Unimplemented ArrayType " + (Object)((Object)dataType));
    }

    public static <T> Array<T> factoryCopy(ArrayType dataType, int[] shape, List<Array<T>> dataArrays) {
        if (dataArrays.size() == 1) {
            return Arrays.factory(dataType, shape, dataArrays.get(0).storage());
        }
        Object dataArray = Arrays.combine(dataType, shape, dataArrays);
        return Arrays.factory(dataType, shape, dataArray);
    }

    private static <T> Object combine(ArrayType dataType, int[] shape, List<Array<T>> dataArrays) {
        Object[] all;
        long size = Arrays.computeSize(shape);
        if (size > Integer.MAX_VALUE) {
            throw new OutOfMemoryError();
        }
        switch (dataType) {
            case BYTE: 
            case ENUM1: 
            case UBYTE: {
                all = new byte[(int)size];
                break;
            }
            case CHAR: {
                all = new char[(int)size];
                break;
            }
            case DOUBLE: {
                all = new double[(int)size];
                break;
            }
            case FLOAT: {
                all = new float[(int)size];
                break;
            }
            case INT: 
            case ENUM4: 
            case UINT: {
                all = new int[(int)size];
                break;
            }
            case LONG: 
            case ULONG: {
                all = new long[(int)size];
                break;
            }
            case SHORT: 
            case ENUM2: 
            case USHORT: {
                all = new short[(int)size];
                break;
            }
            case STRING: {
                all = new String[(int)size];
                break;
            }
            default: {
                throw new RuntimeException(" ArrayType " + (Object)((Object)dataType));
            }
        }
        int start = 0;
        for (Array<T> dataArray : dataArrays) {
            dataArray.arraycopy(0, all, start, dataArray.length());
            start = (int)((long)start + dataArray.length());
        }
        return all;
    }

    public static <T> Array<T> factoryArrays(ArrayType dataType, int[] shape, List<Array<?>> dataArrays) {
        if (dataArrays.size() == 1) {
            return Arrays.factory(dataType, shape, dataArrays.get(0).storage());
        }
        switch (dataType) {
            case DOUBLE: {
                ArrayDouble.StorageDM storageD = new ArrayDouble.StorageDM(dataArrays);
                return new ArrayDouble(shape, (Storage<Double>)storageD);
            }
            case FLOAT: {
                ArrayFloat.StorageFM storageF = new ArrayFloat.StorageFM(dataArrays);
                return new ArrayFloat(shape, (Storage<Float>)storageF);
            }
        }
        throw new RuntimeException();
    }

    public static <T> Array<T> flip(Array<T> org, int dim) {
        return org.createView(org.indexFn().flip(dim));
    }

    public static <T> Array<T> permute(Array<T> org, int[] dims) {
        return org.createView(org.indexFn().permute(dims));
    }

    public static <T> Array<T> reshape(Array<T> org, int[] shape) {
        return org.createView(org.indexFn().reshape(shape));
    }

    public static <T> Array<T> reduce(Array<T> org) {
        IndexFn ri = org.indexFn().reduce();
        if (ri == org.indexFn()) {
            return org;
        }
        return org.createView(ri);
    }

    public static <T> Array<T> reduce(Array<T> org, int dim) {
        IndexFn ri = org.indexFn().reduce(dim);
        if (ri == org.indexFn()) {
            return org;
        }
        return org.createView(ri);
    }

    public static <T> Array<T> section(Array<T> org, Section section) throws InvalidRangeException {
        return org.createView(org.indexFn().section(section));
    }

    public static <T> Array<T> slice(Array<T> org, int dim, int value) throws InvalidRangeException {
        Section.Builder sb = Section.builder();
        for (int i = 0; i < org.getSection().getRank(); ++i) {
            sb.appendRange(null);
        }
        sb.replaceRange(dim, new Range(value, value));
        Array<T> s = Arrays.section(org, sb.build());
        return Arrays.reduce(s, dim);
    }

    public static <T> Array<T> transpose(Array<T> org, int dim1, int dim2) {
        return org.createView(org.indexFn().transpose(dim1, dim2));
    }

    public static long computeSize(int[] shape) {
        long product = 1L;
        for (int aShape : shape) {
            if (aShape < 0) break;
            product *= (long)aShape;
        }
        return product;
    }

    public static int[] removeVlen(int[] shape) {
        int prefixrank;
        for (prefixrank = 0; prefixrank < shape.length && shape[prefixrank] >= 0; ++prefixrank) {
        }
        if (prefixrank == shape.length) {
            return shape;
        }
        int[] newshape = new int[prefixrank];
        System.arraycopy(shape, 0, newshape, 0, prefixrank);
        return newshape;
    }

    public static Object copyPrimitiveArray(Array<?> data) {
        ArrayType dataType = data.getArrayType();
        int idx = 0;
        switch (dataType) {
            case OPAQUE: 
            case BYTE: 
            case ENUM1: 
            case UBYTE: {
                Array<?> bdata = data;
                byte[] parray = new byte[(int)data.length()];
                Iterator<?> iterator = bdata.iterator();
                while (iterator.hasNext()) {
                    byte val = (Byte)iterator.next();
                    parray[idx++] = val;
                }
                return parray;
            }
            case CHAR: {
                Array<?> cdata = data;
                char[] parray = new char[(int)data.length()];
                Iterator<?> iterator = cdata.iterator();
                while (iterator.hasNext()) {
                    char val = ((Character)iterator.next()).charValue();
                    parray[idx++] = val;
                }
                return parray;
            }
            case SHORT: 
            case ENUM2: 
            case USHORT: {
                Array<?> sdata = data;
                short[] parray = new short[(int)data.length()];
                Iterator<?> iterator = sdata.iterator();
                while (iterator.hasNext()) {
                    short val = (Short)iterator.next();
                    parray[idx++] = val;
                }
                return parray;
            }
            case INT: 
            case ENUM4: 
            case UINT: {
                Array<?> idata = data;
                int[] parray = new int[(int)data.length()];
                Iterator<?> iterator = idata.iterator();
                while (iterator.hasNext()) {
                    int val = (Integer)iterator.next();
                    parray[idx++] = val;
                }
                return parray;
            }
            case LONG: 
            case ULONG: {
                Array<?> ldata = data;
                long[] parray = new long[(int)data.length()];
                Iterator<?> iterator = ldata.iterator();
                while (iterator.hasNext()) {
                    long val = (Long)iterator.next();
                    parray[idx++] = val;
                }
                return parray;
            }
            case FLOAT: {
                Array<?> fdata = data;
                float[] parray = new float[(int)data.length()];
                Iterator<?> iterator = fdata.iterator();
                while (iterator.hasNext()) {
                    float val = ((Float)iterator.next()).floatValue();
                    parray[idx++] = val;
                }
                return parray;
            }
            case DOUBLE: {
                Array<?> ddata = data;
                double[] parray = new double[(int)data.length()];
                Iterator<?> iterator = ddata.iterator();
                while (iterator.hasNext()) {
                    double val = (Double)iterator.next();
                    parray[idx++] = val;
                }
                return parray;
            }
            case STRING: {
                Array<?> sdata = data;
                String[] parray = new String[(int)data.length()];
                for (String val : sdata) {
                    parray[idx++] = val;
                }
                return parray;
            }
        }
        throw new IllegalStateException("Unimplemented datatype " + (Object)((Object)dataType));
    }

    public static Array<Double> toDouble(Array<?> array) {
        if (array instanceof ArrayDouble) {
            return array;
        }
        Array<Double> conv = array;
        int n = (int)array.length();
        double[] storage = new double[n];
        int count = 0;
        for (Number number : conv) {
            storage[count++] = number.doubleValue();
        }
        return Arrays.factory(ArrayType.DOUBLE, array.getShape(), storage);
    }

    public static MinMax getMinMaxSkipMissingData(Array<? extends Number> a, @Nullable IsMissingEvaluator eval) {
        Preconditions.checkNotNull(a);
        boolean hasEval = eval != null && eval.hasMissing();
        double max = -1.7976931348623157E308;
        double min = Double.MAX_VALUE;
        if (a instanceof ArrayDouble) {
            ArrayDouble ad = (ArrayDouble)a;
            for (double val : ad) {
                if (hasEval && eval.isMissing(val)) continue;
                if (val > max) {
                    max = val;
                }
                if (!(val < min)) continue;
                min = val;
            }
        } else {
            for (Number number : a) {
                double val = number.doubleValue();
                if (hasEval && eval.isMissing(val)) continue;
                if (val > max) {
                    max = val;
                }
                if (!(val < min)) continue;
                min = val;
            }
        }
        return MinMax.create(min, max);
    }

    public static <T> Array<T> makeArray(ArrayType type, int npts, double start, double incr, int ... shape) {
        Object[] pvals;
        Preconditions.checkArgument((boolean)type.isNumeric());
        if (shape.length == 0) {
            shape = new int[]{npts};
        }
        switch (type) {
            case BYTE: {
                byte[] bvals = new byte[npts];
                for (int i = 0; i < npts; ++i) {
                    bvals[i] = (byte)(start + (double)i * incr);
                }
                pvals = bvals;
                break;
            }
            case DOUBLE: {
                double[] dvals = new double[npts];
                for (int i = 0; i < npts; ++i) {
                    dvals[i] = (float)(start + (double)i * incr);
                }
                pvals = dvals;
                break;
            }
            case FLOAT: {
                float[] fvals = new float[npts];
                for (int i = 0; i < npts; ++i) {
                    fvals[i] = (float)(start + (double)i * incr);
                }
                pvals = fvals;
                break;
            }
            case INT: {
                int[] ivals = new int[npts];
                for (int i = 0; i < npts; ++i) {
                    ivals[i] = (int)(start + (double)i * incr);
                }
                pvals = ivals;
                break;
            }
            case SHORT: {
                short[] svals = new short[npts];
                for (int i = 0; i < npts; ++i) {
                    svals[i] = (short)(start + (double)i * incr);
                }
                pvals = svals;
                break;
            }
            case LONG: {
                long[] lvals = new long[npts];
                for (int i = 0; i < npts; ++i) {
                    lvals[i] = (long)(start + (double)i * incr);
                }
                pvals = lvals;
                break;
            }
            default: {
                throw new IllegalArgumentException("makeArray od type " + (Object)((Object)type));
            }
        }
        return Arrays.factory(type, shape, pvals);
    }

    public static Array<String> makeStringsFromChar(Array<Byte> from) {
        return ((ArrayByte)from).makeStringsFromChar();
    }

    public static String makeStringFromChar(Array<Byte> from) {
        return ((ArrayByte)from).makeStringFromChar();
    }

    public static ByteBuffer getByteBuffer(Array<Byte> from) {
        return ((ArrayByte)from).getByteBuffer();
    }

    public static ByteString getByteString(Array<Byte> from) {
        return ((ArrayByte)from).getByteString();
    }
}

