/*
 * Decompiled with CFR 0.152.
 */
package ucar.array;

import com.google.common.base.Preconditions;
import ucar.array.IndexFn;

public class Index {
    private int[] current;
    private final IndexFn indexFn;

    public static Index ofRank(int rank) {
        return new Index(new int[rank], IndexFn.builder(rank).build());
    }

    public static Index of(int[] index) {
        return new Index(index, IndexFn.builder(index.length).build());
    }

    Index(int[] index, IndexFn indexFn) {
        this.current = index;
        this.indexFn = indexFn;
    }

    public Index(Index from) {
        this.current = new int[from.current.length];
        System.arraycopy(from.current, 0, this.current, 0, from.current.length);
        this.indexFn = from.indexFn;
    }

    public Index incr(int dim) {
        Preconditions.checkArgument((dim < this.current.length ? 1 : 0) != 0);
        this.setDim(dim, this.current[dim] + 1);
        return this;
    }

    public int[] getCurrentIndex() {
        return this.current;
    }

    public Index setElem(long elem) {
        this.current = this.indexFn.odometer(elem);
        return this;
    }

    public Index setDim(int dim, int value) {
        Preconditions.checkArgument((dim < this.current.length ? 1 : 0) != 0);
        this.current[dim] = value;
        return this;
    }

    public Index set0(int v) {
        this.setDim(0, v);
        return this;
    }

    public Index set1(int v) {
        this.setDim(1, v);
        return this;
    }

    public Index set2(int v) {
        this.setDim(2, v);
        return this;
    }

    public Index set3(int v) {
        this.setDim(3, v);
        return this;
    }

    public Index set4(int v) {
        this.setDim(4, v);
        return this;
    }

    public Index set5(int v) {
        this.setDim(5, v);
        return this;
    }

    public Index set6(int v) {
        this.setDim(6, v);
        return this;
    }

    public Index set(int ... index) {
        if (index.length != this.current.length) {
            throw new ArrayIndexOutOfBoundsException(String.format("Number of indices (%d) must equal rank (%d)", index.length, this.current.length));
        }
        if (this.current.length == 0) {
            return this;
        }
        System.arraycopy(index, 0, this.current, 0, index.length);
        return this;
    }
}

