/*
 * Decompiled with CFR 0.152.
 */
package ucar.array;

import com.google.common.collect.ImmutableSortedSet;
import java.util.Iterator;
import java.util.Set;
import javax.annotation.concurrent.Immutable;
import ucar.array.Range;
import ucar.array.RangeIterator;

@Immutable
class RangeScatter
implements RangeIterator {
    private final ImmutableSortedSet<Integer> vals;
    private final String name;

    public static RangeIterator intersect(Range one, Range other) {
        Range big;
        Range small;
        ImmutableSortedSet.Builder vals = ImmutableSortedSet.naturalOrder();
        if (other.length() < one.length()) {
            small = other;
            big = one;
        } else {
            small = one;
            big = other;
        }
        for (int elem : small) {
            if (!big.contains(elem)) continue;
            vals.add((Object)elem);
        }
        return new RangeScatter(String.format("Intersect%sAnd%s", one.name(), other.name()), (Set<Integer>)vals.build());
    }

    public RangeScatter(String name, Set<Integer> vals) {
        this.name = name;
        this.vals = ImmutableSortedSet.copyOf(vals);
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public RangeScatter copyWithName(String name) {
        if (name.equals(this.name())) {
            return this;
        }
        return new RangeScatter(name, (Set<Integer>)this.vals);
    }

    @Override
    public int length() {
        return this.vals.size();
    }

    @Override
    public Iterator<Integer> iterator() {
        return this.vals.iterator();
    }
}

