/*
 * Decompiled with CFR 0.152.
 */
package ucar.array;

import com.google.common.base.Preconditions;
import java.util.Iterator;
import java.util.List;
import javax.annotation.concurrent.Immutable;
import ucar.array.Array;
import ucar.array.ArrayType;
import ucar.array.Index;
import ucar.array.IndexFn;
import ucar.array.Storage;
import ucar.array.StorageMutable;
import ucar.array.StructureData;
import ucar.array.StructureMembers;

@Immutable
public final class StructureDataArray
extends Array<StructureData> {
    private final Storage<StructureData> storage;
    private final StructureMembers members;

    public StructureDataArray(StructureMembers members, int[] shape, StructureData[] parray) {
        super(ArrayType.STRUCTURE, shape);
        this.members = members;
        this.storage = new StorageSD(parray, (int)this.indexFn.length());
    }

    public StructureDataArray(StructureMembers members, int[] shape, Storage<StructureData> storage) {
        super(ArrayType.STRUCTURE, shape);
        if (this.indexFn.length() != storage.length()) {
            throw new IllegalArgumentException(String.format("indexFn.length %d != %d storage.length", this.indexFn.length(), storage.length()));
        }
        this.members = members;
        this.storage = storage;
    }

    public StructureDataArray(StructureMembers members, IndexFn indexFn, Storage<StructureData> storage) {
        super(ArrayType.STRUCTURE, indexFn);
        this.members = members;
        this.storage = storage;
    }

    public StructureMembers getStructureMembers() {
        return this.members;
    }

    public List<String> getStructureMemberNames() {
        return this.members.getMemberNames();
    }

    @Override
    void arraycopy(int srcPos, Object dest, int destPos, long length) {
    }

    @Override
    Array<StructureData> createView(IndexFn view) {
        return new StructureDataArray(this.members, view, this.storage);
    }

    @Override
    Iterator<StructureData> fastIterator() {
        return this.storage.iterator();
    }

    @Override
    public Iterator<StructureData> iterator() {
        return this.indexFn.isCanonicalOrder() ? this.fastIterator() : new CanonicalIterator();
    }

    @Override
    public StructureData get(int ... index) {
        Preconditions.checkArgument((this.rank == index.length ? 1 : 0) != 0);
        return this.storage.get(this.indexFn.get(index));
    }

    @Override
    public StructureData get(Index index) {
        return this.get(index.getCurrentIndex());
    }

    public int getStructureSize() {
        return this.members.getStorageSizeBytes();
    }

    @Override
    Storage<StructureData> storage() {
        return this.storage;
    }

    static final class StorageSD
    implements StorageMutable<StructureData> {
        final StructureData[] parray;
        final int length;

        StorageSD(StructureData[] parray, int length) {
            Preconditions.checkArgument((parray.length >= length ? 1 : 0) != 0);
            this.parray = parray;
            this.length = length;
        }

        @Override
        public long length() {
            return this.length;
        }

        @Override
        public StructureData get(long elem) {
            return this.parray[(int)elem];
        }

        @Override
        public void arraycopy(int srcPos, Object dest, int destPos, long length) {
        }

        @Override
        public void set(int index, Object value) {
            this.parray[index] = (StructureData)value;
        }

        @Override
        public Iterator<StructureData> iterator() {
            return new Iter();
        }

        private final class Iter
        implements Iterator<StructureData> {
            private int count = 0;

            private Iter() {
            }

            @Override
            public final boolean hasNext() {
                return this.count < StorageSD.this.length;
            }

            @Override
            public final StructureData next() {
                return StorageSD.this.parray[this.count++];
            }
        }
    }

    private class CanonicalIterator
    implements Iterator<StructureData> {
        private final Iterator<Integer> iter;

        private CanonicalIterator() {
            this.iter = StructureDataArray.this.indexFn.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public StructureData next() {
            return (StructureData)StructureDataArray.this.storage.get(this.iter.next().intValue());
        }
    }
}

