/*
 * Decompiled with CFR 0.152.
 */
package ucar.array;

import com.google.common.base.Preconditions;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.array.Array;
import ucar.array.ArrayByte;
import ucar.array.ArrayDouble;
import ucar.array.ArrayFloat;
import ucar.array.ArrayInteger;
import ucar.array.ArrayLong;
import ucar.array.ArrayShort;
import ucar.array.ArrayString;
import ucar.array.ArrayType;
import ucar.array.ArrayVlen;
import ucar.array.Storage;
import ucar.array.StructureData;
import ucar.array.StructureDataArray;
import ucar.array.StructureMembers;

public final class StructureDataStorageBB
implements Storage<StructureData> {
    private static final Logger log = LoggerFactory.getLogger(StructureDataStorageBB.class);
    private static final boolean debug = false;
    private final StructureMembers members;
    private final ByteBuffer bbuffer;
    private final int nelems;
    private final int offset;
    private final ArrayList<Object> heap = new ArrayList();
    private boolean structuresOnHeap = false;

    public StructureDataStorageBB(StructureMembers members, ByteBuffer bbuffer, int nelems) {
        this.members = members;
        this.bbuffer = bbuffer;
        this.nelems = nelems;
        this.offset = 0;
    }

    StructureDataStorageBB(StructureMembers members, ByteBuffer bbuffer, int nelems, ArrayList<Object> heap, int offset) {
        this.members = members;
        this.bbuffer = bbuffer;
        this.nelems = nelems;
        this.offset = offset;
        this.heap.addAll(heap);
    }

    public StructureDataStorageBB setStructuresOnHeap(boolean structuresOnHeap) {
        this.structuresOnHeap = structuresOnHeap;
        return this;
    }

    public int putOnHeap(Object s) {
        this.heap.add(s);
        return this.heap.size() - 1;
    }

    @Override
    public long length() {
        return this.nelems;
    }

    @Override
    public StructureData get(long elem) {
        return new StructureDataBB((int)elem);
    }

    @Override
    public void arraycopy(int srcPos, Object dest, int destPos, long length) {
    }

    public int getStructureSize() {
        return this.members.getStorageSizeBytes();
    }

    ByteBuffer buffer() {
        return this.bbuffer;
    }

    public void setMemberData(int offset, StructureMembers.Member member, Array<?> data) {
        int pos = offset + member.getOffset();
        this.bbuffer.position(pos);
        this.bbuffer.order(member.getByteOrder());
        if (member.isVlen()) {
            int index = this.putOnHeap(data);
            this.bbuffer.putInt(index);
            return;
        }
        ArrayType dataType = data.getArrayType();
        switch (dataType) {
            case CHAR: 
            case ENUM1: 
            case UBYTE: 
            case BYTE: {
                Array<?> bdata = data;
                Iterator<?> iterator = bdata.iterator();
                while (iterator.hasNext()) {
                    byte val = (Byte)iterator.next();
                    this.bbuffer.put(val);
                }
                return;
            }
            case OPAQUE: {
                int index = this.putOnHeap(data);
                this.bbuffer.putInt(index);
                return;
            }
            case ENUM2: 
            case USHORT: 
            case SHORT: {
                Array<?> sdata = data;
                Iterator<?> iterator = sdata.iterator();
                while (iterator.hasNext()) {
                    short val = (Short)iterator.next();
                    this.bbuffer.putShort(val);
                }
                return;
            }
            case ENUM4: 
            case UINT: 
            case INT: {
                Array<?> idata = data;
                Iterator<?> iterator = idata.iterator();
                while (iterator.hasNext()) {
                    int val = (Integer)iterator.next();
                    this.bbuffer.putInt(val);
                }
                return;
            }
            case ULONG: 
            case LONG: {
                Array<?> ldata = data;
                Iterator<?> iterator = ldata.iterator();
                while (iterator.hasNext()) {
                    long val = (Long)iterator.next();
                    this.bbuffer.putLong(val);
                }
                return;
            }
            case FLOAT: {
                Array<?> fdata = data;
                Iterator<?> iterator = fdata.iterator();
                while (iterator.hasNext()) {
                    float val = ((Float)iterator.next()).floatValue();
                    this.bbuffer.putFloat(val);
                }
                return;
            }
            case DOUBLE: {
                Array<?> ddata = data;
                Iterator<?> iterator = ddata.iterator();
                while (iterator.hasNext()) {
                    double val = (Double)iterator.next();
                    this.bbuffer.putDouble(val);
                }
                return;
            }
            case STRING: {
                String[] vals = new String[(int)data.length()];
                Array<?> sdata = data;
                int idx = 0;
                for (String val : sdata) {
                    vals[idx++] = val;
                }
                int index = this.putOnHeap(vals);
                this.bbuffer.putInt(index);
                return;
            }
            case STRUCTURE: {
                Preconditions.checkArgument((member.getStructureMembers() != null ? 1 : 0) != 0);
                StructureDataArray orgArray = (StructureDataArray)data;
                StructureMembers nestedMembers = orgArray.getStructureMembers();
                int length = (int)orgArray.length();
                for (int nrow = 0; nrow < length; ++nrow) {
                    StructureData orgData = orgArray.get(nrow);
                    for (StructureMembers.Member nmember : nestedMembers) {
                        int nestedPos = offset + nestedMembers.getStorageSizeBytes() * nrow;
                        this.setMemberData(nestedPos, nmember, orgData.getMemberData(nmember));
                    }
                }
                return;
            }
        }
        throw new IllegalStateException("Unkown datatype " + (Object)((Object)dataType));
    }

    @Override
    public Iterator<StructureData> iterator() {
        return new Iter();
    }

    private final class StructureDataBB
    extends StructureData {
        private final int recno;

        private StructureDataBB(int recno) {
            super(StructureDataStorageBB.this.members);
            this.recno = recno;
        }

        @Override
        public Array<?> getMemberData(StructureMembers.Member m) {
            ArrayType dataType = m.getArrayType();
            if (m.isVlen() || dataType == ArrayType.OPAQUE) {
                return this.getMemberVlenData(m);
            }
            StructureDataStorageBB.this.bbuffer.order(m.getByteOrder());
            int length = m.length();
            int pos = StructureDataStorageBB.this.offset + this.recno * this.members.getStorageSizeBytes() + m.getOffset();
            switch (dataType) {
                case CHAR: 
                case ENUM1: 
                case UBYTE: 
                case BYTE: 
                case BOOLEAN: {
                    byte[] array = new byte[length];
                    for (int count = 0; count < length; ++count) {
                        array[count] = StructureDataStorageBB.this.bbuffer.get(pos + count);
                    }
                    return new ArrayByte(dataType, m.getShape(), (Storage<Byte>)new ArrayByte.StorageS(array));
                }
                case DOUBLE: {
                    double[] darray = new double[length];
                    for (int count = 0; count < length; ++count) {
                        darray[count] = StructureDataStorageBB.this.bbuffer.getDouble(pos + 8 * count);
                    }
                    return new ArrayDouble(m.getShape(), (Storage<Double>)new ArrayDouble.StorageD(darray));
                }
                case FLOAT: {
                    float[] farray = new float[length];
                    for (int count = 0; count < length; ++count) {
                        farray[count] = StructureDataStorageBB.this.bbuffer.getFloat(pos + 4 * count);
                    }
                    return new ArrayFloat(m.getShape(), (Storage<Float>)new ArrayFloat.StorageF(farray));
                }
                case ENUM4: 
                case UINT: 
                case INT: {
                    int[] array = new int[length];
                    for (int count = 0; count < length; ++count) {
                        array[count] = StructureDataStorageBB.this.bbuffer.getInt(pos + 4 * count);
                    }
                    return new ArrayInteger(dataType, m.getShape(), (Storage<Integer>)new ArrayInteger.StorageS(array));
                }
                case ULONG: 
                case LONG: {
                    long[] array = new long[length];
                    for (int count = 0; count < length; ++count) {
                        array[count] = StructureDataStorageBB.this.bbuffer.getLong(pos + 8 * count);
                    }
                    return new ArrayLong(dataType, m.getShape(), (Storage<Long>)new ArrayLong.StorageS(array));
                }
                case ENUM2: 
                case USHORT: 
                case SHORT: {
                    short[] array = new short[length];
                    for (int count = 0; count < length; ++count) {
                        array[count] = StructureDataStorageBB.this.bbuffer.getShort(pos + 2 * count);
                    }
                    return new ArrayShort(dataType, m.getShape(), (Storage<Short>)new ArrayShort.StorageS(array));
                }
                case STRING: {
                    int heapIdx = StructureDataStorageBB.this.bbuffer.getInt(pos);
                    if (heapIdx < 0 || heapIdx >= StructureDataStorageBB.this.heap.size()) {
                        log.warn("getMemberData = {} heapIdx = {} member = {} bo = {}", new Object[]{pos, heapIdx, m.getName(), m.getByteOrder()});
                    }
                    String[] array = (String[])StructureDataStorageBB.this.heap.get(heapIdx);
                    return new ArrayString(m.getShape(), (Storage<String>)new ArrayString.StorageS(array));
                }
                case SEQUENCE: {
                    int heapIdx = StructureDataStorageBB.this.bbuffer.getInt(pos);
                    return (StructureDataArray)StructureDataStorageBB.this.heap.get(heapIdx);
                }
                case STRUCTURE: {
                    if (StructureDataStorageBB.this.structuresOnHeap) {
                        int heapIdx = StructureDataStorageBB.this.bbuffer.getInt(pos);
                        StructureDataArray structArray = (StructureDataArray)StructureDataStorageBB.this.heap.get(heapIdx);
                        return structArray;
                    }
                    StructureMembers nestedMembers = (StructureMembers)Preconditions.checkNotNull((Object)m.getStructureMembers());
                    StructureDataStorageBB nestedStorage = new StructureDataStorageBB(nestedMembers, StructureDataStorageBB.this.bbuffer, length, StructureDataStorageBB.this.heap, pos);
                    return new StructureDataArray(nestedMembers, m.getShape(), (Storage<StructureData>)nestedStorage);
                }
            }
            throw new RuntimeException("unknown dataType " + (Object)((Object)dataType));
        }

        private Array<?> getMemberVlenData(StructureMembers.Member m) {
            StructureDataStorageBB.this.bbuffer.order(m.getByteOrder());
            int pos = StructureDataStorageBB.this.offset + this.recno * this.members.getStorageSizeBytes() + m.getOffset();
            int heapIdx = StructureDataStorageBB.this.bbuffer.getInt(pos);
            return (ArrayVlen)StructureDataStorageBB.this.heap.get(heapIdx);
        }
    }

    private final class Iter
    implements Iterator<StructureData> {
        private int count = 0;

        private Iter() {
        }

        @Override
        public final boolean hasNext() {
            return this.count < StructureDataStorageBB.this.nelems;
        }

        @Override
        public final StructureData next() {
            return new StructureDataBB(this.count++);
        }
    }
}

