/*
 * Decompiled with CFR 0.152.
 */
package ucar.array;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import ucar.array.ArrayType;
import ucar.array.Arrays;
import ucar.ma2.Index;

@Immutable
public final class StructureMembers
implements Iterable<Member> {
    private final String name;
    private final int structureSize;
    private final boolean structuresOnHeap;
    private final ImmutableList<Member> members;

    @Nullable
    public String getName() {
        return this.name;
    }

    public int numberOfMembers() {
        return this.members.size();
    }

    public ImmutableList<Member> getMembers() {
        return ImmutableList.copyOf(this.members);
    }

    public ImmutableList<String> getMemberNames() {
        return (ImmutableList)this.members.stream().map(Member::getName).collect(ImmutableList.toImmutableList());
    }

    public Member getMember(int index) {
        return (Member)this.members.get(index);
    }

    @Nullable
    public Member findMember(String memberName) {
        if (memberName == null) {
            return null;
        }
        return this.members.stream().filter(m -> ((Member)m).name.equals(memberName)).findFirst().orElse(null);
    }

    public int getStorageSizeBytes() {
        return this.structureSize;
    }

    public boolean isStructuresOnHeap() {
        return this.structuresOnHeap;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("members", this.members).add("structureSize", this.structureSize).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StructureMembers that = (StructureMembers)o;
        return this.structureSize == that.structureSize && this.structuresOnHeap == that.structuresOnHeap && Objects.equal((Object)this.name, (Object)that.name) && Objects.equal(this.members, that.members);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.name, this.structureSize, this.structuresOnHeap, this.members});
    }

    @Override
    public Iterator<Member> iterator() {
        return this.members.iterator();
    }

    private StructureMembers(Builder builder) {
        this.name = builder.name == null ? "" : builder.name;
        ImmutableList.Builder list = ImmutableList.builder();
        HashSet<String> nameSet = new HashSet<String>();
        int count = 0;
        for (MemberBuilder mbuilder : builder.members) {
            if (nameSet.contains(mbuilder.name)) {
                throw new IllegalStateException("Duplicate member name in " + this.name);
            }
            nameSet.add(mbuilder.name);
            list.add((Object)mbuilder.build(count++, builder.structuresOnHeap));
        }
        this.members = list.build();
        this.structuresOnHeap = builder.structuresOnHeap;
        this.structureSize = builder.structureSize > 0 ? builder.structureSize : builder.getStorageSizeBytes(builder.structuresOnHeap);
    }

    public Builder toBuilder() {
        Builder b = StructureMembers.builder().setName(this.name).setStructureSize(this.structureSize).setStructuresOnHeap(this.structuresOnHeap);
        this.members.forEach(m -> b.addMember(m.toBuilder()));
        return b;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static MemberBuilder memberBuilder() {
        return new MemberBuilder();
    }

    public static class Builder {
        private String name;
        private final ArrayList<MemberBuilder> members = new ArrayList();
        private int structureSize = -1;
        private boolean structuresOnHeap = false;
        private boolean built;

        private Builder() {
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder addMember(MemberBuilder m) {
            this.members.add(m);
            return this;
        }

        public Builder addMember(int pos, MemberBuilder m) {
            this.members.add(pos, m);
            return this;
        }

        public MemberBuilder addMember(String name, String desc, String units, ArrayType dtype, int[] shape) {
            Preconditions.checkNotNull((Object)name);
            Preconditions.checkNotNull((Object)((Object)dtype));
            MemberBuilder m = new MemberBuilder().setName(name).setDesc(desc).setUnits(units).setArrayType(dtype).setShape(shape);
            this.addMember(m);
            return m;
        }

        public boolean hasMember(String memberName) {
            Preconditions.checkNotNull((Object)memberName);
            for (MemberBuilder mb : this.members) {
                if (!memberName.equals(mb.name)) continue;
                return true;
            }
            return false;
        }

        public List<MemberBuilder> getStructureMembers() {
            return this.members;
        }

        public Builder setStructureSize(int structureSize) {
            this.structureSize = structureSize;
            return this;
        }

        Builder setStructuresOnHeap(boolean structuresOnHeap) {
            this.structuresOnHeap = structuresOnHeap;
            return this;
        }

        public Builder setStandardOffsets(boolean structuresOnHeap) {
            this.structuresOnHeap = structuresOnHeap;
            int offset = 0;
            for (MemberBuilder m : this.members) {
                m.setOffset(offset);
                if (m.dataType == ArrayType.SEQUENCE || m.dataType == ArrayType.STRUCTURE) {
                    m.getStructureMembers().setStandardOffsets(structuresOnHeap);
                }
                offset += m.getStorageSizeBytes(structuresOnHeap);
            }
            this.setStructureSize(offset);
            return this;
        }

        public int getStorageSizeBytes(boolean structuresOnHeap) {
            return this.members.stream().mapToInt(m -> ((MemberBuilder)m).getStorageSizeBytes(structuresOnHeap)).sum();
        }

        public StructureMembers build() {
            if (this.built) {
                throw new IllegalStateException("already built");
            }
            this.built = true;
            return new StructureMembers(this);
        }
    }

    public static class MemberBuilder {
        private String name;
        private String desc;
        private String units;
        private ArrayType dataType;
        private int[] shape;
        private Builder members;
        private ByteOrder byteOrder = ByteOrder.BIG_ENDIAN;
        private int offset = -1;
        private boolean built;

        private MemberBuilder() {
        }

        public MemberBuilder setName(String name) {
            Preconditions.checkNotNull((Object)name);
            this.name = name;
            return this;
        }

        public String getName() {
            return this.name;
        }

        public MemberBuilder setDesc(String desc) {
            this.desc = desc;
            return this;
        }

        public MemberBuilder setUnits(String units) {
            this.units = units;
            return this;
        }

        public MemberBuilder setArrayType(ArrayType dtype) {
            Preconditions.checkNotNull((Object)((Object)dtype));
            this.dataType = dtype;
            return this;
        }

        public MemberBuilder setStructureMembers(Builder members) {
            this.members = members;
            return this;
        }

        public Builder getStructureMembers() {
            return this.members;
        }

        public MemberBuilder setShape(int[] shape) {
            this.shape = (int[])Preconditions.checkNotNull((Object)shape);
            return this;
        }

        public MemberBuilder setByteOrder(ByteOrder byteOrder) {
            this.byteOrder = byteOrder;
            return this;
        }

        public MemberBuilder setOffset(int offset) {
            this.offset = offset;
            return this;
        }

        private int getStorageSizeBytes(boolean structuresOnHeap) {
            int length;
            boolean isVariableLength = this.shape != null && this.shape.length > 0 && this.shape[this.shape.length - 1] < 0;
            int n = length = this.shape == null ? 1 : (int)Arrays.computeSize(this.shape);
            if (isVariableLength) {
                return 4;
            }
            if (this.dataType == ArrayType.OPAQUE) {
                return 4;
            }
            if (this.dataType == ArrayType.SEQUENCE) {
                return 4;
            }
            if (this.dataType == ArrayType.STRING) {
                return 4;
            }
            if (this.dataType == ArrayType.STRUCTURE) {
                return structuresOnHeap ? 4 : length * this.members.getStorageSizeBytes(structuresOnHeap);
            }
            return length * this.dataType.getSize();
        }

        public String toString() {
            return this.name;
        }

        public Member build(int index, boolean structuresOnHeap) {
            if (this.built) {
                throw new IllegalStateException("already built");
            }
            this.built = true;
            return new Member(this, index, structuresOnHeap);
        }
    }

    @Immutable
    public static final class Member {
        private final String name;
        private final String desc;
        private final String units;
        private final ArrayType dataType;
        private final int index;
        private final int length;
        private final int[] shape;
        private final StructureMembers members;
        private final ByteOrder byteOrder;
        private final int offset;
        private final int storageSizeInBytes;
        private final boolean isVlen;

        private Member(MemberBuilder builder, int index, boolean structuresOnHeap) {
            this.index = index;
            this.name = (String)Preconditions.checkNotNull((Object)builder.name);
            this.desc = builder.desc;
            this.units = builder.units;
            this.dataType = (ArrayType)((Object)Preconditions.checkNotNull((Object)((Object)builder.dataType)));
            this.shape = builder.shape != null ? builder.shape : new int[]{};
            this.members = builder.members != null ? builder.members.build() : null;
            this.byteOrder = builder.byteOrder;
            this.offset = builder.offset;
            this.length = (int)Index.computeSize(this.shape);
            this.isVlen = this.dataType != ArrayType.OPAQUE && this.dataType != ArrayType.SEQUENCE && this.shape.length > 0 && this.shape[this.shape.length - 1] < 0;
            this.storageSizeInBytes = builder.getStorageSizeBytes(structuresOnHeap);
        }

        public MemberBuilder toBuilder() {
            MemberBuilder b = new MemberBuilder().setName(this.name).setDesc(this.desc).setUnits(this.units).setArrayType(this.dataType).setShape(this.shape).setByteOrder(this.getByteOrder()).setOffset(this.getOffset());
            if (this.members != null) {
                b.setStructureMembers(this.members.toBuilder());
            }
            return b;
        }

        @Nullable
        public StructureMembers getStructureMembers() {
            return this.members;
        }

        public String getName() {
            return this.name;
        }

        @Nullable
        public String getUnitsString() {
            return this.units;
        }

        @Nullable
        public String getDescription() {
            return this.desc;
        }

        public ArrayType getArrayType() {
            return this.dataType;
        }

        public int getIndex() {
            return this.index;
        }

        public int[] getShape() {
            return this.shape;
        }

        public int length() {
            return this.length;
        }

        public boolean isVlen() {
            return this.isVlen;
        }

        public ByteOrder getByteOrder() {
            return this.byteOrder;
        }

        public int getOffset() {
            return this.offset;
        }

        public int getStorageSizeBytes() {
            return this.storageSizeInBytes;
        }

        public int getStructureSize() {
            Preconditions.checkNotNull((Object)this.members);
            return this.members.getStorageSizeBytes();
        }

        public boolean isScalar() {
            return this.length == 1;
        }

        public String toString() {
            return this.name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Member member = (Member)o;
            return this.index == member.index && this.length == member.length && this.offset == member.offset && this.storageSizeInBytes == member.storageSizeInBytes && this.isVlen == member.isVlen && Objects.equal((Object)this.name, (Object)member.name) && Objects.equal((Object)this.desc, (Object)member.desc) && Objects.equal((Object)this.units, (Object)member.units) && this.dataType == member.dataType && Objects.equal((Object)this.shape, (Object)member.shape) && Objects.equal((Object)this.members, (Object)member.members) && Objects.equal((Object)this.byteOrder, (Object)member.byteOrder);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.name, this.desc, this.units, this.dataType, this.index, this.length, this.shape, this.members, this.byteOrder, this.offset, this.storageSizeInBytes, this.isVlen});
        }
    }
}

