/*
 * Decompiled with CFR 0.152.
 */
package ucar.ma2;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.annotation.concurrent.Immutable;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.RangeIterator;

@Immutable
public class RangeComposite
implements RangeIterator {
    private final ImmutableList<RangeIterator> ranges;
    private final String name;

    public RangeComposite(String name, List<RangeIterator> ranges) {
        this.name = name;
        this.ranges = ImmutableList.copyOf(ranges);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public ImmutableList<RangeIterator> getRanges() {
        return this.ranges;
    }

    @Override
    public RangeIterator copyWithName(String name) {
        if (name.equals(this.getName())) {
            return this;
        }
        return new RangeComposite(name, (List<RangeIterator>)this.ranges);
    }

    @Override
    public RangeIterator copyWithStride(int stride) throws InvalidRangeException {
        ArrayList<RangeIterator> list = new ArrayList<RangeIterator>();
        for (RangeIterator range : this.ranges) {
            list.add(range.copyWithStride(stride));
        }
        return new RangeComposite(this.name, list);
    }

    @Override
    public Iterator<Integer> iterator() {
        ArrayList iters = new ArrayList(this.ranges);
        return new CompositeIterator<Integer>(iters);
    }

    @Override
    public int length() {
        int result = 0;
        for (RangeIterator r : this.ranges) {
            result += r.length();
        }
        return result;
    }

    private static class CompositeIterator<T>
    implements Iterator<T> {
        Iterator<Iterable<T>> iters;
        Iterator<T> current;

        CompositeIterator(Collection<Iterable<T>> iters) {
            this.iters = iters.iterator();
            this.current = this.iters.next().iterator();
        }

        @Override
        public boolean hasNext() {
            if (this.current.hasNext()) {
                return true;
            }
            if (!this.iters.hasNext()) {
                return false;
            }
            this.current = this.iters.next().iterator();
            return this.hasNext();
        }

        @Override
        public T next() {
            return this.current.next();
        }
    }
}

