/*
 * Decompiled with CFR 0.152.
 */
package ucar.ma2;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Formatter;
import java.util.List;
import java.util.StringTokenizer;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import ucar.ma2.Index;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Range;
import ucar.ma2.RangeIterator;

@Immutable
public class Section {
    public static final Section SCALAR = new Section(Range.ONE);
    private final List<Range> ranges;

    public static Section fill(Section s, int[] shape) throws InvalidRangeException {
        if (s == null) {
            return new Section(shape);
        }
        if (shape.length == 0 && s.equals(SCALAR)) {
            return s;
        }
        String errs = s.checkInRange(shape);
        if (errs != null) {
            throw new InvalidRangeException(errs);
        }
        boolean ok = true;
        for (int i = 0; i < shape.length; ++i) {
            ok &= s.getRange(i) != null;
        }
        if (ok) {
            return s;
        }
        return new Section(s.getRanges(), shape);
    }

    public static Section make(List<RangeIterator> rangeIter) {
        ArrayList<Range> ranges = new ArrayList<Range>();
        for (RangeIterator iter : rangeIter) {
            if (iter instanceof Range) {
                ranges.add((Range)iter);
                continue;
            }
            throw new IllegalArgumentException("Can deal with non Range yet");
        }
        return new Section(ranges);
    }

    public Section(int[] shape) {
        ArrayList<Range> builder = new ArrayList<Range>();
        for (int aShape : shape) {
            if (aShape > 0) {
                builder.add(new Range(aShape));
                continue;
            }
            if (aShape == 0) {
                builder.add(Range.EMPTY);
                continue;
            }
            builder.add(Range.VLEN);
        }
        this.ranges = Collections.unmodifiableList(builder);
    }

    public Section(int[] origin, int[] shape) throws InvalidRangeException {
        ArrayList<Range> builder = new ArrayList<Range>();
        for (int i = 0; i < shape.length; ++i) {
            if (shape[i] > 0) {
                builder.add(new Range(origin[i], origin[i] + shape[i] - 1));
                continue;
            }
            if (shape[i] == 0) {
                builder.add(Range.EMPTY);
                continue;
            }
            builder.add(Range.VLEN);
        }
        this.ranges = Collections.unmodifiableList(builder);
    }

    public Section(int[] origin, int[] size, int[] stride) throws InvalidRangeException {
        ArrayList<Range> builder = new ArrayList<Range>();
        for (int i = 0; i < size.length; ++i) {
            if (size[i] > 0) {
                builder.add(new Range(origin[i], origin[i] + size[i] - 1, stride[i]));
                continue;
            }
            if (size[i] == 0) {
                builder.add(Range.EMPTY);
                continue;
            }
            builder.add(Range.VLEN);
        }
        this.ranges = Collections.unmodifiableList(builder);
    }

    public Section(List<Range> from) {
        this.ranges = Collections.unmodifiableList(new ArrayList<Range>(from));
    }

    public Section(Range ... ranges) {
        this.ranges = Collections.unmodifiableList(Arrays.asList(ranges));
    }

    public Section(List<Range> from, int[] shape) throws InvalidRangeException {
        if (shape.length != from.size()) {
            throw new InvalidRangeException(" shape[] must have same rank as list of ranges");
        }
        ArrayList<Range> builder = new ArrayList<Range>();
        for (int i = 0; i < shape.length; ++i) {
            Range r = from.get(i);
            if (r == null) {
                if (shape[i] > 0) {
                    builder.add(new Range(shape[i]));
                    continue;
                }
                if (shape[i] == 0) {
                    builder.add(Range.EMPTY);
                    continue;
                }
                builder.add(Range.VLEN);
                continue;
            }
            builder.add(r);
        }
        this.ranges = Collections.unmodifiableList(builder);
    }

    public Section(String sectionSpec) throws InvalidRangeException {
        ArrayList<Range> builder = new ArrayList<Range>();
        StringTokenizer stoke = new StringTokenizer(sectionSpec, "(),");
        while (stoke.hasMoreTokens()) {
            Range range;
            String s = stoke.nextToken().trim();
            if (s.equals(":")) {
                range = null;
            } else {
                if (s.indexOf(58) < 0) {
                    try {
                        int index = Integer.parseInt(s);
                        range = new Range(index, index);
                    }
                    catch (NumberFormatException e) {
                        throw new IllegalArgumentException(" illegal selector: " + s + " part of <" + sectionSpec + ">");
                    }
                }
                StringTokenizer stoke2 = new StringTokenizer(s, ":");
                String s1 = stoke2.nextToken();
                String s2 = stoke2.nextToken();
                String s3 = stoke2.hasMoreTokens() ? stoke2.nextToken() : null;
                try {
                    int index1 = Integer.parseInt(s1);
                    int index2 = Integer.parseInt(s2);
                    int stride = s3 != null ? Integer.parseInt(s3) : 1;
                    range = new Range(index1, index2, stride);
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException(" illegal selector: " + s + " part of <" + sectionSpec + ">");
                }
            }
            builder.add(range);
        }
        this.ranges = Collections.unmodifiableList(builder);
    }

    public Section compact() throws InvalidRangeException {
        ArrayList<Range> results = new ArrayList<Range>(this.getRank());
        for (Range r : this.ranges) {
            results.add(r.compact());
        }
        return new Section(results);
    }

    public Section compose(Section want) throws InvalidRangeException {
        if (want == null) {
            return this;
        }
        if (want.getRank() != this.getRank()) {
            throw new InvalidRangeException("Invalid Section rank");
        }
        ArrayList<Range> results = new ArrayList<Range>(this.getRank());
        for (int j = 0; j < this.ranges.size(); ++j) {
            Range base = this.ranges.get(j);
            Range r = want.getRange(j);
            if (r == null) {
                results.add(base);
                continue;
            }
            results.add(base.compose(r));
        }
        return new Section(results);
    }

    public Section intersect(Section other) throws InvalidRangeException {
        if (!this.compatibleRank(other)) {
            throw new InvalidRangeException("Invalid Section rank");
        }
        ArrayList<Range> results = new ArrayList<Range>(this.getRank());
        for (int j = 0; j < this.ranges.size(); ++j) {
            Range base = this.ranges.get(j);
            Range r = other.getRange(j);
            results.add(base.intersect(r));
        }
        return new Section(results);
    }

    public int offset(Section intersect) throws InvalidRangeException {
        if (!this.compatibleRank(intersect)) {
            throw new InvalidRangeException("Incompatible Section rank");
        }
        int result = 0;
        int stride = 1;
        for (int j = this.ranges.size() - 1; j >= 0; --j) {
            Range base = this.ranges.get(j);
            Range r = intersect.getRange(j);
            int offset = base.index(r.first());
            result += offset * stride;
            stride *= base.length();
        }
        return result;
    }

    public Section union(Section other) throws InvalidRangeException {
        if (other.getRank() != this.getRank()) {
            throw new InvalidRangeException("Invalid Section rank");
        }
        ArrayList<Range> results = new ArrayList<Range>(this.getRank());
        for (int j = 0; j < this.ranges.size(); ++j) {
            Range base = this.ranges.get(j);
            Range r = other.getRange(j);
            results.add(base.union(r));
        }
        return new Section(results);
    }

    public Section shiftOrigin(Section newOrigin) throws InvalidRangeException {
        if (newOrigin.getRank() != this.getRank()) {
            throw new InvalidRangeException("Invalid Section rank");
        }
        ArrayList<Range> results = new ArrayList<Range>(this.getRank());
        for (int j = 0; j < this.ranges.size(); ++j) {
            Range base = this.ranges.get(j);
            Range r = newOrigin.getRange(j);
            results.add(base.shiftOrigin(r.first()));
        }
        return new Section(results);
    }

    public Section shiftOrigin(int[] newOrigin) throws InvalidRangeException {
        if (newOrigin.length != this.getRank()) {
            throw new InvalidRangeException("Invalid Section rank");
        }
        ArrayList<Range> results = new ArrayList<Range>(this.getRank());
        for (int j = 0; j < this.ranges.size(); ++j) {
            Range base = this.ranges.get(j);
            results.add(base.shiftOrigin(-newOrigin[j]));
        }
        return new Section(results);
    }

    public boolean intersects(Section other) throws InvalidRangeException {
        if (!this.compatibleRank(other)) {
            throw new InvalidRangeException("Invalid Section rank");
        }
        for (int j = 0; j < this.ranges.size(); ++j) {
            Range base = this.ranges.get(j);
            Range r = other.getRange(j);
            if (base == Range.VLEN || r == Range.VLEN || base.intersects(r)) continue;
            return false;
        }
        return true;
    }

    public boolean contains(Section other) {
        if (other.getRank() != this.getRank()) {
            return false;
        }
        for (int j = 0; j < this.ranges.size(); ++j) {
            Range base = this.ranges.get(j);
            Range r = other.getRange(j);
            if (base.first() > r.first()) {
                return false;
            }
            if (base.last() >= r.last()) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        Formatter sbuff = new Formatter();
        for (int i = 0; i < this.ranges.size(); ++i) {
            Range r = this.ranges.get(i);
            if (i > 0) {
                sbuff.format(",", new Object[0]);
            }
            if (r == null) {
                sbuff.format(":", new Object[0]);
                continue;
            }
            sbuff.format("%s", r.toString());
        }
        return sbuff.toString();
    }

    public String show() {
        Formatter sbuff = new Formatter();
        for (int i = 0; i < this.ranges.size(); ++i) {
            Range r = this.ranges.get(i);
            if (i > 0) {
                sbuff.format("%n", new Object[0]);
            }
            if (r == null) {
                sbuff.format(":", new Object[0]);
                continue;
            }
            if (r.getName() != null) {
                sbuff.format("%s=", r.getName());
            }
            sbuff.format("%s", r.toString());
        }
        return sbuff.toString();
    }

    public Section() {
        this.ranges = new ArrayList<Range>();
    }

    public Section reduce() {
        boolean needed = false;
        for (Range r2 : this.ranges) {
            if (r2.length() != 1) continue;
            needed = true;
        }
        if (!needed) {
            return this;
        }
        List<Range> newList = this.ranges.stream().filter(r -> r.length() > 1).collect(Collectors.toList());
        return new Section(newList);
    }

    public Section subSection(int fromIndex, int endExclusive) {
        return new Section(this.ranges.subList(fromIndex, endExclusive));
    }

    @Deprecated
    public Section removeLast() {
        int size = this.ranges.size();
        return this.subSection(size - 2, size - 1);
    }

    @Deprecated
    public Section removeVlen() {
        int size = this.ranges.size();
        if (this.ranges.get(size - 1) == Range.VLEN) {
            return this.removeLast();
        }
        return this;
    }

    public Section removeFirst(Section parentSection) {
        int parentSize = parentSection.getRank();
        assert (parentSize <= this.ranges.size());
        if (parentSize == this.ranges.size()) {
            return new Section();
        }
        return this.subSection(parentSize, this.ranges.size());
    }

    public Section prepend(Section parentSection) {
        if (parentSection == null) {
            return this;
        }
        ArrayList<Range> ranges = new ArrayList<Range>(parentSection.getRanges());
        ranges.addAll(this.getRanges());
        return new Section(ranges);
    }

    public boolean isVariableLength() {
        for (Range aFrom : this.ranges) {
            if (aFrom != Range.VLEN) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    public boolean isStrided() {
        for (Range r : this.ranges) {
            if (r == null || r.stride() == 1) continue;
            return false;
        }
        return true;
    }

    public int[] getShape() {
        int[] result = new int[this.ranges.size()];
        for (int i = 0; i < this.ranges.size(); ++i) {
            result[i] = this.ranges.get(i).length();
        }
        return result;
    }

    public int[] getOrigin() {
        int[] result = new int[this.ranges.size()];
        for (int i = 0; i < this.ranges.size(); ++i) {
            result[i] = this.ranges.get(i).first();
        }
        return result;
    }

    public int[] getStride() {
        int[] result = new int[this.ranges.size()];
        for (int i = 0; i < this.ranges.size(); ++i) {
            result[i] = this.ranges.get(i).stride();
        }
        return result;
    }

    public int getOrigin(int i) {
        return this.ranges.get(i).first();
    }

    public int getShape(int i) {
        return this.ranges.get(i).length();
    }

    public int getStride(int i) {
        return this.ranges.get(i).stride();
    }

    public long getSize() {
        return Index.computeSize(this.getShape());
    }

    public int getRank() {
        return this.ranges.size();
    }

    public boolean compatibleRank(Section other) {
        return this.getRank() == other.getRank();
    }

    public long computeSize() {
        long product = 1L;
        for (Range r : this.ranges) {
            if (r == Range.VLEN) continue;
            product *= (long)r.length();
        }
        return product;
    }

    public static long computeSize(int[] shape) {
        long product = 1L;
        for (int len : shape) {
            product *= (long)len;
        }
        return product;
    }

    public List<Range> getRanges() {
        return this.ranges;
    }

    public Range getRange(int i) {
        return this.ranges.get(i);
    }

    @Nullable
    public Range find(String rangeName) {
        for (Range r : this.ranges) {
            if (!rangeName.equals(r.getName())) continue;
            return r;
        }
        return null;
    }

    public String checkInRange(int[] shape) {
        if (this.ranges.size() != shape.length) {
            return "Number of ranges in section (" + this.ranges.size() + ") must be = " + shape.length;
        }
        for (int i = 0; i < this.ranges.size(); ++i) {
            Range r = this.ranges.get(i);
            if (r == null || r == Range.VLEN) continue;
            if (r == Range.EMPTY) {
                if (shape[i] == 0) continue;
                return "Illegal Range for dimension " + i + ": empty range only for unlimited dimension len = 0";
            }
            if (r.last() < shape[i]) continue;
            return "Illegal Range for dimension " + i + ": last requested " + r.last() + " > max " + (shape[i] - 1);
        }
        return null;
    }

    public boolean equivalent(int[] shape) throws InvalidRangeException {
        if (this.getRank() != shape.length) {
            throw new InvalidRangeException("Invalid Section rank");
        }
        for (int i = 0; i < this.ranges.size(); ++i) {
            Range r = this.ranges.get(i);
            if (r == null) continue;
            if (r.first() != 0) {
                return false;
            }
            if (r.length() == shape[i]) continue;
            return false;
        }
        return true;
    }

    public boolean conformal(Section other) {
        if (this.computeSize() != other.computeSize()) {
            return false;
        }
        Section reduceThis = this.reduce();
        Section reduceOther = other.reduce();
        return reduceThis.equalShape(reduceOther);
    }

    public boolean equalShape(Section other) {
        if (this.computeSize() != other.computeSize()) {
            return false;
        }
        if (this.getRank() != other.getRank()) {
            return false;
        }
        for (int i = 0; i < this.getRank(); ++i) {
            Range r = this.getRange(i);
            Range or = other.getRange(i);
            if (r.length() == or.length()) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Section)) {
            return false;
        }
        Section os = (Section)o;
        if (this.getRank() != os.getRank()) {
            return false;
        }
        for (int i = 0; i < this.getRank(); ++i) {
            Range r = this.getRange(i);
            Range or = os.getRange(i);
            if (r == null && or != null) {
                return false;
            }
            if (or == null && r != null) {
                return false;
            }
            if (r == null || r.equals(or)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = 17;
        for (Range r : this.ranges) {
            if (r == null) continue;
            result += 37 * result + r.hashCode();
        }
        return result;
    }

    public Iterator getIterator(int[] shape) {
        return new Iterator(shape);
    }

    public Builder toBuilder() {
        return new Builder().appendRanges(this.getRanges());
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        List<Range> ranges = new ArrayList<Range>();

        public Builder appendRangeAll() {
            this.ranges.add(null);
            return this;
        }

        public Builder appendRange(Range range) {
            this.ranges.add(range);
            return this;
        }

        public Builder appendRange(int size) {
            if (size > 0) {
                this.ranges.add(new Range(size));
            } else if (size == 0) {
                this.ranges.add(Range.EMPTY);
            } else {
                this.ranges.add(Range.VLEN);
            }
            return this;
        }

        public Builder appendRange(int first, int last) throws InvalidRangeException {
            if (last < 0) {
                this.ranges.add(Range.VLEN);
            } else {
                this.ranges.add(new Range(first, last));
            }
            return this;
        }

        public Builder appendRange(int first, int last, int stride) throws InvalidRangeException {
            if (last < 0) {
                this.ranges.add(Range.VLEN);
            } else {
                this.ranges.add(new Range(first, last, stride));
            }
            return this;
        }

        public Builder appendRange(String name, int first, int last, int stride) throws InvalidRangeException {
            if (last < 0) {
                this.ranges.add(Range.VLEN);
            } else {
                this.ranges.add(new Range(name, first, last, stride));
            }
            return this;
        }

        public Builder appendRanges(List<Range> ranges) {
            this.ranges.addAll(ranges);
            return this;
        }

        public Builder appendRanges(int[] shape) {
            for (int aShape : shape) {
                if (aShape > 0) {
                    this.ranges.add(new Range(aShape));
                    continue;
                }
                if (aShape == 0) {
                    this.ranges.add(Range.EMPTY);
                    continue;
                }
                this.ranges.add(Range.VLEN);
            }
            return this;
        }

        public Builder insertRange(int index, Range r) {
            this.ranges.add(index, r);
            return this;
        }

        public Builder removeRange(int index) {
            this.ranges.remove(index);
            return this;
        }

        public Builder replaceRange(int index, Range r) {
            this.ranges.set(index, r);
            return this;
        }

        public Builder setRange(int index, Range r) {
            this.ranges.set(index, r);
            return this;
        }

        public Builder removeLast() {
            int size = this.ranges.size();
            if (size > 0) {
                this.ranges.remove(size - 1);
            }
            return this;
        }

        public Builder removeFirst(int n) {
            assert (n <= this.ranges.size());
            this.ranges = this.ranges.subList(n, this.ranges.size());
            return this;
        }

        public Builder removeVlen() {
            int size = this.ranges.size();
            if (this.ranges.get(size - 1) == Range.VLEN) {
                this.ranges.remove(size - 1);
            }
            return this;
        }

        public Section build() {
            return new Section(this.ranges);
        }
    }

    public class Iterator {
        private final int[] odo;
        private final List<java.util.Iterator<Integer>> rangeIterList;
        private final int[] stride;
        private final long total;
        private long done;

        Iterator(int[] shape) {
            int i;
            this.odo = new int[Section.this.getRank()];
            this.rangeIterList = new ArrayList<java.util.Iterator<Integer>>();
            this.stride = new int[Section.this.getRank()];
            int ss = 1;
            for (i = Section.this.getRank() - 1; i >= 0; --i) {
                this.stride[i] = ss;
                ss *= shape[i];
            }
            for (i = 0; i < Section.this.getRank(); ++i) {
                java.util.Iterator<Integer> iter = Section.this.getRange(i).iterator();
                this.odo[i] = iter.next();
                this.rangeIterList.add(iter);
            }
            this.done = 0L;
            this.total = Index.computeSize(Section.this.getShape());
        }

        public boolean hasNext() {
            return this.done < this.total;
        }

        public int next(int[] index) {
            int next = this.currentElement();
            if (index != null) {
                System.arraycopy(this.odo, 0, index, 0, this.odo.length);
            }
            ++this.done;
            if (this.done < this.total) {
                this.incr();
            }
            return next;
        }

        private void incr() {
            int digit = Section.this.getRank() - 1;
            while (digit >= 0) {
                java.util.Iterator<Integer> iter = this.rangeIterList.get(digit);
                if (iter.hasNext()) {
                    this.odo[digit] = iter.next();
                    break;
                }
                java.util.Iterator<Integer> iterReset = Section.this.getRange(digit).iterator();
                this.odo[digit] = iterReset.next();
                this.rangeIterList.set(digit, iterReset);
                assert (--digit >= 0);
            }
        }

        private int currentElement() {
            int value = 0;
            for (int ii = 0; ii < Section.this.getRank(); ++ii) {
                value += this.odo[ii] * this.stride[ii];
            }
            return value;
        }
    }
}

