/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.Formatter;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import ucar.array.Array;
import ucar.array.ArrayType;
import ucar.array.Arrays;
import ucar.array.ArraysConvert;
import ucar.ma2.DataType;
import ucar.nc2.EnumTypedef;
import ucar.nc2.NetcdfFiles;
import ucar.unidata.util.Parameter;
import ucar.unidata.util.StringUtil2;

@Immutable
public class Attribute {
    private static final char[] org = new char[]{'\b', '\f', '\n', '\r', '\t', '\\', '\'', '\"'};
    private static final String[] replace = new String[]{"\\b", "\\f", "\\n", "\\r", "\\t", "\\\\", "\\'", "\\\""};
    private final String name;
    private final ArrayType dataType;
    @Nullable
    private final String svalue;
    @Nullable
    private final Number nvalue;
    @Nullable
    private final EnumTypedef enumtype;
    @Nullable
    private final Array<?> values;
    private final int nelems;

    public static Attribute fromParameter(Parameter param) {
        Preconditions.checkNotNull((Object)param);
        Builder b = Attribute.builder(param.getName());
        if (param.isString()) {
            b.setStringValue(param.getStringValue());
        } else {
            double[] values = param.getNumericValues();
            assert (values != null);
            int n = values.length;
            Array vala = Arrays.factory(ArrayType.DOUBLE, new int[]{n}, values);
            b.setArrayValues(vala);
        }
        return b.build();
    }

    public static Parameter toParameter(Attribute att) {
        Preconditions.checkNotNull((Object)att);
        if (att.isString()) {
            return new Parameter(att.getShortName(), att.getStringValue());
        }
        if (att.getLength() == 1) {
            return new Parameter(att.getShortName(), att.getNumericValue().doubleValue());
        }
        double[] values = new double[att.getLength()];
        for (int idx = 0; idx < att.getLength(); ++idx) {
            values[idx] = att.getNumericValue(idx).doubleValue();
        }
        return new Parameter(att.getShortName(), values);
    }

    @Deprecated
    public static Attribute fromArray(String name, ucar.ma2.Array values) {
        return Attribute.builder(name).setValues(values).build();
    }

    public static Attribute fromArray(String name, Array<?> values) {
        return Attribute.builder(name).setArrayValues(values).build();
    }

    @Deprecated
    public static Attribute emptyValued(String name, DataType dtype) {
        return Attribute.builder(name).setDataType(dtype).build();
    }

    public static Attribute emptyValued(String name, ArrayType dtype) {
        return Attribute.builder(name).setArrayType(dtype).build();
    }

    public Attribute(String name, @Nullable String val) {
        Preconditions.checkNotNull((Object)Strings.emptyToNull((String)name), (Object)"Attribute name cannot be empty or null");
        this.name = NetcdfFiles.makeValidCdmObjectName(name);
        this.dataType = ArrayType.STRING;
        this.nelems = 1;
        this.svalue = Attribute.stripZeroes(val);
        this.enumtype = null;
        this.nvalue = null;
        this.values = null;
    }

    public Attribute(String name, Number val) {
        Preconditions.checkNotNull((Object)Strings.emptyToNull((String)name), (Object)"Attribute name cannot be empty or null");
        Preconditions.checkNotNull((Object)val, (Object)"Attribute value cannot be null");
        this.name = name;
        this.dataType = ArrayType.forPrimitiveClass(val.getClass(), false);
        this.nvalue = val;
        this.enumtype = null;
        this.svalue = null;
        this.values = null;
        this.nelems = 1;
    }

    @Deprecated
    public DataType getDataType() {
        return this.dataType.getDataType();
    }

    public ArrayType getArrayType() {
        return this.dataType;
    }

    @Nullable
    public EnumTypedef getEnumType() {
        return this.enumtype;
    }

    public int getLength() {
        return this.nelems;
    }

    public String getName() {
        return this.name;
    }

    @Nullable
    public Number getNumericValue() {
        return this.getNumericValue(0);
    }

    @Nullable
    public Number getNumericValue(int index) {
        if (index < 0 || index >= this.nelems) {
            return null;
        }
        if (this.dataType == ArrayType.STRING) {
            String svalue = (String)Preconditions.checkNotNull((Object)this.getStringValue(index));
            try {
                return Double.parseDouble(svalue);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        if (this.nvalue != null && index == 0) {
            return this.nvalue;
        }
        Preconditions.checkNotNull(this.values);
        switch (this.dataType) {
            case BYTE: 
            case UBYTE: {
                return (Byte)this.values.get(index);
            }
            case SHORT: 
            case USHORT: {
                return (Short)this.values.get(index);
            }
            case INT: 
            case UINT: {
                return (Integer)this.values.get(index);
            }
            case FLOAT: {
                return (Float)this.values.get(index);
            }
            case DOUBLE: {
                return (Double)this.values.get(index);
            }
            case LONG: 
            case ULONG: {
                return (Long)this.values.get(index);
            }
        }
        return null;
    }

    public String getShortName() {
        return this.name;
    }

    @Nullable
    public String getStringValue() {
        if (this.dataType != ArrayType.STRING) {
            return null;
        }
        return this.svalue != null ? this.svalue : this._getStringValue(0);
    }

    @Nullable
    public String getStringValue(int index) {
        if (this.dataType != ArrayType.STRING) {
            return null;
        }
        if (this.svalue != null && index == 0) {
            return this.svalue;
        }
        return this._getStringValue(index);
    }

    private String _getStringValue(int index) {
        if (index < 0 || index >= this.nelems || this.values == null) {
            return null;
        }
        return (String)this.values.get(index);
    }

    @Nullable
    public Object getValue(int index) {
        if (this.isString()) {
            return this.getStringValue(index);
        }
        return this.getNumericValue(index);
    }

    @Nullable
    public ucar.ma2.Array getValues() {
        Array<?> arrayValues = this.getArrayValues();
        return arrayValues == null ? null : ArraysConvert.convertFromArray(arrayValues);
    }

    @Nullable
    public Array<?> getArrayValues() {
        if (this.svalue != null) {
            return Arrays.factory(ArrayType.STRING, new int[]{1}, new String[]{this.svalue});
        }
        if (this.nvalue != null) {
            ucar.ma2.Array values = ucar.ma2.Array.factory(this.dataType.getDataType(), new int[]{1});
            values.setObject(values.getIndex(), (Object)this.nvalue);
            return ArraysConvert.convertToArray(values);
        }
        return this.values;
    }

    public boolean isArray() {
        return this.getLength() > 1;
    }

    public boolean isString() {
        return this.dataType == ArrayType.STRING && null != this.getStringValue();
    }

    public String toString() {
        Formatter f = new Formatter();
        this.writeCDL(f, false, null);
        return f.toString();
    }

    void writeCDL(Formatter f, boolean strict, String parentname) {
        if (strict && (this.isString() || this.getEnumType() != null)) {
            f.format("string ", new Object[0]);
        }
        if (strict && parentname != null) {
            f.format(NetcdfFiles.makeValidCDLName(parentname), new Object[0]);
        }
        f.format(":", new Object[0]);
        f.format("%s", strict ? NetcdfFiles.makeValidCDLName(this.getShortName()) : this.getShortName());
        if (this.isString()) {
            f.format(" = ", new Object[0]);
            for (int i = 0; i < this.getLength(); ++i) {
                String val;
                if (i != 0) {
                    f.format(", ", new Object[0]);
                }
                if ((val = this.getStringValue(i)) == null) continue;
                f.format("\"%s\"", Attribute.encodeString(val));
            }
        } else if (this.getEnumType() != null) {
            f.format(" = ", new Object[0]);
            for (int i = 0; i < this.getLength(); ++i) {
                String ecname;
                if (i != 0) {
                    f.format(", ", new Object[0]);
                }
                EnumTypedef en = this.getEnumType();
                Integer intValue = (Integer)this.getValue(i);
                String string = ecname = intValue == null ? "" : en.lookupEnumString(intValue);
                if (ecname == null) {
                    ecname = Integer.toString(intValue);
                }
                f.format("\"%s\"", Attribute.encodeString(ecname));
            }
        } else {
            f.format(" = ", new Object[0]);
            for (int i = 0; i < this.getLength(); ++i) {
                if (i != 0) {
                    f.format(", ", new Object[0]);
                }
                Number number = this.getNumericValue(i);
                if (this.dataType.isUnsigned()) {
                    number = ArrayType.widenNumber(number);
                }
                f.format("%s", number);
                if (this.dataType.isUnsigned()) {
                    f.format("U", new Object[0]);
                }
                if (this.dataType == ArrayType.FLOAT) {
                    f.format("f", new Object[0]);
                    continue;
                }
                if (this.dataType == ArrayType.SHORT || this.dataType == ArrayType.USHORT) {
                    f.format("S", new Object[0]);
                    continue;
                }
                if (this.dataType == ArrayType.BYTE || this.dataType == ArrayType.UBYTE) {
                    f.format("B", new Object[0]);
                    continue;
                }
                if (this.dataType != ArrayType.LONG && this.dataType != ArrayType.ULONG) continue;
                f.format("L", new Object[0]);
            }
        }
    }

    private static String encodeString(String s) {
        return StringUtil2.replace(s, org, replace);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Attribute)) {
            return false;
        }
        Attribute att = (Attribute)o;
        String name = this.getShortName();
        if (!name.equals(att.getShortName())) {
            return false;
        }
        if (this.nelems != att.nelems) {
            return false;
        }
        if (this.dataType != att.dataType) {
            return false;
        }
        if (this.isString()) {
            return att.getStringValue().equals(this.getStringValue());
        }
        if (this.nvalue != null) {
            return this.nvalue.equals(att.nvalue);
        }
        if (this.values != null) {
            for (int i = 0; i < this.getLength(); ++i) {
                int r2;
                int r1 = this.isString() ? this.getStringValue(i).hashCode() : this.getNumericValue(i).hashCode();
                int n = r2 = att.isString() ? att.getStringValue(i).hashCode() : att.getNumericValue(i).hashCode();
                if (r1 == r2) continue;
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + this.getShortName().hashCode();
        result = 37 * result + this.nelems;
        result = 37 * result + this.getDataType().hashCode();
        if (this.svalue != null) {
            result = 37 * result + this.svalue.hashCode();
        } else if (this.nvalue != null) {
            result = 37 * result + this.nvalue.hashCode();
        } else if (this.values != null) {
            for (int i = 0; i < this.getLength(); ++i) {
                int h = this.isString() ? this.getStringValue(i).hashCode() : this.getNumericValue(i).hashCode();
                result = 37 * result + h;
            }
        }
        return result;
    }

    private static String stripZeroes(String s) {
        int len;
        if (s == null) {
            return null;
        }
        for (len = s.length(); len > 0 && s.charAt(len - 1) == '\u0000'; --len) {
        }
        if (len != s.length()) {
            s = s.substring(0, len);
        }
        return s;
    }

    private Attribute(Builder builder) {
        this.name = builder.name;
        this.svalue = Attribute.stripZeroes(builder.svalue);
        this.nvalue = builder.nvalue;
        this.dataType = builder.dataType;
        this.enumtype = builder.enumtype;
        this.values = builder.values;
        this.nelems = this.svalue != null || this.nvalue != null ? 1 : (this.values != null ? (int)this.values.length() : builder.nelems);
    }

    public Builder toBuilder() {
        Builder b = Attribute.builder().setName(this.name).setArrayType(this.dataType).setEnumType(this.enumtype);
        if (this.svalue != null) {
            b.setStringValue(this.svalue);
        } else if (this.nvalue != null) {
            b.setNumericValue(this.nvalue, this.dataType.isUnsigned());
        } else if (this.values != null) {
            b.setArrayValues(this.values);
        }
        return b;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String name) {
        return new Builder().setName(name);
    }

    public static class Builder {
        private String name;
        private ArrayType dataType = ArrayType.STRING;
        private String svalue;
        private Number nvalue;
        private Array<?> values;
        private int nelems;
        private EnumTypedef enumtype;
        private boolean built;

        private Builder() {
        }

        public Builder setName(String name) {
            Preconditions.checkNotNull((Object)Strings.emptyToNull((String)name), (Object)"Attribute name cannot be empty or null");
            this.name = NetcdfFiles.makeValidCdmObjectName(name);
            return this;
        }

        @Deprecated
        public Builder setDataType(DataType dataType) {
            this.dataType = dataType.getArrayType();
            return this;
        }

        public Builder setArrayType(ArrayType dataType) {
            this.dataType = dataType;
            return this;
        }

        public Builder setEnumType(EnumTypedef enumtype) {
            this.enumtype = enumtype;
            return this;
        }

        public Builder setNumericValue(Number val, boolean isUnsigned) {
            Preconditions.checkNotNull((Object)val, (Object)"Attribute value cannot be null");
            this.nvalue = val;
            this.nelems = 1;
            this.dataType = ArrayType.forPrimitiveClass(val.getClass(), isUnsigned);
            return this;
        }

        public Builder setStringValue(String svalue) {
            Preconditions.checkNotNull((Object)svalue, (Object)"Attribute value cannot be null");
            this.svalue = svalue;
            this.nelems = 1;
            this.dataType = ArrayType.STRING;
            return this;
        }

        public Builder setValues(List<Object> values, boolean unsigned) {
            Object[] pa;
            if (values == null || values.isEmpty()) {
                throw new IllegalArgumentException("values may not be null or empty");
            }
            int n = values.size();
            Class<?> c = values.get(0).getClass();
            if (c == String.class) {
                String[] va;
                this.dataType = ArrayType.STRING;
                pa = va = new String[n];
                for (int i = 0; i < n; ++i) {
                    va[i] = Attribute.stripZeroes((String)values.get(i));
                }
            } else if (c == Integer.class) {
                this.dataType = unsigned ? ArrayType.UINT : ArrayType.INT;
                int[] va = new int[n];
                pa = va;
                for (int i = 0; i < n; ++i) {
                    va[i] = (Integer)values.get(i);
                }
            } else if (c == Double.class) {
                this.dataType = ArrayType.DOUBLE;
                double[] va = new double[n];
                pa = va;
                for (int i = 0; i < n; ++i) {
                    va[i] = (Double)values.get(i);
                }
            } else if (c == Float.class) {
                this.dataType = ArrayType.FLOAT;
                float[] va = new float[n];
                pa = va;
                for (int i = 0; i < n; ++i) {
                    va[i] = ((Float)values.get(i)).floatValue();
                }
            } else if (c == Short.class) {
                this.dataType = unsigned ? ArrayType.USHORT : ArrayType.SHORT;
                short[] va = new short[n];
                pa = va;
                for (int i = 0; i < n; ++i) {
                    va[i] = (Short)values.get(i);
                }
            } else if (c == Byte.class) {
                this.dataType = unsigned ? ArrayType.UBYTE : ArrayType.BYTE;
                byte[] va = new byte[n];
                pa = va;
                for (int i = 0; i < n; ++i) {
                    va[i] = (Byte)values.get(i);
                }
            } else if (c == Long.class) {
                this.dataType = unsigned ? ArrayType.ULONG : ArrayType.LONG;
                long[] va = new long[n];
                pa = va;
                for (int i = 0; i < n; ++i) {
                    va[i] = (Long)values.get(i);
                }
            } else {
                throw new IllegalArgumentException("Unknown type for Attribute = " + c.getName());
            }
            return this.setArrayValues(Arrays.factory(this.dataType, new int[]{n}, pa));
        }

        @Deprecated
        public Builder setValues(ucar.ma2.Array arr) {
            if (arr == null) {
                this.dataType = ArrayType.STRING;
                return this;
            }
            this.setArrayValues(ArraysConvert.convertToArray(arr));
            return this;
        }

        public Builder setArrayValues(Array<?> arr) {
            if (arr == null) {
                this.dataType = ArrayType.STRING;
                return this;
            }
            if (arr.getArrayType() == ArrayType.CHAR) {
                if (arr.getRank() < 2) {
                    this.svalue = Arrays.makeStringFromChar(arr);
                    this.nelems = 1;
                    this.dataType = ArrayType.STRING;
                    return this;
                }
                arr = Arrays.makeStringsFromChar(arr);
            }
            if (arr.length() == 1L) {
                if (arr.getArrayType().isNumeric()) {
                    this.nvalue = (Number)arr.getScalar();
                    this.nelems = 1;
                    this.dataType = arr.getArrayType();
                    return this;
                }
                if (arr.getArrayType() == ArrayType.STRING) {
                    this.svalue = (String)arr.getScalar();
                    this.nelems = 1;
                    this.dataType = arr.getArrayType();
                    return this;
                }
            }
            if (arr.getRank() > 1) {
                arr = Arrays.reshape(arr, new int[]{(int)arr.length()});
            }
            this.values = arr;
            this.nelems = (int)arr.length();
            this.dataType = arr.getArrayType();
            return this;
        }

        public Attribute build() {
            if (this.built) {
                throw new IllegalStateException("already built");
            }
            this.built = true;
            return new Attribute(this);
        }
    }
}

