/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2;

import java.util.ArrayList;
import java.util.Iterator;
import javax.annotation.Nullable;
import ucar.nc2.Attribute;
import ucar.nc2.AttributeContainerMutable;

public interface AttributeContainer
extends Iterable<Attribute> {
    public static AttributeContainer filter(AttributeContainer atts, String ... remove) {
        ArrayList<Attribute> result = new ArrayList<Attribute>();
        for (Attribute att : atts) {
            boolean ok = true;
            for (String s : remove) {
                if (!att.getShortName().startsWith(s)) continue;
                ok = false;
                break;
            }
            if (!ok) continue;
            result.add(att);
        }
        return new AttributeContainerMutable(atts.getName(), result).toImmutable();
    }

    @Nullable
    public Attribute findAttribute(String var1);

    default public boolean hasAttribute(String attName) {
        return null != this.findAttribute(attName);
    }

    @Nullable
    public Attribute findAttributeIgnoreCase(String var1);

    default public boolean hasAttributeIgnoreCase(String attName) {
        return null != this.findAttributeIgnoreCase(attName);
    }

    public double findAttributeDouble(String var1, double var2);

    public int findAttributeInteger(String var1, int var2);

    public String findAttributeString(String var1, String var2);

    public boolean isEmpty();

    @Nullable
    public String getName();

    @Override
    public Iterator<Attribute> iterator();
}

