/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import ucar.nc2.Attribute;
import ucar.nc2.AttributeContainer;

public class AttributeContainerMutable
implements AttributeContainer {
    @Nullable
    private String name;
    private final ArrayList<Attribute> atts;

    public static AttributeContainerMutable copyFrom(@Nullable AttributeContainer from) {
        return from == null ? new AttributeContainerMutable(null) : new AttributeContainerMutable(from.getName(), from);
    }

    public AttributeContainerMutable(@Nullable String name) {
        this.name = name;
        this.atts = new ArrayList();
    }

    public AttributeContainerMutable(@Nullable String name, Iterable<Attribute> from) {
        this(name);
        this.addAll(from);
    }

    public AttributeContainerMutable setName(@Nullable String name) {
        this.name = name;
        return this;
    }

    @Override
    @Nullable
    public String getName() {
        return this.name;
    }

    @Override
    public Iterator<Attribute> iterator() {
        return this.atts.iterator();
    }

    public Attribute addAttribute(Attribute att) {
        if (att == null) {
            return null;
        }
        for (int i = 0; i < this.atts.size(); ++i) {
            Attribute a = this.atts.get(i);
            if (!att.getShortName().equals(a.getShortName())) continue;
            this.atts.set(i, att);
            return att;
        }
        this.atts.add(att);
        return att;
    }

    public Attribute addAttribute(String name, String value) {
        if (name == null || value == null) {
            return null;
        }
        Attribute att = new Attribute(name, value);
        return this.addAttribute(att);
    }

    public Attribute addAttribute(String name, Number value) {
        if (name == null || value == null) {
            return null;
        }
        Attribute att = new Attribute(name, value);
        return this.addAttribute(att);
    }

    public void addAll(Iterable<Attribute> atts) {
        for (Attribute att : atts) {
            this.addAttribute(att);
        }
    }

    @Override
    public String findAttributeString(String attName, String defaultValue) {
        String attValue = null;
        Attribute att = this.findAttributeIgnoreCase(attName);
        if (att != null && att.isString()) {
            attValue = att.getStringValue();
        }
        if (null == attValue) {
            attValue = defaultValue;
        }
        return attValue;
    }

    @Override
    public Attribute findAttribute(String name) {
        for (Attribute a : this.atts) {
            if (!name.equals(a.getShortName())) continue;
            return a;
        }
        return null;
    }

    @Override
    public Attribute findAttributeIgnoreCase(String name) {
        Attribute result = this.findAttribute(name);
        return result != null ? result : (Attribute)this.atts.stream().filter(a -> a.getShortName().equalsIgnoreCase(name)).findFirst().orElse(null);
    }

    @Override
    public double findAttributeDouble(String attName, double defaultValue) {
        Attribute att = this.findAttributeIgnoreCase(attName);
        if (att == null) {
            return defaultValue;
        }
        if (att.isString()) {
            return Double.parseDouble(att.getStringValue());
        }
        return att.getNumericValue().doubleValue();
    }

    @Override
    public int findAttributeInteger(String attName, int defaultValue) {
        Attribute att = this.findAttributeIgnoreCase(attName);
        if (att == null) {
            return defaultValue;
        }
        if (att.isString()) {
            return Integer.parseInt(att.getStringValue());
        }
        return att.getNumericValue().intValue();
    }

    public boolean remove(Attribute a) {
        return a != null && this.atts.remove(a);
    }

    public boolean replace(Attribute a, String newName) {
        boolean ok = this.atts.remove(a);
        Attribute newAtt = a.toBuilder().setName(newName).build();
        this.addAttribute(newAtt);
        return ok;
    }

    public AttributeContainerMutable clear() {
        this.atts.clear();
        return this;
    }

    public boolean removeAttribute(String attName) {
        Attribute att = this.findAttribute(attName);
        return att != null && this.atts.remove(att);
    }

    public boolean removeAttributeIgnoreCase(String attName) {
        Attribute att = this.findAttributeIgnoreCase(attName);
        return att != null && this.atts.remove(att);
    }

    public AttributeContainer toImmutable() {
        return new AttributeContainerImmutable(this.name, this.atts);
    }

    @Override
    public boolean isEmpty() {
        return this.atts.isEmpty();
    }

    @Immutable
    private static class AttributeContainerImmutable
    implements AttributeContainer {
        private final String name;
        private final ImmutableList<Attribute> atts;

        private AttributeContainerImmutable(String name, List<Attribute> atts) {
            this.name = name;
            this.atts = ImmutableList.copyOf(atts);
        }

        @Override
        public Iterator<Attribute> iterator() {
            return this.atts.iterator();
        }

        @Override
        public String findAttributeString(String attName, String defaultValue) {
            return this.atts.stream().filter(a -> a.getShortName().equalsIgnoreCase(attName)).findFirst().map(Attribute::getStringValue).orElse(defaultValue);
        }

        @Override
        public Attribute findAttribute(String attName) {
            return this.atts.stream().filter(a -> a.getShortName().equals(attName)).findFirst().orElse(null);
        }

        @Override
        public Attribute findAttributeIgnoreCase(String attName) {
            Attribute result = this.findAttribute(attName);
            return result != null ? result : (Attribute)this.atts.stream().filter(a -> a.getShortName().equalsIgnoreCase(attName)).findFirst().orElse(null);
        }

        @Override
        public double findAttributeDouble(String attName, double defaultValue) {
            Attribute att = this.findAttributeIgnoreCase(attName);
            if (att == null) {
                return defaultValue;
            }
            if (att.isString()) {
                return Double.parseDouble(att.getStringValue());
            }
            return att.getNumericValue().doubleValue();
        }

        @Override
        public int findAttributeInteger(String attName, int defaultValue) {
            Attribute att = this.findAttributeIgnoreCase(attName);
            if (att == null) {
                return defaultValue;
            }
            if (att.isString()) {
                return Integer.parseInt(att.getStringValue());
            }
            return att.getNumericValue().intValue();
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public boolean isEmpty() {
            return this.atts.isEmpty();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AttributeContainerImmutable that = (AttributeContainerImmutable)o;
            return Objects.equals(this.name, that.name) && Objects.equals(this.atts, that.atts);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.atts);
        }
    }
}

