/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.util.Formatter;
import javax.annotation.concurrent.Immutable;
import ucar.nc2.Group;
import ucar.nc2.NetcdfFiles;
import ucar.nc2.Variable;
import ucar.nc2.util.Indent;

@Immutable
public class Dimension
implements Comparable<Dimension> {
    public static final Dimension VLEN = Dimension.builder().setName("*").setIsVariableLength(true).build();
    private final String shortName;
    private final boolean isUnlimited;
    private final boolean isVariableLength;
    private final boolean isShared;
    private final int length;

    public Dimension(String name, int length) {
        this(name, length, true, false, false);
    }

    public Dimension(String name, int length, boolean isShared, boolean isUnlimited, boolean isVariableLength) {
        Preconditions.checkArgument((name != null && !name.trim().isEmpty() || !isShared ? 1 : 0) != 0, (Object)"Dimension name can only be null/empty if not shared");
        Preconditions.checkArgument((!isVariableLength || !isUnlimited ? 1 : 0) != 0, (Object)"variable length dimension cannot be unlimited");
        Preconditions.checkArgument((!isVariableLength || !isShared ? 1 : 0) != 0, (Object)"variable length dimension cannot be shared");
        this.shortName = name == null ? null : name.trim();
        this.isShared = isShared;
        this.isUnlimited = isUnlimited;
        this.isVariableLength = isVariableLength;
        if (isVariableLength) {
            length = -1;
        } else if (isUnlimited) {
            if (length < 0) {
                throw new IllegalArgumentException("Unlimited Dimension length =" + length + " must >= 0");
            }
        } else if (length < 1) {
            throw new IllegalArgumentException("Dimension length =" + length + " must be > 0");
        }
        this.length = length;
    }

    public int getLength() {
        return this.length;
    }

    public String getShortName() {
        return this.shortName;
    }

    public boolean isUnlimited() {
        return this.isUnlimited;
    }

    public boolean isVariableLength() {
        return this.isVariableLength;
    }

    public boolean isShared() {
        return this.isShared;
    }

    public String makeFullName(Variable v) {
        return this.makeFullName(v.getParentGroup());
    }

    public String makeFullName(Group containingGroup) {
        if (!this.isShared) {
            return String.format("%d", this.getLength());
        }
        Preconditions.checkNotNull((Object)containingGroup);
        for (Group group = containingGroup; group != null; group = group.getParentGroup()) {
            if (group.findDimensionLocal(this.shortName) == null) continue;
            return NetcdfFiles.makeFullNameWithString(group, this.shortName);
        }
        throw new IllegalStateException(String.format("Dimension %s not found starting from group '%s'", this.shortName, containingGroup.getFullName()));
    }

    public boolean equals(Object o) {
        boolean result;
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Dimension dimension = (Dimension)o;
        boolean bl = result = this.isUnlimited == dimension.isUnlimited && this.isVariableLength == dimension.isVariableLength && this.isShared == dimension.isShared && Objects.equal((Object)this.shortName, (Object)dimension.shortName);
        return this.isUnlimited ? result : result && this.getLength() == dimension.getLength();
    }

    public int hashCode() {
        if (this.isUnlimited) {
            return Objects.hashCode((Object[])new Object[]{this.shortName, this.isUnlimited, this.isVariableLength, this.isShared});
        }
        return Objects.hashCode((Object[])new Object[]{this.shortName, this.isUnlimited, this.isVariableLength, this.isShared, this.getLength()});
    }

    @Override
    public int compareTo(Dimension odim) {
        String name = this.getShortName();
        return name.compareTo(odim.getShortName());
    }

    public String toString() {
        Formatter f = new Formatter();
        this.writeCDL(f, new Indent(2), false);
        return f.toString();
    }

    void writeCDL(Formatter out, Indent indent, boolean strict) {
        String name = strict ? NetcdfFiles.makeValidCDLName(this.getShortName()) : this.getShortName();
        out.format("%s%s", indent, name);
        if (this.isUnlimited()) {
            out.format(" = UNLIMITED;   // (%d currently)", this.getLength());
        } else if (this.isVariableLength()) {
            out.format(" = UNKNOWN;", new Object[0]);
        } else {
            out.format(" = %d;", this.getLength());
        }
    }

    private Dimension(Builder builder) {
        this(builder.shortName, builder.length, builder.isShared, builder.isUnlimited, builder.isVariableLength);
    }

    public Builder toBuilder() {
        return Dimension.builder().setName(this.shortName).setIsUnlimited(this.isUnlimited).setIsVariableLength(this.isVariableLength).setIsShared(this.isShared).setLength(this.getLength());
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String name, int length) {
        return new Builder().setName(name).setLength(length);
    }

    public static class Builder {
        private String shortName;
        private boolean isUnlimited;
        private boolean isVariableLength;
        private boolean isShared = true;
        private int length;
        private boolean built;

        private Builder() {
        }

        public Builder setIsUnlimited(boolean isUnlimited) {
            this.isUnlimited = isUnlimited;
            return this;
        }

        public Builder setIsVariableLength(boolean isVariableLength) {
            this.isVariableLength = isVariableLength;
            if (isVariableLength) {
                this.isShared = false;
                this.isUnlimited = false;
                this.length = -1;
            }
            return this;
        }

        public Builder setIsShared(boolean isShared) {
            this.isShared = isShared;
            return this;
        }

        public Builder setLength(int n) {
            if (this.isVariableLength) {
                if (n != -1) {
                    throw new IllegalArgumentException("VariableLength Dimension length =" + n + " must be -1");
                }
            } else if (this.isUnlimited) {
                if (n < 0) {
                    throw new IllegalArgumentException("Unlimited Dimension length =" + n + " must >= 0");
                }
            } else if (n < 1) {
                throw new IllegalArgumentException("Dimension length =" + n + " must be > 0");
            }
            this.length = n;
            return this;
        }

        public Builder setName(String shortName) {
            this.shortName = NetcdfFiles.makeValidCdmObjectName(shortName);
            return this;
        }

        public Dimension build() {
            if (this.built) {
                throw new IllegalStateException("already built");
            }
            this.built = true;
            return new Dimension(this);
        }
    }
}

