/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Formatter;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import ucar.array.ArrayType;
import ucar.ma2.DataType;
import ucar.nc2.NetcdfFiles;
import ucar.nc2.util.Indent;

@Immutable
public class EnumTypedef {
    private static final int UBYTE_MAX = 255;
    private static final int USHORT_MAX = 65535;
    private final String name;
    private final ImmutableMap<Integer, String> map;
    private final ArrayType basetype;

    public EnumTypedef(String name, Map<Integer, String> map) {
        this(name, map, ArrayType.ENUM4);
    }

    @Deprecated
    public EnumTypedef(String name, Map<Integer, String> map, DataType basetype) {
        this.name = name;
        Preconditions.checkArgument((basetype == DataType.ENUM1 || basetype == DataType.ENUM2 || basetype == DataType.ENUM4 ? 1 : 0) != 0);
        this.basetype = basetype.getArrayType();
        Preconditions.checkNotNull(map);
        Preconditions.checkArgument((boolean)this.validateMap(map, this.basetype));
        this.map = ImmutableMap.copyOf(map);
    }

    public EnumTypedef(String name, Map<Integer, String> map, ArrayType basetype) {
        this.name = name;
        Preconditions.checkArgument((basetype == ArrayType.ENUM1 || basetype == ArrayType.ENUM2 || basetype == ArrayType.ENUM4 ? 1 : 0) != 0);
        this.basetype = basetype;
        Preconditions.checkNotNull(map);
        Preconditions.checkArgument((boolean)this.validateMap(map, basetype));
        this.map = ImmutableMap.copyOf(map);
    }

    @Deprecated
    public DataType getBaseType() {
        return this.basetype.getDataType();
    }

    public ArrayType getBaseArrayType() {
        return this.basetype;
    }

    public String getShortName() {
        return this.name;
    }

    public ImmutableMap<Integer, String> getMap() {
        return this.map;
    }

    private boolean validateMap(Map<Integer, String> map, ArrayType basetype) {
        block5: for (Integer i : map.keySet()) {
            switch (basetype) {
                case ENUM1: {
                    if (i >= -128 && i <= 255) continue block5;
                    return false;
                }
                case ENUM2: {
                    if (i >= Short.MIN_VALUE && i <= 65535) continue block5;
                    return false;
                }
                case ENUM4: {
                    continue block5;
                }
            }
            return false;
        }
        return true;
    }

    @Nullable
    public Integer lookupEnumInt(String name) {
        for (Map.Entry entry : this.map.entrySet()) {
            if (!((String)entry.getValue()).equalsIgnoreCase(name)) continue;
            return (Integer)entry.getKey();
        }
        return null;
    }

    @Nullable
    public String lookupEnumString(int e) {
        return (String)this.map.get((Object)e);
    }

    void writeCDL(Formatter out, Indent indent, boolean strict) {
        String name = strict ? NetcdfFiles.makeValidCDLName(this.name) : this.name;
        String basetype = "";
        switch (this.basetype) {
            case ENUM1: {
                basetype = "byte ";
                break;
            }
            case ENUM2: {
                basetype = "short ";
                break;
            }
            case ENUM4: {
                basetype = "";
                break;
            }
            default: {
                assert (false) : "Internal error";
                break;
            }
        }
        out.format("%s%senum %s { ", indent, basetype, name);
        int count = 0;
        ArrayList keysetList = new ArrayList(this.map.keySet());
        Collections.sort(keysetList);
        for (Integer key : keysetList) {
            String s = (String)this.map.get((Object)key);
            if (0 < count++) {
                out.format(", ", new Object[0]);
            }
            if (strict) {
                out.format("%s = %s", NetcdfFiles.makeValidCDLName(s), key);
                continue;
            }
            out.format("'%s' = %s", s, key);
        }
        out.format("};", new Object[0]);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EnumTypedef that = (EnumTypedef)o;
        return Objects.equal((Object)this.name, (Object)that.name) && Objects.equal(this.map, that.map) && this.basetype == that.basetype;
    }

    public boolean equalsMapOnly(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EnumTypedef that = (EnumTypedef)o;
        return Objects.equal(this.map, that.map);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.name, this.map, this.basetype});
    }

    public String toString() {
        Formatter f = new Formatter();
        this.writeCDL(f, new Indent(0), false);
        return f.toString();
    }
}

