/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Formatter;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.StringTokenizer;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import ucar.array.ArrayType;
import ucar.nc2.Attribute;
import ucar.nc2.AttributeContainer;
import ucar.nc2.AttributeContainerMutable;
import ucar.nc2.Dimension;
import ucar.nc2.Dimensions;
import ucar.nc2.EnumTypedef;
import ucar.nc2.NetcdfFile;
import ucar.nc2.NetcdfFiles;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.internal.util.EscapeStrings;
import ucar.nc2.util.Indent;

@Immutable
public class Group {
    private final NetcdfFile ncfile;
    private final ImmutableList<Variable> variables;
    private final ImmutableList<Dimension> dimensions;
    private final ImmutableList<Group> groups;
    private final AttributeContainer attributes;
    private final ImmutableList<EnumTypedef> enumTypedefs;
    private final String shortName;
    private final Group parentGroup;

    public AttributeContainer attributes() {
        return this.attributes;
    }

    public Group commonParent(Group other) {
        if (this.isParent(other)) {
            return this;
        }
        if (other.isParent(this)) {
            return other;
        }
        while (other != null && !other.isParent(this)) {
            other = other.getParentGroup();
        }
        return other;
    }

    @Nullable
    public Attribute findAttribute(String name) {
        return this.attributes.findAttribute(name);
    }

    public String findAttributeString(String attName, String defaultValue) {
        return this.attributes.findAttributeString(attName, defaultValue);
    }

    public Optional<Dimension> findDimension(String name) {
        if (name == null) {
            return Optional.empty();
        }
        Dimension d = this.findDimensionLocal(name);
        if (d != null) {
            return Optional.of(d);
        }
        Group parent = this.getParentGroup();
        if (parent != null) {
            return parent.findDimension(name);
        }
        return Optional.empty();
    }

    @Nullable
    public Dimension findDimension(Dimension dim) {
        if (dim == null) {
            return null;
        }
        for (Dimension d : this.dimensions) {
            if (!d.equals(dim)) continue;
            return d;
        }
        Group parent = this.getParentGroup();
        if (parent != null) {
            return parent.findDimension(dim);
        }
        return null;
    }

    @Nullable
    public Dimension findDimensionLocal(String shortName) {
        if (shortName == null) {
            return null;
        }
        for (Dimension d : this.dimensions) {
            if (!shortName.equals(d.getShortName())) continue;
            return d;
        }
        return null;
    }

    @Nullable
    public EnumTypedef findEnumeration(String name) {
        if (name == null) {
            return null;
        }
        for (EnumTypedef d : this.enumTypedefs) {
            if (!name.equals(d.getShortName())) continue;
            return d;
        }
        Group parent = this.getParentGroup();
        if (parent != null) {
            return parent.findEnumeration(name);
        }
        return null;
    }

    @Nullable
    public Group findGroupLocal(String groupShortName) {
        if (groupShortName == null) {
            return null;
        }
        for (Group group : this.groups) {
            if (!groupShortName.equals(group.getShortName())) continue;
            return group;
        }
        return null;
    }

    public Optional<Group> findGroupNested(String groupShortName) {
        if (groupShortName == null) {
            return Optional.empty();
        }
        Group local = this.findGroupLocal(groupShortName);
        if (local != null) {
            return Optional.of(local);
        }
        for (Group nested : this.groups) {
            Optional<Group> result = nested.findGroupNested(groupShortName);
            if (!result.isPresent()) continue;
            return result;
        }
        return Optional.empty();
    }

    @Nullable
    public Variable findVariableByAttribute(String attName, String attValue) {
        Preconditions.checkNotNull((Object)attName);
        for (Variable v : this.getVariables()) {
            for (Attribute att : v.attributes()) {
                if (!attName.equals(att.getShortName()) || !attValue.equals(att.getStringValue())) continue;
                return v;
            }
        }
        for (Group nested : this.getGroups()) {
            Variable v = nested.findVariableByAttribute(attName, attValue);
            if (v == null) continue;
            return v;
        }
        return null;
    }

    @Nullable
    public Variable findVariableLocal(String varShortName) {
        if (varShortName == null) {
            return null;
        }
        for (Variable v : this.variables) {
            if (!varShortName.equals(v.getShortName())) continue;
            return v;
        }
        return null;
    }

    @Nullable
    public Variable findVariableOrInParent(String varShortName) {
        if (varShortName == null) {
            return null;
        }
        Variable v = this.findVariableLocal(varShortName);
        Group parent = this.getParentGroup();
        if (v == null && parent != null) {
            v = parent.findVariableOrInParent(varShortName);
        }
        return v;
    }

    public ImmutableList<Dimension> getDimensions() {
        return this.dimensions;
    }

    public ImmutableList<EnumTypedef> getEnumTypedefs() {
        return ImmutableList.copyOf(this.enumTypedefs);
    }

    public String getFullName() {
        return NetcdfFiles.makeFullName(this);
    }

    public ImmutableList<Group> getGroups() {
        return ImmutableList.copyOf(this.groups);
    }

    public NetcdfFile getNetcdfFile() {
        return this.ncfile;
    }

    @Nullable
    public Group getParentGroup() {
        return this.parentGroup;
    }

    public String getShortName() {
        return this.shortName;
    }

    public ImmutableList<Variable> getVariables() {
        return this.variables;
    }

    public boolean isParent(Group other) {
        while (other != this && other.getParentGroup() != null) {
            other = other.getParentGroup();
        }
        return other == this;
    }

    public boolean isRoot() {
        return this.getParentGroup() == null;
    }

    public ImmutableList<Dimension> makeDimensionsList(String dimString) throws IllegalArgumentException {
        return Dimensions.makeDimensionsList(this::findDimension, dimString);
    }

    public String getNameAndAttributes() {
        StringBuilder sbuff = new StringBuilder();
        sbuff.append("Group ");
        sbuff.append(this.getShortName());
        sbuff.append("\n");
        for (Attribute att : this.attributes) {
            sbuff.append("  ").append(this.getShortName()).append(":");
            sbuff.append(att);
            sbuff.append(";");
            sbuff.append("\n");
        }
        return sbuff.toString();
    }

    void writeCDL(Formatter out, Indent indent, boolean strict) {
        boolean hasA;
        boolean hasE = !this.enumTypedefs.isEmpty();
        boolean hasD = !this.dimensions.isEmpty();
        boolean hasV = !this.variables.isEmpty();
        boolean bl = hasA = !Iterables.isEmpty((Iterable)this.attributes);
        if (hasE) {
            out.format("%stypes:%n", indent);
            indent.incr();
            for (EnumTypedef e : this.enumTypedefs) {
                e.writeCDL(out, indent, strict);
                out.format("%n", new Object[0]);
            }
            indent.decr();
            out.format("%n", new Object[0]);
        }
        if (hasD) {
            out.format("%sdimensions:%n", indent);
            indent.incr();
            for (Dimension myd : this.dimensions) {
                myd.writeCDL(out, indent, strict);
                out.format("%n", new Object[0]);
            }
            indent.decr();
        }
        if (hasV) {
            out.format("%svariables:%n", indent);
            indent.incr();
            for (Variable v : this.variables) {
                v.writeCDL(out, indent, false, strict);
                out.format("%n", new Object[0]);
            }
            indent.decr();
        }
        for (Group g : this.groups) {
            String gname = strict ? NetcdfFiles.makeValidCDLName(g.getShortName()) : g.getShortName();
            out.format("%sgroup: %s {%n", indent, gname);
            indent.incr();
            g.writeCDL(out, indent, strict);
            indent.decr();
            out.format("%s}%n%n", indent);
        }
        if (hasA) {
            if (this.isRoot()) {
                out.format("%s// global attributes:%n", indent);
            } else {
                out.format("%s// group attributes:%n", indent);
            }
            for (Attribute att : this.attributes) {
                out.format("%s", indent);
                att.writeCDL(out, strict, null);
                out.format(";", new Object[0]);
                if (!strict && att.getArrayType() != ArrayType.STRING) {
                    out.format(" // %s", att.getArrayType().toCdl());
                }
                out.format("%n", new Object[0]);
            }
        }
    }

    public String toString() {
        Formatter buf = new Formatter();
        this.writeCDL(buf, new Indent(2), false);
        return buf.toString();
    }

    public boolean equals(Object oo) {
        if (this == oo) {
            return true;
        }
        if (!(oo instanceof Group)) {
            return false;
        }
        Group og = (Group)oo;
        if (!this.getShortName().equals(og.getShortName())) {
            return false;
        }
        return this.getParentGroup() == null || this.getParentGroup().equals(og.getParentGroup());
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + this.getShortName().hashCode();
        if (this.getParentGroup() != null) {
            result = 37 * result + this.getParentGroup().hashCode();
        }
        return result;
    }

    private Group(Builder builder, @Nullable Group parent) {
        this.shortName = builder.shortName;
        this.parentGroup = parent;
        this.ncfile = builder.ncfile;
        this.dimensions = ImmutableList.copyOf((Collection)builder.dimensions);
        this.enumTypedefs = ImmutableList.copyOf(builder.enumTypedefs);
        this.groups = (ImmutableList)builder.gbuilders.stream().map(g -> g.setNcfile(this.ncfile).build(this)).collect(ImmutableList.toImmutableList());
        builder.vbuilders.forEach(vb -> {
            if (vb.ncfile == null) {
                vb.setNcfile(this.ncfile);
            }
        });
        ImmutableList.Builder vlistb = ImmutableList.builder();
        for (Variable.Builder<?> vb2 : builder.vbuilders) {
            Variable var = vb2.build(this);
            vlistb.add((Object)var);
        }
        this.variables = vlistb.build();
        this.attributes = builder.attributes.toImmutable();
    }

    public Builder toBuilder() {
        Builder builder = Group.builder().setName(this.shortName).setNcfile(this.ncfile).addAttributes(this.attributes).addDimensions((Collection<Dimension>)this.dimensions).addEnumTypedefs((Collection<EnumTypedef>)this.enumTypedefs);
        this.groups.forEach(g -> builder.addGroup(g.toBuilder()));
        this.variables.forEach(v -> builder.addVariable(v.toBuilder()));
        return builder;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        @Nullable
        private Builder parentGroup;
        public List<Builder> gbuilders = new ArrayList<Builder>();
        public List<Variable.Builder<?>> vbuilders = new ArrayList();
        public String shortName = "";
        private NetcdfFile ncfile;
        private final AttributeContainerMutable attributes = new AttributeContainerMutable("");
        private final List<Dimension> dimensions = new ArrayList<Dimension>();
        public final List<EnumTypedef> enumTypedefs = new ArrayList<EnumTypedef>();
        private boolean built;

        public Builder setParentGroup(@Nullable Builder parentGroup) {
            this.parentGroup = parentGroup;
            return this;
        }

        @Nullable
        public Builder getParentGroup() {
            return this.parentGroup;
        }

        public Builder addAttribute(Attribute att) {
            Preconditions.checkNotNull((Object)att);
            this.attributes.addAttribute(att);
            return this;
        }

        public Builder addAttributes(Iterable<Attribute> atts) {
            Preconditions.checkNotNull(atts);
            this.attributes.addAll(atts);
            return this;
        }

        public AttributeContainerMutable getAttributeContainer() {
            return this.attributes;
        }

        public Builder addDimension(Dimension dim) {
            Preconditions.checkNotNull((Object)dim);
            this.findDimensionLocal(dim.getShortName()).ifPresent(d -> {
                throw new IllegalArgumentException("Dimension '" + d.getShortName() + "' already exists");
            });
            this.dimensions.add(dim);
            return this;
        }

        public boolean addDimensionIfNotExists(Dimension dim) {
            Preconditions.checkNotNull((Object)dim);
            if (!this.findDimensionLocal(dim.getShortName()).isPresent()) {
                this.dimensions.add(dim);
                return true;
            }
            return false;
        }

        public Builder addDimensions(Collection<Dimension> dims) {
            Preconditions.checkNotNull(dims);
            dims.forEach(this::addDimension);
            return this;
        }

        public boolean replaceDimension(Dimension dim) {
            Optional<Dimension> want = this.findDimensionLocal(dim.getShortName());
            want.ifPresent(this.dimensions::remove);
            this.addDimension(dim);
            return want.isPresent();
        }

        public boolean removeDimension(String name) {
            Optional<Dimension> want = this.findDimensionLocal(name);
            want.ifPresent(this.dimensions::remove);
            return want.isPresent();
        }

        public Optional<Dimension> findDimensionLocal(String name) {
            return this.dimensions.stream().filter(d -> d.getShortName().equals(name)).findFirst();
        }

        public boolean contains(Dimension want) {
            Dimension have = this.dimensions.stream().filter(d -> d.equals(want)).findFirst().orElse(null);
            if (have != null) {
                return true;
            }
            if (this.parentGroup != null) {
                return this.parentGroup.contains(want);
            }
            return false;
        }

        public Optional<Dimension> findDimension(String name) {
            if (name == null) {
                return Optional.empty();
            }
            Optional<Dimension> dopt = this.findDimensionLocal(name);
            if (dopt.isPresent()) {
                return dopt;
            }
            if (this.parentGroup != null) {
                return this.parentGroup.findDimension(name);
            }
            return Optional.empty();
        }

        public Iterable<Dimension> getDimensions() {
            return ImmutableList.copyOf(this.dimensions);
        }

        public Builder addGroup(Builder nested) {
            Preconditions.checkNotNull((Object)nested);
            this.findGroupLocal(nested.shortName).ifPresent(g -> {
                throw new IllegalStateException("Nested group already exists " + nested.shortName);
            });
            this.gbuilders.add(nested);
            nested.setParentGroup(this);
            return this;
        }

        public Builder addGroups(Collection<Builder> groups) {
            Preconditions.checkNotNull(groups);
            this.gbuilders.addAll(groups);
            return this;
        }

        public boolean removeGroup(String name) {
            Optional<Builder> want = this.findGroupLocal(name);
            want.ifPresent(v -> this.gbuilders.remove(v));
            return want.isPresent();
        }

        public Optional<Builder> findGroupLocal(String shortName) {
            return this.gbuilders.stream().filter(g -> g.shortName.equals(shortName)).findFirst();
        }

        public Optional<Builder> findGroupNested(String reletiveName) {
            if (reletiveName == null || reletiveName.isEmpty()) {
                return this.getParentGroup() == null ? Optional.of(this) : Optional.empty();
            }
            Builder g = this;
            StringTokenizer stoke = new StringTokenizer(reletiveName, "/");
            while (stoke.hasMoreTokens()) {
                String groupName = NetcdfFiles.makeNameUnescaped(stoke.nextToken());
                Optional<Builder> sub = g.findGroupLocal(groupName);
                if (!sub.isPresent()) {
                    return Optional.empty();
                }
                g = sub.get();
            }
            return Optional.of(g);
        }

        public boolean isParent(Builder other) {
            while (other != this && other.parentGroup != null) {
                other = other.parentGroup;
            }
            return other == this;
        }

        public Builder commonParent(Builder other) {
            Preconditions.checkNotNull((Object)other);
            if (this.isParent(other)) {
                return this;
            }
            if (other.isParent(this)) {
                return other;
            }
            while (!other.isParent(this)) {
                other = other.parentGroup;
            }
            return other;
        }

        public Builder addEnumTypedef(EnumTypedef typedef) {
            Preconditions.checkNotNull((Object)typedef);
            this.enumTypedefs.add(typedef);
            return this;
        }

        public Builder addEnumTypedefs(Collection<EnumTypedef> typedefs) {
            Preconditions.checkNotNull(typedefs);
            this.enumTypedefs.addAll(typedefs);
            return this;
        }

        public EnumTypedef findOrAddEnumTypedef(String name, Map<Integer, String> map) {
            Optional<EnumTypedef> opt = this.findEnumeration(name);
            if (opt.isPresent()) {
                return opt.get();
            }
            EnumTypedef enumTypedef = new EnumTypedef(name, map);
            this.addEnumTypedef(enumTypedef);
            return enumTypedef;
        }

        public Optional<EnumTypedef> findEnumeration(String name) {
            return this.enumTypedefs.stream().filter(e -> e.getShortName().equals(name)).findFirst();
        }

        public Builder addVariable(Variable.Builder<?> variable) {
            Preconditions.checkNotNull(variable);
            this.findVariableLocal(variable.shortName).ifPresent(v -> {
                throw new IllegalArgumentException("Variable '" + v.shortName + "' already exists");
            });
            this.vbuilders.add(variable);
            variable.setParentGroupBuilder(this);
            return this;
        }

        public Builder addVariables(Collection<Variable.Builder<?>> vars) {
            vars.forEach(this::addVariable);
            return this;
        }

        public boolean replaceVariable(Variable.Builder<?> vb) {
            Optional<Variable.Builder<?>> want = this.findVariableLocal(vb.shortName);
            want.ifPresent(v -> this.vbuilders.remove(v));
            this.addVariable(vb);
            return want.isPresent();
        }

        public boolean removeVariable(String name) {
            Optional<Variable.Builder<?>> want = this.findVariableLocal(name);
            want.ifPresent(v -> this.vbuilders.remove(v));
            return want.isPresent();
        }

        public Optional<Variable.Builder<?>> findVariableLocal(String name) {
            return this.vbuilders.stream().filter(v -> v.shortName.equals(name)).findFirst();
        }

        public Optional<Variable.Builder<?>> findVariableNested(String reletiveName) {
            if (reletiveName == null || reletiveName.isEmpty()) {
                return Optional.empty();
            }
            Builder group = this;
            String varName = reletiveName;
            int pos = reletiveName.lastIndexOf(47);
            if (pos >= 0) {
                String groupNames = reletiveName.substring(0, pos);
                varName = reletiveName.substring(pos + 1);
                group = this.findGroupNested(groupNames).orElse(null);
            }
            return group == null ? Optional.empty() : group.findVariableLocal(varName);
        }

        public Optional<Variable.Builder<?>> findVariable(String fullNameEscaped) {
            if (fullNameEscaped == null || fullNameEscaped.isEmpty()) {
                return Optional.empty();
            }
            Builder group = this;
            String vars = fullNameEscaped;
            int pos = fullNameEscaped.lastIndexOf(47);
            if (pos >= 0) {
                String groupNames = fullNameEscaped.substring(0, pos);
                vars = fullNameEscaped.substring(pos + 1);
                group = this.findGroupNested(groupNames).orElse(null);
            }
            if (group == null) {
                return Optional.empty();
            }
            List<String> snames = EscapeStrings.tokenizeEscapedName(vars);
            if (snames.isEmpty()) {
                return Optional.empty();
            }
            String varShortName = NetcdfFiles.makeNameUnescaped(snames.get(0));
            Variable.Builder v = group.findVariableLocal(varShortName).orElse(null);
            if (v == null) {
                return Optional.empty();
            }
            for (int memberCount = 1; memberCount < snames.size(); ++memberCount) {
                if (!(v instanceof Structure.Builder)) {
                    return Optional.empty();
                }
                Structure.Builder sb = (Structure.Builder)v;
                String name = NetcdfFiles.makeNameUnescaped(snames.get(memberCount));
                if ((v = (Variable.Builder)sb.findMemberVariable(name).orElse(null)) != null) continue;
                return Optional.empty();
            }
            return Optional.of(v);
        }

        public Optional<Variable.Builder<?>> findVariableOrInParent(String varShortName) {
            if (varShortName == null) {
                return Optional.empty();
            }
            Optional<Variable.Builder<?>> vopt = this.findVariableLocal(varShortName);
            Builder parent = this.getParentGroup();
            if (!vopt.isPresent() && parent != null) {
                vopt = parent.findVariableOrInParent(varShortName);
            }
            return vopt;
        }

        public Builder setNcfile(NetcdfFile ncfile) {
            this.ncfile = ncfile;
            return this;
        }

        public Builder setName(String shortName) {
            this.shortName = NetcdfFiles.makeValidCdmObjectName(shortName);
            return this;
        }

        @Deprecated
        public NetcdfFile getNcfile() {
            return this.ncfile;
        }

        public ImmutableList<Dimension> makeDimensionsList(String dimString) throws IllegalArgumentException {
            return Dimensions.makeDimensionsList(this::findDimension, dimString);
        }

        public String makeFullName() {
            if (this.parentGroup == null) {
                return "";
            }
            StringBuilder sbuff = new StringBuilder();
            this.appendGroupName(sbuff, this);
            return sbuff.toString();
        }

        private void appendGroupName(StringBuilder sbuff, Builder g) {
            if (g == null || g.getParentGroup() == null) {
                return;
            }
            this.appendGroupName(sbuff, g.getParentGroup());
            sbuff.append(EscapeStrings.backslashEscape(g.shortName, ".\\"));
            sbuff.append("/");
        }

        public void removeDimensionFromAllGroups(Builder group, Dimension remove) {
            group.dimensions.removeIf(dim -> dim.equals(remove));
            group.gbuilders.forEach(g -> this.removeDimensionFromAllGroups((Builder)g, remove));
        }

        public Group build() {
            return this.build(null);
        }

        Group build(@Nullable Group parent) {
            if (this.built) {
                throw new IllegalStateException("Group was already built " + this.shortName);
            }
            this.built = true;
            return new Group(this, parent);
        }
    }
}

