/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Formatter;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.array.InvalidRangeException;
import ucar.array.StructureData;
import ucar.ma2.Array;
import ucar.ma2.Section;
import ucar.ma2.StructureDataIterator;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.Group;
import ucar.nc2.NetcdfFiles;
import ucar.nc2.ParsedArraySectionSpec;
import ucar.nc2.ParsedSectionSpec;
import ucar.nc2.Sequence;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.internal.cache.FileCacheIF;
import ucar.nc2.internal.cache.FileCacheable;
import ucar.nc2.internal.iosp.netcdf3.N3header;
import ucar.nc2.internal.iosp.netcdf3.N3iosp;
import ucar.nc2.internal.util.EscapeStrings;
import ucar.nc2.iosp.AbstractIOServiceProvider;
import ucar.nc2.iosp.IOServiceProvider;
import ucar.nc2.iosp.IospHelper;
import ucar.nc2.util.DebugFlags;
import ucar.nc2.util.Indent;
import ucar.nc2.write.NcmlWriter;

@Immutable
public class NetcdfFile
implements FileCacheable,
Closeable {
    private static final Logger log = LoggerFactory.getLogger(NetcdfFile.class);
    @Deprecated
    public static final String IOSP_MESSAGE_ADD_RECORD_STRUCTURE = "AddRecordStructure";
    public static final String IOSP_MESSAGE_RANDOM_ACCESS_FILE = "RandomAccessFile";
    public static final String IOSP_MESSAGE_GET_IOSP = "IOSP";
    public static final String IOSP_MESSAGE_GET_NETCDF_FILE_FORMAT = "NetcdfFileFormat";
    static boolean debugSPI;
    static boolean debugCompress;
    static boolean debugStructureIterator;
    private static boolean showRequest;
    private final String location;
    private final String id;
    private final String title;
    private final Group rootGroup;
    @Nullable
    private IOServiceProvider iosp;
    protected FileCacheIF cache;
    private final ImmutableList<Variable> allVariables;
    private final ImmutableList<Dimension> allDimensions;
    private final ImmutableList<Attribute> allAttributes;

    @Deprecated
    public static void setDebugFlags(DebugFlags debugFlag) {
        debugSPI = debugFlag.isSet("NetcdfFile/debugSPI");
        debugCompress = debugFlag.isSet("NetcdfFile/debugCompress");
        debugStructureIterator = debugFlag.isSet("NetcdfFile/structureIterator");
        N3header.disallowFileTruncation = debugFlag.isSet("NetcdfFile/disallowFileTruncation");
        N3header.debugHeaderSize = debugFlag.isSet("NetcdfFile/debugHeaderSize");
        showRequest = debugFlag.isSet("NetcdfFile/showRequest");
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.cache != null && this.cache.release(this)) {
            return;
        }
        try {
            if (null != this.iosp) {
                this.iosp.close();
            }
        }
        finally {
            this.iosp = null;
        }
    }

    @Nullable
    public Attribute findAttribute(String fullNameEscaped) {
        String varName;
        if (fullNameEscaped == null || fullNameEscaped.isEmpty()) {
            return null;
        }
        int posAtt = fullNameEscaped.indexOf(64);
        if (posAtt < 0 || posAtt >= fullNameEscaped.length() - 1) {
            return null;
        }
        if (posAtt == 0) {
            return this.findGlobalAttribute(fullNameEscaped.substring(1));
        }
        String path = fullNameEscaped.substring(0, posAtt);
        String attName = fullNameEscaped.substring(posAtt + 1);
        Group g = this.rootGroup;
        int pos = path.lastIndexOf(47);
        String string = varName = pos > 0 && pos < path.length() - 1 ? path.substring(pos + 1) : null;
        if (pos >= 0) {
            String groups = path.substring(0, pos);
            StringTokenizer stoke = new StringTokenizer(groups, "/");
            while (stoke.hasMoreTokens()) {
                String token = NetcdfFiles.makeNameUnescaped(stoke.nextToken());
                if ((g = g.findGroupLocal(token)) != null) continue;
                return null;
            }
        }
        if (varName == null) {
            return g.findAttribute(attName);
        }
        List<String> snames = EscapeStrings.tokenizeEscapedName(varName);
        if (snames.isEmpty()) {
            return null;
        }
        String varShortName = NetcdfFiles.makeNameUnescaped(snames.get(0));
        Variable v = g.findVariableLocal(varShortName);
        if (v == null) {
            return null;
        }
        int memberCount = 1;
        while (memberCount < snames.size()) {
            String name;
            if (!(v instanceof Structure)) {
                return null;
            }
            if ((v = ((Structure)v).findVariable(name = NetcdfFiles.makeNameUnescaped(snames.get(memberCount++)))) != null) continue;
            return null;
        }
        return v.findAttribute(attName);
    }

    @Nullable
    public Dimension findDimension(String fullName) {
        if (fullName == null || fullName.isEmpty()) {
            return null;
        }
        Group group = this.rootGroup;
        String dimShortName = fullName;
        int pos = fullName.lastIndexOf(47);
        if (pos >= 0) {
            String groups = fullName.substring(0, pos);
            dimShortName = fullName.substring(pos + 1);
            StringTokenizer stoke = new StringTokenizer(groups, "/");
            while (stoke.hasMoreTokens()) {
                String token = NetcdfFiles.makeNameUnescaped(stoke.nextToken());
                if ((group = group.findGroupLocal(token)) != null) continue;
                return null;
            }
        }
        return group.findDimensionLocal(dimShortName);
    }

    @Nullable
    public Attribute findGlobalAttribute(String attName) {
        for (Attribute a : this.allAttributes) {
            if (!attName.equals(a.getShortName())) continue;
            return a;
        }
        return null;
    }

    @Nullable
    public Attribute findGlobalAttributeIgnoreCase(String name) {
        for (Attribute a : this.allAttributes) {
            if (!name.equalsIgnoreCase(a.getShortName())) continue;
            return a;
        }
        return null;
    }

    @Nullable
    public Group findGroup(@Nullable String fullName) {
        if (fullName == null || fullName.isEmpty()) {
            return this.rootGroup;
        }
        Group g = this.rootGroup;
        StringTokenizer stoke = new StringTokenizer(fullName, "/");
        while (stoke.hasMoreTokens()) {
            String groupName = NetcdfFiles.makeNameUnescaped(stoke.nextToken());
            if ((g = g.findGroupLocal(groupName)) != null) continue;
            return null;
        }
        return g;
    }

    @Nullable
    public Variable findVariable(String fullNameEscaped) {
        List<String> snames;
        if (fullNameEscaped == null || fullNameEscaped.isEmpty()) {
            return null;
        }
        Group g = this.rootGroup;
        String vars = fullNameEscaped;
        int pos = fullNameEscaped.lastIndexOf(47);
        if (pos >= 0) {
            String groups = fullNameEscaped.substring(0, pos);
            vars = fullNameEscaped.substring(pos + 1);
            StringTokenizer stoke = new StringTokenizer(groups, "/");
            while (stoke.hasMoreTokens()) {
                String token = NetcdfFiles.makeNameUnescaped(stoke.nextToken());
                if ((g = g.findGroupLocal(token)) != null) continue;
                return null;
            }
        }
        if ((snames = EscapeStrings.tokenizeEscapedName(vars)).isEmpty()) {
            return null;
        }
        String varShortName = NetcdfFiles.makeNameUnescaped(snames.get(0));
        Variable v = g.findVariableLocal(varShortName);
        if (v == null) {
            return null;
        }
        int memberCount = 1;
        while (memberCount < snames.size()) {
            String name;
            if (!(v instanceof Structure)) {
                return null;
            }
            if ((v = ((Structure)v).findVariable(name = NetcdfFiles.makeNameUnescaped(snames.get(memberCount++)))) != null) continue;
            return null;
        }
        return v;
    }

    public ImmutableList<Dimension> getDimensions() {
        return this.allDimensions;
    }

    @Nullable
    public String getFileTypeId() {
        if (this.iosp != null) {
            return this.iosp.getFileTypeId();
        }
        return null;
    }

    public String getFileTypeDescription() {
        if (this.iosp != null) {
            return this.iosp.getFileTypeDescription();
        }
        return "N/A";
    }

    public String getFileTypeVersion() {
        if (this.iosp != null) {
            return this.iosp.getFileTypeVersion();
        }
        return "N/A";
    }

    public ImmutableList<Attribute> getGlobalAttributes() {
        return this.allAttributes;
    }

    @Override
    public String getLocation() {
        return this.location;
    }

    @Nullable
    public String getId() {
        return this.id;
    }

    public Group getRootGroup() {
        return this.rootGroup;
    }

    @Nullable
    public String getTitle() {
        return this.title;
    }

    public ImmutableList<Variable> getVariables() {
        return this.allVariables;
    }

    @Nullable
    public Dimension getUnlimitedDimension() {
        for (Dimension d : this.allDimensions) {
            if (!d.isUnlimited()) continue;
            return d;
        }
        return null;
    }

    public boolean hasUnlimitedDimension() {
        return this.getUnlimitedDimension() != null;
    }

    @Deprecated
    protected StructureDataIterator getStructureIterator(Structure s, int bufferSize) throws IOException {
        return this.iosp.getStructureIterator(s, bufferSize);
    }

    protected Iterator<StructureData> getStructureDataArrayIterator(Sequence s, int bufferSize) throws IOException {
        return this.iosp.getStructureDataArrayIterator(s, bufferSize);
    }

    @Deprecated
    protected Array readData(Variable v, Section ranges) throws IOException, ucar.ma2.InvalidRangeException {
        if (this.iosp == null) {
            throw new IOException("iosp is null, perhaps file has been closed. Trying to read variable " + v.getFullName());
        }
        return this.iosp.readData(v, ranges);
    }

    @Nullable
    protected ucar.array.Array<?> readArrayData(Variable v, ucar.array.Section ranges) throws IOException, InvalidRangeException {
        if (this.iosp == null) {
            throw new IOException("iosp is null, perhaps file has been closed. Trying to read variable " + v.getFullName());
        }
        return this.iosp.readArrayData(v, ranges);
    }

    @Deprecated
    public Array readSection(String variableSection) throws IOException, ucar.ma2.InvalidRangeException {
        ParsedSectionSpec cer = ParsedSectionSpec.parseVariableSection(this, variableSection);
        if (cer.getChild() == null) {
            return cer.getVariable().read(cer.getSection());
        }
        if (this.iosp == null) {
            return IospHelper.readSection(cer);
        }
        return this.iosp.readSection(cer);
    }

    public ucar.array.Array<?> readSectionArray(String variableSection) throws IOException, InvalidRangeException {
        ParsedArraySectionSpec cer = ParsedArraySectionSpec.parseVariableSection(this, variableSection);
        if (cer.getChild() == null) {
            return cer.getVariable().readArray(cer.getArraySection());
        }
        throw new UnsupportedOperationException();
    }

    protected long readToOutputStream(Variable v, Section section, OutputStream out) throws IOException, ucar.ma2.InvalidRangeException {
        if (this.iosp == null || v.hasCachedData()) {
            return IospHelper.copyToOutputStream(v.read(section), out);
        }
        return this.iosp.readToOutputStream(v, section, out);
    }

    public Object sendIospMessage(Object message) {
        if (null == message) {
            return null;
        }
        if (message == IOSP_MESSAGE_GET_IOSP) {
            return this.iosp;
        }
        if (message == IOSP_MESSAGE_ADD_RECORD_STRUCTURE) {
            Variable v = this.rootGroup.findVariableLocal("record");
            boolean gotit = v instanceof Structure;
            return gotit || this.makeRecordStructure();
        }
        if (this.iosp != null) {
            return this.iosp.sendIospMessage(message);
        }
        return null;
    }

    @Deprecated
    private boolean makeRecordStructure() {
        Boolean didit = false;
        if (this.iosp != null && this.iosp instanceof N3iosp && this.hasUnlimitedDimension()) {
            didit = (Boolean)this.iosp.sendIospMessage(IOSP_MESSAGE_ADD_RECORD_STRUCTURE);
        }
        return didit != null && didit != false;
    }

    protected void setCachedData(Variable v, ucar.array.Array<?> cacheData) {
        v.setCachedData(cacheData);
    }

    public String toString() {
        Formatter f = new Formatter();
        this.writeCDL(f, new Indent(2), false);
        return f.toString();
    }

    public String toNcml(String url) {
        NcmlWriter ncmlWriter = new NcmlWriter(null, null, NcmlWriter.writeNoVariablesPredicate);
        Element netcdfElement = ncmlWriter.makeNetcdfElement(this, url);
        return ncmlWriter.writeToString(netcdfElement);
    }

    public void writeNcml(OutputStream os, String uri) throws IOException {
        NcmlWriter ncmlWriter = new NcmlWriter();
        Element netcdfElem = ncmlWriter.makeNetcdfElement(this, uri);
        ncmlWriter.writeToStream(netcdfElem, os);
    }

    public void writeNcml(Writer writer, String uri) throws IOException {
        NcmlWriter ncmlWriter = new NcmlWriter();
        Element netcdfElem = ncmlWriter.makeNetcdfElement(this, uri);
        ncmlWriter.writeToWriter(netcdfElem, writer);
    }

    void writeCDL(Formatter f, Indent indent, boolean strict) {
        this.toStringStart(f, indent, strict);
        f.format("%s}%n", indent);
    }

    private void toStringStart(Formatter f, Indent indent, boolean strict) {
        String name = this.getLocation();
        if (strict) {
            if (name.endsWith(".nc")) {
                name = name.substring(0, name.length() - 3);
            }
            if (name.endsWith(".cdl")) {
                name = name.substring(0, name.length() - 4);
            }
            name = NetcdfFiles.makeValidCDLName(name);
        }
        f.format("%snetcdf %s {%n", indent, name);
        indent.incr();
        this.rootGroup.writeCDL(f, indent, strict);
        indent.decr();
    }

    @Override
    @Deprecated
    public long getLastModified() {
        if (this.iosp != null && this.iosp instanceof AbstractIOServiceProvider) {
            AbstractIOServiceProvider aspi = (AbstractIOServiceProvider)this.iosp;
            return aspi.getLastModified();
        }
        return 0L;
    }

    @Deprecated
    protected String toStringDebug(Object o) {
        return this.iosp == null ? "" : this.iosp.toStringDebug(o);
    }

    @Override
    @Deprecated
    public void release() throws IOException {
        if (this.iosp != null) {
            this.iosp.release();
        }
    }

    @Override
    @Deprecated
    public void reacquire() throws IOException {
        if (this.iosp != null) {
            this.iosp.reacquire();
        }
    }

    @Override
    @Deprecated
    public synchronized void setFileCache(FileCacheIF cache) {
        this.cache = cache;
    }

    public String getDetailInfo() {
        Formatter f = new Formatter();
        this.getDetailInfo(f);
        return f.toString();
    }

    public void getDetailInfo(Formatter f) {
        f.format("NetcdfFile location= %s%n", this.getLocation());
        f.format("  title= %s%n", this.getTitle());
        f.format("  id= %s%n", this.getId());
        f.format("  fileType= %s%n", this.getFileTypeId());
        f.format("  fileDesc= %s%n", this.getFileTypeDescription());
        f.format("  fileVersion= %s%n", this.getFileTypeVersion());
        f.format("  class= %s%n", this.getClass().getName());
        if (this.iosp == null) {
            f.format("  has no IOSP%n", new Object[0]);
        } else {
            f.format("  iosp= %s%n%n", this.iosp.getClass());
            f.format("%s", this.iosp.getDetailInfo());
        }
        this.showCached(f);
        this.showProxies(f);
    }

    @Deprecated
    protected void showCached(Formatter f) {
        int maxNameLen = 8;
        for (Variable v : this.getVariables()) {
            maxNameLen = Math.max(maxNameLen, v.getShortName().length());
        }
        long total = 0L;
        long totalCached = 0L;
        f.format("%n%-" + maxNameLen + "s isCaching  size     cachedSize (bytes) %n", "Variable");
        for (Variable v : this.getVariables()) {
            long vtotal = v.getSize() * (long)v.getElementSize();
            total += vtotal;
            f.format(" %-" + maxNameLen + "s %5s %8d ", v.getShortName(), v.isCaching(), vtotal);
            if (v.hasCachedData()) {
                Array data;
                try {
                    data = v.read();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return;
                }
                long size = data.getSizeBytes();
                f.format(" %8d", size);
                totalCached += size;
            }
            f.format("%n", new Object[0]);
        }
        f.format(" %" + maxNameLen + "s                  --------%n", " ");
        f.format(" %" + maxNameLen + "s total %8d Mb cached= %8d Kb%n", " ", total / 1000L / 1000L, totalCached / 1000L);
    }

    @Deprecated
    protected void showProxies(Formatter f) {
        int maxNameLen = 8;
        boolean hasProxy = false;
        for (Variable v : this.getVariables()) {
            if (v.proxyReader != v) {
                hasProxy = true;
            }
            maxNameLen = Math.max(maxNameLen, v.getShortName().length());
        }
        if (!hasProxy) {
            return;
        }
        f.format("%n%-" + maxNameLen + "s  proxyReader   Variable.Class %n", "Variable");
        for (Variable v : this.getVariables()) {
            if (v.proxyReader == v) continue;
            f.format(" %-" + maxNameLen + "s  %s %s%n", v.getShortName(), v.proxyReader.getClass().getName(), v.getClass().getName());
        }
        f.format("%n", new Object[0]);
    }

    protected NetcdfFile(Builder<?> builder) {
        this.location = builder.location;
        this.id = ((Builder)builder).id;
        this.title = ((Builder)builder).title;
        if (builder.rootGroup != null) {
            builder.rootGroup.setNcfile(this);
            this.rootGroup = builder.rootGroup.build();
        } else {
            this.rootGroup = Group.builder().setNcfile(this).setName("").build();
        }
        if (builder.iosp != null) {
            builder.iosp.setNetcdfFile(this);
            builder.iosp.setNetcdfFile(this);
        }
        this.iosp = builder.iosp;
        ImmutableList.Builder alist = ImmutableList.builder();
        ImmutableList.Builder dlist = ImmutableList.builder();
        ImmutableList.Builder vlist = ImmutableList.builder();
        this.extractAll(this.rootGroup, (ImmutableList.Builder<Attribute>)alist, (ImmutableList.Builder<Dimension>)dlist, (ImmutableList.Builder<Variable>)vlist);
        this.allAttributes = alist.build();
        this.allDimensions = dlist.build();
        this.allVariables = vlist.build();
    }

    private void extractAll(Group group, ImmutableList.Builder<Attribute> alist, ImmutableList.Builder<Dimension> dlist, ImmutableList.Builder<Variable> vlist) {
        alist.addAll((Iterable)group.attributes());
        group.getDimensions().stream().filter(Dimension::isShared).forEach(arg_0 -> dlist.add(arg_0));
        vlist.addAll(group.getVariables());
        for (Group nested : group.getGroups()) {
            this.extractAll(nested, alist, dlist, vlist);
        }
    }

    public Builder<?> toBuilder() {
        return this.addLocalFieldsToBuilder(NetcdfFile.builder());
    }

    protected Builder<?> addLocalFieldsToBuilder(Builder<? extends Builder<?>> b) {
        return ((Builder)((Builder)((Builder)b.setLocation(this.location).setId(this.id)).setTitle(this.title)).setRootGroup(this.rootGroup.toBuilder())).setIosp((AbstractIOServiceProvider)this.iosp);
    }

    public static Builder<?> builder() {
        return new Builder2();
    }

    public static abstract class Builder<T extends Builder<T>> {
        public Group.Builder rootGroup = Group.builder().setName("");
        private String id;
        private String title;
        public String location;
        protected AbstractIOServiceProvider iosp;
        private boolean built;

        protected abstract T self();

        public T setRootGroup(Group.Builder rootGroup) {
            Preconditions.checkArgument((boolean)rootGroup.shortName.equals(""), (Object)"root group name must be empty string");
            this.rootGroup = rootGroup;
            return this.self();
        }

        public T setIosp(AbstractIOServiceProvider iosp) {
            this.iosp = iosp;
            return this.self();
        }

        public T setId(String id) {
            this.id = id;
            return this.self();
        }

        public T setTitle(String title) {
            this.title = title;
            return this.self();
        }

        public T setLocation(String location) {
            this.location = location;
            return this.self();
        }

        public NetcdfFile build() {
            if (this.built) {
                throw new IllegalStateException("already built");
            }
            this.built = true;
            return new NetcdfFile(this);
        }
    }

    private static class Builder2
    extends Builder<Builder2> {
        private Builder2() {
        }

        @Override
        protected Builder2 self() {
            return this;
        }
    }
}

