/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2;

import com.google.common.base.Preconditions;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ServiceLoader;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.Group;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.internal.iosp.netcdf3.N3header;
import ucar.nc2.internal.iosp.netcdf3.N3iosp;
import ucar.nc2.internal.util.DiskCache;
import ucar.nc2.internal.util.EscapeStrings;
import ucar.nc2.internal.util.StringLocker;
import ucar.nc2.internal.util.URLnaming;
import ucar.nc2.iosp.AbstractIOServiceProvider;
import ucar.nc2.iosp.IOServiceProvider;
import ucar.nc2.util.CancelTask;
import ucar.nc2.util.IO;
import ucar.unidata.io.InMemoryRandomAccessFile;
import ucar.unidata.io.RandomAccessFile;
import ucar.unidata.io.spi.RandomAccessFileProvider;
import ucar.unidata.util.StringUtil2;

public class NetcdfFiles {
    private static final Logger log = LoggerFactory.getLogger(NetcdfFile.class);
    private static final List<IOServiceProvider> registeredProviders = new ArrayList<IOServiceProvider>();
    private static final List<RandomAccessFileProvider> registeredRandomAccessFileProviders = new ArrayList<RandomAccessFileProvider>();
    private static final int default_buffersize = 8092;
    private static final StringLocker stringLocker = new StringLocker();
    private static final List<String> possibleCompressedSuffixes = Arrays.asList("Z", "zip", "gzip", "gz", "bz2");
    private static final boolean loadWarnings = false;
    private static final boolean userLoadsFirst;
    public static final String reservedFullName = ".\\";
    private static final String reservedSectionSpec = "();,.\\";
    private static final String reservedCdl = "[ !\"#$%&'()*,:;<=>?[]^`{|}~\\";

    private NetcdfFiles() {
    }

    public static void registerIOProvider(String className) throws IllegalAccessException, InstantiationException, ClassNotFoundException {
        Class<?> ioClass = NetcdfFile.class.getClassLoader().loadClass(className);
        NetcdfFiles.registerIOProvider(ioClass);
    }

    public static void registerIOProvider(Class<?> iospClass) throws IllegalAccessException, InstantiationException {
        NetcdfFiles.registerIOProvider(iospClass, false);
    }

    private static void registerIOProvider(Class<?> iospClass, boolean last) throws IllegalAccessException, InstantiationException {
        IOServiceProvider spi = (IOServiceProvider)iospClass.newInstance();
        if (userLoadsFirst && !last) {
            registeredProviders.add(0, spi);
        } else {
            registeredProviders.add(spi);
        }
    }

    public static void registerRandomAccessFileProvider(String className) throws IllegalAccessException, InstantiationException, ClassNotFoundException {
        Class<?> rafClass = NetcdfFile.class.getClassLoader().loadClass(className);
        NetcdfFiles.registerRandomAccessFileProvider(rafClass);
    }

    public static void registerRandomAccessFileProvider(Class<?> rafClass) throws IllegalAccessException, InstantiationException {
        NetcdfFiles.registerRandomAccessFileProvider(rafClass, false);
    }

    private static void registerRandomAccessFileProvider(Class<?> rafClass, boolean last) throws IllegalAccessException, InstantiationException {
        RandomAccessFileProvider rafProvider = (RandomAccessFileProvider)rafClass.newInstance();
        if (userLoadsFirst && !last) {
            registeredRandomAccessFileProviders.add(0, rafProvider);
        } else {
            registeredRandomAccessFileProviders.add(rafProvider);
        }
    }

    public static NetcdfFile open(String location) throws IOException {
        return NetcdfFiles.open(location, -1, null);
    }

    public static NetcdfFile open(String location, CancelTask cancelTask) throws IOException {
        return NetcdfFiles.open(location, -1, cancelTask);
    }

    public static NetcdfFile open(String location, int buffer_size, CancelTask cancelTask) throws IOException {
        return NetcdfFiles.open(location, buffer_size, cancelTask, null);
    }

    public static NetcdfFile open(String location, int buffer_size, CancelTask cancelTask, Object iospMessage) throws IOException {
        RandomAccessFile raf = NetcdfFiles.getRaf(location, buffer_size);
        try {
            return NetcdfFiles.open(raf, location, cancelTask, iospMessage);
        }
        catch (Throwable t) {
            raf.close();
            throw new IOException(t);
        }
    }

    public static NetcdfFile open(String location, String iospClassName, int bufferSize, CancelTask cancelTask, Object iospMessage) throws ClassNotFoundException, IllegalAccessException, InstantiationException, IOException {
        Class<?> iospClass = NetcdfFile.class.getClassLoader().loadClass(iospClassName);
        IOServiceProvider spi = (IOServiceProvider)iospClass.newInstance();
        if (iospMessage != null) {
            spi.sendIospMessage(iospMessage);
        }
        if (bufferSize <= 0) {
            bufferSize = 8092;
        }
        String urlCanonical = URLnaming.canonicalizeUriString(location);
        RandomAccessFile raf = RandomAccessFile.acquire(urlCanonical, bufferSize);
        NetcdfFile result = NetcdfFiles.build(spi, raf, location, cancelTask);
        if (iospMessage != null) {
            spi.sendIospMessage(iospMessage);
        }
        return result;
    }

    public static boolean canOpen(String location) {
        boolean canOpen = false;
        try (RandomAccessFile raf = NetcdfFiles.getRaf(location, -1);){
            log.info(String.format("%s can be accessed with %s", raf.getLocation(), raf.getClass()));
            IOServiceProvider iosp = NetcdfFiles.getIosp(raf);
            if (iosp != null) {
                canOpen = true;
                log.info(String.format("%s can be opened by %s", raf.getLocation(), iosp.getClass()));
            }
        }
        catch (IOException e) {
            return false;
        }
        return canOpen;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static RandomAccessFile getRaf(String location, int buffer_size) throws IOException {
        String uriString = location.trim();
        if (buffer_size <= 0) {
            buffer_size = 8092;
        }
        RandomAccessFile raf = null;
        for (RandomAccessFileProvider provider : registeredRandomAccessFileProviders) {
            if (!provider.isOwnerOf(location)) continue;
            raf = provider.open(location, buffer_size);
            Preconditions.checkNotNull((Object)raf);
            if (!NetcdfFiles.looksCompressed(uriString)) break;
            raf = NetcdfFiles.downloadAndDecompress(raf, uriString, buffer_size);
            break;
        }
        if (raf == null) {
            for (RandomAccessFileProvider provider : ServiceLoader.load(RandomAccessFileProvider.class)) {
                if (!provider.isOwnerOf(location)) continue;
                raf = provider.open(location, buffer_size);
                Preconditions.checkNotNull((Object)raf);
                if (!NetcdfFiles.looksCompressed(uriString)) break;
                raf = NetcdfFiles.downloadAndDecompress(raf, uriString, buffer_size);
                break;
            }
        }
        if (raf == null) {
            if ((uriString = StringUtil2.replace(uriString, '\\', "/")).startsWith("file:")) {
                uriString = StringUtil2.unescape(uriString.substring(5));
            }
            String uncompressedFileName = null;
            if (NetcdfFiles.looksCompressed(uriString)) {
                try {
                    stringLocker.control(uriString);
                    uncompressedFileName = NetcdfFiles.makeUncompressed(uriString);
                }
                catch (Exception e) {
                    log.warn("Failed to uncompress {}, err= {}; try as a regular file.", (Object)uriString, (Object)e.getMessage());
                }
                finally {
                    stringLocker.release(uriString);
                }
            }
            raf = uncompressedFileName != null ? RandomAccessFile.acquire(uncompressedFileName, buffer_size) : RandomAccessFile.acquire(uriString, buffer_size);
        }
        if (raf == null) {
            throw new IOException("Could not find an appropriate RandomAccessFileProvider to open " + location);
        }
        return raf;
    }

    private static boolean looksCompressed(String filename) {
        int pos = filename.lastIndexOf(46);
        boolean looksCompressed = false;
        if (pos > 0) {
            String suffix = filename.substring(pos + 1).toLowerCase();
            looksCompressed = possibleCompressedSuffixes.stream().anyMatch(suffix::equalsIgnoreCase);
        }
        return looksCompressed;
    }

    private static RandomAccessFile downloadAndDecompress(RandomAccessFile raf, String uriString, int buffer_size) throws IOException {
        int pos = uriString.lastIndexOf(47);
        if (pos < 0) {
            pos = uriString.lastIndexOf(58);
        }
        String tmp = System.getProperty("java.io.tmpdir");
        String filename = uriString.substring(pos + 1);
        String sep = File.separator;
        uriString = DiskCache.getFileStandardPolicy(tmp + sep + filename).getPath();
        NetcdfFiles.copy(raf, new FileOutputStream(uriString), 0x100000);
        try {
            String uncompressedFileName = NetcdfFiles.makeUncompressed(uriString);
            return RandomAccessFile.acquire(uncompressedFileName, buffer_size);
        }
        catch (Exception e) {
            throw new IOException();
        }
    }

    private static void copy(RandomAccessFile in, OutputStream out, int bufferSize) throws IOException {
        byte[] buffer = new byte[bufferSize];
        int bytesRead = 0;
        for (long length = in.length(); length > 0L; length -= (long)bufferSize) {
            if (length > (long)bufferSize) {
                in.readFully(buffer, 0, bufferSize);
                bytesRead = bufferSize;
            } else if (length <= (long)bufferSize) {
                in.readFully(buffer, 0, (int)length);
                bytesRead = (int)length;
            }
            out.write(buffer, 0, bytesRead);
        }
    }

    /*
     * Exception decompiling
     */
    private static String makeUncompressed(String filename) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [72[UNCONDITIONALDOLOOP]], but top level block is 8[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static NetcdfFile openInMemory(String filename) throws IOException {
        File file = new File(filename);
        ByteArrayOutputStream bos = new ByteArrayOutputStream((int)file.length());
        try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(filename));){
            IO.copy(in, bos);
        }
        return NetcdfFiles.openInMemory(filename, bos.toByteArray());
    }

    public static NetcdfFile openInMemory(URI uri) throws IOException {
        byte[] contents;
        URL url = uri.toURL();
        try (InputStream in = url.openStream();){
            contents = IO.readContentsToByteArray(in);
        }
        return NetcdfFiles.openInMemory(uri.toString(), contents);
    }

    public static NetcdfFile openInMemory(String name, byte[] data) throws IOException {
        InMemoryRandomAccessFile raf = new InMemoryRandomAccessFile(name, data);
        return NetcdfFiles.open(raf, name, null, null);
    }

    public static NetcdfFile openInMemory(String name, byte[] data, String iospClassName) throws IOException, ClassNotFoundException, IllegalAccessException, InstantiationException {
        InMemoryRandomAccessFile raf = new InMemoryRandomAccessFile(name, data);
        Class<?> iospClass = NetcdfFile.class.getClassLoader().loadClass(iospClassName);
        IOServiceProvider spi = (IOServiceProvider)iospClass.newInstance();
        return NetcdfFiles.build(spi, raf, name, null);
    }

    public static NetcdfFile open(RandomAccessFile raf, String location, @Nullable CancelTask cancelTask, @Nullable Object iospMessage) throws IOException {
        IOServiceProvider spi = NetcdfFiles.getIosp(raf);
        if (spi == null) {
            raf.close();
            throw new IOException("Cant read " + location + ": not a valid CDM file.");
        }
        if (iospMessage != null) {
            spi.sendIospMessage(iospMessage);
        }
        if (log.isDebugEnabled()) {
            log.debug("Using IOSP {}", (Object)spi.getClass().getName());
        }
        NetcdfFile ncfile = NetcdfFiles.build(spi, raf, location, cancelTask);
        spi.buildFinish(ncfile);
        if (iospMessage != null) {
            spi.sendIospMessage(iospMessage);
        }
        return ncfile;
    }

    @Nullable
    private static IOServiceProvider getIosp(RandomAccessFile raf) throws IOException {
        if (NetcdfFile.debugSPI) {
            log.info("NetcdfFile try to open = {}", (Object)raf.getLocation());
        }
        for (IOServiceProvider registeredSpi : registeredProviders) {
            if (NetcdfFile.debugSPI) {
                log.info(" try iosp = {}", (Object)registeredSpi.getClass().getName());
            }
            if (!registeredSpi.isValidFile(raf)) continue;
            Class<?> c = registeredSpi.getClass();
            try {
                return (IOServiceProvider)c.newInstance();
            }
            catch (InstantiationException e) {
                throw new IOException("IOServiceProvider " + c.getName() + "must have no-arg constructor.");
            }
            catch (IllegalAccessException e) {
                throw new IOException("IOServiceProvider " + c.getName() + " IllegalAccessException: " + e.getMessage());
            }
        }
        if (N3header.isValidFile(raf)) {
            return new N3iosp();
        }
        for (IOServiceProvider loadedSpi : ServiceLoader.load(IOServiceProvider.class)) {
            if (!loadedSpi.isValidFile(raf)) continue;
            Class<?> c = loadedSpi.getClass();
            try {
                return (IOServiceProvider)c.newInstance();
            }
            catch (InstantiationException e) {
                throw new IOException("IOServiceProvider " + c.getName() + "must have no-arg constructor.");
            }
            catch (IllegalAccessException e) {
                throw new IOException("IOServiceProvider " + c.getName() + " IllegalAccessException: " + e.getMessage());
            }
        }
        return null;
    }

    public static NetcdfFile build(IOServiceProvider spi, RandomAccessFile raf, String location, CancelTask cancelTask) throws IOException {
        Object builder = ((NetcdfFile.Builder)NetcdfFile.builder().setIosp((AbstractIOServiceProvider)spi)).setLocation(location);
        try {
            String title;
            Group.Builder root = Group.builder().setName("");
            spi.build(raf, root, cancelTask);
            ((NetcdfFile.Builder)builder).setRootGroup(root);
            String id = root.getAttributeContainer().findAttributeString("_Id", null);
            if (id != null) {
                ((NetcdfFile.Builder)builder).setId(id);
            }
            if ((title = root.getAttributeContainer().findAttributeString("_Title", null)) != null) {
                ((NetcdfFile.Builder)builder).setTitle(title);
            }
        }
        catch (IOException | RuntimeException e) {
            try {
                raf.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                spi.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw e;
        }
        catch (Throwable t) {
            try {
                spi.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                raf.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw new RuntimeException(t);
        }
        return ((NetcdfFile.Builder)builder).build();
    }

    public static String makeValidCdmObjectName(String shortName) {
        if (shortName == null) {
            return null;
        }
        return StringUtil2.makeValidCdmObjectName(shortName);
    }

    public static String makeValidCDLName(String vname) {
        return EscapeStrings.backslashEscape(vname, reservedCdl);
    }

    public static String makeValidPathName(String vname) {
        return EscapeStrings.backslashEscape(vname, reservedFullName);
    }

    static String makeValidSectionSpecName(String vname) {
        return EscapeStrings.backslashEscape(vname, reservedSectionSpec);
    }

    public static String makeNameUnescaped(String vname) {
        return EscapeStrings.backslashUnescape(vname);
    }

    public static String makeFullName(Group g) {
        Group parent = g.getParentGroup();
        if (parent == null || parent.isRoot()) {
            return EscapeStrings.backslashEscape(g.getShortName(), reservedFullName);
        }
        StringBuilder sbuff = new StringBuilder();
        NetcdfFiles.appendGroupName(sbuff, parent, reservedFullName);
        return sbuff.toString();
    }

    public static String makeFullName(Variable v) {
        return NetcdfFiles.makeFullName(v, reservedFullName);
    }

    public static String makeFullNameSectionSpec(Variable v) {
        return NetcdfFiles.makeFullName(v, reservedSectionSpec);
    }

    private static String makeFullName(Variable node, String reservedChars) {
        Group parent = node.getParentGroup();
        if ((parent == null || parent.isRoot()) && !node.isMemberOfStructure()) {
            return EscapeStrings.backslashEscape(node.getShortName(), reservedChars);
        }
        StringBuilder sbuff = new StringBuilder();
        NetcdfFiles.appendGroupName(sbuff, parent, reservedChars);
        NetcdfFiles.appendStructureName(sbuff, node, reservedChars);
        return sbuff.toString();
    }

    private static void appendGroupName(StringBuilder sbuff, Group g, String reserved) {
        if (g == null) {
            return;
        }
        if (g.getParentGroup() == null) {
            return;
        }
        NetcdfFiles.appendGroupName(sbuff, g.getParentGroup(), reserved);
        sbuff.append(EscapeStrings.backslashEscape(g.getShortName(), reserved));
        sbuff.append("/");
    }

    private static void appendStructureName(StringBuilder sbuff, Variable n, String reserved) {
        if (n == null) {
            return;
        }
        if (n.isMemberOfStructure()) {
            NetcdfFiles.appendStructureName(sbuff, n.getParentStructure(), reserved);
            sbuff.append(".");
        }
        sbuff.append(EscapeStrings.backslashEscape(n.getShortName(), reserved));
    }

    protected static String makeFullNameWithString(Group parent, String name) {
        name = NetcdfFiles.makeValidPathName(name);
        StringBuilder sbuff = new StringBuilder();
        NetcdfFiles.appendGroupName(sbuff, parent, null);
        sbuff.append(name);
        return sbuff.toString();
    }

    static {
        try {
            NetcdfFiles.registerIOProvider("ucar.nc2.internal.iosp.hdf5.H5iospArrays");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            NetcdfFiles.registerIOProvider("ucar.nc2.stream.NcStreamIosp");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            NetcdfFiles.registerIOProvider("ucar.nc2.internal.iosp.hdf4.H4iosp");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            NetcdfFiles.registerRandomAccessFileProvider("ucar.unidata.io.http.HTTPRandomAccessFile$Provider");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            NetcdfFiles.registerRandomAccessFileProvider("ucar.unidata.io.InMemoryRandomAccessFile$Provider");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        userLoadsFirst = true;
    }
}

