/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2;

import java.util.List;
import javax.annotation.Nullable;
import ucar.array.ArrayType;
import ucar.array.InvalidRangeException;
import ucar.array.Range;
import ucar.array.Section;
import ucar.nc2.NetcdfFile;
import ucar.nc2.NetcdfFiles;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.internal.util.EscapeStrings;

public class ParsedArraySectionSpec {
    private static final boolean debugSelector = false;
    private final Variable variable;
    private final Section section;
    private ParsedArraySectionSpec child;

    public static ParsedArraySectionSpec parseVariableSection(NetcdfFile ncfile, String variableSection) throws InvalidRangeException {
        ParsedArraySectionSpec outerV;
        List<String> tokes = EscapeStrings.tokenizeEscapedName(variableSection);
        if (tokes.isEmpty()) {
            throw new IllegalArgumentException("empty sectionSpec = " + variableSection);
        }
        String selector = tokes.get(0);
        ParsedArraySectionSpec current = outerV = ParsedArraySectionSpec.parseSelector(ncfile, selector);
        for (int i = 1; i < tokes.size(); ++i) {
            selector = tokes.get(i);
            current = current.child = ParsedArraySectionSpec.parseSelector(current.getVariable(), selector);
        }
        return outerV;
    }

    private static ParsedArraySectionSpec parseSelector(Object parent, String selector) throws InvalidRangeException {
        Section section;
        String varNameEsc;
        String indexSelect = null;
        int pos1 = EscapeStrings.indexOf(selector, '(');
        if (pos1 < 0) {
            varNameEsc = selector;
        } else {
            varNameEsc = selector.substring(0, pos1);
            int pos2 = selector.indexOf(41, pos1 + 1);
            indexSelect = selector.substring(pos1, pos2);
        }
        Variable v = null;
        if (parent instanceof NetcdfFile) {
            NetcdfFile ncfile = (NetcdfFile)parent;
            v = ncfile.findVariable(varNameEsc);
        } else if (parent instanceof Structure) {
            Structure s = (Structure)parent;
            v = s.findVariable(NetcdfFiles.makeNameUnescaped(varNameEsc));
        }
        if (v == null) {
            throw new IllegalArgumentException(" cant find variable: " + varNameEsc + " in selector=" + selector);
        }
        if (v.getArrayType() == ArrayType.SEQUENCE) {
            indexSelect = null;
        }
        if (indexSelect != null) {
            section = new Section(indexSelect);
            section = Section.fill(section, v.getShape());
        } else {
            section = v.getSection();
        }
        return new ParsedArraySectionSpec(v, section);
    }

    public static ParsedArraySectionSpec makeFromVariable(Variable v, String selector) throws InvalidRangeException {
        Section section;
        String indexSelect = null;
        int pos1 = EscapeStrings.indexOf(selector, '(');
        if (pos1 < 0) {
            String varNameEsc = selector;
        } else {
            String varNameEsc = selector.substring(0, pos1);
            int pos2 = selector.indexOf(41, pos1 + 1);
            indexSelect = selector.substring(pos1, pos2);
        }
        if (v.getArrayType() == ArrayType.SEQUENCE) {
            indexSelect = null;
        }
        if (indexSelect != null) {
            section = new Section(indexSelect);
            section = Section.fill(section, v.getShape());
        } else {
            section = v.getSection();
        }
        return new ParsedArraySectionSpec(v, section);
    }

    public static String makeSectionSpecString(Variable v, @Nullable Section section) {
        StringBuilder sb = new StringBuilder();
        ParsedArraySectionSpec.makeSpec(sb, v, section);
        return sb.toString();
    }

    private static Section makeSpec(StringBuilder sb, Variable v, Section orgSection) {
        if (v.isMemberOfStructure()) {
            assert (v.getParentStructure() != null);
            orgSection = ParsedArraySectionSpec.makeSpec(sb, v.getParentStructure(), orgSection);
            sb.append('.');
        }
        Section vsection = orgSection == null ? v.getSection() : orgSection;
        sb.append(v.isMemberOfStructure() ? NetcdfFiles.makeValidSectionSpecName(v.getShortName()) : NetcdfFiles.makeFullNameSectionSpec(v));
        if (!v.isVariableLength() && !v.isScalar()) {
            sb.append('(');
            for (int count = 0; count < v.getRank(); ++count) {
                Range r = vsection.getRange(count);
                if (r == null) {
                    r = new Range(v.getDimension(count).getLength());
                }
                if (count > 0) {
                    sb.append(", ");
                }
                sb.append(r);
            }
            sb.append(')');
        }
        if (orgSection == null) {
            return null;
        }
        List<Range> ranges = vsection.getRanges();
        return new Section(ranges.subList(v.getRank(), vsection.getRank()));
    }

    public ParsedArraySectionSpec(Variable variable, Section section) {
        this.variable = variable;
        this.section = section;
    }

    public Variable getVariable() {
        return this.variable;
    }

    public Section getArraySection() {
        return this.section;
    }

    public ParsedArraySectionSpec getChild() {
        return this.child;
    }

    public String toString() {
        return "ParsedSectionSpec{v=" + this.variable.getFullName() + ", section=" + this.section + ", child=" + this.child + '}';
    }

    public String makeSectionSpecString() {
        return ParsedArraySectionSpec.makeSectionSpecString(this.variable, this.section);
    }
}

