/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2;

import java.io.IOException;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.Array;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Section;
import ucar.nc2.Group;
import ucar.nc2.ProxyReader;
import ucar.nc2.Variable;
import ucar.nc2.util.CancelTask;

@Immutable
class SliceReader
implements ProxyReader {
    private static final Logger log = LoggerFactory.getLogger(SliceReader.class);
    private final Variable orgClient;
    private final Group parentGroup;
    private final String orgName;
    private final int sliceDim;
    private final Section slice;

    SliceReader(Variable orgClient, int dim, Section slice) {
        this.orgClient = orgClient;
        this.sliceDim = dim;
        this.slice = slice;
        this.orgName = orgClient.getShortName();
        this.parentGroup = orgClient.getParentGroup();
    }

    SliceReader(Group parentGroup, String orgName, int dim, Section slice) {
        this.parentGroup = parentGroup;
        this.orgName = orgName;
        this.sliceDim = dim;
        this.slice = slice;
        this.orgClient = null;
    }

    @Override
    public Array reallyRead(Variable client, CancelTask cancelTask) throws IOException {
        Array data;
        Variable orgClient = this.orgClient != null ? this.orgClient : this.parentGroup.findVariableLocal(this.orgName);
        try {
            data = orgClient._read(this.slice);
        }
        catch (InvalidRangeException e) {
            log.error("InvalidRangeException in slice, var=" + client);
            throw new IllegalStateException(e.getMessage());
        }
        data = data.reduce(this.sliceDim);
        return data;
    }

    @Override
    public Array reallyRead(Variable client, Section section, CancelTask cancelTask) throws IOException, InvalidRangeException {
        Variable orgClient = this.parentGroup.findVariableLocal(this.orgName);
        Section.Builder orgSection = Section.builder().appendRanges(section.getRanges());
        orgSection.insertRange(this.sliceDim, this.slice.getRange(this.sliceDim));
        Array data = orgClient._read(orgSection.build());
        data = data.reduce(this.sliceDim);
        return data;
    }
}

