/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.array.ArrayType;
import ucar.array.StructureMembers;
import ucar.ma2.Array;
import ucar.ma2.ArrayObject;
import ucar.ma2.ArrayStructure;
import ucar.ma2.DataType;
import ucar.ma2.Index;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Range;
import ucar.ma2.Section;
import ucar.ma2.StructureData;
import ucar.ma2.StructureDataIterator;
import ucar.ma2.StructureMembers;
import ucar.nc2.Attribute;
import ucar.nc2.Group;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.util.Indent;

@Immutable
public class Structure
extends Variable {
    private static final Logger log = LoggerFactory.getLogger(Structure.class);
    private static final int defaultBufferSize = 500000;
    protected final ImmutableList<Variable> members;
    private final HashMap<String, Variable> memberHash;
    protected final boolean isSubset;

    @Nullable
    public Variable findVariable(String shortName) {
        if (shortName == null) {
            return null;
        }
        return this.memberHash.get(shortName);
    }

    public int getNumberOfMemberVariables() {
        return this.members.size();
    }

    @Override
    public int getElementSize() {
        return this.elementSize;
    }

    public ImmutableList<Variable> getVariables() {
        return this.members;
    }

    public ImmutableList<String> getVariableNames() {
        return (ImmutableList)this.members.stream().map(Variable::getShortName).collect(ImmutableList.toImmutableList());
    }

    public boolean isSubset() {
        return this.isSubset;
    }

    @Deprecated
    public StructureMembers makeStructureMembers() {
        StructureMembers.Builder builder = StructureMembers.builder().setName(this.getShortName());
        for (Variable v2 : this.getVariables()) {
            StructureMembers.MemberBuilder m = builder.addMember(v2.getShortName(), v2.getDescription(), v2.getUnitsString(), v2.getDataType(), v2.getShape());
            if (!(v2 instanceof Structure)) continue;
            m.setStructureMembers(((Structure)v2).makeStructureMembers());
        }
        return builder.build();
    }

    public StructureMembers.Builder makeStructureMembersBuilder() {
        StructureMembers.Builder builder = ucar.array.StructureMembers.builder().setName(this.getShortName());
        for (Variable v2 : this.getVariables()) {
            StructureMembers.MemberBuilder m = builder.addMember(v2.getShortName(), v2.getDescription(), v2.getUnitsString(), v2.getArrayType(), v2.getShape());
            if (!(v2 instanceof Structure)) continue;
            Structure s2 = (Structure)v2;
            m.setStructureMembers(s2.makeStructureMembersBuilder());
        }
        return builder;
    }

    public Structure select(List<String> memberNames) {
        Variable.Builder result = this.toBuilder();
        result.setElementSize(this.elementSize);
        ArrayList selected = new ArrayList();
        for (String name : memberNames) {
            ((Builder)result).findMemberVariable(name).ifPresent(selected::add);
        }
        ((Builder)result).vbuilders = selected;
        ((Builder)result).isSubset = true;
        return ((Builder)result).build(this.getParentGroup());
    }

    public Structure select(String varName) {
        Preconditions.checkArgument((this.findVariable(varName) != null ? 1 : 0) != 0);
        return this.select((List<String>)ImmutableList.of((Object)varName));
    }

    private int calcElementSize() {
        return this.makeStructureMembersBuilder().getStorageSizeBytes(false);
    }

    @Deprecated
    public StructureData readStructure(int index) throws IOException, InvalidRangeException {
        Section.Builder sb = Section.builder();
        if (this.getRank() == 1) {
            sb.appendRange(index, index);
        } else if (this.getRank() > 1) {
            int[] origin;
            Index ii = Index.factory(this.shape);
            ii.setCurrentCounter(index);
            for (int anOrigin : origin = ii.getCurrentCounter()) {
                sb.appendRange(anOrigin, anOrigin);
            }
        }
        Array dataArray = this.read(sb.build());
        if (dataArray instanceof ArrayStructure) {
            ArrayStructure data = (ArrayStructure)dataArray;
            return data.getStructureData(0);
        }
        if (dataArray instanceof ArrayObject) {
            return (StructureData)dataArray.getObject(0);
        }
        throw new RuntimeException("Unknown structure array class " + dataArray.getClass().getName());
    }

    @Deprecated
    public ArrayStructure readStructure(int start, int count) throws IOException, InvalidRangeException {
        Preconditions.checkArgument((this.getRank() <= 1 ? 1 : 0) != 0, (Object)"not a vector structure");
        int[] origin = new int[]{start};
        int[] shape = new int[]{count};
        return (ArrayStructure)this.read(origin, shape);
    }

    @Deprecated
    public StructureDataIterator getStructureIterator() throws IOException {
        return this.getStructureIterator(500000);
    }

    @Deprecated
    public StructureDataIterator getStructureIterator(int bufferSize) throws IOException {
        return this.getRank() < 2 ? new IteratorRank1(bufferSize) : new IteratorRankAny();
    }

    public String getNameAndAttributes() {
        Formatter sbuff = new Formatter();
        sbuff.format("Structure ", new Object[0]);
        this.getNameAndDimensions(sbuff, false, true);
        sbuff.format("%n", new Object[0]);
        for (Attribute att : this.attributes) {
            sbuff.format("  %s:%s;%n", this.getShortName(), att.toString());
        }
        return sbuff.toString();
    }

    @Override
    protected void writeCDL(Formatter buf, Indent indent, boolean useFullName, boolean strict) {
        buf.format("%n%s%s {%n", new Object[]{indent, this.dataType});
        indent.incr();
        for (Variable v : this.members) {
            v.writeCDL(buf, indent, useFullName, strict);
        }
        indent.decr();
        buf.format("%s} ", indent);
        this.getNameAndDimensions(buf, useFullName, strict);
        buf.format(";%s%n", this.extraInfo());
        for (Attribute att : this.attributes()) {
            buf.format("%s", indent);
            att.writeCDL(buf, strict, this.getShortName());
            buf.format(";", new Object[0]);
            if (!strict && att.getArrayType() != ArrayType.STRING) {
                buf.format(" // %s", new Object[]{att.getDataType()});
            }
            buf.format("%n", new Object[0]);
        }
        buf.format("%n", new Object[0]);
    }

    protected Structure(Builder<?> builder, Group parentGroup) {
        super(builder, parentGroup);
        builder.vbuilders.forEach(v -> ((Variable.Builder)v.setParentStructure(this)).setNcfile(builder.ncfile));
        this.members = (ImmutableList)builder.vbuilders.stream().map(vb -> vb.build(parentGroup)).collect(ImmutableList.toImmutableList());
        this.memberHash = new HashMap();
        this.members.forEach(m -> this.memberHash.put(m.getShortName(), (Variable)m));
        if (builder.elementSize <= 0) {
            this.elementSize = this.calcElementSize();
        }
        this.isSubset = ((Builder)builder).isSubset;
    }

    public Builder<?> toBuilder() {
        return this.addLocalFieldsToBuilder(Structure.builder());
    }

    protected Builder<?> addLocalFieldsToBuilder(Builder<? extends Builder<?>> b) {
        this.members.forEach(m -> b.addMemberVariable(m.toBuilder()));
        return (Builder)super.addLocalFieldsToBuilder(b);
    }

    public static Builder<?> builder() {
        return new Builder2();
    }

    public static abstract class Builder<T extends Builder<T>>
    extends Variable.Builder<T> {
        public List<Variable.Builder<?>> vbuilders = new ArrayList();
        private boolean isSubset;
        private boolean built;

        public T addMemberVariable(Variable.Builder<?> v) {
            this.vbuilders.add(v);
            v.setParentStructureBuilder(this);
            return (T)((Builder)this.self());
        }

        public T addMemberVariables(List<Variable.Builder<?>> vars) {
            this.vbuilders.addAll(vars);
            return (T)((Builder)this.self());
        }

        @Deprecated
        public T addMemberVariable(String shortName, DataType dataType, String dimString) {
            Object vb = ((Variable.Builder)((Variable.Builder)((Variable.Builder)Variable.builder().setName(shortName)).setDataType(dataType)).setParentGroupBuilder(this.parentBuilder)).setDimensionsByName(dimString);
            this.addMemberVariable((Variable.Builder<?>)vb);
            return (T)((Builder)this.self());
        }

        public T addMemberVariable(String shortName, ArrayType dataType, String dimString) {
            Object vb = ((Variable.Builder)((Variable.Builder)((Variable.Builder)Variable.builder().setName(shortName)).setArrayType(dataType)).setParentGroupBuilder(this.parentBuilder)).setDimensionsByName(dimString);
            this.addMemberVariable((Variable.Builder<?>)vb);
            return (T)((Builder)this.self());
        }

        public boolean removeMemberVariable(String memberName) {
            Optional<Variable.Builder> want = this.vbuilders.stream().filter(v -> v.shortName.equals(memberName)).findFirst();
            want.ifPresent(v -> this.vbuilders.remove(v));
            return want.isPresent();
        }

        public boolean replaceMemberVariable(Variable.Builder<?> replacement) {
            boolean wasPresent = this.removeMemberVariable(replacement.shortName);
            this.addMemberVariable(replacement);
            return wasPresent;
        }

        public long calcElementSize() {
            int total = 0;
            for (Variable.Builder<?> v : this.vbuilders) {
                total = (int)((long)total + (long)v.getElementSize() * v.getSize());
            }
            return total;
        }

        public Optional<Variable.Builder<?>> findMemberVariable(String name) {
            return this.vbuilders.stream().filter(d -> d.shortName.equals(name)).findFirst();
        }

        @Override
        public Structure build(Group parentGroup) {
            if (this.built) {
                throw new IllegalStateException("already built");
            }
            this.built = true;
            this.setArrayType(ArrayType.STRUCTURE);
            return new Structure(this, parentGroup);
        }
    }

    private static class Builder2
    extends Builder<Builder2> {
        private Builder2() {
        }

        @Override
        protected Builder2 self() {
            return this;
        }
    }

    private class IteratorRankAny
    implements StructureDataIterator {
        private int count;
        private int total;
        private int readStart;
        private int readCount;
        private int outerCount;
        private ArrayStructure as;

        private IteratorRankAny() {
            this.total = (int)Structure.this.getSize();
        }

        @Override
        public boolean hasNext() {
            return this.count < this.total;
        }

        @Override
        public StructureDataIterator reset() {
            this.count = 0;
            this.total = (int)Structure.this.getSize();
            this.readStart = 0;
            this.readCount = 0;
            this.outerCount = 0;
            return this;
        }

        @Override
        public int getCurrentRecno() {
            return this.count - 1;
        }

        @Override
        public StructureData next() throws IOException {
            if (this.count >= this.readStart) {
                this.readNextGeneralRank();
            }
            ++this.count;
            return this.as.getStructureData(this.readCount++);
        }

        private void readNextGeneralRank() throws IOException {
            try {
                Section.Builder sb = Section.builder().appendRanges(Structure.this.shape);
                sb.setRange(0, new Range(this.outerCount, this.outerCount));
                this.as = (ArrayStructure)Structure.this.read(sb.build());
                if (NetcdfFile.debugStructureIterator) {
                    System.out.println("readNext inner=" + this.outerCount + " total=" + this.outerCount);
                }
                ++this.outerCount;
            }
            catch (InvalidRangeException e) {
                log.error("Structure.Iterator.readNext() ", (Throwable)e);
                throw new IllegalStateException("Structure.Iterator.readNext() ", e);
            }
            this.readStart = (int)((long)this.readStart + this.as.getSize());
            this.readCount = 0;
        }
    }

    private class IteratorRank1
    implements StructureDataIterator {
        private int count;
        private final int recnum;
        private int readStart;
        private int readCount;
        private int readAtaTime;
        private ArrayStructure as;

        IteratorRank1(int bufferSize) {
            this.recnum = (int)Structure.this.getSize();
            this.setBufferSize(bufferSize);
        }

        @Override
        public boolean hasNext() {
            return this.count < this.recnum;
        }

        @Override
        public StructureDataIterator reset() {
            this.count = 0;
            this.readStart = 0;
            this.readCount = 0;
            return this;
        }

        @Override
        public StructureData next() throws IOException {
            if (this.count >= this.readStart) {
                this.readNext();
            }
            ++this.count;
            return this.as.getStructureData(this.readCount++);
        }

        @Override
        public int getCurrentRecno() {
            return this.count - 1;
        }

        private void readNext() throws IOException {
            int left = Math.min(this.recnum, this.readStart + this.readAtaTime);
            int need = left - this.readStart;
            try {
                this.as = Structure.this.readStructure(this.readStart, need);
                if (NetcdfFile.debugStructureIterator) {
                    System.out.println("readNext " + this.count + " " + this.readStart);
                }
            }
            catch (InvalidRangeException e) {
                log.error("Structure.IteratorRank1.readNext() ", (Throwable)e);
                throw new IllegalStateException("Structure.Iterator.readNext() ", e);
            }
            this.readStart += need;
            this.readCount = 0;
        }

        @Override
        public void setBufferSize(int bytes) {
            if (this.count > 0) {
                return;
            }
            int structureSize = Structure.this.getElementSize();
            if (structureSize <= 0) {
                structureSize = 1;
            }
            if (bytes <= 0) {
                bytes = 500000;
            }
            this.readAtaTime = Math.max(10, bytes / structureSize);
            if (NetcdfFile.debugStructureIterator) {
                System.out.println("Iterator structureSize= " + structureSize + " readAtaTime= " + this.readAtaTime);
            }
        }
    }
}

