/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Formatter;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.array.ArrayType;
import ucar.array.Arrays;
import ucar.array.ArraysConvert;
import ucar.array.InvalidRangeException;
import ucar.ma2.Array;
import ucar.ma2.ArrayChar;
import ucar.ma2.ArrayStructure;
import ucar.ma2.DataType;
import ucar.ma2.Index;
import ucar.ma2.Range;
import ucar.ma2.Section;
import ucar.nc2.Attribute;
import ucar.nc2.AttributeContainer;
import ucar.nc2.AttributeContainerMutable;
import ucar.nc2.Dimension;
import ucar.nc2.Dimensions;
import ucar.nc2.EnumTypedef;
import ucar.nc2.Group;
import ucar.nc2.NetcdfFile;
import ucar.nc2.NetcdfFiles;
import ucar.nc2.ProxyReader;
import ucar.nc2.ReduceReader;
import ucar.nc2.SectionReader;
import ucar.nc2.SliceReader;
import ucar.nc2.Structure;
import ucar.nc2.VariableSimpleIF;
import ucar.nc2.iosp.IospHelper;
import ucar.nc2.util.CancelTask;
import ucar.nc2.util.Indent;

@Immutable
public class Variable
implements VariableSimpleIF,
ProxyReader {
    private static final Logger log = LoggerFactory.getLogger(Variable.class);
    private static final boolean showSize = false;
    public static boolean permitCaching = true;
    private static final int defaultSizeToCache = 4000;
    private static final int defaultCoordsSizeToCache = 40000;
    protected int hashCode;
    private final String shortName;
    private final Group parentGroup;
    @Nullable
    private final Structure parentStructure;
    @Nullable
    protected final NetcdfFile ncfile;
    @Nullable
    private final EnumTypedef enumTypedef;
    @Nullable
    protected final Object spiObject;
    protected final ImmutableList<Dimension> dimensions;
    protected final AttributeContainer attributes;
    protected final ProxyReader proxyReader;
    private Section shapeAsSection;
    protected int[] shape;
    protected boolean isVariableLength;
    protected int elementSize;
    protected ArrayType dataType;
    protected Cache cache;

    public int findDimensionIndex(String name) {
        for (int i = 0; i < this.dimensions.size(); ++i) {
            Dimension d = (Dimension)this.dimensions.get(i);
            if (!name.equals(d.getShortName())) continue;
            return i;
        }
        return -1;
    }

    public String getDatasetLocation() {
        if (this.ncfile != null) {
            return this.ncfile.getLocation();
        }
        return "N/A";
    }

    @Override
    @Deprecated
    public DataType getDataType() {
        return this.dataType.getDataType();
    }

    @Override
    public ArrayType getArrayType() {
        return this.dataType;
    }

    @Override
    public String getDescription() {
        String desc = null;
        Attribute att = this.attributes.findAttributeIgnoreCase("long_name");
        if (att != null && att.isString()) {
            desc = att.getStringValue();
        }
        if (desc == null && (att = this.attributes.findAttributeIgnoreCase("description")) != null && att.isString()) {
            desc = att.getStringValue();
        }
        if (desc == null && (att = this.attributes.findAttributeIgnoreCase("title")) != null && att.isString()) {
            desc = att.getStringValue();
        }
        if (desc == null && (att = this.attributes.findAttributeIgnoreCase("standard_name")) != null && att.isString()) {
            desc = att.getStringValue();
        }
        return desc;
    }

    @Override
    public ImmutableList<Dimension> getDimensions() {
        return this.dimensions;
    }

    public ImmutableSet<Dimension> getDimensionSet() {
        return ImmutableSet.copyOf(this.dimensions);
    }

    public Dimension getDimension(int i) {
        if (i < 0 || i >= this.getRank()) {
            return null;
        }
        return (Dimension)this.dimensions.get(i);
    }

    public String getDimensionsString() {
        return Dimensions.makeDimensionsString(this.dimensions);
    }

    public int getElementSize() {
        return this.elementSize;
    }

    @Nullable
    public EnumTypedef getEnumTypedef() {
        return this.enumTypedef;
    }

    @Nullable
    public String getFileTypeId() {
        return this.ncfile == null ? null : this.ncfile.getFileTypeId();
    }

    @Override
    public String getFullName() {
        return NetcdfFiles.makeFullName(this);
    }

    @Nullable
    public NetcdfFile getNetcdfFile() {
        return this.ncfile;
    }

    public Group getParentGroup() {
        return this.parentGroup;
    }

    @Nullable
    public Structure getParentStructure() {
        return this.parentStructure;
    }

    public ImmutableList<Range> getRanges() {
        return ImmutableList.copyOf(this.getShapeAsSection().getRanges());
    }

    @Override
    public int getRank() {
        return this.shape.length;
    }

    @Override
    public int[] getShape() {
        int[] result = new int[this.shape.length];
        System.arraycopy(this.shape, 0, result, 0, this.shape.length);
        return result;
    }

    public int getShape(int index) {
        return this.shape[index];
    }

    @Deprecated
    public Section getShapeAsSection() {
        return this.shapeAsSection;
    }

    public ucar.array.Section getSection() {
        return ArraysConvert.convertSection(this.shapeAsSection);
    }

    @Override
    public String getShortName() {
        return this.shortName;
    }

    public long getSize() {
        return Arrays.computeSize(this.shape);
    }

    @Override
    @Nullable
    public String getUnitsString() {
        String units = null;
        Attribute att = this.attributes().findAttributeIgnoreCase("units");
        if (att != null && att.isString() && (units = att.getStringValue()) != null) {
            units = units.trim();
        }
        return units;
    }

    public boolean isCoordinateVariable() {
        Dimension firstd;
        if (this.getArrayType() == ArrayType.STRUCTURE || this.isMemberOfStructure()) {
            return false;
        }
        int n = this.getRank();
        if (n == 1 && this.dimensions.size() == 1) {
            firstd = (Dimension)this.dimensions.get(0);
            if (this.getShortName().equals(firstd.getShortName())) {
                return true;
            }
        }
        if (n == 2 && this.dimensions.size() == 2) {
            firstd = (Dimension)this.dimensions.get(0);
            return this.shortName.equals(firstd.getShortName()) && this.getArrayType() == ArrayType.CHAR;
        }
        return false;
    }

    public boolean isMemberOfStructure() {
        return this.parentStructure != null;
    }

    public boolean isMetadata() {
        return this.cache != null && this.cache.srcData != null;
    }

    public boolean isScalar() {
        return this.getRank() == 0;
    }

    public boolean isUnlimited() {
        for (Dimension d : this.dimensions) {
            if (!d.isUnlimited()) continue;
            return true;
        }
        return false;
    }

    public boolean isVariableLength() {
        return this.isVariableLength;
    }

    @Nullable
    public String lookupEnumString(int val) {
        Preconditions.checkArgument((boolean)this.dataType.isEnum(), (Object)"Can only call Variable.lookupEnumVal() on enum types");
        Preconditions.checkNotNull((Object)this.enumTypedef, (Object)"enum Variable does not have enumTypedef");
        return this.enumTypedef.lookupEnumString(val);
    }

    public Variable section(List<Range> ranges) throws ucar.ma2.InvalidRangeException {
        return this.section(new Section(ranges, this.shape));
    }

    public Variable section(Section subsection) throws ucar.ma2.InvalidRangeException {
        subsection = Section.fill(subsection, this.shape);
        Builder<?> sectionV = this.toBuilder();
        sectionV.setProxyReader(new SectionReader(this, subsection));
        sectionV.resetCache();
        sectionV.setIsCaching(false);
        int[] shape = subsection.getShape();
        ArrayList<Dimension> dimensions = new ArrayList<Dimension>();
        for (int i = 0; i < this.getRank(); ++i) {
            Dimension oldD = this.getDimension(i);
            Dimension newD = oldD.getLength() == shape[i] ? oldD : Dimension.builder().setName(oldD.getShortName()).setIsUnlimited(oldD.isUnlimited()).setIsShared(false).setLength(shape[i]).build();
            dimensions.add(newD);
        }
        ((Builder)sectionV).dimensions = dimensions;
        return sectionV.build(this.getParentGroup());
    }

    public Variable slice(int dim, int value) throws ucar.ma2.InvalidRangeException {
        if (dim < 0 || dim >= this.shape.length) {
            throw new ucar.ma2.InvalidRangeException("Slice dim invalid= " + dim);
        }
        boolean recordSliceOk = false;
        if (dim == 0 && value == 0) {
            Dimension d = this.getDimension(0);
            recordSliceOk = d.isUnlimited();
        }
        if (!(recordSliceOk || value >= 0 && value < this.shape[dim])) {
            throw new ucar.ma2.InvalidRangeException("Slice value invalid= " + value + " for dimension " + dim);
        }
        Builder<?> sliceV = this.toBuilder();
        Section.Builder slice = Section.builder().appendRanges(this.getShape());
        slice.replaceRange(dim, new Range(value, value));
        sliceV.setProxyReader(new SliceReader(this, dim, slice.build()));
        sliceV.resetCache();
        sliceV.setIsCaching(false);
        ((Builder)sliceV).dimensions.remove(dim);
        return sliceV.build(this.getParentGroup());
    }

    public Variable reduce(List<Dimension> dims) {
        ArrayList<Integer> dimIdx = new ArrayList<Integer>(dims.size());
        for (Dimension d : dims) {
            assert (this.dimensions.contains((Object)d));
            assert (d.getLength() == 1);
            dimIdx.add(this.dimensions.indexOf((Object)d));
        }
        Builder<?> sliceV = this.toBuilder();
        sliceV.setProxyReader(new ReduceReader(this, dimIdx));
        sliceV.resetCache();
        sliceV.setIsCaching(false);
        for (Dimension d : dims) {
            ((Builder)sliceV).dimensions.remove(d);
        }
        return sliceV.build(this.getParentGroup());
    }

    @Deprecated
    public long readToStream(Section section, OutputStream out) throws IOException, ucar.ma2.InvalidRangeException {
        if (this.ncfile == null || this.hasCachedData()) {
            return IospHelper.copyToOutputStream(this.read(section), out);
        }
        return this.ncfile.readToOutputStream(this, section, out);
    }

    @Deprecated
    public Array read(int[] origin, int[] shape) throws IOException, ucar.ma2.InvalidRangeException {
        if (origin == null && shape == null) {
            return this.read();
        }
        if (origin == null) {
            return this.read(new Section(shape));
        }
        if (shape == null) {
            return this.read(new Section(origin, this.shape));
        }
        return this.read(new Section(origin, shape));
    }

    @Deprecated
    public Array read(String sectionSpec) throws IOException, ucar.ma2.InvalidRangeException {
        return this.read(new Section(sectionSpec));
    }

    @Deprecated
    public Array read(List<Range> ranges) throws IOException, ucar.ma2.InvalidRangeException {
        if (null == ranges) {
            return this._read();
        }
        return this.read(new Section(ranges));
    }

    @Deprecated
    public Array read(Section section) throws IOException, ucar.ma2.InvalidRangeException {
        return section == null ? this._read() : this._read(Section.fill(section, this.shape));
    }

    @Deprecated
    public Array read() throws IOException {
        return this._read();
    }

    @Deprecated
    public byte readScalarByte() throws IOException {
        Array data = this._readScalarData();
        return data.getByte(Index.scalarIndexImmutable);
    }

    @Deprecated
    public short readScalarShort() throws IOException {
        Array data = this._readScalarData();
        return data.getShort(Index.scalarIndexImmutable);
    }

    @Deprecated
    public int readScalarInt() throws IOException {
        Array data = this._readScalarData();
        return data.getInt(Index.scalarIndexImmutable);
    }

    @Deprecated
    public long readScalarLong() throws IOException {
        Array data = this._readScalarData();
        return data.getLong(Index.scalarIndexImmutable);
    }

    @Deprecated
    public float readScalarFloat() throws IOException {
        Array data = this._readScalarData();
        return data.getFloat(Index.scalarIndexImmutable);
    }

    @Deprecated
    public double readScalarDouble() throws IOException {
        Array data = this._readScalarData();
        return data.getDouble(Index.scalarIndexImmutable);
    }

    @Deprecated
    public String readScalarString() throws IOException {
        Array data = this._readScalarData();
        if (this.getArrayType() == ArrayType.STRING) {
            return (String)data.getObject(Index.scalarIndexImmutable);
        }
        if (this.getArrayType() == ArrayType.CHAR) {
            ArrayChar dataC = (ArrayChar)data;
            return dataC.getString();
        }
        throw new IllegalArgumentException("readScalarString not STRING or CHAR " + this.getFullName());
    }

    protected Array _read() throws IOException {
        if (this.cache.getData() != null) {
            return ArraysConvert.convertFromArray(this.cache.getData());
        }
        Array data = this.proxyReader.reallyRead(this, null);
        if (this.isCaching()) {
            this.cache.setCachedData(ArraysConvert.convertToArray(data));
        }
        return data;
    }

    public ucar.array.Array<?> readArray() throws IOException {
        if (this.cache.getData() != null) {
            return this.cache.getData();
        }
        ucar.array.Array<?> data = this.proxyReader.proxyReadArray(this, null);
        if (this.isCaching()) {
            this.cache.setCachedData(data);
        }
        return data;
    }

    protected Array _read(Section section) throws IOException, ucar.ma2.InvalidRangeException {
        if (null == section || section.computeSize() == this.getSize()) {
            return this._read();
        }
        if (this.isCaching()) {
            Array cacheData;
            if (this.cache.getData() == null) {
                cacheData = this._read();
                this.cache.setCachedData(ArraysConvert.convertToArray(cacheData));
            } else {
                cacheData = ArraysConvert.convertFromArray(this.cache.getData());
            }
            return cacheData.sectionNoReduce(section.getRanges()).copy();
        }
        return this.proxyReader.reallyRead(this, section, null);
    }

    public ucar.array.Array<?> readArray(@Nullable ucar.array.Section section) throws IOException, InvalidRangeException {
        if (null == section || section.computeSize() == this.getSize()) {
            return this.readArray();
        }
        if (this.isCaching()) {
            if (this.cache.getData() == null) {
                this.cache.setCachedData(this.readArray());
            }
            return Arrays.section(this.cache.getData(), section);
        }
        return this.proxyReader.proxyReadArray(this, section, null);
    }

    @Deprecated
    protected Array _readScalarData() throws IOException {
        Array scalarData = this.read();
        if ((scalarData = scalarData.reduce()).getRank() == 0 || scalarData.getRank() == 1 && this.getArrayType() == ArrayType.CHAR) {
            return scalarData;
        }
        throw new UnsupportedOperationException("not a scalar variable =" + this);
    }

    @Override
    @Deprecated
    public Array reallyRead(Variable client, CancelTask cancelTask) throws IOException {
        if (this.isMemberOfStructure()) {
            ArrayList<String> memList = new ArrayList<String>();
            memList.add(this.getShortName());
            Structure s = this.getParentStructure().select(memList);
            ArrayStructure as = (ArrayStructure)s.read();
            return as.extractMemberArray(as.findMember(this.getShortName()));
        }
        try {
            return this.ncfile.readData(this, this.getShapeAsSection());
        }
        catch (ucar.ma2.InvalidRangeException e) {
            e.printStackTrace();
            throw new IOException(e.getMessage());
        }
    }

    @Override
    public ucar.array.Array<?> proxyReadArray(Variable client, CancelTask cancelTask) throws IOException {
        if (this.isMemberOfStructure()) {
            throw new UnsupportedOperationException("Cannot directly read Member Variable=" + this.getFullName());
        }
        try {
            return this.ncfile.readArrayData(this, this.getSection());
        }
        catch (InvalidRangeException e) {
            e.printStackTrace();
            throw new IOException(e.getMessage());
        }
    }

    @Override
    @Deprecated
    public Array reallyRead(Variable client, Section section, CancelTask cancelTask) throws IOException, ucar.ma2.InvalidRangeException {
        if (this.isMemberOfStructure()) {
            throw new UnsupportedOperationException("Cannot directly read section of Member Variable=" + this.getFullName());
        }
        return this.ncfile.readData(this, section);
    }

    @Override
    public ucar.array.Array<?> proxyReadArray(Variable client, ucar.array.Section section, CancelTask cancelTask) throws IOException, InvalidRangeException {
        if (this.isMemberOfStructure()) {
            throw new UnsupportedOperationException("Cannot directly read section of Member Variable=" + this.getFullName());
        }
        return this.ncfile.readArrayData(this, section);
    }

    public String getNameAndDimensions() {
        Formatter buf = new Formatter();
        this.getNameAndDimensions(buf, true, false);
        return buf.toString();
    }

    public void getNameAndDimensions(Formatter buf, boolean useFullName, boolean strict) {
        String name;
        useFullName = useFullName && !strict;
        String string = name = useFullName ? this.getFullName() : this.getShortName();
        if (strict) {
            name = NetcdfFiles.makeValidCDLName(this.getShortName());
        }
        buf.format("%s", name);
        if (this.shape != null) {
            if (this.getRank() > 0) {
                buf.format("(", new Object[0]);
            }
            for (int i = 0; i < this.dimensions.size(); ++i) {
                Dimension myd = (Dimension)this.dimensions.get(i);
                String dimName = myd.getShortName();
                if (dimName != null && strict) {
                    dimName = NetcdfFiles.makeValidCDLName(dimName);
                }
                if (i != 0) {
                    buf.format(", ", new Object[0]);
                }
                if (myd.isVariableLength()) {
                    buf.format("*", new Object[0]);
                    continue;
                }
                if (myd.isShared()) {
                    if (!strict) {
                        buf.format("%s=%d", dimName, myd.getLength());
                        continue;
                    }
                    buf.format("%s", dimName);
                    continue;
                }
                if (dimName != null) {
                    buf.format("%s=", dimName);
                }
                buf.format("%d", myd.getLength());
            }
            if (this.getRank() > 0) {
                buf.format(")", new Object[0]);
            }
        }
    }

    public String toString() {
        Formatter buf = new Formatter();
        this.writeCDL(buf, new Indent(2), false, false);
        return buf.toString();
    }

    protected void writeCDL(Formatter buf, Indent indent, boolean useFullName, boolean strict) {
        buf.format("%s", indent);
        if (this.dataType == null) {
            buf.format("Unknown", new Object[0]);
        } else if (this.dataType.isEnum()) {
            if (this.enumTypedef == null) {
                buf.format("enum UNKNOWN", new Object[0]);
            } else {
                buf.format("enum %s", NetcdfFiles.makeValidCDLName(this.enumTypedef.getShortName()));
            }
        } else {
            buf.format("%s", this.dataType.toCdl());
        }
        buf.format(" ", new Object[0]);
        this.getNameAndDimensions(buf, useFullName, strict);
        buf.format(";", new Object[0]);
        if (!strict) {
            buf.format(this.extraInfo(), new Object[0]);
        }
        buf.format("%n", new Object[0]);
        indent.incr();
        for (Attribute att : this.attributes()) {
            buf.format("%s", indent);
            att.writeCDL(buf, strict, this.getShortName());
            buf.format(";", new Object[0]);
            if (!strict && att.getArrayType() == ArrayType.STRING) {
                buf.format(" // %s", att.getArrayType().toCdl());
            }
            buf.format("%n", new Object[0]);
        }
        indent.decr();
    }

    public String toStringDebug() {
        Formatter f = new Formatter();
        f.format("Variable %s", this.getFullName());
        if (this.ncfile != null) {
            f.format(" in file %s", this.getDatasetLocation());
            String extra = this.ncfile.toStringDebug(this);
            if (extra != null) {
                f.format(" %s", extra);
            }
        }
        return f.toString();
    }

    protected String extraInfo() {
        return "";
    }

    public boolean equals(Object oo) {
        if (this == oo) {
            return true;
        }
        if (!(oo instanceof Variable)) {
            return false;
        }
        Variable o = (Variable)oo;
        if (!this.getShortName().equals(o.getShortName())) {
            return false;
        }
        if (this.isScalar() != o.isScalar()) {
            return false;
        }
        if (this.getDataType() != o.getDataType()) {
            return false;
        }
        if (!this.getParentGroup().equals(o.getParentGroup())) {
            return false;
        }
        if (this.getParentStructure() != null && !this.getParentStructure().equals(o.getParentStructure())) {
            return false;
        }
        if (this.isVariableLength() != o.isVariableLength()) {
            return false;
        }
        if (this.dimensions.size() != o.getDimensions().size()) {
            return false;
        }
        for (int i = 0; i < this.dimensions.size(); ++i) {
            if (this.getDimension(i).equals(o.getDimension(i))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int result = 17;
            result = 37 * result + this.getShortName().hashCode();
            if (this.isScalar()) {
                ++result;
            }
            result = 37 * result + this.getDataType().hashCode();
            result = 37 * result + this.getParentGroup().hashCode();
            if (this.getParentStructure() != null) {
                result = 37 * result + this.getParentStructure().hashCode();
            }
            if (this.isVariableLength) {
                ++result;
            }
            this.hashCode = result = 37 * result + this.dimensions.hashCode();
        }
        return this.hashCode;
    }

    @Override
    public int compareTo(VariableSimpleIF o) {
        return this.getShortName().compareTo(o.getShortName());
    }

    @Override
    public AttributeContainer attributes() {
        return this.attributes;
    }

    @Nullable
    public Attribute findAttribute(String name) {
        return this.attributes.findAttribute(name);
    }

    public String findAttributeString(String attName, String defaultValue) {
        return this.attributes.findAttributeString(attName, defaultValue);
    }

    @Deprecated
    public void resetShape() {
        this.shape = new int[this.dimensions.size()];
        for (int i = 0; i < this.dimensions.size(); ++i) {
            Dimension dim = (Dimension)this.dimensions.get(i);
            this.shape[i] = dim.getLength();
            if (!dim.isVariableLength()) continue;
            this.isVariableLength = true;
        }
        this.shapeAsSection = Dimensions.makeSectionFromDimensions(this.dimensions).build();
    }

    public Object getSPobject() {
        return this.spiObject;
    }

    public int getSizeToCache() {
        if (this.cache.sizeToCacheBytes != null) {
            return this.cache.sizeToCacheBytes;
        }
        return this.isCoordinateVariable() ? 40000 : 4000;
    }

    public void setCaching(boolean caching) {
        this.cache.setIsCaching(caching);
        if (!caching) {
            this.cache.setCachedData(null);
        }
    }

    public boolean isCaching() {
        if (!permitCaching) {
            return false;
        }
        if (this.cache.isCaching != null) {
            return this.cache.isCaching;
        }
        if (this.cache.srcData != null || this.cache.cacheData != null) {
            return true;
        }
        return !(this instanceof Structure) && !this.isVariableLength && this.getSize() * (long)this.getElementSize() < (long)this.getSizeToCache();
    }

    public void invalidateCache() {
        this.cache.setCachedData(null);
    }

    protected void setCachedData(ucar.array.Array<?> cacheData) {
        if (cacheData != null && cacheData.getArrayType() != this.getArrayType()) {
            throw new IllegalArgumentException("setCachedData type=" + (Object)((Object)cacheData.getArrayType()) + " incompatible with variable type=" + (Object)((Object)this.getDataType()));
        }
        this.cache.setCachedData(cacheData);
    }

    public boolean hasCachedData() {
        return null != this.cache.cacheData || null != this.cache.srcData;
    }

    protected Variable(Builder<?> builder, Group parentGroup) {
        ProxyReader useProxyReader;
        if (parentGroup == null) {
            throw new IllegalStateException(String.format("Parent Group must be set for Variable %s", builder.shortName));
        }
        if (builder.dataType == null) {
            throw new IllegalStateException(String.format("DataType must be set for Variable %s", builder.shortName));
        }
        if (builder.shortName == null || builder.shortName.isEmpty()) {
            throw new IllegalStateException("Name must be set for Variable");
        }
        this.shortName = builder.shortName;
        this.parentGroup = parentGroup;
        this.ncfile = builder.ncfile;
        this.parentStructure = ((Builder)builder).parentStruct;
        this.dataType = builder.dataType;
        this.attributes = ((Builder)builder).attributes;
        this.spiObject = builder.spiObject;
        this.cache = builder.cache;
        ProxyReader proxyReader = useProxyReader = builder.proxyReader == null ? this : builder.proxyReader;
        if (this.dataType.isEnum()) {
            this.enumTypedef = this.parentGroup.findEnumeration(((Builder)builder).enumTypeName);
            if (this.enumTypedef == null) {
                throw new IllegalStateException(String.format("EnumTypedef '%s' does not exist in a parent Group", ((Builder)builder).enumTypeName));
            }
        } else {
            this.enumTypedef = null;
        }
        ArrayList<Dimension> dims = new ArrayList<Dimension>();
        for (Dimension dim : ((Builder)builder).dimensions) {
            if (dim.isShared()) {
                Dimension sharedDim = this.parentGroup.findDimension(dim.getShortName()).orElse(null);
                if (sharedDim == null) {
                    throw new IllegalStateException(String.format("Shared Dimension %s does not exist in a parent proup", dim));
                }
                dims.add(sharedDim);
                continue;
            }
            dims.add(dim);
        }
        if (((Builder)builder).slicer != null) {
            int dim = ((Builder)builder).slicer.dim;
            int index = ((Builder)builder).slicer.index;
            Section slice = Dimensions.makeSectionFromDimensions(dims).replaceRange(dim, Range.make(index, index)).build();
            useProxyReader = new SliceReader(parentGroup, ((Builder)builder).slicer.orgName, dim, slice);
            builder.resetCache();
            dims.remove(dim);
        }
        this.proxyReader = useProxyReader;
        this.dimensions = ImmutableList.copyOf(dims);
        if (((Builder)builder).autoGen != null) {
            this.cache.srcData = ((Builder)builder).autoGen.makeDataArray(this.getArrayType(), this.dimensions);
        }
        this.elementSize = builder.elementSize > 0 ? builder.elementSize : this.getDataType().getSize();
        this.isVariableLength = this.dimensions.stream().anyMatch(Dimension::isVariableLength);
        try {
            ArrayList<Range> list = new ArrayList<Range>();
            for (Dimension d : this.dimensions) {
                int len = d.getLength();
                if (len > 0) {
                    list.add(new Range(d.getShortName(), 0, len - 1));
                    continue;
                }
                if (len == 0) {
                    list.add(Range.EMPTY);
                    continue;
                }
                assert (d.isVariableLength());
                list.add(Range.VLEN);
            }
            this.shapeAsSection = new Section(list);
            this.shape = this.shapeAsSection.getShape();
        }
        catch (ucar.ma2.InvalidRangeException e) {
            log.error("Bad shape in variable " + this.getFullName(), (Throwable)e);
            throw new IllegalStateException(e.getMessage());
        }
    }

    public Builder<?> toBuilder() {
        return this.addLocalFieldsToBuilder(Variable.builder());
    }

    protected Builder<?> addLocalFieldsToBuilder(Builder<? extends Builder<?>> builder) {
        ((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)builder.setName(this.shortName).setNcfile(this.ncfile)).setParentStructure(this.getParentStructure())).setArrayType(this.dataType)).setEnumTypeName(this.enumTypedef != null ? this.enumTypedef.getShortName() : null)).addDimensions((Collection<Dimension>)this.dimensions)).addAttributes(this.attributes)).setSPobject(this.spiObject);
        if (this.proxyReader != this) {
            builder.setProxyReader(this.proxyReader);
        }
        if (this.cache.srcData != null) {
            builder.setSourceData(this.cache.srcData);
        }
        return builder;
    }

    public static Builder<?> builder() {
        return new Builder2();
    }

    @Immutable
    private static class Slicer {
        final int dim;
        final int index;
        final String orgName;

        Slicer(int dim, int index, String orgName) {
            this.dim = dim;
            this.index = index;
            this.orgName = orgName;
        }
    }

    @Immutable
    private static class AutoGen {
        final double start;
        final double incr;

        private AutoGen(double start, double incr) {
            this.start = start;
            this.incr = incr;
        }

        private ucar.array.Array<?> makeDataArray(ArrayType dtype, List<Dimension> dimensions) {
            Section section = Dimensions.makeSectionFromDimensions(dimensions).build();
            return ArraysConvert.convertToArray(Array.makeArray(dtype.getDataType(), (int)section.getSize(), this.start, this.incr).reshape(section.getShape()));
        }
    }

    public static abstract class Builder<T extends Builder<T>> {
        public String shortName;
        public ArrayType dataType;
        protected int elementSize;
        public NetcdfFile ncfile;
        private Structure parentStruct;
        protected Group.Builder parentBuilder;
        protected Structure.Builder<?> parentStructureBuilder;
        private ArrayList<Dimension> dimensions = new ArrayList();
        public Object spiObject;
        public ProxyReader proxyReader;
        public Cache cache = new Cache();
        private String enumTypeName;
        private AutoGen autoGen;
        private Slicer slicer;
        private final AttributeContainerMutable attributes = new AttributeContainerMutable("");
        private boolean built;

        protected abstract T self();

        public T addAttribute(Attribute att) {
            this.attributes.addAttribute(att);
            return this.self();
        }

        public T addAttributes(Iterable<Attribute> atts) {
            this.attributes.addAll(atts);
            return this.self();
        }

        public AttributeContainerMutable getAttributeContainer() {
            return this.attributes;
        }

        public T addDimension(Dimension dim) {
            this.dimensions.add(dim);
            return this.self();
        }

        public T addDimensions(Collection<Dimension> dims) {
            this.dimensions.addAll(dims);
            return this.self();
        }

        public T setDimensions(List<Dimension> dims) {
            this.dimensions = new ArrayList<Dimension>(dims);
            return this.self();
        }

        public boolean replaceDimensionByName(Dimension dim) {
            int idx = -1;
            for (int i = 0; i < this.dimensions.size(); ++i) {
                if (!this.dimensions.get(i).getShortName().equals(dim.getShortName())) continue;
                idx = i;
            }
            if (idx >= 0) {
                this.dimensions.set(idx, dim);
            }
            return idx >= 0;
        }

        public void replaceDimension(int idx, Dimension dim) {
            this.dimensions.set(idx, dim);
        }

        public T setDimensionsByName(String dimString) {
            if (dimString == null || dimString.isEmpty()) {
                return this.self();
            }
            Preconditions.checkNotNull((Object)this.parentBuilder);
            this.dimensions = new ArrayList<Dimension>((Collection<Dimension>)this.parentBuilder.makeDimensionsList(dimString));
            return this.self();
        }

        @Nullable
        public String getFirstDimensionName() {
            return this.getDimensionName(0);
        }

        @Nullable
        public String getDimensionName(int index) {
            if (this.dimensions.size() > index) {
                return this.dimensions.get(index).getShortName();
            }
            return null;
        }

        public Iterable<String> getDimensionNames() {
            if (this.dimensions.size() > 0) {
                return this.dimensions.stream().map(Dimension::getShortName).filter(Objects::nonNull).collect(Collectors.toList());
            }
            return ImmutableList.of();
        }

        public String makeDimensionsString() {
            return Dimensions.makeDimensionsString(this.dimensions);
        }

        public T setDimensionsAnonymous(int[] shape) {
            this.dimensions = new ArrayList<Dimension>((Collection<Dimension>)Dimensions.makeDimensionsAnon(shape));
            return this.self();
        }

        public ImmutableList<Dimension> getDimensions() {
            return ImmutableList.copyOf(this.dimensions);
        }

        public Dimension getDimension(int idx) {
            return this.dimensions.get(idx);
        }

        public ImmutableSet<String> getDimensionNamesAll() {
            ImmutableSet.Builder dimsAll = new ImmutableSet.Builder();
            this.addDimensionNamesAll((ImmutableSet.Builder<String>)dimsAll, this);
            return dimsAll.build();
        }

        private void addDimensionNamesAll(ImmutableSet.Builder<String> result, Builder<?> v) {
            if (v.parentStructureBuilder != null) {
                v.parentStructureBuilder.getDimensionNamesAll().forEach(arg_0 -> result.add(arg_0));
            }
            this.getDimensionNames().forEach(arg_0 -> result.add(arg_0));
        }

        public boolean isUnlimited() {
            for (Dimension d : this.dimensions) {
                if (!d.isUnlimited()) continue;
                return true;
            }
            return false;
        }

        public T setIsScalar() {
            this.dimensions = new ArrayList();
            return this.self();
        }

        public int getRank() {
            return this.dimensions.size();
        }

        public int[] getShape() {
            return Dimensions.makeShape(this.dimensions);
        }

        public long getSize() {
            return Dimensions.getSize(this.dimensions);
        }

        @Deprecated
        public T setDataType(DataType dataType) {
            this.dataType = dataType.getArrayType();
            return this.self();
        }

        public T setArrayType(ArrayType dataType) {
            this.dataType = dataType;
            return this.self();
        }

        public String getEnumTypeName() {
            return this.enumTypeName;
        }

        public int getElementSize() {
            return this.elementSize > 0 ? this.elementSize : this.dataType.getSize();
        }

        public T setElementSize(int elementSize) {
            this.elementSize = elementSize;
            return this.self();
        }

        public T setEnumTypeName(String enumTypeName) {
            this.enumTypeName = enumTypeName;
            return this.self();
        }

        public T setNcfile(NetcdfFile ncfile) {
            this.ncfile = ncfile;
            return this.self();
        }

        public T setSPobject(Object spiObject) {
            this.spiObject = spiObject;
            return this.self();
        }

        public T setName(String shortName) {
            this.shortName = NetcdfFiles.makeValidCdmObjectName(shortName);
            this.attributes.setName(shortName);
            return this.self();
        }

        public String getFullName() {
            Group.Builder group;
            String full = "";
            Group.Builder builder = group = this.parentStructureBuilder != null ? this.parentStructureBuilder.parentBuilder : this.parentBuilder;
            if (group != null) {
                full = group.makeFullName();
            }
            if (this.parentStructureBuilder != null) {
                full = full + this.parentStructureBuilder.shortName + ".";
            }
            return full + this.shortName;
        }

        public T setParentGroupBuilder(Group.Builder parent) {
            this.parentBuilder = parent;
            return this.self();
        }

        public Group.Builder getParentGroupBuilder() {
            return this.parentBuilder;
        }

        T setParentStructureBuilder(Structure.Builder<?> structureBuilder) {
            this.parentStructureBuilder = structureBuilder;
            return this.self();
        }

        public Structure.Builder<?> getParentStructureBuilder() {
            return this.parentStructureBuilder;
        }

        T setParentStructure(Structure parent) {
            this.parentStruct = parent;
            return this.self();
        }

        public T setProxyReader(ProxyReader proxy) {
            this.proxyReader = proxy;
            return this.self();
        }

        @Deprecated
        public T setCachedData(Array cacheData, boolean isMetadata) {
            this.cache.srcData = ArraysConvert.convertToArray(cacheData);
            return this.self();
        }

        @Deprecated
        public T setSourceData(Array srcData) {
            this.cache.srcData = ArraysConvert.convertToArray(srcData);
            return this.self();
        }

        public T setSourceData(ucar.array.Array<?> srcData) {
            this.cache.srcData = srcData;
            return this.self();
        }

        public T setAutoGen(double start, double incr) {
            this.autoGen = new AutoGen(start, incr);
            return this.self();
        }

        public T resetAutoGen() {
            this.autoGen = null;
            return this.self();
        }

        public T resetCache() {
            this.cache = new Cache();
            return this.self();
        }

        public T setIsCaching(boolean caching) {
            this.cache.isCaching = caching;
            return this.self();
        }

        public T setSizeToCacheInBytes(int sizeToCacheBytes) {
            this.cache.sizeToCacheBytes = sizeToCacheBytes;
            return this.self();
        }

        public Builder<?> makeSliceBuilder(int dim, int index) {
            Builder<?> sliced = this.copy();
            sliced.slicer = new Slicer(dim, index, this.shortName);
            return sliced;
        }

        public Builder<?> copy() {
            return new Builder2().copyFrom(this);
        }

        public T copyFrom(Variable orgVar) {
            this.setName(orgVar.getShortName());
            this.setDataType(orgVar.getDataType());
            if (orgVar.getEnumTypedef() != null) {
                this.setEnumTypeName(orgVar.getEnumTypedef().getShortName());
            }
            this.setSPobject(orgVar.getSPobject());
            this.addDimensions((Collection<Dimension>)orgVar.getDimensions());
            this.addAttributes(orgVar.attributes());
            return this.self();
        }

        public T copyFrom(Builder<?> builder) {
            this.addAttributes(builder.attributes);
            this.autoGen = builder.autoGen;
            this.cache = builder.cache;
            this.setArrayType(builder.dataType);
            this.addDimensions(builder.dimensions);
            this.elementSize = builder.elementSize;
            this.setEnumTypeName(builder.getEnumTypeName());
            this.setNcfile(builder.ncfile);
            this.parentBuilder = builder.parentBuilder;
            this.setParentStructure(builder.parentStruct);
            this.setParentStructureBuilder(builder.parentStructureBuilder);
            this.setProxyReader(builder.proxyReader);
            this.setName(builder.shortName);
            this.setSPobject(builder.spiObject);
            return this.self();
        }

        public String toString() {
            return this.dataType.toCdl() + " " + this.shortName;
        }

        public Variable build(Group parentGroup) {
            if (this.built) {
                throw new IllegalStateException("already built");
            }
            this.built = true;
            return new Variable(this, parentGroup);
        }
    }

    private static class Builder2
    extends Builder<Builder2> {
        private Builder2() {
        }

        @Override
        protected Builder2 self() {
            return this;
        }
    }

    protected static class Cache {
        private ucar.array.Array<?> srcData;
        private ucar.array.Array<?> cacheData;
        private Integer sizeToCacheBytes;
        private Boolean isCaching;

        private Cache() {
        }

        protected void reset() {
            this.cacheData = null;
        }

        protected ucar.array.Array<?> getData() {
            return this.srcData != null ? this.srcData : this.cacheData;
        }

        protected void setIsCaching(boolean isCaching) {
            this.isCaching = isCaching;
        }

        protected void setCachedData(ucar.array.Array<?> data) {
            this.cacheData = data;
        }
    }
}

