/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.constants;

public enum FeatureType {
    ANY,
    COVERAGE,
    GRID,
    FMRC,
    SWATH,
    CURVILINEAR,
    ANY_POINT,
    POINT,
    PROFILE,
    STATION,
    STATION_PROFILE,
    TRAJECTORY,
    TRAJECTORY_PROFILE,
    RADIAL,
    STATION_RADIAL,
    SIMPLE_GEOMETRY,
    IMAGE,
    UGRID;


    public static FeatureType getType(String name) {
        if (name == null) {
            return null;
        }
        try {
            return FeatureType.valueOf(name.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public boolean isPointFeatureType() {
        return this == ANY_POINT || this == POINT || this == STATION || this == TRAJECTORY || this == PROFILE || this == STATION_PROFILE || this == TRAJECTORY_PROFILE;
    }

    public boolean isCoverageFeatureType() {
        return this == COVERAGE || this == GRID || this == FMRC || this == SWATH || this == CURVILINEAR;
    }

    public boolean isUnstructuredGridFeatureType() {
        return this == UGRID;
    }

    public boolean isSimpleGeometry() {
        return this == SIMPLE_GEOMETRY;
    }
}

