/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dataset;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Comparator;
import java.util.Formatter;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.array.ArrayType;
import ucar.ma2.Array;
import ucar.ma2.MAMath;
import ucar.nc2.Attribute;
import ucar.nc2.AttributeContainer;
import ucar.nc2.Group;
import ucar.nc2.constants.AxisType;
import ucar.nc2.dataset.CoordinateAxis1D;
import ucar.nc2.dataset.CoordinateAxis2D;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.VariableDS;
import ucar.nc2.internal.dataset.conv.CF1Convention;
import ucar.nc2.time.Calendar;

public class CoordinateAxis
extends VariableDS {
    private static final Logger log = LoggerFactory.getLogger(CoordinateAxis.class);
    private MAMath.MinMax minmax;
    protected final NetcdfDataset ncd;
    protected final AxisType axisType;
    protected final String positive;
    protected final String boundaryRef;
    protected boolean isContiguous;

    public static Builder<?> fromVariableDS(VariableDS.Builder<?> vdsBuilder) {
        if (vdsBuilder.getRank() == 0 || vdsBuilder.getRank() == 1 || vdsBuilder.getRank() == 2 && vdsBuilder.dataType == ArrayType.CHAR) {
            return CoordinateAxis1D.builder().copyFrom((VariableDS.Builder)vdsBuilder);
        }
        if (vdsBuilder.getRank() == 2) {
            return CoordinateAxis2D.builder().copyFrom((VariableDS.Builder)vdsBuilder);
        }
        return CoordinateAxis.builder().copyFrom((VariableDS.Builder)vdsBuilder);
    }

    @Nullable
    public AxisType getAxisType() {
        return this.axisType;
    }

    @Override
    public String getUnitsString() {
        String units = super.getUnitsString();
        return units == null ? "" : units;
    }

    public boolean isNumeric() {
        return this.getDataType().isNumeric();
    }

    @Deprecated
    public boolean isContiguous() {
        return this.isContiguous;
    }

    @Deprecated
    public boolean isInterval() {
        return false;
    }

    @Deprecated
    public boolean isIndependentCoordinate() {
        if (this.isCoordinateVariable()) {
            return true;
        }
        return this.attributes.hasAttribute("_CoordinateAliasForDimension");
    }

    @Deprecated
    public String getPositive() {
        return this.positive;
    }

    @Deprecated
    public String getBoundaryRef() {
        return this.boundaryRef;
    }

    private void init() {
        try {
            Array data = this.read();
            this.minmax = MAMath.getMinMax(data);
        }
        catch (IOException ioe) {
            log.error("Error reading coordinate values ", (Throwable)ioe);
            throw new IllegalStateException(ioe);
        }
    }

    @Deprecated
    public double getMinValue() {
        if (this.minmax == null) {
            this.init();
        }
        return this.minmax.min;
    }

    @Deprecated
    public double getMaxValue() {
        if (this.minmax == null) {
            this.init();
        }
        return this.minmax.max;
    }

    public void getInfo(Formatter buf) {
        buf.format("%-30s", this.getNameAndDimensions());
        buf.format("%-30s", this.getUnitsString());
        if (this.axisType != null) {
            buf.format("%-10s", this.axisType.toString());
        }
        buf.format("%s", this.getDescription());
    }

    @Override
    public boolean equals(Object oo) {
        if (this == oo) {
            return true;
        }
        if (!(oo instanceof CoordinateAxis)) {
            return false;
        }
        if (!super.equals(oo)) {
            return false;
        }
        CoordinateAxis o = (CoordinateAxis)oo;
        if (this.getAxisType() != null && this.getAxisType() != o.getAxisType()) {
            return false;
        }
        if (this.getPositive() != null) {
            return this.getPositive().equals(o.getPositive());
        }
        return true;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        if (this.getAxisType() != null) {
            result = 37 * result + this.getAxisType().hashCode();
        }
        if (this.getPositive() != null) {
            result = 37 * result + this.getPositive().hashCode();
        }
        return result;
    }

    public Calendar getCalendarFromAttribute() {
        return CoordinateAxis.getCalendarFromAttribute(this.ncd, this.attributes);
    }

    public static Calendar getCalendarFromAttribute(@Nullable NetcdfDataset ncd, AttributeContainer attributes) {
        String cal = attributes.findAttributeString("calendar", null);
        if (cal == null) {
            Attribute convention;
            Attribute attribute = convention = ncd == null ? null : ncd.getRootGroup().findAttribute("Conventions");
            if (convention != null && convention.isString()) {
                String hasName = convention.getStringValue();
                int version = CF1Convention.getVersion(hasName);
                if (version >= 0) {
                    return Calendar.gregorian;
                }
                if (hasName != null && hasName.equalsIgnoreCase("COARDS")) {
                    return Calendar.gregorian;
                }
            }
        }
        return Calendar.get(cal);
    }

    protected CoordinateAxis(Builder<?> builder, Group parentGroup) {
        super((VariableDS.Builder<?>)builder, parentGroup);
        this.ncd = (NetcdfDataset)this.ncfile;
        this.axisType = builder.axisType;
        this.positive = builder.positive;
        this.boundaryRef = builder.boundaryRef;
        this.isContiguous = builder.isContiguous;
    }

    @Override
    public Builder<?> toBuilder() {
        return this.addLocalFieldsToBuilder(CoordinateAxis.builder());
    }

    protected Builder<?> addLocalFieldsToBuilder(Builder<? extends Builder<?>> b) {
        ((Builder)((Builder)b.setAxisType(this.axisType).setPositive(this.positive)).setBoundary(this.boundaryRef)).setIsContiguous(this.isContiguous);
        return (Builder)super.addLocalFieldsToBuilder((VariableDS.Builder<? extends VariableDS.Builder<?>>)b);
    }

    public static Builder<?> builder() {
        return new Builder2();
    }

    public static abstract class Builder<T extends Builder<T>>
    extends VariableDS.Builder<T> {
        public AxisType axisType;
        protected String positive;
        protected String boundaryRef;
        protected boolean isContiguous = true;
        private boolean built;

        @Override
        protected abstract T self();

        public T setAxisType(AxisType axisType) {
            this.axisType = axisType;
            return (T)this.self();
        }

        public T setPositive(String positive) {
            this.positive = positive;
            return (T)this.self();
        }

        public T setBoundary(String boundaryRef) {
            this.boundaryRef = boundaryRef;
            return (T)this.self();
        }

        public T setIsContiguous(boolean isContiguous) {
            this.isContiguous = isContiguous;
            return (T)this.self();
        }

        @Override
        public T copyFrom(VariableDS.Builder<?> vds) {
            super.copyFrom(vds);
            return (T)this.self();
        }

        @Override
        public CoordinateAxis build(Group parentGroup) {
            if (this.built) {
                throw new IllegalStateException("already built");
            }
            this.built = true;
            return new CoordinateAxis(this, parentGroup);
        }
    }

    private static class Builder2
    extends Builder<Builder2> {
        private Builder2() {
        }

        @Override
        protected Builder2 self() {
            return this;
        }
    }

    public static class AxisComparator
    implements Comparator<CoordinateAxis> {
        @Override
        public int compare(CoordinateAxis c1, CoordinateAxis c2) {
            Preconditions.checkNotNull((Object)c1);
            Preconditions.checkNotNull((Object)c2);
            AxisType t1 = c1.getAxisType();
            AxisType t2 = c2.getAxisType();
            if (t1 == null && t2 == null) {
                return c1.getShortName().compareTo(c2.getShortName());
            }
            if (t1 == null) {
                return -1;
            }
            if (t2 == null) {
                return 1;
            }
            return t1.axisOrder() - t2.axisOrder();
        }
    }
}

