/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dataset;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Formatter;
import java.util.List;
import java.util.StringTokenizer;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.array.ArrayType;
import ucar.array.Arrays;
import ucar.ma2.Array;
import ucar.ma2.ArrayChar;
import ucar.ma2.ArrayObject;
import ucar.ma2.DataType;
import ucar.ma2.Index;
import ucar.ma2.IndexIterator;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Range;
import ucar.nc2.Dimension;
import ucar.nc2.Group;
import ucar.nc2.constants.AxisType;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.CoordinateAxis1D;
import ucar.nc2.dataset.CoordinateAxisTimeHelper;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.VariableDS;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.time.CalendarDateRange;
import ucar.nc2.units.TimeUnit;

@Deprecated
public class CoordinateAxis1DTime
extends CoordinateAxis1D {
    private static final Logger logger = LoggerFactory.getLogger(CoordinateAxis1DTime.class);
    private final CoordinateAxisTimeHelper helper;
    private List<CalendarDate> cdates;

    public static CoordinateAxis1DTime factory(@Nullable NetcdfDataset ncd, VariableDS org, Formatter errMessages) throws IOException {
        if (org instanceof CoordinateAxis1DTime) {
            return (CoordinateAxis1DTime)org;
        }
        if (org.getDataType() == DataType.CHAR) {
            return CoordinateAxis1DTime.fromStringVarDS(ncd, org, (List<Dimension>)ImmutableList.of((Object)org.getDimension(0)));
        }
        if (org.getDataType() == DataType.STRING) {
            return CoordinateAxis1DTime.fromStringVarDS(ncd, org, org.getDimensions());
        }
        return CoordinateAxis1DTime.fromVarDS(ncd, org, errMessages);
    }

    private static CoordinateAxis1DTime fromStringVarDS(@Nullable NetcdfDataset ncd, VariableDS org, List<Dimension> dims) {
        Builder builder = (Builder)((Builder)((Builder)((Builder)((Builder)CoordinateAxis1DTime.builder().setName(org.getShortName())).setDataType(DataType.STRING)).setUnits(org.getUnitsString())).setDesc(org.getDescription())).setDimensions(dims);
        ((Builder)builder.setOriginalVariable(org)).setOriginalName(org.getOriginalName());
        builder.setTimeHelper(new CoordinateAxisTimeHelper(CoordinateAxis1DTime.getCalendarFromAttribute(ncd, org.attributes()), null));
        builder.addAttributes(org.attributes());
        if (org instanceof CoordinateAxis) {
            builder.setAxisType(((CoordinateAxis)org).axisType);
        }
        return builder.build(org.getParentGroup());
    }

    private static CoordinateAxis1DTime fromVarDS(@Nullable NetcdfDataset ncd, VariableDS org, Formatter errMessages) throws IOException {
        Builder builder = (Builder)((Builder)((Builder)((Builder)CoordinateAxis1DTime.builder().setName(org.getShortName())).setDataType(org.getDataType())).setUnits(org.getUnitsString())).setDesc(org.getDescription());
        ((Builder)builder.setOriginalVariable(org)).setOriginalName(org.getOriginalName());
        CoordinateAxisTimeHelper helper = new CoordinateAxisTimeHelper(CoordinateAxis1DTime.getCalendarFromAttribute(ncd, org.attributes()), org.getUnitsString());
        builder.setTimeHelper(helper);
        int ncoords = (int)org.getSize();
        ArrayList<CalendarDate> result = new ArrayList<CalendarDate>(ncoords);
        Array data = org.read();
        int count = 0;
        IndexIterator ii = data.getIndexIterator();
        for (int i = 0; i < ncoords; ++i) {
            double val = ii.getDoubleNext();
            if (Double.isNaN(val)) continue;
            result.add(helper.makeCalendarDateFromOffset(val));
            ++count;
        }
        ArrayList<Dimension> dims = new ArrayList<Dimension>((Collection<Dimension>)org.getDimensions());
        if (count != ncoords) {
            Dimension localDim = Dimension.builder(org.getShortName(), count).setIsShared(false).build();
            dims.set(0, localDim);
            Array shortData = Array.factory(data.getDataType(), new int[]{count});
            Index ima = shortData.getIndex();
            int count2 = 0;
            ii = data.getIndexIterator();
            for (int i = 0; i < ncoords; ++i) {
                double val = ii.getDoubleNext();
                if (Double.isNaN(val)) continue;
                shortData.setDouble(ima.set0(count2), val);
                ++count2;
            }
        }
        builder.setCalendarDates(result);
        builder.setDimensions(dims);
        builder.addAttributes(org.attributes());
        if (org instanceof CoordinateAxis) {
            builder.setAxisType(((CoordinateAxis)org).axisType);
        }
        return builder.build(org.getParentGroup());
    }

    @Override
    public CoordinateAxis1DTime section(Range r) throws InvalidRangeException {
        CoordinateAxis1DTime s = (CoordinateAxis1DTime)super.section(r);
        List<CalendarDate> cdates = this.getCalendarDates();
        ArrayList<CalendarDate> cdateSection = new ArrayList<CalendarDate>(cdates.size());
        for (int idx : r) {
            cdateSection.add(cdates.get(idx));
        }
        s.cdates = cdateSection;
        return s;
    }

    public CalendarDate getCalendarDate(int idx) {
        List<CalendarDate> cdates = this.getCalendarDates();
        return cdates.get(idx);
    }

    public CalendarDateRange getCalendarDateRange() {
        List<CalendarDate> cd = this.getCalendarDates();
        int last = cd.size();
        return last > 0 ? CalendarDateRange.of(cd.get(0), cd.get(last - 1)) : null;
    }

    @Nullable
    public TimeUnit getTimeResolution() throws Exception {
        String tUnits = this.getUnitsString();
        if (tUnits != null) {
            StringTokenizer stoker = new StringTokenizer(tUnits);
            double tResolution = this.getIncrement();
            return new TimeUnit(tResolution, stoker.nextToken());
        }
        return null;
    }

    public int findTimeIndexFromCalendarDate(CalendarDate d) {
        int index;
        List<CalendarDate> cdates = this.getCalendarDates();
        for (index = 0; index < cdates.size() && d.compareTo(cdates.get(index)) >= 0; ++index) {
        }
        return Math.max(0, index - 1);
    }

    public boolean hasCalendarDate(CalendarDate date) {
        List<CalendarDate> cdates = this.getCalendarDates();
        for (CalendarDate cd : cdates) {
            if (!date.equals(cd)) continue;
            return true;
        }
        return false;
    }

    public List<CalendarDate> getCalendarDates() {
        return this.cdates;
    }

    public CalendarDate[] getCoordBoundsDate(int i) {
        double[] intv = this.getCoordBounds(i);
        CalendarDate[] e = new CalendarDate[]{this.helper.makeCalendarDateFromOffset(intv[0]), this.helper.makeCalendarDateFromOffset(intv[1])};
        return e;
    }

    public CalendarDate getCoordBoundsMidpointDate(int i) {
        double[] intv = this.getCoordBounds(i);
        double midpoint = (intv[0] + intv[1]) / 2.0;
        return this.helper.makeCalendarDateFromOffset(midpoint);
    }

    @Override
    protected void readValues() {
        if (!this.dataType.isNumeric()) {
            this.coords = this.cdates.stream().mapToDouble(cdate -> cdate.getDifferenceInMsecs(this.cdates.get(0))).toArray();
            this.wasRead = true;
        } else {
            super.readValues();
        }
    }

    @Override
    public boolean isNumeric() {
        return true;
    }

    private List<CalendarDate> makeTimesFromChar(VariableDS org, Formatter errMessages) throws IOException {
        int ncoords = (int)org.getSize();
        int rank = org.getRank();
        int strlen = org.getShape(rank - 1);
        ArrayList<CalendarDate> result = new ArrayList<CalendarDate>(ncoords /= strlen);
        ArrayChar data = (ArrayChar)org.read();
        ArrayChar.StringIterator ii = data.getStringIterator();
        String[] dateStrings = new String[ncoords];
        for (int i = 0; i < ncoords; ++i) {
            String coordValue = ii.next();
            CalendarDate cd = this.makeCalendarDateFromStringCoord(coordValue, org, errMessages);
            dateStrings[i] = coordValue;
            result.add(cd);
        }
        this.setCachedData(Arrays.factory(ArrayType.STRING, new int[]{ncoords}, dateStrings));
        return result;
    }

    private List<CalendarDate> makeTimesFromStrings(VariableDS org, Formatter errMessages) throws IOException {
        int ncoords = (int)org.getSize();
        ArrayList<CalendarDate> result = new ArrayList<CalendarDate>(ncoords);
        ArrayObject data = (ArrayObject)org.read();
        IndexIterator ii = data.getIndexIterator();
        for (int i = 0; i < ncoords; ++i) {
            String coordValue = (String)ii.getObjectNext();
            CalendarDate cd = this.makeCalendarDateFromStringCoord(coordValue, org, errMessages);
            result.add(cd);
        }
        return result;
    }

    private CalendarDate makeCalendarDateFromStringCoord(String coordValue, VariableDS org, Formatter errMessages) {
        CalendarDate cd = this.helper.makeCalendarDateFromOffset(coordValue);
        if (cd == null) {
            if (errMessages != null) {
                errMessages.format("String time coordinate must be ISO formatted= %s%n", coordValue);
                logger.info("Char time coordinate must be ISO formatted= {} file = {}", (Object)coordValue, (Object)org.getDatasetLocation());
            }
            throw new IllegalArgumentException();
        }
        return cd;
    }

    @Deprecated
    public Date[] getTimeDates() {
        List<CalendarDate> cdates = this.getCalendarDates();
        Date[] timeDates = new Date[cdates.size()];
        int index = 0;
        for (CalendarDate cd : cdates) {
            timeDates[index++] = cd.toDate();
        }
        return timeDates;
    }

    protected CoordinateAxis1DTime(Builder<?> builder, Group parentGroup) {
        super((CoordinateAxis1D.Builder<?>)builder, parentGroup);
        this.helper = ((Builder)builder).helper;
        try {
            Formatter errMessages = new Formatter();
            this.cdates = this.getDataType() == DataType.CHAR ? this.makeTimesFromChar((VariableDS)builder.orgVar, errMessages) : (this.getDataType() == DataType.STRING ? this.makeTimesFromStrings((VariableDS)builder.orgVar, errMessages) : ((Builder)builder).cdates);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    @Override
    public Builder<?> toBuilder() {
        return this.addLocalFieldsToBuilder(CoordinateAxis1DTime.builder());
    }

    protected Builder<?> addLocalFieldsToBuilder(Builder<? extends Builder<?>> b) {
        return (Builder)super.addLocalFieldsToBuilder((CoordinateAxis1D.Builder<? extends CoordinateAxis1D.Builder<?>>)b);
    }

    public static Builder<?> builder() {
        return new Builder2();
    }

    @Deprecated
    public static abstract class Builder<T extends Builder<T>>
    extends CoordinateAxis1D.Builder<T> {
        private boolean built;
        private CoordinateAxisTimeHelper helper;
        private List<CalendarDate> cdates;

        @Override
        protected abstract T self();

        public T setTimeHelper(CoordinateAxisTimeHelper helper) {
            this.helper = helper;
            return (T)this.self();
        }

        public T setCalendarDates(List<CalendarDate> cdates) {
            this.cdates = cdates;
            return (T)this.self();
        }

        @Override
        public CoordinateAxis1DTime build(Group parentGroup) {
            if (this.built) {
                throw new IllegalStateException("already built");
            }
            this.built = true;
            if (this.axisType == null) {
                this.axisType = AxisType.Time;
            }
            return new CoordinateAxis1DTime(this, parentGroup);
        }
    }

    private static class Builder2
    extends Builder<Builder2> {
        private Builder2() {
        }

        @Override
        protected Builder2 self() {
            return this;
        }
    }
}

