/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dataset;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.array.ArrayType;
import ucar.nc2.Dimension;
import ucar.nc2.Dimensions;
import ucar.nc2.Group;
import ucar.nc2.NetcdfFiles;
import ucar.nc2.Variable;
import ucar.nc2.constants.AxisType;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.CoordinateAxis1D;
import ucar.nc2.dataset.CoordinateTransform;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.ProjectionCT;
import ucar.nc2.dataset.TransformType;
import ucar.nc2.dataset.VerticalCT;
import ucar.unidata.geoloc.Projection;
import ucar.unidata.geoloc.projection.LatLonProjection;
import ucar.unidata.util.StringUtil2;

public class CoordinateSystem {
    private static final Logger log = LoggerFactory.getLogger(CoordinateSystem.class);
    protected NetcdfDataset ds;
    protected List<CoordinateAxis> coordAxes = new ArrayList<CoordinateAxis>();
    protected List<CoordinateTransform> coordTrans = new ArrayList<CoordinateTransform>();
    private Projection projection;
    protected String name;
    protected Set<Dimension> domain = new HashSet<Dimension>();
    protected CoordinateAxis xAxis;
    protected CoordinateAxis yAxis;
    protected CoordinateAxis zAxis;
    protected CoordinateAxis tAxis;
    protected CoordinateAxis latAxis;
    protected CoordinateAxis lonAxis;
    protected CoordinateAxis hAxis;
    protected CoordinateAxis pAxis;
    protected CoordinateAxis ensAxis;
    protected CoordinateAxis aziAxis;
    protected CoordinateAxis elevAxis;
    protected CoordinateAxis radialAxis;
    protected boolean isImplicit;
    protected String dataType;

    @Deprecated
    protected CoordinateSystem() {
    }

    public static String makeName(List<CoordinateAxis> axes) {
        ArrayList<CoordinateAxis> axesSorted = new ArrayList<CoordinateAxis>(axes);
        axesSorted.sort(new CoordinateAxis.AxisComparator());
        ArrayList names = new ArrayList();
        axesSorted.forEach(axis -> names.add(NetcdfFiles.makeFullName(axis)));
        return String.join((CharSequence)" ", names);
    }

    public ImmutableList<CoordinateAxis> getCoordinateAxes() {
        return ImmutableList.copyOf(this.coordAxes);
    }

    @Deprecated
    public ImmutableList<CoordinateTransform> getCoordinateTransforms() {
        return ImmutableList.copyOf(this.coordTrans);
    }

    public String getName() {
        return this.name;
    }

    @Deprecated
    public NetcdfDataset getNetcdfDataset() {
        return this.ds;
    }

    public ImmutableCollection<Dimension> getDomain() {
        return ImmutableList.copyOf(this.domain);
    }

    @Deprecated
    public int getRankDomain() {
        return this.domain.size();
    }

    @Deprecated
    public int getRankRange() {
        return this.coordAxes.size();
    }

    @Nullable
    public CoordinateAxis findAxis(AxisType type) {
        CoordinateAxis result = null;
        for (CoordinateAxis axis : this.coordAxes) {
            AxisType axisType = axis.getAxisType();
            if (axisType == null || axisType != type) continue;
            result = this.lesserRank(result, axis);
        }
        return result;
    }

    private CoordinateAxis lesserRank(CoordinateAxis a1, CoordinateAxis a2) {
        if (a1 == null) {
            return a2;
        }
        return a1.getRank() <= a2.getRank() ? a1 : a2;
    }

    @Nullable
    public CoordinateAxis findAxis(AxisType ... axisType) {
        for (AxisType type : axisType) {
            CoordinateAxis result = this.findAxis(type);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Deprecated
    public CoordinateAxis getXaxis() {
        return this.xAxis;
    }

    @Deprecated
    public CoordinateAxis getYaxis() {
        return this.yAxis;
    }

    @Deprecated
    public CoordinateAxis getZaxis() {
        return this.zAxis;
    }

    @Deprecated
    public CoordinateAxis getTaxis() {
        return this.tAxis;
    }

    @Deprecated
    public CoordinateAxis getLatAxis() {
        return this.latAxis;
    }

    @Deprecated
    public CoordinateAxis getLonAxis() {
        return this.lonAxis;
    }

    @Deprecated
    public CoordinateAxis getHeightAxis() {
        return this.hAxis;
    }

    @Deprecated
    public CoordinateAxis getPressureAxis() {
        return this.pAxis;
    }

    @Deprecated
    public CoordinateAxis getEnsembleAxis() {
        return this.ensAxis;
    }

    @Deprecated
    public CoordinateAxis getAzimuthAxis() {
        return this.aziAxis;
    }

    @Deprecated
    public CoordinateAxis getRadialAxis() {
        return this.radialAxis;
    }

    @Deprecated
    public CoordinateAxis getElevationAxis() {
        return this.elevAxis;
    }

    @Deprecated
    public ProjectionCT getProjectionCT() {
        for (CoordinateTransform ct : this.coordTrans) {
            if (!(ct instanceof ProjectionCT)) continue;
            return (ProjectionCT)ct;
        }
        return null;
    }

    @Nullable
    public Projection getProjection() {
        if (this.projection == null) {
            ProjectionCT projCT;
            if (this.isLatLon()) {
                this.projection = new LatLonProjection();
            }
            if (null != (projCT = this.getProjectionCT())) {
                this.projection = projCT.getProjection();
            }
        }
        return this.projection;
    }

    @Nullable
    public VerticalCT getVerticalCT() {
        Optional<CoordinateTransform> result = this.coordTrans.stream().filter(t -> t.getTransformType() == TransformType.Vertical).findFirst();
        return result.orElse(null);
    }

    public boolean isGeoXY() {
        if (this.xAxis == null || this.yAxis == null) {
            return false;
        }
        return null != this.getProjection() && !(this.projection instanceof LatLonProjection);
    }

    public boolean isLatLon() {
        return this.latAxis != null && this.lonAxis != null;
    }

    public boolean isRadial() {
        return this.radialAxis != null && this.aziAxis != null;
    }

    public boolean isGeoReferencing() {
        return this.isGeoXY() || this.isLatLon();
    }

    @Deprecated
    public boolean isProductSet() {
        for (CoordinateAxis axis : this.coordAxes) {
            if (axis.getRank() == 1) continue;
            return false;
        }
        return true;
    }

    @Deprecated
    public boolean isRegular() {
        for (CoordinateAxis axis : this.coordAxes) {
            if (!(axis instanceof CoordinateAxis1D)) {
                return false;
            }
            if (((CoordinateAxis1D)axis).isRegular()) continue;
            return false;
        }
        return true;
    }

    public boolean isComplete(Variable v) {
        return CoordinateSystem.isComplete(v.getDimensionSet(), this.domain);
    }

    public static boolean isComplete(Collection<Dimension> variableDomain, Collection<Dimension> csysDomain) {
        for (Dimension d : variableDomain) {
            if (csysDomain.contains(d) || d.getLength() <= 1) continue;
            return false;
        }
        return true;
    }

    public boolean isCoordinateSystemFor(Variable v) {
        HashSet<Dimension> varDims = new HashSet<Dimension>((Collection<Dimension>)v.getDimensions());
        for (CoordinateAxis axis : this.getCoordinateAxes()) {
            Group groupv = v.getParentGroup();
            Group groupa = axis.getParentGroup();
            Group commonGroup = groupv.commonParent(groupa);
            int checkDims = axis.getRank();
            if (axis.getArrayType() == ArrayType.CHAR) {
                --checkDims;
            }
            for (int i = 0; i < checkDims; ++i) {
                Dimension axisDim = axis.getDimension(i);
                if (!axisDim.isShared()) continue;
                if (!varDims.contains(axisDim)) {
                    return false;
                }
                if (groupa == groupv || commonGroup.findDimension(axisDim) != null) continue;
                return false;
            }
        }
        return true;
    }

    @Deprecated
    public static boolean isSubset(Collection<Dimension> subset, Collection<Dimension> set) {
        for (Dimension d : subset) {
            if (set.contains(d)) continue;
            return false;
        }
        return true;
    }

    @Deprecated
    public static boolean isSubset(Set<String> subset, Set<String> set) {
        for (String d : subset) {
            if (set.contains(d)) continue;
            return false;
        }
        return true;
    }

    @Deprecated
    public static Set<Dimension> makeDomain(Iterable<? extends Variable> axes) {
        HashSet<Dimension> domain = new HashSet<Dimension>();
        for (Variable variable : axes) {
            domain.addAll((Collection<Dimension>)variable.getDimensions());
        }
        return domain;
    }

    @Deprecated
    public static int countDomain(Variable[] axes) {
        HashSet<Dimension> domain = new HashSet<Dimension>();
        for (Variable axis : axes) {
            domain.addAll((Collection<Dimension>)axis.getDimensions());
        }
        return domain.size();
    }

    public boolean isImplicit() {
        return this.isImplicit;
    }

    @Deprecated
    public boolean hasVerticalAxis() {
        return this.hAxis != null || this.pAxis != null || this.zAxis != null;
    }

    @Deprecated
    public boolean hasTimeAxis() {
        return this.tAxis != null;
    }

    @Deprecated
    public boolean containsAxes(List<CoordinateAxis> wantAxes) {
        for (CoordinateAxis ca : wantAxes) {
            if (this.containsAxis(ca.getFullName())) continue;
            return false;
        }
        return true;
    }

    @Deprecated
    public boolean containsAxis(String axisFullName) {
        for (CoordinateAxis ca : this.coordAxes) {
            if (!ca.getFullName().equals(axisFullName)) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    public boolean containsDomain(List<Dimension> wantDimensions) {
        for (Dimension d : wantDimensions) {
            if (this.domain.contains(d)) continue;
            return false;
        }
        return true;
    }

    @Deprecated
    public boolean containsAxisTypes(List<AxisType> wantAxes) {
        for (AxisType wantAxisType : wantAxes) {
            if (this.containsAxisType(wantAxisType)) continue;
            return false;
        }
        return true;
    }

    @Deprecated
    public boolean containsAxisType(AxisType wantAxisType) {
        for (CoordinateAxis ca : this.coordAxes) {
            if (ca.getAxisType() != wantAxisType) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CoordinateSystem that = (CoordinateSystem)o;
        return Objects.equal(this.coordAxes, that.coordAxes) && Objects.equal(this.coordTrans, that.coordTrans) && Objects.equal((Object)this.name, (Object)that.name);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.coordAxes, this.coordTrans, this.name});
    }

    public String toString() {
        return this.name;
    }

    protected CoordinateSystem(Builder<?> builder, NetcdfDataset ncd, List<CoordinateAxis> axesAll, List<CoordinateTransform> allTransforms) {
        this.ds = ncd;
        this.isImplicit = ((Builder)builder).isImplicit;
        ArrayList<CoordinateAxis> axesList = new ArrayList<CoordinateAxis>();
        for (String axisName : StringUtil2.split(builder.coordAxesNames)) {
            Optional<CoordinateAxis> found = axesAll.stream().filter(a -> axisName.equals(a.getFullName())).findFirst();
            if (!found.isPresent()) {
                throw new RuntimeException("Cant find axis " + axisName);
            }
            axesList.add(found.get());
        }
        this.coordAxes = axesList;
        this.coordAxes.sort(new CoordinateAxis.AxisComparator());
        this.name = CoordinateSystem.makeName(this.coordAxes);
        for (CoordinateAxis axis : this.coordAxes) {
            AxisType axisType = axis.getAxisType();
            if (axisType != null) {
                if (axisType == AxisType.GeoX) {
                    this.xAxis = this.lesserRank(this.xAxis, axis);
                }
                if (axisType == AxisType.GeoY) {
                    this.yAxis = this.lesserRank(this.yAxis, axis);
                }
                if (axisType == AxisType.GeoZ) {
                    this.zAxis = this.lesserRank(this.zAxis, axis);
                }
                if (axisType == AxisType.Time) {
                    this.tAxis = this.lesserRank(this.tAxis, axis);
                }
                if (axisType == AxisType.Lat) {
                    this.latAxis = this.lesserRank(this.latAxis, axis);
                }
                if (axisType == AxisType.Lon) {
                    this.lonAxis = this.lesserRank(this.lonAxis, axis);
                }
                if (axisType == AxisType.Height) {
                    this.hAxis = this.lesserRank(this.hAxis, axis);
                }
                if (axisType == AxisType.Pressure) {
                    this.pAxis = this.lesserRank(this.pAxis, axis);
                }
                if (axisType == AxisType.Ensemble) {
                    this.ensAxis = this.lesserRank(this.ensAxis, axis);
                }
                if (axisType == AxisType.RadialAzimuth) {
                    this.aziAxis = this.lesserRank(this.aziAxis, axis);
                }
                if (axisType == AxisType.RadialDistance) {
                    this.radialAxis = this.lesserRank(this.radialAxis, axis);
                }
                if (axisType == AxisType.RadialElevation) {
                    this.elevAxis = this.lesserRank(this.elevAxis, axis);
                }
            }
            this.domain.addAll((Collection<Dimension>)Dimensions.makeDimensionsAll(axis));
        }
        for (String want : ((Builder)builder).transNames) {
            allTransforms.stream().filter(ct -> want.equals(ct.getName()) || ct.getCtvAttributes() != null && want.equals(ct.getCtvAttributes().getName())).findFirst().ifPresent(got -> this.coordTrans.add((CoordinateTransform)got));
        }
    }

    public Builder<?> toBuilder() {
        return this.addLocalFieldsToBuilder(CoordinateSystem.builder());
    }

    protected Builder<?> addLocalFieldsToBuilder(Builder<? extends Builder<?>> b) {
        return ((Builder)b.setImplicit(this.isImplicit).setCoordAxesNames(this.name)).addCoordinateTransforms(this.coordTrans);
    }

    public static Builder<?> builder() {
        return new Builder2();
    }

    public static abstract class Builder<T extends Builder<T>> {
        public String coordAxesNames = "";
        private final List<String> transNames = new ArrayList<String>();
        private boolean isImplicit;
        private boolean built;

        protected abstract T self();

        public T setCoordAxesNames(String names) {
            this.coordAxesNames = names;
            return this.self();
        }

        public T addCoordinateTransformByName(String ct) {
            this.transNames.add(ct);
            return this.self();
        }

        public T addCoordinateTransforms(Collection<CoordinateTransform> transforms) {
            transforms.forEach(trans -> this.addCoordinateTransformByName(trans.name));
            return this.self();
        }

        public T setImplicit(boolean isImplicit) {
            this.isImplicit = isImplicit;
            return this.self();
        }

        public CoordinateSystem build(NetcdfDataset ncd, List<CoordinateAxis> axes, List<CoordinateTransform> transforms) {
            if (this.built) {
                throw new IllegalStateException("already built");
            }
            this.built = true;
            return new CoordinateSystem(this, ncd, axes, transforms);
        }
    }

    private static class Builder2
    extends Builder<Builder2> {
        private Builder2() {
        }

        @Override
        protected Builder2 self() {
            return this;
        }
    }
}

