/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dataset;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import javax.annotation.concurrent.Immutable;
import ucar.nc2.Attribute;
import ucar.nc2.AttributeContainer;
import ucar.nc2.AttributeContainerMutable;
import ucar.nc2.dataset.TransformType;
import ucar.unidata.util.Parameter;

@Immutable
public abstract class CoordinateTransform
implements Comparable<CoordinateTransform> {
    final String name;
    final String authority;
    final TransformType transformType;
    final AttributeContainer ctvAttributes;

    public String getName() {
        return this.name;
    }

    @Deprecated
    public String getAuthority() {
        return this.authority;
    }

    public TransformType getTransformType() {
        return this.transformType;
    }

    @Deprecated
    public ImmutableList<Parameter> getParameters() {
        ImmutableList.Builder params = ImmutableList.builder();
        for (Attribute a : this.ctvAttributes) {
            params.add((Object)Attribute.toParameter(a));
        }
        return params.build();
    }

    public AttributeContainer getCtvAttributes() {
        return this.ctvAttributes;
    }

    @Deprecated
    public Parameter findParameterIgnoreCase(String name) {
        for (Attribute a : this.ctvAttributes) {
            if (!name.equalsIgnoreCase(a.getName())) continue;
            return Attribute.toParameter(a);
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CoordinateTransform that = (CoordinateTransform)o;
        return Objects.equal((Object)this.name, (Object)that.name) && Objects.equal((Object)this.authority, (Object)that.authority) && this.transformType == that.transformType && Objects.equal((Object)this.ctvAttributes, (Object)that.ctvAttributes);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.name, this.authority, this.transformType, this.ctvAttributes});
    }

    public String toString() {
        return this.name;
    }

    @Override
    public int compareTo(CoordinateTransform oct) {
        return this.name.compareTo(oct.getName());
    }

    protected CoordinateTransform(Builder<?> builder) {
        this.name = builder.name;
        this.authority = ((Builder)builder).authority;
        this.transformType = ((Builder)builder).transformType;
        this.ctvAttributes = ((Builder)builder).ctvAttributes.setName(this.name).toImmutable();
    }

    protected CoordinateTransform(String name, String authority, TransformType transformType, AttributeContainer params) {
        this.name = name;
        this.authority = authority;
        this.transformType = transformType;
        AttributeContainerMutable atts = new AttributeContainerMutable(this.name);
        atts.addAll(params);
        this.ctvAttributes = atts.toImmutable();
    }

    public abstract Builder<?> toBuilder();

    protected Builder<?> addLocalFieldsToBuilder(Builder<? extends Builder<?>> b) {
        return ((Builder)((Builder)b.setName(this.name).setAuthority(this.authority)).setTransformType(this.transformType)).setCtvAttributes(this.ctvAttributes);
    }

    public static abstract class Builder<T extends Builder<T>> {
        public String name;
        private String authority;
        private TransformType transformType;
        private final AttributeContainerMutable ctvAttributes = new AttributeContainerMutable(".");

        protected abstract T self();

        public T setName(String name) {
            this.name = name;
            return this.self();
        }

        public T setAuthority(String authority) {
            this.authority = authority;
            return this.self();
        }

        public T setTransformType(TransformType transformType) {
            this.transformType = transformType;
            return this.self();
        }

        public T setCtvAttributes(AttributeContainer attributeContainer) {
            this.ctvAttributes.addAll(attributeContainer);
            return this.self();
        }

        @Deprecated
        public T addParameter(Parameter param) {
            this.ctvAttributes.addAttribute(Attribute.fromParameter(param));
            return this.self();
        }

        public T addParameter(Attribute param) {
            this.ctvAttributes.addAttribute(param);
            return this.self();
        }

        public abstract CoordinateTransform build();
    }
}

