/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dataset;

import com.google.common.base.Preconditions;
import javax.annotation.concurrent.Immutable;
import ucar.nc2.Attribute;
import ucar.nc2.Variable;

@Immutable
class EnhancementsImpl {
    private final Variable forVar;
    private final String desc;
    private final String units;

    EnhancementsImpl(Variable forVar, String units, String desc) {
        Preconditions.checkNotNull((Object)forVar);
        this.forVar = forVar;
        this.units = this.makeUnits(units);
        this.desc = this.makeDescription(desc);
    }

    public String getDescription() {
        return this.desc;
    }

    public String getUnitsString() {
        return this.units;
    }

    private String makeDescription(String desc) {
        if (desc == null) {
            Attribute att = this.forVar.attributes().findAttributeIgnoreCase("long_name");
            if (att != null && att.isString()) {
                desc = att.getStringValue();
            }
            if (desc == null && (att = this.forVar.attributes().findAttributeIgnoreCase("description")) != null && att.isString()) {
                desc = att.getStringValue();
            }
            if (desc == null && (att = this.forVar.attributes().findAttributeIgnoreCase("title")) != null && att.isString()) {
                desc = att.getStringValue();
            }
            if (desc == null && (att = this.forVar.attributes().findAttributeIgnoreCase("standard_name")) != null && att.isString()) {
                desc = att.getStringValue();
            }
        }
        return desc == null ? null : desc.trim();
    }

    private String makeUnits(String units) {
        Attribute att;
        if (units == null && (att = this.forVar.attributes().findAttributeIgnoreCase("units")) != null && att.isString()) {
            units = att.getStringValue().trim();
        }
        return units;
    }
}

