/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dataset;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Formatter;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.Dimension;
import ucar.nc2.EnumTypedef;
import ucar.nc2.Group;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Sequence;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.constants.AxisType;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.CoordinateSystem;
import ucar.nc2.dataset.CoordinateTransform;
import ucar.nc2.dataset.SequenceDS;
import ucar.nc2.dataset.StructureDS;
import ucar.nc2.dataset.VariableDS;
import ucar.nc2.internal.dataset.CoordinatesHelper;
import ucar.nc2.internal.ncml.Aggregation;

@Immutable
public class NetcdfDataset
extends NetcdfFile {
    private static final Logger log = LoggerFactory.getLogger(NetcdfDataset.class);
    public static final String AGGREGATION = "Aggregation";
    private static final Set<Enhance> EnhanceAll = Collections.unmodifiableSet(EnumSet.of(Enhance.ConvertEnums, Enhance.ConvertUnsigned, Enhance.ApplyScaleOffset, Enhance.ConvertMissing, Enhance.CoordSystems));
    private static final Set<Enhance> EnhanceNone = Collections.unmodifiableSet(EnumSet.noneOf(Enhance.class));
    private static Set<Enhance> defaultEnhanceMode = EnhanceAll;
    protected static boolean fillValueIsMissing = true;
    protected static boolean invalidDataIsMissing = true;
    protected static boolean missingDataIsMissing = true;
    private boolean wasClosed = false;
    @Nullable
    private final NetcdfFile orgFile;
    private final CoordinatesHelper coords;
    private final String convUsed;
    private final Set<Enhance> enhanceMode;
    private final Aggregation agg;
    private final String fileTypeId;
    private final ImmutableList<CoordinateAxis> coordAxes;

    public static Set<Enhance> getEnhanceAll() {
        return EnhanceAll;
    }

    public static Set<Enhance> getEnhanceNone() {
        return EnhanceNone;
    }

    public static Set<Enhance> getDefaultEnhanceMode() {
        return defaultEnhanceMode;
    }

    public static void setDefaultEnhanceMode(Set<Enhance> mode) {
        defaultEnhanceMode = Collections.unmodifiableSet(mode);
    }

    @Deprecated
    public static void setFillValueIsMissing(boolean b) {
        fillValueIsMissing = b;
    }

    @Deprecated
    public static boolean getFillValueIsMissing() {
        return fillValueIsMissing;
    }

    @Deprecated
    public static void setInvalidDataIsMissing(boolean b) {
        invalidDataIsMissing = b;
    }

    @Deprecated
    public static boolean getInvalidDataIsMissing() {
        return invalidDataIsMissing;
    }

    @Deprecated
    public static void setMissingDataIsMissing(boolean b) {
        missingDataIsMissing = b;
    }

    @Deprecated
    public static boolean getMissingDataIsMissing() {
        return missingDataIsMissing;
    }

    public ImmutableList<CoordinateSystem> getCoordinateSystems() {
        return this.coords.getCoordSystems();
    }

    public String getConventionUsed() {
        return this.convUsed;
    }

    public Set<Enhance> getEnhanceMode() {
        return this.enhanceMode;
    }

    @Deprecated
    public ImmutableList<CoordinateTransform> getCoordinateTransforms() {
        return this.coords.getCoordTransforms();
    }

    public ImmutableList<CoordinateAxis> getCoordinateAxes() {
        if (this.coords == null && this.coordAxes != null) {
            return this.coordAxes;
        }
        return this.coords.getCoordAxes();
    }

    public CoordinateAxis findCoordinateAxis(AxisType type) {
        if (type == null) {
            return null;
        }
        for (CoordinateAxis v : this.coords.getCoordAxes()) {
            if (type != v.getAxisType()) continue;
            return v;
        }
        return null;
    }

    public CoordinateAxis findCoordinateAxis(String fullName) {
        if (fullName == null) {
            return null;
        }
        for (CoordinateAxis v : this.coords.getCoordAxes()) {
            if (!fullName.equals(v.getFullName())) continue;
            return v;
        }
        return null;
    }

    public CoordinateSystem findCoordinateSystem(String name) {
        if (name == null) {
            return null;
        }
        for (CoordinateSystem v : this.coords.getCoordSystems()) {
            if (!name.equals(v.getName())) continue;
            return v;
        }
        return null;
    }

    @Deprecated
    public CoordinateTransform findCoordinateTransform(String name) {
        if (name == null) {
            return null;
        }
        for (CoordinateTransform v : this.coords.getCoordTransforms()) {
            if (!name.equals(v.getName())) continue;
            return v;
        }
        return null;
    }

    public boolean isIndependentCoordinate(CoordinateAxis axis) {
        if (axis.isCoordinateVariable()) {
            return true;
        }
        if (axis.getRank() != 1) {
            return false;
        }
        if (axis.attributes().hasAttribute("_CoordinateAliasForDimension")) {
            return true;
        }
        Dimension dim = axis.getDimension(0);
        for (CoordinateAxis other : this.getCoordinateAxes()) {
            if (other == axis) continue;
            for (Dimension odim : other.getDimensions()) {
                if (!dim.equals(odim)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public Object sendIospMessage(Object message) {
        if (message == "IOSP") {
            return this.orgFile == null ? null : this.orgFile.sendIospMessage(message);
        }
        if (message == AGGREGATION) {
            return this.agg;
        }
        return super.sendIospMessage(message);
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.agg != null) {
            this.agg.persistWrite();
            this.agg.close();
        }
        if (this.cache != null && this.cache.release(this)) {
            return;
        }
        if (!this.wasClosed && this.orgFile != null) {
            this.orgFile.close();
        }
        this.wasClosed = true;
    }

    @Override
    @Deprecated
    public void release() throws IOException {
        if (this.orgFile != null) {
            this.orgFile.release();
        }
    }

    @Override
    @Deprecated
    public void reacquire() throws IOException {
        if (this.orgFile != null) {
            this.orgFile.reacquire();
        }
    }

    @Override
    @Deprecated
    public long getLastModified() {
        if (this.agg != null) {
            return this.agg.getLastModified();
        }
        return this.orgFile != null ? this.orgFile.getLastModified() : 0L;
    }

    @Deprecated
    public NetcdfFile getReferencedFile() {
        return this.orgFile;
    }

    @Override
    public void getDetailInfo(Formatter f) {
        f.format("NetcdfDataset location= %s%n", this.getLocation());
        f.format("  title= %s%n", this.getTitle());
        f.format("  id= %s%n", this.getId());
        f.format("  fileType= %s%n", this.getFileTypeId());
        f.format("  fileDesc= %s%n", this.getFileTypeDescription());
        f.format("  class= %s%n", this.getClass().getName());
        if (this.agg == null) {
            f.format("  has no Aggregation element%n", new Object[0]);
        } else {
            f.format("%nAggregation:%n", new Object[0]);
            this.agg.getDetailInfo(f);
        }
        if (this.orgFile == null) {
            f.format("  has no referenced NetcdfFile%n", new Object[0]);
            this.showCached(f);
            this.showProxies(f);
        } else {
            f.format("%nReferenced File:%n", new Object[0]);
            f.format("%s", this.orgFile.getDetailInfo());
        }
    }

    @Override
    @Nullable
    public String getFileTypeId() {
        String inner = null;
        if (this.orgFile != null) {
            inner = this.orgFile.getFileTypeId();
        }
        if (inner == null && this.agg != null) {
            inner = this.agg.getFileTypeId();
        }
        if (this.fileTypeId == null) {
            return inner;
        }
        if (inner == null) {
            return this.fileTypeId;
        }
        return inner.startsWith(this.fileTypeId) ? inner : this.fileTypeId + "/" + inner;
    }

    @Override
    public String getFileTypeDescription() {
        if (this.orgFile != null) {
            return this.orgFile.getFileTypeDescription();
        }
        if (this.agg != null) {
            return this.agg.getFileTypeDescription();
        }
        return "N/A";
    }

    private NetcdfDataset(Builder<?> builder) {
        super(builder);
        this.orgFile = builder.orgFile;
        this.fileTypeId = ((Builder)builder).fileTypeId;
        this.convUsed = ((Builder)builder).convUsed;
        this.enhanceMode = builder.getEnhanceMode();
        this.agg = builder.agg;
        this.coordAxes = CoordinatesHelper.makeAxes(this);
        this.coords = builder.coords.build(this, this.coordAxes);
        for (Variable v : this.getVariables()) {
            if (v instanceof CoordinateAxis) continue;
            if (v instanceof VariableDS) {
                VariableDS vds = (VariableDS)v;
                vds.setCoordinateSystems(this.coords);
            }
            if (!(v instanceof StructureDS)) continue;
            StructureDS sds = (StructureDS)v;
            sds.setCoordinateSystems(this.coords);
        }
    }

    public Builder<?> toBuilder() {
        return this.addLocalFieldsToBuilder(NetcdfDataset.builder());
    }

    private Builder<?> addLocalFieldsToBuilder(Builder<? extends Builder<?>> b) {
        this.coords.getCoordAxes().forEach(axis -> b.coords.addCoordinateAxis((CoordinateAxis.Builder<?>)axis.toBuilder()));
        this.coords.getCoordSystems().forEach(sys -> b.coords.addCoordinateSystem(sys.toBuilder()));
        this.coords.getCoordTransforms().forEach(trans -> b.coords.addCoordinateTransform(trans.toBuilder()));
        ((Builder)((Builder)((Builder)b.setOrgFile(this.orgFile).setConventionUsed(this.convUsed)).setEnhanceMode(this.enhanceMode)).setAggregation(this.agg)).setFileTypeId(this.fileTypeId);
        return (Builder)super.addLocalFieldsToBuilder(b);
    }

    public static Builder<?> builder() {
        return new Builder2();
    }

    public static abstract class Builder<T extends Builder<T>>
    extends NetcdfFile.Builder<T> {
        @Nullable
        public NetcdfFile orgFile;
        public CoordinatesHelper.Builder coords = CoordinatesHelper.builder();
        private String convUsed;
        private Set<Enhance> enhanceMode = EnumSet.noneOf(Enhance.class);
        public Aggregation agg;
        private String fileTypeId;
        private boolean built;

        @Override
        protected abstract T self();

        public void replaceCoordinateAxis(Group.Builder group, CoordinateAxis.Builder<?> axis) {
            if (axis == null) {
                return;
            }
            this.coords.replaceCoordinateAxis(axis);
            group.replaceVariable(axis);
            axis.setParentGroupBuilder(group);
        }

        public T setOrgFile(NetcdfFile orgFile) {
            this.orgFile = orgFile;
            return (T)this.self();
        }

        public T setFileTypeId(String fileTypeId) {
            this.fileTypeId = fileTypeId;
            return (T)this.self();
        }

        public T setConventionUsed(String convUsed) {
            this.convUsed = convUsed;
            return (T)this.self();
        }

        public T setEnhanceMode(Set<Enhance> enhanceMode) {
            this.enhanceMode = enhanceMode;
            return (T)this.self();
        }

        public T setDefaultEnhanceMode() {
            this.enhanceMode = NetcdfDataset.getDefaultEnhanceMode();
            return (T)this.self();
        }

        public Set<Enhance> getEnhanceMode() {
            return this.enhanceMode;
        }

        public void addEnhanceMode(Enhance addEnhanceMode) {
            ImmutableSet.Builder result = new ImmutableSet.Builder();
            result.addAll(this.enhanceMode);
            result.add((Object)addEnhanceMode);
            this.enhanceMode = result.build();
        }

        public void removeEnhanceMode(Enhance removeEnhanceMode) {
            ImmutableSet.Builder result = new ImmutableSet.Builder();
            this.enhanceMode.stream().filter(e -> !e.equals((Object)removeEnhanceMode)).forEach(arg_0 -> ((ImmutableSet.Builder)result).add(arg_0));
            this.enhanceMode = result.build();
        }

        public void addEnhanceModes(Set<Enhance> addEnhanceModes) {
            ImmutableSet.Builder result = new ImmutableSet.Builder();
            result.addAll(this.enhanceMode);
            result.addAll(addEnhanceModes);
            this.enhanceMode = result.build();
        }

        public T setAggregation(Aggregation agg) {
            this.agg = agg;
            return (T)this.self();
        }

        public T copyFrom(NetcdfFile orgFile) {
            this.setLocation(orgFile.getLocation());
            this.setId(orgFile.getId());
            this.setTitle(orgFile.getTitle());
            Group.Builder root = Group.builder().setName("");
            this.convertGroup(root, orgFile.getRootGroup());
            this.setRootGroup(root);
            return (T)this.self();
        }

        private void convertGroup(Group.Builder g, Group from) {
            g.setName(from.getShortName());
            g.addEnumTypedefs((Collection<EnumTypedef>)from.getEnumTypedefs());
            for (Dimension d : from.getDimensions()) {
                g.addDimension(d);
            }
            g.addAttributes(from.attributes());
            for (Variable v : from.getVariables()) {
                g.addVariable(this.convertVariable(g, v));
            }
            for (Group nested : from.getGroups()) {
                Group.Builder nnested = Group.builder();
                g.addGroup(nnested);
                this.convertGroup(nnested, nested);
            }
        }

        private Variable.Builder<?> convertVariable(Group.Builder g, Variable v) {
            Object newVar = v instanceof Sequence ? SequenceDS.builder().copyFrom((Sequence)v) : (v instanceof Structure ? StructureDS.builder().copyFrom((Structure)v) : VariableDS.builder().copyFrom(v));
            ((Variable.Builder)newVar).setParentGroupBuilder(g);
            return newVar;
        }

        @Override
        public NetcdfDataset build() {
            if (this.built) {
                throw new IllegalStateException("already built");
            }
            this.built = true;
            return new NetcdfDataset(this);
        }
    }

    private static class Builder2
    extends Builder<Builder2> {
        private Builder2() {
        }

        @Override
        protected Builder2 self() {
            return this;
        }
    }

    public static enum Enhance {
        ConvertEnums,
        ConvertUnsigned,
        ApplyScaleOffset,
        ConvertMissing,
        CoordSystems,
        IncompleteCoordSystems;

    }
}

