/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dataset;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.Reader;
import java.util.EnumSet;
import java.util.ServiceLoader;
import java.util.Set;
import javax.annotation.Nullable;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.NetcdfFiles;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.dataset.DatasetUrl;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.StructureDS;
import ucar.nc2.dataset.VariableDS;
import ucar.nc2.dataset.spi.NetcdfFileProvider;
import ucar.nc2.internal.cache.FileCache;
import ucar.nc2.internal.cache.FileCacheIF;
import ucar.nc2.internal.cache.FileFactory;
import ucar.nc2.internal.dataset.DatasetEnhancer;
import ucar.nc2.internal.iosp.netcdf3.N3iosp;
import ucar.nc2.internal.ncml.NcmlReader;
import ucar.nc2.iosp.IOServiceProvider;
import ucar.nc2.util.CancelTask;

public class NetcdfDatasets {
    private static FileCache netcdfFileCache;
    private static final FileFactory defaultNetcdfFileFactory;

    private NetcdfDatasets() {
    }

    public static synchronized void initNetcdfFileCache(int minElementsInMemory, int maxElementsInMemory, int period) {
        NetcdfDatasets.initNetcdfFileCache(minElementsInMemory, maxElementsInMemory, -1, period);
    }

    public static synchronized void initNetcdfFileCache(int minElementsInMemory, int maxElementsInMemory, int hardLimit, int period) {
        netcdfFileCache = new FileCache("NetcdfFileCache ", minElementsInMemory, maxElementsInMemory, hardLimit, period);
    }

    public static synchronized void disableNetcdfFileCache() {
        if (null != netcdfFileCache) {
            netcdfFileCache.disable();
        }
        netcdfFileCache = null;
    }

    public static synchronized void shutdown() {
        NetcdfDatasets.disableNetcdfFileCache();
        FileCache.shutdown();
    }

    public static synchronized FileCacheIF getNetcdfFileCache() {
        return netcdfFileCache;
    }

    public static NetcdfDataset openDataset(String location) throws IOException {
        return NetcdfDatasets.openDataset(location, true, null);
    }

    public static NetcdfDataset openDataset(String location, boolean enhance, @Nullable CancelTask cancelTask) throws IOException {
        return NetcdfDatasets.openDataset(location, enhance ? NetcdfDataset.getDefaultEnhanceMode() : null, cancelTask);
    }

    public static NetcdfDataset openDataset(String location, @Nullable Set<NetcdfDataset.Enhance> enhanceMode, @Nullable CancelTask cancelTask) throws IOException {
        DatasetUrl durl = DatasetUrl.findDatasetUrl(location);
        return NetcdfDatasets.openDataset(durl, enhanceMode, -1, cancelTask, null);
    }

    public static NetcdfDataset openDataset(String location, boolean enhance, @Nullable CancelTask cancelTask, @Nullable Object iospMessage) throws IOException {
        DatasetUrl durl = DatasetUrl.findDatasetUrl(location);
        return NetcdfDatasets.openDataset(durl, enhance ? NetcdfDataset.getDefaultEnhanceMode() : null, -1, cancelTask, iospMessage);
    }

    public static NetcdfDataset openDataset(DatasetUrl location, @Nullable Set<NetcdfDataset.Enhance> enhanceMode, int buffer_size, @Nullable CancelTask cancelTask, @Nullable Object iospMessage) throws IOException {
        NetcdfFile ncfile = NetcdfDatasets.openProtocolOrFile(location, buffer_size, cancelTask, iospMessage);
        return NetcdfDatasets.enhance(ncfile, enhanceMode, cancelTask);
    }

    public static NetcdfDataset openNcmlDataset(Reader reader, String ncmlLocation, @Nullable CancelTask cancelTask) throws IOException {
        NetcdfDataset.Builder<?> builder = NcmlReader.readNcml(reader, ncmlLocation, cancelTask);
        if (!builder.getEnhanceMode().isEmpty()) {
            DatasetEnhancer enhancer = new DatasetEnhancer(builder, builder.getEnhanceMode(), cancelTask);
            return enhancer.enhance().build();
        }
        return builder.build();
    }

    public static NetcdfDataset enhance(NetcdfFile ncfile, @Nullable Set<NetcdfDataset.Enhance> mode, @Nullable CancelTask cancelTask) throws IOException {
        if (ncfile instanceof NetcdfDataset) {
            NetcdfDataset ncd = (NetcdfDataset)ncfile;
            NetcdfFile.Builder builder = ncd.toBuilder();
            if (DatasetEnhancer.enhanceNeeded(mode, ncd.getEnhanceMode())) {
                DatasetEnhancer enhancer = new DatasetEnhancer((NetcdfDataset.Builder<?>)builder, mode, cancelTask);
                return enhancer.enhance().build();
            }
            return ncd;
        }
        Object builder = ((NetcdfDataset.Builder)NetcdfDataset.builder().copyFrom(ncfile)).setOrgFile(ncfile);
        if (DatasetEnhancer.enhanceNeeded(mode, null)) {
            DatasetEnhancer enhancer = new DatasetEnhancer((NetcdfDataset.Builder<?>)builder, mode, cancelTask);
            return enhancer.enhance().build();
        }
        return ((NetcdfDataset.Builder)builder).build();
    }

    @Deprecated
    public static NetcdfDataset addNetcdf3RecordStructure(NetcdfDataset ncd) throws IOException {
        if (ncd.getReferencedFile() == null) {
            return ncd;
        }
        NetcdfFile orgFile = ncd.getReferencedFile();
        IOServiceProvider iosp = (IOServiceProvider)orgFile.sendIospMessage("IOSP");
        if (!(iosp instanceof N3iosp)) {
            return ncd;
        }
        if (ncd.getUnlimitedDimension() == null) {
            return ncd;
        }
        if (ncd.findVariable("record") != null) {
            return ncd;
        }
        DatasetUrl durl = DatasetUrl.findDatasetUrl(orgFile.getLocation());
        NetcdfFile ncfile = NetcdfDatasets.openFile(durl, -1, null, "AddRecordStructure");
        Object builder = ((NetcdfDataset.Builder)ncd.toBuilder()).setOrgFile(ncfile);
        ncd.close();
        Structure orgStructure = (Structure)ncfile.getRootGroup().findVariableLocal("record");
        Dimension udim = ncfile.getUnlimitedDimension();
        Preconditions.checkNotNull((Object)udim);
        StructureDS.Builder newStructure = (StructureDS.Builder)((StructureDS.Builder)((StructureDS.Builder)StructureDS.builder().setName("record")).setParentGroupBuilder(((NetcdfDataset.Builder)builder).rootGroup)).setDimensionsByName(udim.getShortName());
        newStructure.setOriginalVariable(orgStructure);
        for (Variable.Builder<?> vb : ((NetcdfDataset.Builder)builder).rootGroup.vbuilders) {
            vb.setNcfile(null);
            Variable orgVar = ncfile.findVariable(vb.shortName);
            VariableDS.Builder vdb = (VariableDS.Builder)vb;
            vdb.setOriginalVariable(orgVar);
            vdb.setProxyReader(null);
            if (!vb.isUnlimited()) continue;
            VariableDS.Builder memberV = (VariableDS.Builder)vb.makeSliceBuilder(0, 0);
            newStructure.addMemberVariable(memberV);
        }
        ((NetcdfDataset.Builder)builder).rootGroup.addVariable(newStructure);
        return ((NetcdfDataset.Builder)builder).build();
    }

    public static NetcdfDataset acquireDataset(DatasetUrl location, @Nullable CancelTask cancelTask) throws IOException {
        return NetcdfDatasets.acquireDataset(null, location, NetcdfDataset.getDefaultEnhanceMode(), -1, cancelTask, null);
    }

    public static NetcdfDataset acquireDataset(DatasetUrl location, boolean enhanceMode, @Nullable CancelTask cancelTask) throws IOException {
        return NetcdfDatasets.acquireDataset(null, location, enhanceMode ? NetcdfDataset.getDefaultEnhanceMode() : null, -1, cancelTask, null);
    }

    public static NetcdfDataset acquireDataset(DatasetUrl location, @Nullable Set<NetcdfDataset.Enhance> enhanceMode, @Nullable CancelTask cancelTask, @Nullable Object iospMessage) throws IOException {
        return NetcdfDatasets.acquireDataset(null, location, enhanceMode, -1, cancelTask, iospMessage);
    }

    public static NetcdfDataset acquireDataset(@Nullable FileFactory fac, DatasetUrl durl, @Nullable Set<NetcdfDataset.Enhance> enhanceMode, int buffer_size, @Nullable CancelTask cancelTask, @Nullable Object iospMessage) throws IOException {
        if (netcdfFileCache == null) {
            if (fac == null) {
                return NetcdfDatasets.openDataset(durl, enhanceMode, buffer_size, cancelTask, iospMessage);
            }
            return (NetcdfDataset)fac.open(durl, buffer_size, cancelTask, iospMessage);
        }
        if (fac != null) {
            return (NetcdfDataset)NetcdfDatasets.openOrAcquireFile(netcdfFileCache, fac, null, durl, buffer_size, cancelTask, iospMessage);
        }
        fac = new StandardDatasetFactory(durl, enhanceMode);
        return (NetcdfDataset)NetcdfDatasets.openOrAcquireFile(netcdfFileCache, fac, fac.hashCode(), durl, buffer_size, cancelTask, iospMessage);
    }

    public static NetcdfFile openFile(String location, CancelTask cancelTask) throws IOException {
        DatasetUrl durl = DatasetUrl.findDatasetUrl(location);
        return NetcdfDatasets.openFile(durl, -1, cancelTask, null);
    }

    public static NetcdfFile openFile(DatasetUrl location, int buffer_size, CancelTask cancelTask, Object iospMessage) throws IOException {
        return NetcdfDatasets.openProtocolOrFile(location, buffer_size, cancelTask, iospMessage);
    }

    public static NetcdfFile acquireFile(DatasetUrl location, CancelTask cancelTask) throws IOException {
        return NetcdfDatasets.acquireFile(null, null, location, -1, cancelTask, null);
    }

    public static NetcdfFile acquireFile(@Nullable FileFactory factory, @Nullable Object hashKey, DatasetUrl location, int buffer_size, @Nullable CancelTask cancelTask, @Nullable Object spiObject) throws IOException {
        if (netcdfFileCache == null && factory != null) {
            return (NetcdfFile)factory.open(location, buffer_size, cancelTask, spiObject);
        }
        return NetcdfDatasets.openOrAcquireFile(netcdfFileCache, factory, hashKey, location, buffer_size, cancelTask, spiObject);
    }

    private static NetcdfFile openOrAcquireFile(FileCache cache, FileFactory factory, Object hashKey, DatasetUrl durl, int buffer_size, CancelTask cancelTask, Object iospMessage) throws IOException {
        if (factory == null) {
            factory = defaultNetcdfFileFactory;
        }
        if (cache != null) {
            return (NetcdfFile)cache.acquire(factory, hashKey, durl, buffer_size, cancelTask, iospMessage);
        }
        return (NetcdfFile)factory.open(durl, buffer_size, cancelTask, iospMessage);
    }

    private static NetcdfFile openProtocolOrFile(DatasetUrl durl, int buffer_size, CancelTask cancelTask, Object iospMessage) throws IOException {
        for (NetcdfFileProvider provider : ServiceLoader.load(NetcdfFileProvider.class)) {
            if (!provider.isOwnerOf(durl)) continue;
            return provider.open(durl.getTrueurl(), cancelTask);
        }
        for (NetcdfFileProvider provider : ServiceLoader.load(NetcdfFileProvider.class)) {
            if (!provider.isOwnerOf(durl.getTrueurl())) continue;
            return provider.open(durl.getTrueurl(), cancelTask);
        }
        if (durl.getServiceType() != null) {
            switch (durl.getServiceType()) {
                case File: 
                case HTTPServer: {
                    break;
                }
                default: {
                    throw new IOException("Unknown service type: " + (Object)((Object)durl.getServiceType()));
                }
            }
        }
        return NetcdfFiles.open(durl.getTrueurl(), buffer_size, cancelTask, iospMessage);
    }

    static {
        defaultNetcdfFileFactory = new StandardFileFactory();
    }

    private static class StandardDatasetFactory
    implements FileFactory {
        DatasetUrl location;
        EnumSet<NetcdfDataset.Enhance> enhanceMode;

        StandardDatasetFactory(DatasetUrl location, Set<NetcdfDataset.Enhance> enhanceMode) {
            this.location = location;
            this.enhanceMode = enhanceMode == null ? EnumSet.noneOf(NetcdfDataset.Enhance.class) : EnumSet.copyOf(enhanceMode);
        }

        @Override
        public NetcdfFile open(DatasetUrl location, int buffer_size, CancelTask cancelTask, Object iospMessage) throws IOException {
            return NetcdfDatasets.openDataset(location, this.enhanceMode, buffer_size, cancelTask, iospMessage);
        }

        public int hashCode() {
            int result = this.location.hashCode();
            result += 37 * result + this.enhanceMode.hashCode();
            return result;
        }
    }

    private static class StandardFileFactory
    implements FileFactory {
        private StandardFileFactory() {
        }

        @Override
        public NetcdfFile open(DatasetUrl location, int buffer_size, CancelTask cancelTask, Object iospMessage) throws IOException {
            return NetcdfDatasets.openFile(location, buffer_size, cancelTask, iospMessage);
        }
    }
}

