/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dataset;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.Iterator;
import javax.annotation.concurrent.Immutable;
import ucar.array.ArrayType;
import ucar.array.StructureData;
import ucar.ma2.Array;
import ucar.ma2.ArrayStructure;
import ucar.ma2.Section;
import ucar.ma2.StructureDataIterator;
import ucar.nc2.Group;
import ucar.nc2.Sequence;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.dataset.CoordinateSystem;
import ucar.nc2.dataset.StructureDS;
import ucar.nc2.dataset.StructureDataEnhancer;
import ucar.nc2.dataset.StructureEnhanced;
import ucar.nc2.dataset.VariableDS;
import ucar.nc2.internal.dataset.SequenceArrayEnhancer;

@Immutable
public class SequenceDS
extends Sequence
implements StructureEnhanced {
    private final Sequence orgSeq;
    private final String orgName;

    @Override
    @Deprecated
    public StructureDataIterator getStructureIterator(int bufferSize) throws IOException {
        return new StructureDataEnhancer.StructureDataIteratorEnhanced(this, this.orgSeq.getStructureIterator(bufferSize));
    }

    @Override
    public Iterator<StructureData> iterator() {
        return new SequenceArrayEnhancer(this, this.orgSeq.iterator());
    }

    @Override
    public Variable getOriginalVariable() {
        return this.orgSeq;
    }

    @Override
    public String getOriginalName() {
        return this.orgName;
    }

    @Override
    public ImmutableList<CoordinateSystem> getCoordinateSystems() {
        return ImmutableList.of();
    }

    @Override
    @Deprecated
    public Array read(Section section) throws IOException {
        return this.read();
    }

    @Override
    @Deprecated
    public Array read() throws IOException {
        Array data = this.orgSeq.read();
        StructureDataEnhancer enhancer = new StructureDataEnhancer(this);
        return enhancer.enhance((ArrayStructure)data, null);
    }

    protected SequenceDS(Builder<?> builder, Group parentGroup) {
        super((Sequence.Builder<?>)builder, parentGroup);
        this.orgSeq = ((Builder)builder).orgSeq;
        this.orgName = ((Builder)builder).orgName;
    }

    @Override
    public Builder<?> toBuilder() {
        return this.addLocalFieldsToBuilder(SequenceDS.builder());
    }

    protected Builder<?> addLocalFieldsToBuilder(Builder<? extends Builder<?>> b) {
        b.setOriginalSequence(this.orgSeq).setOriginalName(this.orgName);
        return (Builder)super.addLocalFieldsToBuilder((Sequence.Builder<? extends Sequence.Builder<?>>)b);
    }

    public static Builder<?> builder() {
        return new Builder2();
    }

    public static abstract class Builder<T extends Builder<T>>
    extends Sequence.Builder<T> {
        private Sequence orgSeq;
        private String orgName;
        private boolean built;

        public T setOriginalSequence(Sequence orgVar) {
            this.orgSeq = orgVar;
            return (T)((Builder)this.self());
        }

        public T setOriginalName(String orgName) {
            this.orgName = orgName;
            return (T)((Builder)this.self());
        }

        public T copyFrom(Sequence orgVar) {
            super.copyFrom(orgVar);
            for (Variable v : orgVar.getVariables()) {
                Object newVar = v instanceof Sequence ? SequenceDS.builder().copyFrom((Sequence)v) : (v instanceof Structure ? StructureDS.builder().copyFrom((Structure)v) : VariableDS.builder().copyFrom(v));
                this.addMemberVariable((Variable.Builder<?>)newVar);
            }
            this.setOriginalSequence(orgVar);
            this.setOriginalName(orgVar.getShortName());
            return (T)((Builder)this.self());
        }

        @Override
        public SequenceDS build(Group parentGroup) {
            if (this.built) {
                throw new IllegalStateException("already built");
            }
            this.built = true;
            this.setArrayType(ArrayType.SEQUENCE);
            return new SequenceDS(this, parentGroup);
        }
    }

    private static class Builder2
    extends Builder<Builder2> {
        private Builder2() {
        }

        @Override
        protected Builder2 self() {
            return this;
        }
    }
}

